# Generated by Django 4.1.5 on 2023-02-04 14:33

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import rest_framework_simple_api_key.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="APIKey",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "expiry_date",
                    models.DateTimeField(
                        default=rest_framework_simple_api_key.models._expiry_date,
                        help_text="Once API key expires, entities cannot use it anymore.",
                        verbose_name="Expires",
                    ),
                ),
                (
                    "revoked",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="If the API key is revoked, entities cannot use it anymore. (This cannot be undone.)",
                    ),
                ),
                ("created", models.DateTimeField(auto_now=True)),
                (
                    "entity",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="api_keys",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
    ]
