/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.types;

import com.datapps.linkoopdb.jdbc.SessionInterface;
import com.datapps.linkoopdb.jdbc.SortAndSlice;
import com.datapps.linkoopdb.jdbc.error.Error;
import com.datapps.linkoopdb.jdbc.types.Type;
import java.sql.ResultSet;

public class RowType
extends Type {
    public Type[] colTypes;
    Type.TypedComparator comparator;

    public RowType(Type[] colTypes) {
        this(19, 19, colTypes);
    }

    protected RowType(int typeGroup, int type, Type[] colTypes) {
        super(typeGroup, type, 0L, 0);
        this.colTypes = colTypes;
    }

    protected RowType() {
        super(19, 19, 0L, 0);
    }

    public static String convertToSQLString(Object[] array, Type[] types, int maxUnitLength) {
        if (array == null) {
            return "NULL";
        }
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            String string = types[i].convertToSQLString(array[i]);
            if (maxUnitLength > 10 && string.length() > maxUnitLength) {
                sb.append(string.substring(0, maxUnitLength - 4));
                sb.append(" ...");
                continue;
            }
            sb.append(string);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public int displaySize() {
        return 0;
    }

    @Override
    public int getJDBCTypeCode() {
        return 0;
    }

    @Override
    public Class getJDBCClass() {
        return ResultSet.class;
    }

    @Override
    public String getJDBCClassName() {
        return "java.sql.ResultSet";
    }

    @Override
    public int getJDBCScale() {
        return 0;
    }

    @Override
    public int getJDBCPrecision() {
        return 0;
    }

    @Override
    public int getSQLGenericTypeCode() {
        return 19;
    }

    @Override
    public boolean isRowType() {
        return true;
    }

    @Override
    public int getDegree() {
        return this.colTypes.length;
    }

    @Override
    public String getNameString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ROW");
        sb.append('(');
        for (int i = 0; i < this.colTypes.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.colTypes[i].getDefinition());
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String getDefinition() {
        return this.getNameString();
    }

    @Override
    public int compare(SessionInterface session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Object[] arrb = (Object[])b;
        Object[] arra = (Object[])a;
        int length = arra.length;
        if (arrb.length < length) {
            length = arrb.length;
        }
        for (int i = 0; i < length; ++i) {
            int result = this.colTypes[i].compare(session, arra[i], arrb[i]);
            if (result == 0) continue;
            return result;
        }
        if (arra.length > arrb.length) {
            return 1;
        }
        if (arra.length < arrb.length) {
            return -1;
        }
        return 0;
    }

    @Override
    public Object convertToTypeLimits(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        Object[] arra = (Object[])a;
        Object[] arrb = new Object[arra.length];
        for (int i = 0; i < arra.length; ++i) {
            arrb[i] = this.colTypes[i].convertToTypeLimits(session, arra[i]);
        }
        return arrb;
    }

    @Override
    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return null;
        }
        if (otherType == null) {
            return a;
        }
        if (!otherType.isRowType()) {
            throw Error.error(5562);
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.colTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        Object[] arra = (Object[])a;
        Object[] arrb = new Object[arra.length];
        for (int i = 0; i < arra.length; ++i) {
            arrb[i] = this.colTypes[i].convertToType(session, arra[i], otherTypes[i]);
        }
        return arrb;
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object o) {
        return o;
    }

    @Override
    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        return this.convertToSQLString(a);
    }

    @Override
    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        Object[] array = (Object[])a;
        StringBuffer sb = new StringBuffer();
        sb.append("ROW");
        sb.append('(');
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            String string = this.colTypes[i].convertToSQLString(array[i]);
            sb.append(string);
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public boolean canConvertFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        if (!otherType.isRowType()) {
            return false;
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.colTypes.length != otherTypes.length) {
            return false;
        }
        for (int i = 0; i < this.colTypes.length; ++i) {
            if (this.colTypes[i].canConvertFrom(otherTypes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeAssignedFrom(Type otherType) {
        if (otherType == null) {
            return true;
        }
        if (!otherType.isRowType()) {
            return false;
        }
        Type[] otherTypes = ((RowType)otherType).getTypesArray();
        if (this.colTypes.length != otherTypes.length) {
            return false;
        }
        for (int i = 0; i < this.colTypes.length; ++i) {
            if (this.colTypes[i].canBeAssignedFrom(otherTypes[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Type getAggregateType(Type other) {
        if (other == null) {
            return this;
        }
        if (other == SQL_ALL_TYPES) {
            return this;
        }
        if (other == this) {
            return this;
        }
        if (!other.isRowType()) {
            throw Error.error(5562);
        }
        Type[] newTypes = new Type[this.colTypes.length];
        Type[] otherTypes = ((RowType)other).getTypesArray();
        if (this.colTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        for (int i = 0; i < this.colTypes.length; ++i) {
            newTypes[i] = this.colTypes[i].getAggregateType(otherTypes[i]);
        }
        return new RowType(newTypes);
    }

    @Override
    public Type getCombinedType(SessionInterface session, Type other, int operation) {
        if (operation != 36) {
            return this.getAggregateType(other);
        }
        if (other == null) {
            return this;
        }
        if (!other.isRowType()) {
            throw Error.error(5562);
        }
        Type[] newTypes = new Type[this.colTypes.length];
        Type[] otherTypes = ((RowType)other).getTypesArray();
        if (this.colTypes.length != otherTypes.length) {
            throw Error.error(5564);
        }
        for (int i = 0; i < this.colTypes.length; ++i) {
            newTypes[i] = this.colTypes[i].getAggregateType(otherTypes[i]);
        }
        return new RowType(newTypes);
    }

    public Type[] getTypesArray() {
        return this.colTypes;
    }

    @Override
    public int compare(SessionInterface session, Object a, Object b, SortAndSlice sort) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        Object[] arra = (Object[])a;
        Object[] arrb = (Object[])b;
        int length = sort.sortOrder.length;
        for (int i = 0; i < length; ++i) {
            int result;
            a = arra[sort.sortOrder[i]];
            b = arrb[sort.sortOrder[i]];
            if (a == b) continue;
            if (sort.sortNullsLast[i]) {
                if (a == null) {
                    return 1;
                }
                if (b == null) {
                    return -1;
                }
            }
            if ((result = this.colTypes[i].compare(session, a, b)) == 0) continue;
            if (sort.sortDescending[i]) {
                return -result;
            }
            return result;
        }
        return 0;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof Type) {
            if (((Type)other).typeCode != 19) {
                return false;
            }
            Type[] otherTypes = ((RowType)other).colTypes;
            if (otherTypes.length != this.colTypes.length) {
                return false;
            }
            for (int i = 0; i < this.colTypes.length; ++i) {
                if (this.colTypes[i].equals(otherTypes[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode(Object a) {
        if (a == null) {
            return 0;
        }
        int hash = 0;
        Object[] array = (Object[])a;
        for (int i = 0; i < this.colTypes.length && i < 4; ++i) {
            hash += this.colTypes[i].hashCode(array[i]);
        }
        return hash;
    }

    synchronized Type.TypedComparator getComparator(SessionInterface session) {
        if (this.comparator == null) {
            Type.TypedComparator c = Type.newComparator(session);
            SortAndSlice sort = new SortAndSlice();
            sort.prepareMultiColumn(this.colTypes.length);
            c.setType(this, sort);
            this.comparator = c;
        }
        return this.comparator;
    }
}

