# coding: utf-8

"""
    Emby Server API

    Explore the Emby Server API  # noqa: E501

    OpenAPI spec version: 4.6.7.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from embyapi.api_client import ApiClient


class UserActivityAPIApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_user_usage_stats_by_breakdowntype_breakdownreport(self, breakdown_type, **kwargs):  # noqa: E501
        """Gets a breakdown of a usage metric  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_by_breakdowntype_breakdownreport(breakdown_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str breakdown_type: Breakdown type (required)
        :param str user_id: User Id
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_by_breakdowntype_breakdownreport_with_http_info(breakdown_type, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_by_breakdowntype_breakdownreport_with_http_info(breakdown_type, **kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_by_breakdowntype_breakdownreport_with_http_info(self, breakdown_type, **kwargs):  # noqa: E501
        """Gets a breakdown of a usage metric  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_by_breakdowntype_breakdownreport_with_http_info(breakdown_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str breakdown_type: Breakdown type (required)
        :param str user_id: User Id
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['breakdown_type', 'user_id', 'days', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_by_breakdowntype_breakdownreport" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'breakdown_type' is set
        if self.api_client.client_side_validation and ('breakdown_type' not in params or
                                                       params['breakdown_type'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `breakdown_type` when calling `get_user_usage_stats_by_breakdowntype_breakdownreport`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'breakdown_type' in params:
            path_params['BreakdownType'] = params['breakdown_type']  # noqa: E501

        query_params = []
        if 'user_id' in params:
            query_params.append(('user_id', params['user_id']))  # noqa: E501
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/{BreakdownType}/BreakdownReport', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_by_userid_by_date_getitems(self, user_id, _date, **kwargs):  # noqa: E501
        """Gets activity for {USER} for {Date} formatted as yyyy-MM-dd  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_by_userid_by_date_getitems(user_id, _date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: User Id (required)
        :param str _date: UTC DateTime, Format yyyy-MM-dd (required)
        :param str filter: Comma separated list of media types to filter (movies,series)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_by_userid_by_date_getitems_with_http_info(user_id, _date, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_by_userid_by_date_getitems_with_http_info(user_id, _date, **kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_by_userid_by_date_getitems_with_http_info(self, user_id, _date, **kwargs):  # noqa: E501
        """Gets activity for {USER} for {Date} formatted as yyyy-MM-dd  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_by_userid_by_date_getitems_with_http_info(user_id, _date, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: User Id (required)
        :param str _date: UTC DateTime, Format yyyy-MM-dd (required)
        :param str filter: Comma separated list of media types to filter (movies,series)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', '_date', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_by_userid_by_date_getitems" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in params or
                                                       params['user_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_usage_stats_by_userid_by_date_getitems`")  # noqa: E501
        # verify the required parameter '_date' is set
        if self.api_client.client_side_validation and ('_date' not in params or
                                                       params['_date'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `_date` when calling `get_user_usage_stats_by_userid_by_date_getitems`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'user_id' in params:
            path_params['UserID'] = params['user_id']  # noqa: E501
        if '_date' in params:
            path_params['Date'] = params['_date']  # noqa: E501

        query_params = []
        if 'filter' in params:
            query_params.append(('Filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/{UserID}/{Date}/GetItems', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_hourlyreport(self, **kwargs):  # noqa: E501
        """Gets a report of the available activity per hour  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_hourlyreport(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: User Id
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :param str filter: Comma separated list of media types to filter (movies,series)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_hourlyreport_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_hourlyreport_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_hourlyreport_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a report of the available activity per hour  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_hourlyreport_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: User Id
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :param str filter: Comma separated list of media types to filter (movies,series)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'days', 'end_date', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_hourlyreport" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user_id' in params:
            query_params.append(('user_id', params['user_id']))  # noqa: E501
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/HourlyReport', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_load_backup(self, backupfile, **kwargs):  # noqa: E501
        """Loads a backup from a file  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_load_backup(backupfile, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str backupfile: File name of file to load (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_load_backup_with_http_info(backupfile, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_load_backup_with_http_info(backupfile, **kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_load_backup_with_http_info(self, backupfile, **kwargs):  # noqa: E501
        """Loads a backup from a file  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_load_backup_with_http_info(backupfile, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str backupfile: File name of file to load (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['backupfile']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_load_backup" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'backupfile' is set
        if self.api_client.client_side_validation and ('backupfile' not in params or
                                                       params['backupfile'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `backupfile` when calling `get_user_usage_stats_load_backup`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'backupfile' in params:
            query_params.append(('backupfile', params['backupfile']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/load_backup', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_moviesreport(self, **kwargs):  # noqa: E501
        """Gets Movies counts  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_moviesreport(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: User Id
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_moviesreport_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_moviesreport_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_moviesreport_with_http_info(self, **kwargs):  # noqa: E501
        """Gets Movies counts  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_moviesreport_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: User Id
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'days', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_moviesreport" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user_id' in params:
            query_params.append(('user_id', params['user_id']))  # noqa: E501
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/MoviesReport', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_playactivity(self, **kwargs):  # noqa: E501
        """Gets play activity for number of days  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_playactivity(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :param str filter: Comma separated list of media types to filter (movies,series)
        :param str data_type: Data type to return (count,time)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_playactivity_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_playactivity_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_playactivity_with_http_info(self, **kwargs):  # noqa: E501
        """Gets play activity for number of days  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_playactivity_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :param str filter: Comma separated list of media types to filter (movies,series)
        :param str data_type: Data type to return (count,time)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['days', 'end_date', 'filter', 'data_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_playactivity" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501
        if 'data_type' in params:
            query_params.append(('data_type', params['data_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/PlayActivity', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_save_backup(self, **kwargs):  # noqa: E501
        """Saves a backup of the playback report data to the backup path  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_save_backup(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_save_backup_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_save_backup_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_save_backup_with_http_info(self, **kwargs):  # noqa: E501
        """Saves a backup of the playback report data to the backup path  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_save_backup_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_save_backup" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/save_backup', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_session_list(self, **kwargs):  # noqa: E501
        """Gets Session Info  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_session_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_session_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_session_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_session_list_with_http_info(self, **kwargs):  # noqa: E501
        """Gets Session Info  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_session_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_session_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/session_list', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_tvshowsreport(self, **kwargs):  # noqa: E501
        """Gets TV Shows counts  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_tvshowsreport(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: User Id
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_tvshowsreport_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_tvshowsreport_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_tvshowsreport_with_http_info(self, **kwargs):  # noqa: E501
        """Gets TV Shows counts  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_tvshowsreport_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: User Id
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'days', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_tvshowsreport" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user_id' in params:
            query_params.append(('user_id', params['user_id']))  # noqa: E501
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/TvShowsReport', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_type_filter_list(self, **kwargs):  # noqa: E501
        """Gets types filter list items  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_type_filter_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_type_filter_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_type_filter_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_type_filter_list_with_http_info(self, **kwargs):  # noqa: E501
        """Gets types filter list items  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_type_filter_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_type_filter_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/type_filter_list', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_user_activity(self, **kwargs):  # noqa: E501
        """Gets a report of the available activity per hour  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_user_activity(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_user_activity_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_user_activity_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_user_activity_with_http_info(self, **kwargs):  # noqa: E501
        """Gets a report of the available activity per hour  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_user_activity_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['days', 'end_date']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_user_activity" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/user_activity', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_user_list(self, **kwargs):  # noqa: E501
        """Get users  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_user_list(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_user_list_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_user_list_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_user_list_with_http_info(self, **kwargs):  # noqa: E501
        """Get users  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_user_list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_user_list" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/user_list', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_user_manage_by_action_by_id(self, action, id, **kwargs):  # noqa: E501
        """Get users  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_user_manage_by_action_by_id(action, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str action: action to perform (required)
        :param str id: user Id to perform the action on (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_user_manage_by_action_by_id_with_http_info(action, id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_user_manage_by_action_by_id_with_http_info(action, id, **kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_user_manage_by_action_by_id_with_http_info(self, action, id, **kwargs):  # noqa: E501
        """Get users  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_user_manage_by_action_by_id_with_http_info(action, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str action: action to perform (required)
        :param str id: user Id to perform the action on (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action', 'id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_user_manage_by_action_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'action' is set
        if self.api_client.client_side_validation and ('action' not in params or
                                                       params['action'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `action` when calling `get_user_usage_stats_user_manage_by_action_by_id`")  # noqa: E501
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in params or
                                                       params['id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `id` when calling `get_user_usage_stats_user_manage_by_action_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'action' in params:
            path_params['Action'] = params['action']  # noqa: E501
        if 'id' in params:
            path_params['Id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/user_manage/{Action}/{Id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_user_usage_stats_userplaylist(self, user_id, aggregate_data, **kwargs):  # noqa: E501
        """Gets a report of all played items for a user in a date period  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_userplaylist(user_id, aggregate_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: User Id (required)
        :param bool aggregate_data: Aggregate the data to total duration per user per item (required)
        :param str filter_name: Name Filter
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :param str filter: Comma separated list of media types to filter (movies,series)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_user_usage_stats_userplaylist_with_http_info(user_id, aggregate_data, **kwargs)  # noqa: E501
        else:
            (data) = self.get_user_usage_stats_userplaylist_with_http_info(user_id, aggregate_data, **kwargs)  # noqa: E501
            return data

    def get_user_usage_stats_userplaylist_with_http_info(self, user_id, aggregate_data, **kwargs):  # noqa: E501
        """Gets a report of all played items for a user in a date period  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_user_usage_stats_userplaylist_with_http_info(user_id, aggregate_data, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: User Id (required)
        :param bool aggregate_data: Aggregate the data to total duration per user per item (required)
        :param str filter_name: Name Filter
        :param int days: Number of Days
        :param str end_date: End date of the report in yyyy-MM-dd format
        :param str filter: Comma separated list of media types to filter (movies,series)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'aggregate_data', 'filter_name', 'days', 'end_date', 'filter']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_usage_stats_userplaylist" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'user_id' is set
        if self.api_client.client_side_validation and ('user_id' not in params or
                                                       params['user_id'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_usage_stats_userplaylist`")  # noqa: E501
        # verify the required parameter 'aggregate_data' is set
        if self.api_client.client_side_validation and ('aggregate_data' not in params or
                                                       params['aggregate_data'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `aggregate_data` when calling `get_user_usage_stats_userplaylist`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'user_id' in params:
            query_params.append(('user_id', params['user_id']))  # noqa: E501
        if 'aggregate_data' in params:
            query_params.append(('aggregate_data', params['aggregate_data']))  # noqa: E501
        if 'filter_name' in params:
            query_params.append(('filter_name', params['filter_name']))  # noqa: E501
        if 'days' in params:
            query_params.append(('days', params['days']))  # noqa: E501
        if 'end_date' in params:
            query_params.append(('end_date', params['end_date']))  # noqa: E501
        if 'filter' in params:
            query_params.append(('filter', params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/UserPlaylist', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_user_usage_stats_import_backup(self, body, **kwargs):  # noqa: E501
        """Post a backup for importing  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_user_usage_stats_import_backup(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: Binary stream (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_user_usage_stats_import_backup_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_user_usage_stats_import_backup_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_user_usage_stats_import_backup_with_http_info(self, body, **kwargs):  # noqa: E501
        """Post a backup for importing  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_user_usage_stats_import_backup_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str body: Binary stream (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_user_usage_stats_import_backup" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_user_usage_stats_import_backup`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/octet-stream'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/import_backup', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def post_user_usage_stats_submit_custom_query(self, body, **kwargs):  # noqa: E501
        """Submit an SQL query  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_user_usage_stats_submit_custom_query(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PlaybackReportingApiCustomQuery body: CustomQuery (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_user_usage_stats_submit_custom_query_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_user_usage_stats_submit_custom_query_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def post_user_usage_stats_submit_custom_query_with_http_info(self, body, **kwargs):  # noqa: E501
        """Submit an SQL query  # noqa: E501

        Requires authentication as user  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_user_usage_stats_submit_custom_query_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PlaybackReportingApiCustomQuery body: CustomQuery (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_user_usage_stats_submit_custom_query" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if self.api_client.client_side_validation and ('body' not in params or
                                                       params['body'] is None):  # noqa: E501
            raise ValueError("Missing the required parameter `body` when calling `post_user_usage_stats_submit_custom_query`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/xml'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/xml'])  # noqa: E501

        # Authentication setting
        auth_settings = ['apikeyauth']  # noqa: E501

        return self.api_client.call_api(
            '/user_usage_stats/submit_custom_query', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
