# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Bdb(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'account_id': 'int',
        'action_uid': 'str',
        'aof_policy': 'str',
        'authentication_admin_pass': 'str',
        'authentication_redis_pass': 'str',
        'authentication_sasl_pass': 'str',
        'authentication_sasl_uname': 'str',
        'authentication_ssl_client_certs': 'list[BdbAuthenticationSslClientCerts]',
        'authentication_ssl_crdt_certs': 'list[BdbAuthenticationSslClientCerts]',
        'authorized_names': 'list[str]',
        'auto_upgrade': 'bool',
        'avoid_nodes': 'list[str]',
        'background_op': 'list[BdbBackgroundOp]',
        'backup': 'bool',
        'backup_failure_reason': 'str',
        'backup_history': 'int',
        'backup_interval': 'int',
        'backup_interval_offset': 'int',
        'backup_location': 'AnyOfbdbBackupLocation',
        'backup_progress': 'float',
        'backup_status': 'str',
        'bigstore': 'bool',
        'bigstore_ram_size': 'int',
        'bigstore_ram_weights': 'list[BdbBigstoreRamWeights]',
        'crdt': 'bool',
        'crdt_causal_consistency': 'bool',
        'crdt_config_version': 'int',
        'crdt_featureset_version': 'int',
        'crdt_ghost_replica_ids': 'str',
        'crdt_guid': 'str',
        'crdt_protocol_version': 'int',
        'crdt_repl_backlog_size': 'str',
        'crdt_replica_id': 'int',
        'crdt_replicas': 'str',
        'crdt_sources': 'AllOfbdbCrdtSources',
        'crdt_sync': 'AllOfbdbCrdtSync',
        'crdt_sync_dist': 'bool',
        'crdt_syncer_auto_oom_unlatch': 'bool',
        'created_time': 'datetime',
        'data_internode_encryption': 'bool',
        'data_persistence': 'str',
        'dataset_import_sources': 'list[AnyOfbdbDatasetImportSourcesItems]',
        'default_user': 'bool',
        'disabled_commands': 'str',
        'dns_address_master': 'str',
        'email_alerts': 'bool',
        'endpoint': 'str',
        'endpoint_ip': 'list[OneOfbdbEndpointIpItems]',
        'endpoint_node': 'int',
        'endpoints': 'list[BdbEndpoints]',
        'enforce_client_authentication': 'str',
        'eviction_policy': 'str',
        'export_failure_reason': 'str',
        'export_progress': 'float',
        'export_status': 'str',
        'generate_text_monitor': 'bool',
        'gradual_src_max_sources': 'int',
        'gradual_src_mode': 'str',
        'gradual_sync_max_shards_per_source': 'int',
        'gradual_sync_mode': 'str',
        'hash_slots_policy': 'str',
        'implicit_shard_key': 'bool',
        'import_failure_reason': 'AllOfbdbImportFailureReason',
        'import_progress': 'float',
        'import_status': 'str',
        'internal': 'bool',
        'last_backup_time': 'datetime',
        'last_changed_time': 'datetime',
        'last_export_time': 'datetime',
        'max_aof_file_size': 'int',
        'max_aof_load_time': 'int',
        'max_connections': 'int',
        'memory_size': 'int',
        'metrics_export_all': 'bool',
        'mkms': 'bool',
        'module_list': 'list[BdbModuleList]',
        'mtls_allow_outdated_certs': 'bool',
        'mtls_allow_weak_hashing': 'bool',
        'name': 'str',
        'oss_cluster': 'bool',
        'oss_cluster_api_preferred_ip_type': 'str',
        'oss_sharding': 'bool',
        'port': 'int',
        'proxy_policy': 'str',
        'rack_aware': 'bool',
        'redis_version': 'str',
        'repl_backlog_size': 'str',
        'replica_sources': 'AllOfbdbReplicaSources',
        'replica_sync': 'AllOfbdbReplicaSync',
        'replica_sync_dist': 'bool',
        'replication': 'bool',
        'roles_permissions': 'list[BdbRolesPermissions]',
        'shard_block_crossslot_keys': 'bool',
        'shard_block_foreign_keys': 'bool',
        'shard_key_regex': 'list[BdbShardKeyRegex]',
        'shard_list': 'list[int]',
        'sharding': 'bool',
        'shards_count': 'int',
        'shards_placement': 'str',
        'skip_import_analyze': 'str',
        'slave_ha': 'bool',
        'slave_ha_priority': 'int',
        'snapshot_policy': 'AllOfbdbSnapshotPolicy',
        'ssl': 'bool',
        'status': 'str',
        'sync': 'AllOfbdbSync',
        'sync_sources': 'list[BdbSyncSources]',
        'syncer_mode': 'str',
        'tags': 'list[BdbTags]',
        'tls_mode': 'str',
        'type': 'str',
        'uid': 'int',
        'use_nodes': 'list[str]',
        'version': 'str',
        'wait_command': 'bool'
    }

    attribute_map = {
        'account_id': 'account_id',
        'action_uid': 'action_uid',
        'aof_policy': 'aof_policy',
        'authentication_admin_pass': 'authentication_admin_pass',
        'authentication_redis_pass': 'authentication_redis_pass',
        'authentication_sasl_pass': 'authentication_sasl_pass',
        'authentication_sasl_uname': 'authentication_sasl_uname',
        'authentication_ssl_client_certs': 'authentication_ssl_client_certs',
        'authentication_ssl_crdt_certs': 'authentication_ssl_crdt_certs',
        'authorized_names': 'authorized_names',
        'auto_upgrade': 'auto_upgrade',
        'avoid_nodes': 'avoid_nodes',
        'background_op': 'background_op',
        'backup': 'backup',
        'backup_failure_reason': 'backup_failure_reason',
        'backup_history': 'backup_history',
        'backup_interval': 'backup_interval',
        'backup_interval_offset': 'backup_interval_offset',
        'backup_location': 'backup_location',
        'backup_progress': 'backup_progress',
        'backup_status': 'backup_status',
        'bigstore': 'bigstore',
        'bigstore_ram_size': 'bigstore_ram_size',
        'bigstore_ram_weights': 'bigstore_ram_weights',
        'crdt': 'crdt',
        'crdt_causal_consistency': 'crdt_causal_consistency',
        'crdt_config_version': 'crdt_config_version',
        'crdt_featureset_version': 'crdt_featureset_version',
        'crdt_ghost_replica_ids': 'crdt_ghost_replica_ids',
        'crdt_guid': 'crdt_guid',
        'crdt_protocol_version': 'crdt_protocol_version',
        'crdt_repl_backlog_size': 'crdt_repl_backlog_size',
        'crdt_replica_id': 'crdt_replica_id',
        'crdt_replicas': 'crdt_replicas',
        'crdt_sources': 'crdt_sources',
        'crdt_sync': 'crdt_sync',
        'crdt_sync_dist': 'crdt_sync_dist',
        'crdt_syncer_auto_oom_unlatch': 'crdt_syncer_auto_oom_unlatch',
        'created_time': 'created_time',
        'data_internode_encryption': 'data_internode_encryption',
        'data_persistence': 'data_persistence',
        'dataset_import_sources': 'dataset_import_sources',
        'default_user': 'default_user',
        'disabled_commands': 'disabled_commands',
        'dns_address_master': 'dns_address_master',
        'email_alerts': 'email_alerts',
        'endpoint': 'endpoint',
        'endpoint_ip': 'endpoint_ip',
        'endpoint_node': 'endpoint_node',
        'endpoints': 'endpoints',
        'enforce_client_authentication': 'enforce_client_authentication',
        'eviction_policy': 'eviction_policy',
        'export_failure_reason': 'export_failure_reason',
        'export_progress': 'export_progress',
        'export_status': 'export_status',
        'generate_text_monitor': 'generate_text_monitor',
        'gradual_src_max_sources': 'gradual_src_max_sources	',
        'gradual_src_mode': 'gradual_src_mode',
        'gradual_sync_max_shards_per_source': 'gradual_sync_max_shards_per_source',
        'gradual_sync_mode': 'gradual_sync_mode',
        'hash_slots_policy': 'hash_slots_policy',
        'implicit_shard_key': 'implicit_shard_key',
        'import_failure_reason': 'import_failure_reason',
        'import_progress': 'import_progress',
        'import_status': 'import_status',
        'internal': 'internal',
        'last_backup_time': 'last_backup_time',
        'last_changed_time': 'last_changed_time',
        'last_export_time': 'last_export_time',
        'max_aof_file_size': 'max_aof_file_size',
        'max_aof_load_time': 'max_aof_load_time',
        'max_connections': 'max_connections',
        'memory_size': 'memory_size',
        'metrics_export_all': 'metrics_export_all',
        'mkms': 'mkms',
        'module_list': 'module_list',
        'mtls_allow_outdated_certs': 'mtls_allow_outdated_certs',
        'mtls_allow_weak_hashing': 'mtls_allow_weak_hashing',
        'name': 'name',
        'oss_cluster': 'oss_cluster',
        'oss_cluster_api_preferred_ip_type': 'oss_cluster_api_preferred_ip_type',
        'oss_sharding': 'oss_sharding',
        'port': 'port',
        'proxy_policy': 'proxy_policy',
        'rack_aware': 'rack_aware',
        'redis_version': 'redis_version',
        'repl_backlog_size': 'repl_backlog_size',
        'replica_sources': 'replica_sources',
        'replica_sync': 'replica_sync',
        'replica_sync_dist': 'replica_sync_dist',
        'replication': 'replication',
        'roles_permissions': 'roles_permissions',
        'shard_block_crossslot_keys': 'shard_block_crossslot_keys',
        'shard_block_foreign_keys': 'shard_block_foreign_keys',
        'shard_key_regex': 'shard_key_regex',
        'shard_list': 'shard_list',
        'sharding': 'sharding',
        'shards_count': 'shards_count',
        'shards_placement': 'shards_placement',
        'skip_import_analyze': 'skip_import_analyze',
        'slave_ha': 'slave_ha',
        'slave_ha_priority': 'slave_ha_priority',
        'snapshot_policy': 'snapshot_policy',
        'ssl': 'ssl',
        'status': 'status',
        'sync': 'sync',
        'sync_sources': 'sync_sources',
        'syncer_mode': 'syncer_mode',
        'tags': 'tags',
        'tls_mode': 'tls_mode',
        'type': 'type',
        'uid': 'uid',
        'use_nodes': 'use_nodes',
        'version': 'version',
        'wait_command': 'wait_command'
    }

    def __init__(self, account_id=None, action_uid=None, aof_policy='appendfsync-every-sec', authentication_admin_pass=None, authentication_redis_pass=None, authentication_sasl_pass=None, authentication_sasl_uname=None, authentication_ssl_client_certs=None, authentication_ssl_crdt_certs=None, authorized_names=None, auto_upgrade=None, avoid_nodes=None, background_op=None, backup=False, backup_failure_reason=None, backup_history=0, backup_interval=None, backup_interval_offset=None, backup_location=None, backup_progress=None, backup_status=None, bigstore=False, bigstore_ram_size=None, bigstore_ram_weights=None, crdt=False, crdt_causal_consistency=False, crdt_config_version=None, crdt_featureset_version=None, crdt_ghost_replica_ids=None, crdt_guid=None, crdt_protocol_version=None, crdt_repl_backlog_size=None, crdt_replica_id=None, crdt_replicas=None, crdt_sources=None, crdt_sync=None, crdt_sync_dist=None, crdt_syncer_auto_oom_unlatch=True, created_time=None, data_internode_encryption=None, data_persistence=None, dataset_import_sources=None, default_user=True, disabled_commands=None, dns_address_master=None, email_alerts=False, endpoint=None, endpoint_ip=None, endpoint_node=None, endpoints=None, enforce_client_authentication='enabled', eviction_policy=None, export_failure_reason=None, export_progress=None, export_status=None, generate_text_monitor=None, gradual_src_max_sources=1, gradual_src_mode=None, gradual_sync_max_shards_per_source=1, gradual_sync_mode=None, hash_slots_policy='16k', implicit_shard_key=False, import_failure_reason=None, import_progress=None, import_status=None, internal=False, last_backup_time=None, last_changed_time=None, last_export_time=None, max_aof_file_size=None, max_aof_load_time=None, max_connections=0, memory_size=0, metrics_export_all=None, mkms=True, module_list=None, mtls_allow_outdated_certs=None, mtls_allow_weak_hashing=None, name=None, oss_cluster=False, oss_cluster_api_preferred_ip_type='internal', oss_sharding=False, port=None, proxy_policy=None, rack_aware=False, redis_version=None, repl_backlog_size=None, replica_sources=None, replica_sync=None, replica_sync_dist=None, replication=False, roles_permissions=None, shard_block_crossslot_keys=False, shard_block_foreign_keys=True, shard_key_regex=None, shard_list=None, sharding=False, shards_count=1, shards_placement='dense', skip_import_analyze=None, slave_ha=None, slave_ha_priority=None, snapshot_policy=None, ssl=False, status=None, sync=None, sync_sources=None, syncer_mode=None, tags=None, tls_mode='disabled', type='redis', uid=None, use_nodes=None, version=None, wait_command=True):  # noqa: E501
        """Bdb - a model defined in Swagger"""  # noqa: E501
        self._account_id = None
        self._action_uid = None
        self._aof_policy = None
        self._authentication_admin_pass = None
        self._authentication_redis_pass = None
        self._authentication_sasl_pass = None
        self._authentication_sasl_uname = None
        self._authentication_ssl_client_certs = None
        self._authentication_ssl_crdt_certs = None
        self._authorized_names = None
        self._auto_upgrade = None
        self._avoid_nodes = None
        self._background_op = None
        self._backup = None
        self._backup_failure_reason = None
        self._backup_history = None
        self._backup_interval = None
        self._backup_interval_offset = None
        self._backup_location = None
        self._backup_progress = None
        self._backup_status = None
        self._bigstore = None
        self._bigstore_ram_size = None
        self._bigstore_ram_weights = None
        self._crdt = None
        self._crdt_causal_consistency = None
        self._crdt_config_version = None
        self._crdt_featureset_version = None
        self._crdt_ghost_replica_ids = None
        self._crdt_guid = None
        self._crdt_protocol_version = None
        self._crdt_repl_backlog_size = None
        self._crdt_replica_id = None
        self._crdt_replicas = None
        self._crdt_sources = None
        self._crdt_sync = None
        self._crdt_sync_dist = None
        self._crdt_syncer_auto_oom_unlatch = None
        self._created_time = None
        self._data_internode_encryption = None
        self._data_persistence = None
        self._dataset_import_sources = None
        self._default_user = None
        self._disabled_commands = None
        self._dns_address_master = None
        self._email_alerts = None
        self._endpoint = None
        self._endpoint_ip = None
        self._endpoint_node = None
        self._endpoints = None
        self._enforce_client_authentication = None
        self._eviction_policy = None
        self._export_failure_reason = None
        self._export_progress = None
        self._export_status = None
        self._generate_text_monitor = None
        self._gradual_src_max_sources = None
        self._gradual_src_mode = None
        self._gradual_sync_max_shards_per_source = None
        self._gradual_sync_mode = None
        self._hash_slots_policy = None
        self._implicit_shard_key = None
        self._import_failure_reason = None
        self._import_progress = None
        self._import_status = None
        self._internal = None
        self._last_backup_time = None
        self._last_changed_time = None
        self._last_export_time = None
        self._max_aof_file_size = None
        self._max_aof_load_time = None
        self._max_connections = None
        self._memory_size = None
        self._metrics_export_all = None
        self._mkms = None
        self._module_list = None
        self._mtls_allow_outdated_certs = None
        self._mtls_allow_weak_hashing = None
        self._name = None
        self._oss_cluster = None
        self._oss_cluster_api_preferred_ip_type = None
        self._oss_sharding = None
        self._port = None
        self._proxy_policy = None
        self._rack_aware = None
        self._redis_version = None
        self._repl_backlog_size = None
        self._replica_sources = None
        self._replica_sync = None
        self._replica_sync_dist = None
        self._replication = None
        self._roles_permissions = None
        self._shard_block_crossslot_keys = None
        self._shard_block_foreign_keys = None
        self._shard_key_regex = None
        self._shard_list = None
        self._sharding = None
        self._shards_count = None
        self._shards_placement = None
        self._skip_import_analyze = None
        self._slave_ha = None
        self._slave_ha_priority = None
        self._snapshot_policy = None
        self._ssl = None
        self._status = None
        self._sync = None
        self._sync_sources = None
        self._syncer_mode = None
        self._tags = None
        self._tls_mode = None
        self._type = None
        self._uid = None
        self._use_nodes = None
        self._version = None
        self._wait_command = None
        self.discriminator = None
        if account_id is not None:
            self.account_id = account_id
        if action_uid is not None:
            self.action_uid = action_uid
        if aof_policy is not None:
            self.aof_policy = aof_policy
        if authentication_admin_pass is not None:
            self.authentication_admin_pass = authentication_admin_pass
        if authentication_redis_pass is not None:
            self.authentication_redis_pass = authentication_redis_pass
        if authentication_sasl_pass is not None:
            self.authentication_sasl_pass = authentication_sasl_pass
        if authentication_sasl_uname is not None:
            self.authentication_sasl_uname = authentication_sasl_uname
        if authentication_ssl_client_certs is not None:
            self.authentication_ssl_client_certs = authentication_ssl_client_certs
        if authentication_ssl_crdt_certs is not None:
            self.authentication_ssl_crdt_certs = authentication_ssl_crdt_certs
        if authorized_names is not None:
            self.authorized_names = authorized_names
        if auto_upgrade is not None:
            self.auto_upgrade = auto_upgrade
        if avoid_nodes is not None:
            self.avoid_nodes = avoid_nodes
        if background_op is not None:
            self.background_op = background_op
        if backup is not None:
            self.backup = backup
        if backup_failure_reason is not None:
            self.backup_failure_reason = backup_failure_reason
        if backup_history is not None:
            self.backup_history = backup_history
        if backup_interval is not None:
            self.backup_interval = backup_interval
        if backup_interval_offset is not None:
            self.backup_interval_offset = backup_interval_offset
        if backup_location is not None:
            self.backup_location = backup_location
        if backup_progress is not None:
            self.backup_progress = backup_progress
        if backup_status is not None:
            self.backup_status = backup_status
        if bigstore is not None:
            self.bigstore = bigstore
        if bigstore_ram_size is not None:
            self.bigstore_ram_size = bigstore_ram_size
        if bigstore_ram_weights is not None:
            self.bigstore_ram_weights = bigstore_ram_weights
        if crdt is not None:
            self.crdt = crdt
        if crdt_causal_consistency is not None:
            self.crdt_causal_consistency = crdt_causal_consistency
        if crdt_config_version is not None:
            self.crdt_config_version = crdt_config_version
        if crdt_featureset_version is not None:
            self.crdt_featureset_version = crdt_featureset_version
        if crdt_ghost_replica_ids is not None:
            self.crdt_ghost_replica_ids = crdt_ghost_replica_ids
        if crdt_guid is not None:
            self.crdt_guid = crdt_guid
        if crdt_protocol_version is not None:
            self.crdt_protocol_version = crdt_protocol_version
        if crdt_repl_backlog_size is not None:
            self.crdt_repl_backlog_size = crdt_repl_backlog_size
        if crdt_replica_id is not None:
            self.crdt_replica_id = crdt_replica_id
        if crdt_replicas is not None:
            self.crdt_replicas = crdt_replicas
        if crdt_sources is not None:
            self.crdt_sources = crdt_sources
        if crdt_sync is not None:
            self.crdt_sync = crdt_sync
        if crdt_sync_dist is not None:
            self.crdt_sync_dist = crdt_sync_dist
        if crdt_syncer_auto_oom_unlatch is not None:
            self.crdt_syncer_auto_oom_unlatch = crdt_syncer_auto_oom_unlatch
        if created_time is not None:
            self.created_time = created_time
        if data_internode_encryption is not None:
            self.data_internode_encryption = data_internode_encryption
        if data_persistence is not None:
            self.data_persistence = data_persistence
        if dataset_import_sources is not None:
            self.dataset_import_sources = dataset_import_sources
        if default_user is not None:
            self.default_user = default_user
        if disabled_commands is not None:
            self.disabled_commands = disabled_commands
        if dns_address_master is not None:
            self.dns_address_master = dns_address_master
        if email_alerts is not None:
            self.email_alerts = email_alerts
        if endpoint is not None:
            self.endpoint = endpoint
        if endpoint_ip is not None:
            self.endpoint_ip = endpoint_ip
        if endpoint_node is not None:
            self.endpoint_node = endpoint_node
        if endpoints is not None:
            self.endpoints = endpoints
        if enforce_client_authentication is not None:
            self.enforce_client_authentication = enforce_client_authentication
        if eviction_policy is not None:
            self.eviction_policy = eviction_policy
        if export_failure_reason is not None:
            self.export_failure_reason = export_failure_reason
        if export_progress is not None:
            self.export_progress = export_progress
        if export_status is not None:
            self.export_status = export_status
        if generate_text_monitor is not None:
            self.generate_text_monitor = generate_text_monitor
        if gradual_src_max_sources is not None:
            self.gradual_src_max_sources = gradual_src_max_sources
        if gradual_src_mode is not None:
            self.gradual_src_mode = gradual_src_mode
        if gradual_sync_max_shards_per_source is not None:
            self.gradual_sync_max_shards_per_source = gradual_sync_max_shards_per_source
        if gradual_sync_mode is not None:
            self.gradual_sync_mode = gradual_sync_mode
        if hash_slots_policy is not None:
            self.hash_slots_policy = hash_slots_policy
        if implicit_shard_key is not None:
            self.implicit_shard_key = implicit_shard_key
        if import_failure_reason is not None:
            self.import_failure_reason = import_failure_reason
        if import_progress is not None:
            self.import_progress = import_progress
        if import_status is not None:
            self.import_status = import_status
        if internal is not None:
            self.internal = internal
        if last_backup_time is not None:
            self.last_backup_time = last_backup_time
        if last_changed_time is not None:
            self.last_changed_time = last_changed_time
        if last_export_time is not None:
            self.last_export_time = last_export_time
        if max_aof_file_size is not None:
            self.max_aof_file_size = max_aof_file_size
        if max_aof_load_time is not None:
            self.max_aof_load_time = max_aof_load_time
        if max_connections is not None:
            self.max_connections = max_connections
        if memory_size is not None:
            self.memory_size = memory_size
        if metrics_export_all is not None:
            self.metrics_export_all = metrics_export_all
        if mkms is not None:
            self.mkms = mkms
        if module_list is not None:
            self.module_list = module_list
        if mtls_allow_outdated_certs is not None:
            self.mtls_allow_outdated_certs = mtls_allow_outdated_certs
        if mtls_allow_weak_hashing is not None:
            self.mtls_allow_weak_hashing = mtls_allow_weak_hashing
        if name is not None:
            self.name = name
        if oss_cluster is not None:
            self.oss_cluster = oss_cluster
        if oss_cluster_api_preferred_ip_type is not None:
            self.oss_cluster_api_preferred_ip_type = oss_cluster_api_preferred_ip_type
        if oss_sharding is not None:
            self.oss_sharding = oss_sharding
        if port is not None:
            self.port = port
        if proxy_policy is not None:
            self.proxy_policy = proxy_policy
        if rack_aware is not None:
            self.rack_aware = rack_aware
        if redis_version is not None:
            self.redis_version = redis_version
        if repl_backlog_size is not None:
            self.repl_backlog_size = repl_backlog_size
        if replica_sources is not None:
            self.replica_sources = replica_sources
        if replica_sync is not None:
            self.replica_sync = replica_sync
        if replica_sync_dist is not None:
            self.replica_sync_dist = replica_sync_dist
        if replication is not None:
            self.replication = replication
        if roles_permissions is not None:
            self.roles_permissions = roles_permissions
        if shard_block_crossslot_keys is not None:
            self.shard_block_crossslot_keys = shard_block_crossslot_keys
        if shard_block_foreign_keys is not None:
            self.shard_block_foreign_keys = shard_block_foreign_keys
        if shard_key_regex is not None:
            self.shard_key_regex = shard_key_regex
        if shard_list is not None:
            self.shard_list = shard_list
        if sharding is not None:
            self.sharding = sharding
        if shards_count is not None:
            self.shards_count = shards_count
        if shards_placement is not None:
            self.shards_placement = shards_placement
        if skip_import_analyze is not None:
            self.skip_import_analyze = skip_import_analyze
        if slave_ha is not None:
            self.slave_ha = slave_ha
        if slave_ha_priority is not None:
            self.slave_ha_priority = slave_ha_priority
        if snapshot_policy is not None:
            self.snapshot_policy = snapshot_policy
        if ssl is not None:
            self.ssl = ssl
        if status is not None:
            self.status = status
        if sync is not None:
            self.sync = sync
        if sync_sources is not None:
            self.sync_sources = sync_sources
        if syncer_mode is not None:
            self.syncer_mode = syncer_mode
        if tags is not None:
            self.tags = tags
        if tls_mode is not None:
            self.tls_mode = tls_mode
        if type is not None:
            self.type = type
        if uid is not None:
            self.uid = uid
        if use_nodes is not None:
            self.use_nodes = use_nodes
        if version is not None:
            self.version = version
        if wait_command is not None:
            self.wait_command = wait_command

    @property
    def account_id(self):
        """Gets the account_id of this Bdb.  # noqa: E501

        SM account ID  # noqa: E501

        :return: The account_id of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._account_id

    @account_id.setter
    def account_id(self, account_id):
        """Sets the account_id of this Bdb.

        SM account ID  # noqa: E501

        :param account_id: The account_id of this Bdb.  # noqa: E501
        :type: int
        """

        self._account_id = account_id

    @property
    def action_uid(self):
        """Gets the action_uid of this Bdb.  # noqa: E501

        Currently running action's uid  # noqa: E501

        :return: The action_uid of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._action_uid

    @action_uid.setter
    def action_uid(self, action_uid):
        """Sets the action_uid of this Bdb.

        Currently running action's uid  # noqa: E501

        :param action_uid: The action_uid of this Bdb.  # noqa: E501
        :type: str
        """

        self._action_uid = action_uid

    @property
    def aof_policy(self):
        """Gets the aof_policy of this Bdb.  # noqa: E501

        Policy for Append-Only File data persistence  # noqa: E501

        :return: The aof_policy of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._aof_policy

    @aof_policy.setter
    def aof_policy(self, aof_policy):
        """Sets the aof_policy of this Bdb.

        Policy for Append-Only File data persistence  # noqa: E501

        :param aof_policy: The aof_policy of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["appendfsync-every-sec", "appendfsync-always"]  # noqa: E501
        if aof_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `aof_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(aof_policy, allowed_values)
            )

        self._aof_policy = aof_policy

    @property
    def authentication_admin_pass(self):
        """Gets the authentication_admin_pass of this Bdb.  # noqa: E501

        Password for administrative access to the BDB (used for SYNC from the BDB)  # noqa: E501

        :return: The authentication_admin_pass of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._authentication_admin_pass

    @authentication_admin_pass.setter
    def authentication_admin_pass(self, authentication_admin_pass):
        """Sets the authentication_admin_pass of this Bdb.

        Password for administrative access to the BDB (used for SYNC from the BDB)  # noqa: E501

        :param authentication_admin_pass: The authentication_admin_pass of this Bdb.  # noqa: E501
        :type: str
        """

        self._authentication_admin_pass = authentication_admin_pass

    @property
    def authentication_redis_pass(self):
        """Gets the authentication_redis_pass of this Bdb.  # noqa: E501

        Redis AUTH password authentication  # noqa: E501

        :return: The authentication_redis_pass of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._authentication_redis_pass

    @authentication_redis_pass.setter
    def authentication_redis_pass(self, authentication_redis_pass):
        """Sets the authentication_redis_pass of this Bdb.

        Redis AUTH password authentication  # noqa: E501

        :param authentication_redis_pass: The authentication_redis_pass of this Bdb.  # noqa: E501
        :type: str
        """

        self._authentication_redis_pass = authentication_redis_pass

    @property
    def authentication_sasl_pass(self):
        """Gets the authentication_sasl_pass of this Bdb.  # noqa: E501

        Binary memcache SASL password  # noqa: E501

        :return: The authentication_sasl_pass of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._authentication_sasl_pass

    @authentication_sasl_pass.setter
    def authentication_sasl_pass(self, authentication_sasl_pass):
        """Sets the authentication_sasl_pass of this Bdb.

        Binary memcache SASL password  # noqa: E501

        :param authentication_sasl_pass: The authentication_sasl_pass of this Bdb.  # noqa: E501
        :type: str
        """

        self._authentication_sasl_pass = authentication_sasl_pass

    @property
    def authentication_sasl_uname(self):
        """Gets the authentication_sasl_uname of this Bdb.  # noqa: E501

        Binary memcache SASL username (pattern does not allow special characters &,<,>,\\\")  # noqa: E501

        :return: The authentication_sasl_uname of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._authentication_sasl_uname

    @authentication_sasl_uname.setter
    def authentication_sasl_uname(self, authentication_sasl_uname):
        """Sets the authentication_sasl_uname of this Bdb.

        Binary memcache SASL username (pattern does not allow special characters &,<,>,\\\")  # noqa: E501

        :param authentication_sasl_uname: The authentication_sasl_uname of this Bdb.  # noqa: E501
        :type: str
        """

        self._authentication_sasl_uname = authentication_sasl_uname

    @property
    def authentication_ssl_client_certs(self):
        """Gets the authentication_ssl_client_certs of this Bdb.  # noqa: E501

        List of authorized client certificates  # noqa: E501

        :return: The authentication_ssl_client_certs of this Bdb.  # noqa: E501
        :rtype: list[BdbAuthenticationSslClientCerts]
        """
        return self._authentication_ssl_client_certs

    @authentication_ssl_client_certs.setter
    def authentication_ssl_client_certs(self, authentication_ssl_client_certs):
        """Sets the authentication_ssl_client_certs of this Bdb.

        List of authorized client certificates  # noqa: E501

        :param authentication_ssl_client_certs: The authentication_ssl_client_certs of this Bdb.  # noqa: E501
        :type: list[BdbAuthenticationSslClientCerts]
        """

        self._authentication_ssl_client_certs = authentication_ssl_client_certs

    @property
    def authentication_ssl_crdt_certs(self):
        """Gets the authentication_ssl_crdt_certs of this Bdb.  # noqa: E501

        List of authorized crdt certificates   # noqa: E501

        :return: The authentication_ssl_crdt_certs of this Bdb.  # noqa: E501
        :rtype: list[BdbAuthenticationSslClientCerts]
        """
        return self._authentication_ssl_crdt_certs

    @authentication_ssl_crdt_certs.setter
    def authentication_ssl_crdt_certs(self, authentication_ssl_crdt_certs):
        """Sets the authentication_ssl_crdt_certs of this Bdb.

        List of authorized crdt certificates   # noqa: E501

        :param authentication_ssl_crdt_certs: The authentication_ssl_crdt_certs of this Bdb.  # noqa: E501
        :type: list[BdbAuthenticationSslClientCerts]
        """

        self._authentication_ssl_crdt_certs = authentication_ssl_crdt_certs

    @property
    def authorized_names(self):
        """Gets the authorized_names of this Bdb.  # noqa: E501

        Additional certified names  # noqa: E501

        :return: The authorized_names of this Bdb.  # noqa: E501
        :rtype: list[str]
        """
        return self._authorized_names

    @authorized_names.setter
    def authorized_names(self, authorized_names):
        """Sets the authorized_names of this Bdb.

        Additional certified names  # noqa: E501

        :param authorized_names: The authorized_names of this Bdb.  # noqa: E501
        :type: list[str]
        """

        self._authorized_names = authorized_names

    @property
    def auto_upgrade(self):
        """Gets the auto_upgrade of this Bdb.  # noqa: E501

        Should upgrade automatically after a cluster upgrade  # noqa: E501

        :return: The auto_upgrade of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._auto_upgrade

    @auto_upgrade.setter
    def auto_upgrade(self, auto_upgrade):
        """Sets the auto_upgrade of this Bdb.

        Should upgrade automatically after a cluster upgrade  # noqa: E501

        :param auto_upgrade: The auto_upgrade of this Bdb.  # noqa: E501
        :type: bool
        """

        self._auto_upgrade = auto_upgrade

    @property
    def avoid_nodes(self):
        """Gets the avoid_nodes of this Bdb.  # noqa: E501

        Cluster node uids to avoid when placing the bdb's shards and binding its endpoints  # noqa: E501

        :return: The avoid_nodes of this Bdb.  # noqa: E501
        :rtype: list[str]
        """
        return self._avoid_nodes

    @avoid_nodes.setter
    def avoid_nodes(self, avoid_nodes):
        """Sets the avoid_nodes of this Bdb.

        Cluster node uids to avoid when placing the bdb's shards and binding its endpoints  # noqa: E501

        :param avoid_nodes: The avoid_nodes of this Bdb.  # noqa: E501
        :type: list[str]
        """

        self._avoid_nodes = avoid_nodes

    @property
    def background_op(self):
        """Gets the background_op of this Bdb.  # noqa: E501

        A description of the current operation the bdb is running  # noqa: E501

        :return: The background_op of this Bdb.  # noqa: E501
        :rtype: list[BdbBackgroundOp]
        """
        return self._background_op

    @background_op.setter
    def background_op(self, background_op):
        """Sets the background_op of this Bdb.

        A description of the current operation the bdb is running  # noqa: E501

        :param background_op: The background_op of this Bdb.  # noqa: E501
        :type: list[BdbBackgroundOp]
        """

        self._background_op = background_op

    @property
    def backup(self):
        """Gets the backup of this Bdb.  # noqa: E501

        Policy for periodic database backup  # noqa: E501

        :return: The backup of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._backup

    @backup.setter
    def backup(self, backup):
        """Sets the backup of this Bdb.

        Policy for periodic database backup  # noqa: E501

        :param backup: The backup of this Bdb.  # noqa: E501
        :type: bool
        """

        self._backup = backup

    @property
    def backup_failure_reason(self):
        """Gets the backup_failure_reason of this Bdb.  # noqa: E501

        Reason of last failed backup process  # noqa: E501

        :return: The backup_failure_reason of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._backup_failure_reason

    @backup_failure_reason.setter
    def backup_failure_reason(self, backup_failure_reason):
        """Sets the backup_failure_reason of this Bdb.

        Reason of last failed backup process  # noqa: E501

        :param backup_failure_reason: The backup_failure_reason of this Bdb.  # noqa: E501
        :type: str
        """

        self._backup_failure_reason = backup_failure_reason

    @property
    def backup_history(self):
        """Gets the backup_history of this Bdb.  # noqa: E501

        Backup history retention policy (number of days, 0 is forever)  # noqa: E501

        :return: The backup_history of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._backup_history

    @backup_history.setter
    def backup_history(self, backup_history):
        """Sets the backup_history of this Bdb.

        Backup history retention policy (number of days, 0 is forever)  # noqa: E501

        :param backup_history: The backup_history of this Bdb.  # noqa: E501
        :type: int
        """

        self._backup_history = backup_history

    @property
    def backup_interval(self):
        """Gets the backup_interval of this Bdb.  # noqa: E501

        Interval in seconds in which automatic backup will be initiated  # noqa: E501

        :return: The backup_interval of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._backup_interval

    @backup_interval.setter
    def backup_interval(self, backup_interval):
        """Sets the backup_interval of this Bdb.

        Interval in seconds in which automatic backup will be initiated  # noqa: E501

        :param backup_interval: The backup_interval of this Bdb.  # noqa: E501
        :type: int
        """

        self._backup_interval = backup_interval

    @property
    def backup_interval_offset(self):
        """Gets the backup_interval_offset of this Bdb.  # noqa: E501

        Offset (in seconds) from round backup interval when automatic backup will be initiated (should be less than backup_interval)  # noqa: E501

        :return: The backup_interval_offset of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._backup_interval_offset

    @backup_interval_offset.setter
    def backup_interval_offset(self, backup_interval_offset):
        """Sets the backup_interval_offset of this Bdb.

        Offset (in seconds) from round backup interval when automatic backup will be initiated (should be less than backup_interval)  # noqa: E501

        :param backup_interval_offset: The backup_interval_offset of this Bdb.  # noqa: E501
        :type: int
        """

        self._backup_interval_offset = backup_interval_offset

    @property
    def backup_location(self):
        """Gets the backup_location of this Bdb.  # noqa: E501

        Target for automatic database backups. GET /jsonschema to retrieve the object's structure. See also the 'bdb -> backup_location' section.  # noqa: E501

        :return: The backup_location of this Bdb.  # noqa: E501
        :rtype: AnyOfbdbBackupLocation
        """
        return self._backup_location

    @backup_location.setter
    def backup_location(self, backup_location):
        """Sets the backup_location of this Bdb.

        Target for automatic database backups. GET /jsonschema to retrieve the object's structure. See also the 'bdb -> backup_location' section.  # noqa: E501

        :param backup_location: The backup_location of this Bdb.  # noqa: E501
        :type: AnyOfbdbBackupLocation
        """

        self._backup_location = backup_location

    @property
    def backup_progress(self):
        """Gets the backup_progress of this Bdb.  # noqa: E501

        Database scheduled periodic backup progress (percentage)  # noqa: E501

        :return: The backup_progress of this Bdb.  # noqa: E501
        :rtype: float
        """
        return self._backup_progress

    @backup_progress.setter
    def backup_progress(self, backup_progress):
        """Sets the backup_progress of this Bdb.

        Database scheduled periodic backup progress (percentage)  # noqa: E501

        :param backup_progress: The backup_progress of this Bdb.  # noqa: E501
        :type: float
        """

        self._backup_progress = backup_progress

    @property
    def backup_status(self):
        """Gets the backup_status of this Bdb.  # noqa: E501

        Status of scheduled periodic backup process  # noqa: E501

        :return: The backup_status of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._backup_status

    @backup_status.setter
    def backup_status(self, backup_status):
        """Sets the backup_status of this Bdb.

        Status of scheduled periodic backup process  # noqa: E501

        :param backup_status: The backup_status of this Bdb.  # noqa: E501
        :type: str
        """

        self._backup_status = backup_status

    @property
    def bigstore(self):
        """Gets the bigstore of this Bdb.  # noqa: E501

        Database bigstore option  # noqa: E501

        :return: The bigstore of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._bigstore

    @bigstore.setter
    def bigstore(self, bigstore):
        """Sets the bigstore of this Bdb.

        Database bigstore option  # noqa: E501

        :param bigstore: The bigstore of this Bdb.  # noqa: E501
        :type: bool
        """

        self._bigstore = bigstore

    @property
    def bigstore_ram_size(self):
        """Gets the bigstore_ram_size of this Bdb.  # noqa: E501

        Memory size of bigstore RAM part.  # noqa: E501

        :return: The bigstore_ram_size of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._bigstore_ram_size

    @bigstore_ram_size.setter
    def bigstore_ram_size(self, bigstore_ram_size):
        """Sets the bigstore_ram_size of this Bdb.

        Memory size of bigstore RAM part.  # noqa: E501

        :param bigstore_ram_size: The bigstore_ram_size of this Bdb.  # noqa: E501
        :type: int
        """

        self._bigstore_ram_size = bigstore_ram_size

    @property
    def bigstore_ram_weights(self):
        """Gets the bigstore_ram_weights of this Bdb.  # noqa: E501

        List of shard UIDs and their bigstore RAM weights  # noqa: E501

        :return: The bigstore_ram_weights of this Bdb.  # noqa: E501
        :rtype: list[BdbBigstoreRamWeights]
        """
        return self._bigstore_ram_weights

    @bigstore_ram_weights.setter
    def bigstore_ram_weights(self, bigstore_ram_weights):
        """Sets the bigstore_ram_weights of this Bdb.

        List of shard UIDs and their bigstore RAM weights  # noqa: E501

        :param bigstore_ram_weights: The bigstore_ram_weights of this Bdb.  # noqa: E501
        :type: list[BdbBigstoreRamWeights]
        """

        self._bigstore_ram_weights = bigstore_ram_weights

    @property
    def crdt(self):
        """Gets the crdt of this Bdb.  # noqa: E501

        Use CRDT-based data types for multi-master replication  # noqa: E501

        :return: The crdt of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._crdt

    @crdt.setter
    def crdt(self, crdt):
        """Sets the crdt of this Bdb.

        Use CRDT-based data types for multi-master replication  # noqa: E501

        :param crdt: The crdt of this Bdb.  # noqa: E501
        :type: bool
        """

        self._crdt = crdt

    @property
    def crdt_causal_consistency(self):
        """Gets the crdt_causal_consistency of this Bdb.  # noqa: E501

        Causal consistent CRDB.  # noqa: E501

        :return: The crdt_causal_consistency of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._crdt_causal_consistency

    @crdt_causal_consistency.setter
    def crdt_causal_consistency(self, crdt_causal_consistency):
        """Sets the crdt_causal_consistency of this Bdb.

        Causal consistent CRDB.  # noqa: E501

        :param crdt_causal_consistency: The crdt_causal_consistency of this Bdb.  # noqa: E501
        :type: bool
        """

        self._crdt_causal_consistency = crdt_causal_consistency

    @property
    def crdt_config_version(self):
        """Gets the crdt_config_version of this Bdb.  # noqa: E501

        Replica-set configuration version, for internal use only.  # noqa: E501

        :return: The crdt_config_version of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._crdt_config_version

    @crdt_config_version.setter
    def crdt_config_version(self, crdt_config_version):
        """Sets the crdt_config_version of this Bdb.

        Replica-set configuration version, for internal use only.  # noqa: E501

        :param crdt_config_version: The crdt_config_version of this Bdb.  # noqa: E501
        :type: int
        """

        self._crdt_config_version = crdt_config_version

    @property
    def crdt_featureset_version(self):
        """Gets the crdt_featureset_version of this Bdb.  # noqa: E501

        CRDB active FeatureSet version  # noqa: E501

        :return: The crdt_featureset_version of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._crdt_featureset_version

    @crdt_featureset_version.setter
    def crdt_featureset_version(self, crdt_featureset_version):
        """Sets the crdt_featureset_version of this Bdb.

        CRDB active FeatureSet version  # noqa: E501

        :param crdt_featureset_version: The crdt_featureset_version of this Bdb.  # noqa: E501
        :type: int
        """

        self._crdt_featureset_version = crdt_featureset_version

    @property
    def crdt_ghost_replica_ids(self):
        """Gets the crdt_ghost_replica_ids of this Bdb.  # noqa: E501

        Removed replicas IDs, for internal use only.  # noqa: E501

        :return: The crdt_ghost_replica_ids of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._crdt_ghost_replica_ids

    @crdt_ghost_replica_ids.setter
    def crdt_ghost_replica_ids(self, crdt_ghost_replica_ids):
        """Sets the crdt_ghost_replica_ids of this Bdb.

        Removed replicas IDs, for internal use only.  # noqa: E501

        :param crdt_ghost_replica_ids: The crdt_ghost_replica_ids of this Bdb.  # noqa: E501
        :type: str
        """

        self._crdt_ghost_replica_ids = crdt_ghost_replica_ids

    @property
    def crdt_guid(self):
        """Gets the crdt_guid of this Bdb.  # noqa: E501

        GUID of CRDB this bdb is part of, for internal use only.  # noqa: E501

        :return: The crdt_guid of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._crdt_guid

    @crdt_guid.setter
    def crdt_guid(self, crdt_guid):
        """Sets the crdt_guid of this Bdb.

        GUID of CRDB this bdb is part of, for internal use only.  # noqa: E501

        :param crdt_guid: The crdt_guid of this Bdb.  # noqa: E501
        :type: str
        """

        self._crdt_guid = crdt_guid

    @property
    def crdt_protocol_version(self):
        """Gets the crdt_protocol_version of this Bdb.  # noqa: E501

        CRDB active Protocol version  # noqa: E501

        :return: The crdt_protocol_version of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._crdt_protocol_version

    @crdt_protocol_version.setter
    def crdt_protocol_version(self, crdt_protocol_version):
        """Sets the crdt_protocol_version of this Bdb.

        CRDB active Protocol version  # noqa: E501

        :param crdt_protocol_version: The crdt_protocol_version of this Bdb.  # noqa: E501
        :type: int
        """

        self._crdt_protocol_version = crdt_protocol_version

    @property
    def crdt_repl_backlog_size(self):
        """Gets the crdt_repl_backlog_size of this Bdb.  # noqa: E501

        Active-Active replication backlog size ('auto' or size in bytes)  # noqa: E501

        :return: The crdt_repl_backlog_size of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._crdt_repl_backlog_size

    @crdt_repl_backlog_size.setter
    def crdt_repl_backlog_size(self, crdt_repl_backlog_size):
        """Sets the crdt_repl_backlog_size of this Bdb.

        Active-Active replication backlog size ('auto' or size in bytes)  # noqa: E501

        :param crdt_repl_backlog_size: The crdt_repl_backlog_size of this Bdb.  # noqa: E501
        :type: str
        """

        self._crdt_repl_backlog_size = crdt_repl_backlog_size

    @property
    def crdt_replica_id(self):
        """Gets the crdt_replica_id of this Bdb.  # noqa: E501

        Local replica-id, for internal use only.  # noqa: E501

        :return: The crdt_replica_id of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._crdt_replica_id

    @crdt_replica_id.setter
    def crdt_replica_id(self, crdt_replica_id):
        """Sets the crdt_replica_id of this Bdb.

        Local replica-id, for internal use only.  # noqa: E501

        :param crdt_replica_id: The crdt_replica_id of this Bdb.  # noqa: E501
        :type: int
        """

        self._crdt_replica_id = crdt_replica_id

    @property
    def crdt_replicas(self):
        """Gets the crdt_replicas of this Bdb.  # noqa: E501

        Replica-set configuration, for internal use only.  # noqa: E501

        :return: The crdt_replicas of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._crdt_replicas

    @crdt_replicas.setter
    def crdt_replicas(self, crdt_replicas):
        """Sets the crdt_replicas of this Bdb.

        Replica-set configuration, for internal use only.  # noqa: E501

        :param crdt_replicas: The crdt_replicas of this Bdb.  # noqa: E501
        :type: str
        """

        self._crdt_replicas = crdt_replicas

    @property
    def crdt_sources(self):
        """Gets the crdt_sources of this Bdb.  # noqa: E501

        Remote endpoints/peers of CRDB database to sync from. See the 'bdb -> replica_sources' section  # noqa: E501

        :return: The crdt_sources of this Bdb.  # noqa: E501
        :rtype: AllOfbdbCrdtSources
        """
        return self._crdt_sources

    @crdt_sources.setter
    def crdt_sources(self, crdt_sources):
        """Sets the crdt_sources of this Bdb.

        Remote endpoints/peers of CRDB database to sync from. See the 'bdb -> replica_sources' section  # noqa: E501

        :param crdt_sources: The crdt_sources of this Bdb.  # noqa: E501
        :type: AllOfbdbCrdtSources
        """

        self._crdt_sources = crdt_sources

    @property
    def crdt_sync(self):
        """Gets the crdt_sync of this Bdb.  # noqa: E501

        Allow to enable, disable or pause syncing from specified crdt_sources. Applicable only for CRDB bdb. See the 'bdb -> replica_sync' section  # noqa: E501

        :return: The crdt_sync of this Bdb.  # noqa: E501
        :rtype: AllOfbdbCrdtSync
        """
        return self._crdt_sync

    @crdt_sync.setter
    def crdt_sync(self, crdt_sync):
        """Sets the crdt_sync of this Bdb.

        Allow to enable, disable or pause syncing from specified crdt_sources. Applicable only for CRDB bdb. See the 'bdb -> replica_sync' section  # noqa: E501

        :param crdt_sync: The crdt_sync of this Bdb.  # noqa: E501
        :type: AllOfbdbCrdtSync
        """

        self._crdt_sync = crdt_sync

    @property
    def crdt_sync_dist(self):
        """Gets the crdt_sync_dist of this Bdb.  # noqa: E501

        Enable/Disable distributed syncer in master-master  # noqa: E501

        :return: The crdt_sync_dist of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._crdt_sync_dist

    @crdt_sync_dist.setter
    def crdt_sync_dist(self, crdt_sync_dist):
        """Sets the crdt_sync_dist of this Bdb.

        Enable/Disable distributed syncer in master-master  # noqa: E501

        :param crdt_sync_dist: The crdt_sync_dist of this Bdb.  # noqa: E501
        :type: bool
        """

        self._crdt_sync_dist = crdt_sync_dist

    @property
    def crdt_syncer_auto_oom_unlatch(self):
        """Gets the crdt_syncer_auto_oom_unlatch of this Bdb.  # noqa: E501

        Syncer automatically attempts to recover synchronisation from peers after this BDB got Out-Of-Memory. Otherwise, the syncer exits  # noqa: E501

        :return: The crdt_syncer_auto_oom_unlatch of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._crdt_syncer_auto_oom_unlatch

    @crdt_syncer_auto_oom_unlatch.setter
    def crdt_syncer_auto_oom_unlatch(self, crdt_syncer_auto_oom_unlatch):
        """Sets the crdt_syncer_auto_oom_unlatch of this Bdb.

        Syncer automatically attempts to recover synchronisation from peers after this BDB got Out-Of-Memory. Otherwise, the syncer exits  # noqa: E501

        :param crdt_syncer_auto_oom_unlatch: The crdt_syncer_auto_oom_unlatch of this Bdb.  # noqa: E501
        :type: bool
        """

        self._crdt_syncer_auto_oom_unlatch = crdt_syncer_auto_oom_unlatch

    @property
    def created_time(self):
        """Gets the created_time of this Bdb.  # noqa: E501

        The date and time the database was created  # noqa: E501

        :return: The created_time of this Bdb.  # noqa: E501
        :rtype: datetime
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """Sets the created_time of this Bdb.

        The date and time the database was created  # noqa: E501

        :param created_time: The created_time of this Bdb.  # noqa: E501
        :type: datetime
        """

        self._created_time = created_time

    @property
    def data_internode_encryption(self):
        """Gets the data_internode_encryption of this Bdb.  # noqa: E501

        Should the data plane internode communication for this database be encrypted  # noqa: E501

        :return: The data_internode_encryption of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._data_internode_encryption

    @data_internode_encryption.setter
    def data_internode_encryption(self, data_internode_encryption):
        """Sets the data_internode_encryption of this Bdb.

        Should the data plane internode communication for this database be encrypted  # noqa: E501

        :param data_internode_encryption: The data_internode_encryption of this Bdb.  # noqa: E501
        :type: bool
        """

        self._data_internode_encryption = data_internode_encryption

    @property
    def data_persistence(self):
        """Gets the data_persistence of this Bdb.  # noqa: E501

        Database on-disk persistence policy. For snapshot persistence, a snapshot_policy must be provided  # noqa: E501

        :return: The data_persistence of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._data_persistence

    @data_persistence.setter
    def data_persistence(self, data_persistence):
        """Sets the data_persistence of this Bdb.

        Database on-disk persistence policy. For snapshot persistence, a snapshot_policy must be provided  # noqa: E501

        :param data_persistence: The data_persistence of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["disabled", "snapshot", "aof"]  # noqa: E501
        if data_persistence not in allowed_values:
            raise ValueError(
                "Invalid value for `data_persistence` ({0}), must be one of {1}"  # noqa: E501
                .format(data_persistence, allowed_values)
            )

        self._data_persistence = data_persistence

    @property
    def dataset_import_sources(self):
        """Gets the dataset_import_sources of this Bdb.  # noqa: E501

        Array of source file location description objects to import from when performing an import action. This is write only, it cannot be read after set. GET /jsonschema to retrieve the object's structure. See also the 'bdb -> dataset_import_sources' section.  # noqa: E501

        :return: The dataset_import_sources of this Bdb.  # noqa: E501
        :rtype: list[AnyOfbdbDatasetImportSourcesItems]
        """
        return self._dataset_import_sources

    @dataset_import_sources.setter
    def dataset_import_sources(self, dataset_import_sources):
        """Sets the dataset_import_sources of this Bdb.

        Array of source file location description objects to import from when performing an import action. This is write only, it cannot be read after set. GET /jsonschema to retrieve the object's structure. See also the 'bdb -> dataset_import_sources' section.  # noqa: E501

        :param dataset_import_sources: The dataset_import_sources of this Bdb.  # noqa: E501
        :type: list[AnyOfbdbDatasetImportSourcesItems]
        """

        self._dataset_import_sources = dataset_import_sources

    @property
    def default_user(self):
        """Gets the default_user of this Bdb.  # noqa: E501

        Is connecting with a default user allowed?  # noqa: E501

        :return: The default_user of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._default_user

    @default_user.setter
    def default_user(self, default_user):
        """Sets the default_user of this Bdb.

        Is connecting with a default user allowed?  # noqa: E501

        :param default_user: The default_user of this Bdb.  # noqa: E501
        :type: bool
        """

        self._default_user = default_user

    @property
    def disabled_commands(self):
        """Gets the disabled_commands of this Bdb.  # noqa: E501

        Redis commands which are disabled in db  # noqa: E501

        :return: The disabled_commands of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._disabled_commands

    @disabled_commands.setter
    def disabled_commands(self, disabled_commands):
        """Sets the disabled_commands of this Bdb.

        Redis commands which are disabled in db  # noqa: E501

        :param disabled_commands: The disabled_commands of this Bdb.  # noqa: E501
        :type: str
        """

        self._disabled_commands = disabled_commands

    @property
    def dns_address_master(self):
        """Gets the dns_address_master of this Bdb.  # noqa: E501

        (deprecated) Database private address endpoint FQDN  # noqa: E501

        :return: The dns_address_master of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._dns_address_master

    @dns_address_master.setter
    def dns_address_master(self, dns_address_master):
        """Sets the dns_address_master of this Bdb.

        (deprecated) Database private address endpoint FQDN  # noqa: E501

        :param dns_address_master: The dns_address_master of this Bdb.  # noqa: E501
        :type: str
        """

        self._dns_address_master = dns_address_master

    @property
    def email_alerts(self):
        """Gets the email_alerts of this Bdb.  # noqa: E501

        Send email alerts for this DB  # noqa: E501

        :return: The email_alerts of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._email_alerts

    @email_alerts.setter
    def email_alerts(self, email_alerts):
        """Sets the email_alerts of this Bdb.

        Send email alerts for this DB  # noqa: E501

        :param email_alerts: The email_alerts of this Bdb.  # noqa: E501
        :type: bool
        """

        self._email_alerts = email_alerts

    @property
    def endpoint(self):
        """Gets the endpoint of this Bdb.  # noqa: E501

        Latest bound endpoint. Used when reconfiguring an endpoint via update  # noqa: E501

        :return: The endpoint of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._endpoint

    @endpoint.setter
    def endpoint(self, endpoint):
        """Sets the endpoint of this Bdb.

        Latest bound endpoint. Used when reconfiguring an endpoint via update  # noqa: E501

        :param endpoint: The endpoint of this Bdb.  # noqa: E501
        :type: str
        """

        self._endpoint = endpoint

    @property
    def endpoint_ip(self):
        """Gets the endpoint_ip of this Bdb.  # noqa: E501

        (deprecated) External IP addresses of node hosting the BDB's endpoint. GET /jsonschema to retrieve the object's structure.  # noqa: E501

        :return: The endpoint_ip of this Bdb.  # noqa: E501
        :rtype: list[OneOfbdbEndpointIpItems]
        """
        return self._endpoint_ip

    @endpoint_ip.setter
    def endpoint_ip(self, endpoint_ip):
        """Sets the endpoint_ip of this Bdb.

        (deprecated) External IP addresses of node hosting the BDB's endpoint. GET /jsonschema to retrieve the object's structure.  # noqa: E501

        :param endpoint_ip: The endpoint_ip of this Bdb.  # noqa: E501
        :type: list[OneOfbdbEndpointIpItems]
        """

        self._endpoint_ip = endpoint_ip

    @property
    def endpoint_node(self):
        """Gets the endpoint_node of this Bdb.  # noqa: E501

        (deprecated) Node UID hosting the BDB's endpoint  # noqa: E501

        :return: The endpoint_node of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._endpoint_node

    @endpoint_node.setter
    def endpoint_node(self, endpoint_node):
        """Sets the endpoint_node of this Bdb.

        (deprecated) Node UID hosting the BDB's endpoint  # noqa: E501

        :param endpoint_node: The endpoint_node of this Bdb.  # noqa: E501
        :type: int
        """

        self._endpoint_node = endpoint_node

    @property
    def endpoints(self):
        """Gets the endpoints of this Bdb.  # noqa: E501

        List of database access endpoints  # noqa: E501

        :return: The endpoints of this Bdb.  # noqa: E501
        :rtype: list[BdbEndpoints]
        """
        return self._endpoints

    @endpoints.setter
    def endpoints(self, endpoints):
        """Sets the endpoints of this Bdb.

        List of database access endpoints  # noqa: E501

        :param endpoints: The endpoints of this Bdb.  # noqa: E501
        :type: list[BdbEndpoints]
        """

        self._endpoints = endpoints

    @property
    def enforce_client_authentication(self):
        """Gets the enforce_client_authentication of this Bdb.  # noqa: E501

        Require authentication of client certificates for SSL connections to the database. If set to 'enabled', a certificate should be provided in either authentication_ssl_client_certs or authentication_ssl_crdt_certs  # noqa: E501

        :return: The enforce_client_authentication of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._enforce_client_authentication

    @enforce_client_authentication.setter
    def enforce_client_authentication(self, enforce_client_authentication):
        """Sets the enforce_client_authentication of this Bdb.

        Require authentication of client certificates for SSL connections to the database. If set to 'enabled', a certificate should be provided in either authentication_ssl_client_certs or authentication_ssl_crdt_certs  # noqa: E501

        :param enforce_client_authentication: The enforce_client_authentication of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["enabled", "disabled"]  # noqa: E501
        if enforce_client_authentication not in allowed_values:
            raise ValueError(
                "Invalid value for `enforce_client_authentication` ({0}), must be one of {1}"  # noqa: E501
                .format(enforce_client_authentication, allowed_values)
            )

        self._enforce_client_authentication = enforce_client_authentication

    @property
    def eviction_policy(self):
        """Gets the eviction_policy of this Bdb.  # noqa: E501

        Database eviction policy (Redis style). Redis db default: 'volatile-lru', memcached db default: 'allkeys-lru'  # noqa: E501

        :return: The eviction_policy of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._eviction_policy

    @eviction_policy.setter
    def eviction_policy(self, eviction_policy):
        """Sets the eviction_policy of this Bdb.

        Database eviction policy (Redis style). Redis db default: 'volatile-lru', memcached db default: 'allkeys-lru'  # noqa: E501

        :param eviction_policy: The eviction_policy of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["volatile-lru", "volatile-ttl", "volatile-random", "allkeys-lru", "allkeys-random", "noeviction", "volatile-lfu", "allkeys-lfu"]  # noqa: E501
        if eviction_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `eviction_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(eviction_policy, allowed_values)
            )

        self._eviction_policy = eviction_policy

    @property
    def export_failure_reason(self):
        """Gets the export_failure_reason of this Bdb.  # noqa: E501

        Reason of last failed export process  # noqa: E501

        :return: The export_failure_reason of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._export_failure_reason

    @export_failure_reason.setter
    def export_failure_reason(self, export_failure_reason):
        """Sets the export_failure_reason of this Bdb.

        Reason of last failed export process  # noqa: E501

        :param export_failure_reason: The export_failure_reason of this Bdb.  # noqa: E501
        :type: str
        """

        self._export_failure_reason = export_failure_reason

    @property
    def export_progress(self):
        """Gets the export_progress of this Bdb.  # noqa: E501

        Database manually trigerred export progress (percentage)  # noqa: E501

        :return: The export_progress of this Bdb.  # noqa: E501
        :rtype: float
        """
        return self._export_progress

    @export_progress.setter
    def export_progress(self, export_progress):
        """Sets the export_progress of this Bdb.

        Database manually trigerred export progress (percentage)  # noqa: E501

        :param export_progress: The export_progress of this Bdb.  # noqa: E501
        :type: float
        """

        self._export_progress = export_progress

    @property
    def export_status(self):
        """Gets the export_status of this Bdb.  # noqa: E501

        Status of manually triggered export process  # noqa: E501

        :return: The export_status of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._export_status

    @export_status.setter
    def export_status(self, export_status):
        """Sets the export_status of this Bdb.

        Status of manually triggered export process  # noqa: E501

        :param export_status: The export_status of this Bdb.  # noqa: E501
        :type: str
        """

        self._export_status = export_status

    @property
    def generate_text_monitor(self):
        """Gets the generate_text_monitor of this Bdb.  # noqa: E501

        Enable/Disable generation of syncer monitoring information  # noqa: E501

        :return: The generate_text_monitor of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._generate_text_monitor

    @generate_text_monitor.setter
    def generate_text_monitor(self, generate_text_monitor):
        """Sets the generate_text_monitor of this Bdb.

        Enable/Disable generation of syncer monitoring information  # noqa: E501

        :param generate_text_monitor: The generate_text_monitor of this Bdb.  # noqa: E501
        :type: bool
        """

        self._generate_text_monitor = generate_text_monitor

    @property
    def gradual_src_max_sources(self):
        """Gets the gradual_src_max_sources of this Bdb.  # noqa: E501

        Sync a maximum N sources in parallel (gradual_src_mode should be enabled for this to take effect)  # noqa: E501

        :return: The gradual_src_max_sources of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._gradual_src_max_sources

    @gradual_src_max_sources.setter
    def gradual_src_max_sources(self, gradual_src_max_sources):
        """Sets the gradual_src_max_sources of this Bdb.

        Sync a maximum N sources in parallel (gradual_src_mode should be enabled for this to take effect)  # noqa: E501

        :param gradual_src_max_sources: The gradual_src_max_sources of this Bdb.  # noqa: E501
        :type: int
        """

        self._gradual_src_max_sources = gradual_src_max_sources

    @property
    def gradual_src_mode(self):
        """Gets the gradual_src_mode of this Bdb.  # noqa: E501

        Indicates if gradual sync (of sync sources) should be activated  # noqa: E501

        :return: The gradual_src_mode of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._gradual_src_mode

    @gradual_src_mode.setter
    def gradual_src_mode(self, gradual_src_mode):
        """Sets the gradual_src_mode of this Bdb.

        Indicates if gradual sync (of sync sources) should be activated  # noqa: E501

        :param gradual_src_mode: The gradual_src_mode of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["enabled", "disabled"]  # noqa: E501
        if gradual_src_mode not in allowed_values:
            raise ValueError(
                "Invalid value for `gradual_src_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(gradual_src_mode, allowed_values)
            )

        self._gradual_src_mode = gradual_src_mode

    @property
    def gradual_sync_max_shards_per_source(self):
        """Gets the gradual_sync_max_shards_per_source of this Bdb.  # noqa: E501

        Sync a maximum of N shards per source in parallel (gradual_sync_mode should be enabled for this to take effect)  # noqa: E501

        :return: The gradual_sync_max_shards_per_source of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._gradual_sync_max_shards_per_source

    @gradual_sync_max_shards_per_source.setter
    def gradual_sync_max_shards_per_source(self, gradual_sync_max_shards_per_source):
        """Sets the gradual_sync_max_shards_per_source of this Bdb.

        Sync a maximum of N shards per source in parallel (gradual_sync_mode should be enabled for this to take effect)  # noqa: E501

        :param gradual_sync_max_shards_per_source: The gradual_sync_max_shards_per_source of this Bdb.  # noqa: E501
        :type: int
        """

        self._gradual_sync_max_shards_per_source = gradual_sync_max_shards_per_source

    @property
    def gradual_sync_mode(self):
        """Gets the gradual_sync_mode of this Bdb.  # noqa: E501

        Indicates if gradual sync (of source shards) should be activated ('auto' for automatic decision)  # noqa: E501

        :return: The gradual_sync_mode of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._gradual_sync_mode

    @gradual_sync_mode.setter
    def gradual_sync_mode(self, gradual_sync_mode):
        """Sets the gradual_sync_mode of this Bdb.

        Indicates if gradual sync (of source shards) should be activated ('auto' for automatic decision)  # noqa: E501

        :param gradual_sync_mode: The gradual_sync_mode of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["enabled", "disabled", "auto"]  # noqa: E501
        if gradual_sync_mode not in allowed_values:
            raise ValueError(
                "Invalid value for `gradual_sync_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(gradual_sync_mode, allowed_values)
            )

        self._gradual_sync_mode = gradual_sync_mode

    @property
    def hash_slots_policy(self):
        """Gets the hash_slots_policy of this Bdb.  # noqa: E501

        The policy used for hash slots handling; 'legacy' means slots range will be '1-4096', '16k' means slots range will be '0-16383'  # noqa: E501

        :return: The hash_slots_policy of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._hash_slots_policy

    @hash_slots_policy.setter
    def hash_slots_policy(self, hash_slots_policy):
        """Sets the hash_slots_policy of this Bdb.

        The policy used for hash slots handling; 'legacy' means slots range will be '1-4096', '16k' means slots range will be '0-16383'  # noqa: E501

        :param hash_slots_policy: The hash_slots_policy of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["legacy", "16k"]  # noqa: E501
        if hash_slots_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `hash_slots_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(hash_slots_policy, allowed_values)
            )

        self._hash_slots_policy = hash_slots_policy

    @property
    def implicit_shard_key(self):
        """Gets the implicit_shard_key of this Bdb.  # noqa: E501

        Controls the behavior of what happens in case a key does not match any of the regex rules. When set to True, if a key does not match any of the rules, the entire key will be used for the hashing function. When set to False, if a key does not match any of the rules, an error will be returned.  # noqa: E501

        :return: The implicit_shard_key of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._implicit_shard_key

    @implicit_shard_key.setter
    def implicit_shard_key(self, implicit_shard_key):
        """Sets the implicit_shard_key of this Bdb.

        Controls the behavior of what happens in case a key does not match any of the regex rules. When set to True, if a key does not match any of the rules, the entire key will be used for the hashing function. When set to False, if a key does not match any of the rules, an error will be returned.  # noqa: E501

        :param implicit_shard_key: The implicit_shard_key of this Bdb.  # noqa: E501
        :type: bool
        """

        self._implicit_shard_key = implicit_shard_key

    @property
    def import_failure_reason(self):
        """Gets the import_failure_reason of this Bdb.  # noqa: E501

        Import failure reason  # noqa: E501

        :return: The import_failure_reason of this Bdb.  # noqa: E501
        :rtype: AllOfbdbImportFailureReason
        """
        return self._import_failure_reason

    @import_failure_reason.setter
    def import_failure_reason(self, import_failure_reason):
        """Sets the import_failure_reason of this Bdb.

        Import failure reason  # noqa: E501

        :param import_failure_reason: The import_failure_reason of this Bdb.  # noqa: E501
        :type: AllOfbdbImportFailureReason
        """

        self._import_failure_reason = import_failure_reason

    @property
    def import_progress(self):
        """Gets the import_progress of this Bdb.  # noqa: E501

        Database import progress (percentage)  # noqa: E501

        :return: The import_progress of this Bdb.  # noqa: E501
        :rtype: float
        """
        return self._import_progress

    @import_progress.setter
    def import_progress(self, import_progress):
        """Sets the import_progress of this Bdb.

        Database import progress (percentage)  # noqa: E501

        :param import_progress: The import_progress of this Bdb.  # noqa: E501
        :type: float
        """

        self._import_progress = import_progress

    @property
    def import_status(self):
        """Gets the import_status of this Bdb.  # noqa: E501

        Database import process status  # noqa: E501

        :return: The import_status of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._import_status

    @import_status.setter
    def import_status(self, import_status):
        """Sets the import_status of this Bdb.

        Database import process status  # noqa: E501

        :param import_status: The import_status of this Bdb.  # noqa: E501
        :type: str
        """

        self._import_status = import_status

    @property
    def internal(self):
        """Gets the internal of this Bdb.  # noqa: E501

        Is this a bdb used by the cluster internally  # noqa: E501

        :return: The internal of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._internal

    @internal.setter
    def internal(self, internal):
        """Sets the internal of this Bdb.

        Is this a bdb used by the cluster internally  # noqa: E501

        :param internal: The internal of this Bdb.  # noqa: E501
        :type: bool
        """

        self._internal = internal

    @property
    def last_backup_time(self):
        """Gets the last_backup_time of this Bdb.  # noqa: E501

        Time of last successful backup  # noqa: E501

        :return: The last_backup_time of this Bdb.  # noqa: E501
        :rtype: datetime
        """
        return self._last_backup_time

    @last_backup_time.setter
    def last_backup_time(self, last_backup_time):
        """Sets the last_backup_time of this Bdb.

        Time of last successful backup  # noqa: E501

        :param last_backup_time: The last_backup_time of this Bdb.  # noqa: E501
        :type: datetime
        """

        self._last_backup_time = last_backup_time

    @property
    def last_changed_time(self):
        """Gets the last_changed_time of this Bdb.  # noqa: E501

        Last administrative configuration change  # noqa: E501

        :return: The last_changed_time of this Bdb.  # noqa: E501
        :rtype: datetime
        """
        return self._last_changed_time

    @last_changed_time.setter
    def last_changed_time(self, last_changed_time):
        """Sets the last_changed_time of this Bdb.

        Last administrative configuration change  # noqa: E501

        :param last_changed_time: The last_changed_time of this Bdb.  # noqa: E501
        :type: datetime
        """

        self._last_changed_time = last_changed_time

    @property
    def last_export_time(self):
        """Gets the last_export_time of this Bdb.  # noqa: E501

        Time of last successful export  # noqa: E501

        :return: The last_export_time of this Bdb.  # noqa: E501
        :rtype: datetime
        """
        return self._last_export_time

    @last_export_time.setter
    def last_export_time(self, last_export_time):
        """Sets the last_export_time of this Bdb.

        Time of last successful export  # noqa: E501

        :param last_export_time: The last_export_time of this Bdb.  # noqa: E501
        :type: datetime
        """

        self._last_export_time = last_export_time

    @property
    def max_aof_file_size(self):
        """Gets the max_aof_file_size of this Bdb.  # noqa: E501

        Maximum size for shard's AOF file (bytes). Default 300GB, (on bigstore DB 150GB)  # noqa: E501

        :return: The max_aof_file_size of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._max_aof_file_size

    @max_aof_file_size.setter
    def max_aof_file_size(self, max_aof_file_size):
        """Sets the max_aof_file_size of this Bdb.

        Maximum size for shard's AOF file (bytes). Default 300GB, (on bigstore DB 150GB)  # noqa: E501

        :param max_aof_file_size: The max_aof_file_size of this Bdb.  # noqa: E501
        :type: int
        """

        self._max_aof_file_size = max_aof_file_size

    @property
    def max_aof_load_time(self):
        """Gets the max_aof_load_time of this Bdb.  # noqa: E501

        Maximum time shard's AOF reload should take (seconds). Default 3600.  # noqa: E501

        :return: The max_aof_load_time of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._max_aof_load_time

    @max_aof_load_time.setter
    def max_aof_load_time(self, max_aof_load_time):
        """Sets the max_aof_load_time of this Bdb.

        Maximum time shard's AOF reload should take (seconds). Default 3600.  # noqa: E501

        :param max_aof_load_time: The max_aof_load_time of this Bdb.  # noqa: E501
        :type: int
        """

        self._max_aof_load_time = max_aof_load_time

    @property
    def max_connections(self):
        """Gets the max_connections of this Bdb.  # noqa: E501

        Maximum number of client connections allowed (0 unlimited)  # noqa: E501

        :return: The max_connections of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._max_connections

    @max_connections.setter
    def max_connections(self, max_connections):
        """Sets the max_connections of this Bdb.

        Maximum number of client connections allowed (0 unlimited)  # noqa: E501

        :param max_connections: The max_connections of this Bdb.  # noqa: E501
        :type: int
        """

        self._max_connections = max_connections

    @property
    def memory_size(self):
        """Gets the memory_size of this Bdb.  # noqa: E501

        Database memory limit (0 is unlimited), expressed in bytes.  # noqa: E501

        :return: The memory_size of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._memory_size

    @memory_size.setter
    def memory_size(self, memory_size):
        """Sets the memory_size of this Bdb.

        Database memory limit (0 is unlimited), expressed in bytes.  # noqa: E501

        :param memory_size: The memory_size of this Bdb.  # noqa: E501
        :type: int
        """

        self._memory_size = memory_size

    @property
    def metrics_export_all(self):
        """Gets the metrics_export_all of this Bdb.  # noqa: E501

        Enable/Disable exposing all shard metrics through the metrics exporter  # noqa: E501

        :return: The metrics_export_all of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._metrics_export_all

    @metrics_export_all.setter
    def metrics_export_all(self, metrics_export_all):
        """Sets the metrics_export_all of this Bdb.

        Enable/Disable exposing all shard metrics through the metrics exporter  # noqa: E501

        :param metrics_export_all: The metrics_export_all of this Bdb.  # noqa: E501
        :type: bool
        """

        self._metrics_export_all = metrics_export_all

    @property
    def mkms(self):
        """Gets the mkms of this Bdb.  # noqa: E501

        Are MKMS (Multi Key Multi Slots) commands supported?  # noqa: E501

        :return: The mkms of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._mkms

    @mkms.setter
    def mkms(self, mkms):
        """Sets the mkms of this Bdb.

        Are MKMS (Multi Key Multi Slots) commands supported?  # noqa: E501

        :param mkms: The mkms of this Bdb.  # noqa: E501
        :type: bool
        """

        self._mkms = mkms

    @property
    def module_list(self):
        """Gets the module_list of this Bdb.  # noqa: E501

        List of modules associated with database.  # noqa: E501

        :return: The module_list of this Bdb.  # noqa: E501
        :rtype: list[BdbModuleList]
        """
        return self._module_list

    @module_list.setter
    def module_list(self, module_list):
        """Sets the module_list of this Bdb.

        List of modules associated with database.  # noqa: E501

        :param module_list: The module_list of this Bdb.  # noqa: E501
        :type: list[BdbModuleList]
        """

        self._module_list = module_list

    @property
    def mtls_allow_outdated_certs(self):
        """Gets the mtls_allow_outdated_certs of this Bdb.  # noqa: E501

        An optional mTLS relaxation flag for certs verification  # noqa: E501

        :return: The mtls_allow_outdated_certs of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._mtls_allow_outdated_certs

    @mtls_allow_outdated_certs.setter
    def mtls_allow_outdated_certs(self, mtls_allow_outdated_certs):
        """Sets the mtls_allow_outdated_certs of this Bdb.

        An optional mTLS relaxation flag for certs verification  # noqa: E501

        :param mtls_allow_outdated_certs: The mtls_allow_outdated_certs of this Bdb.  # noqa: E501
        :type: bool
        """

        self._mtls_allow_outdated_certs = mtls_allow_outdated_certs

    @property
    def mtls_allow_weak_hashing(self):
        """Gets the mtls_allow_weak_hashing of this Bdb.  # noqa: E501

        An optional mTLS relaxation flag for certs verification  # noqa: E501

        :return: The mtls_allow_weak_hashing of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._mtls_allow_weak_hashing

    @mtls_allow_weak_hashing.setter
    def mtls_allow_weak_hashing(self, mtls_allow_weak_hashing):
        """Sets the mtls_allow_weak_hashing of this Bdb.

        An optional mTLS relaxation flag for certs verification  # noqa: E501

        :param mtls_allow_weak_hashing: The mtls_allow_weak_hashing of this Bdb.  # noqa: E501
        :type: bool
        """

        self._mtls_allow_weak_hashing = mtls_allow_weak_hashing

    @property
    def name(self):
        """Gets the name of this Bdb.  # noqa: E501

        Database name  # noqa: E501

        :return: The name of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Bdb.

        Database name  # noqa: E501

        :param name: The name of this Bdb.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def oss_cluster(self):
        """Gets the oss_cluster of this Bdb.  # noqa: E501

        OSS Cluster mode option. Cannot be enabled with 'hash_slots_policy': 'legacy'  # noqa: E501

        :return: The oss_cluster of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._oss_cluster

    @oss_cluster.setter
    def oss_cluster(self, oss_cluster):
        """Sets the oss_cluster of this Bdb.

        OSS Cluster mode option. Cannot be enabled with 'hash_slots_policy': 'legacy'  # noqa: E501

        :param oss_cluster: The oss_cluster of this Bdb.  # noqa: E501
        :type: bool
        """

        self._oss_cluster = oss_cluster

    @property
    def oss_cluster_api_preferred_ip_type(self):
        """Gets the oss_cluster_api_preferred_ip_type of this Bdb.  # noqa: E501

        Internal/external IP type in oss cluster API. Default value for new endpoints  # noqa: E501

        :return: The oss_cluster_api_preferred_ip_type of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._oss_cluster_api_preferred_ip_type

    @oss_cluster_api_preferred_ip_type.setter
    def oss_cluster_api_preferred_ip_type(self, oss_cluster_api_preferred_ip_type):
        """Sets the oss_cluster_api_preferred_ip_type of this Bdb.

        Internal/external IP type in oss cluster API. Default value for new endpoints  # noqa: E501

        :param oss_cluster_api_preferred_ip_type: The oss_cluster_api_preferred_ip_type of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["internal", "external"]  # noqa: E501
        if oss_cluster_api_preferred_ip_type not in allowed_values:
            raise ValueError(
                "Invalid value for `oss_cluster_api_preferred_ip_type` ({0}), must be one of {1}"  # noqa: E501
                .format(oss_cluster_api_preferred_ip_type, allowed_values)
            )

        self._oss_cluster_api_preferred_ip_type = oss_cluster_api_preferred_ip_type

    @property
    def oss_sharding(self):
        """Gets the oss_sharding of this Bdb.  # noqa: E501

        An alternative to shard_key_regex for using the common case of the oss shard hashing policy  # noqa: E501

        :return: The oss_sharding of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._oss_sharding

    @oss_sharding.setter
    def oss_sharding(self, oss_sharding):
        """Sets the oss_sharding of this Bdb.

        An alternative to shard_key_regex for using the common case of the oss shard hashing policy  # noqa: E501

        :param oss_sharding: The oss_sharding of this Bdb.  # noqa: E501
        :type: bool
        """

        self._oss_sharding = oss_sharding

    @property
    def port(self):
        """Gets the port of this Bdb.  # noqa: E501

        TCP port on which the database is available. Will be generated automatically if omitted and will be returned as 0  # noqa: E501

        :return: The port of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """Sets the port of this Bdb.

        TCP port on which the database is available. Will be generated automatically if omitted and will be returned as 0  # noqa: E501

        :param port: The port of this Bdb.  # noqa: E501
        :type: int
        """

        self._port = port

    @property
    def proxy_policy(self):
        """Gets the proxy_policy of this Bdb.  # noqa: E501

        The default policy used for proxy binding to endpoints  # noqa: E501

        :return: The proxy_policy of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._proxy_policy

    @proxy_policy.setter
    def proxy_policy(self, proxy_policy):
        """Sets the proxy_policy of this Bdb.

        The default policy used for proxy binding to endpoints  # noqa: E501

        :param proxy_policy: The proxy_policy of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["single", "all-master-shards", "all-nodes"]  # noqa: E501
        if proxy_policy not in allowed_values:
            raise ValueError(
                "Invalid value for `proxy_policy` ({0}), must be one of {1}"  # noqa: E501
                .format(proxy_policy, allowed_values)
            )

        self._proxy_policy = proxy_policy

    @property
    def rack_aware(self):
        """Gets the rack_aware of this Bdb.  # noqa: E501

        Require the database to be always replicated across multiple racks  # noqa: E501

        :return: The rack_aware of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._rack_aware

    @rack_aware.setter
    def rack_aware(self, rack_aware):
        """Sets the rack_aware of this Bdb.

        Require the database to be always replicated across multiple racks  # noqa: E501

        :param rack_aware: The rack_aware of this Bdb.  # noqa: E501
        :type: bool
        """

        self._rack_aware = rack_aware

    @property
    def redis_version(self):
        """Gets the redis_version of this Bdb.  # noqa: E501

        Version of the redis-server processes: e.g. 6.0, 5.0-big  # noqa: E501

        :return: The redis_version of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._redis_version

    @redis_version.setter
    def redis_version(self, redis_version):
        """Sets the redis_version of this Bdb.

        Version of the redis-server processes: e.g. 6.0, 5.0-big  # noqa: E501

        :param redis_version: The redis_version of this Bdb.  # noqa: E501
        :type: str
        """

        self._redis_version = redis_version

    @property
    def repl_backlog_size(self):
        """Gets the repl_backlog_size of this Bdb.  # noqa: E501

        Redis replication backlog size ('auto' or size in bytes)  # noqa: E501

        :return: The repl_backlog_size of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._repl_backlog_size

    @repl_backlog_size.setter
    def repl_backlog_size(self, repl_backlog_size):
        """Sets the repl_backlog_size of this Bdb.

        Redis replication backlog size ('auto' or size in bytes)  # noqa: E501

        :param repl_backlog_size: The repl_backlog_size of this Bdb.  # noqa: E501
        :type: str
        """

        self._repl_backlog_size = repl_backlog_size

    @property
    def replica_sources(self):
        """Gets the replica_sources of this Bdb.  # noqa: E501

        Remote endpoints of database to sync from. See the 'bdb -> replica_sources' section  # noqa: E501

        :return: The replica_sources of this Bdb.  # noqa: E501
        :rtype: AllOfbdbReplicaSources
        """
        return self._replica_sources

    @replica_sources.setter
    def replica_sources(self, replica_sources):
        """Sets the replica_sources of this Bdb.

        Remote endpoints of database to sync from. See the 'bdb -> replica_sources' section  # noqa: E501

        :param replica_sources: The replica_sources of this Bdb.  # noqa: E501
        :type: AllOfbdbReplicaSources
        """

        self._replica_sources = replica_sources

    @property
    def replica_sync(self):
        """Gets the replica_sync of this Bdb.  # noqa: E501

        Allow to enable, disable or pause syncing from specified replica_sources. See the 'bdb -> replica_sync' section  # noqa: E501

        :return: The replica_sync of this Bdb.  # noqa: E501
        :rtype: AllOfbdbReplicaSync
        """
        return self._replica_sync

    @replica_sync.setter
    def replica_sync(self, replica_sync):
        """Sets the replica_sync of this Bdb.

        Allow to enable, disable or pause syncing from specified replica_sources. See the 'bdb -> replica_sync' section  # noqa: E501

        :param replica_sync: The replica_sync of this Bdb.  # noqa: E501
        :type: AllOfbdbReplicaSync
        """

        self._replica_sync = replica_sync

    @property
    def replica_sync_dist(self):
        """Gets the replica_sync_dist of this Bdb.  # noqa: E501

        Enable/Disable distributed syncer in replica-of  # noqa: E501

        :return: The replica_sync_dist of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._replica_sync_dist

    @replica_sync_dist.setter
    def replica_sync_dist(self, replica_sync_dist):
        """Sets the replica_sync_dist of this Bdb.

        Enable/Disable distributed syncer in replica-of  # noqa: E501

        :param replica_sync_dist: The replica_sync_dist of this Bdb.  # noqa: E501
        :type: bool
        """

        self._replica_sync_dist = replica_sync_dist

    @property
    def replication(self):
        """Gets the replication of this Bdb.  # noqa: E501

        In-memory database replication mode  # noqa: E501

        :return: The replication of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._replication

    @replication.setter
    def replication(self, replication):
        """Sets the replication of this Bdb.

        In-memory database replication mode  # noqa: E501

        :param replication: The replication of this Bdb.  # noqa: E501
        :type: bool
        """

        self._replication = replication

    @property
    def roles_permissions(self):
        """Gets the roles_permissions of this Bdb.  # noqa: E501

        A binding of role -> redis-acl  # noqa: E501

        :return: The roles_permissions of this Bdb.  # noqa: E501
        :rtype: list[BdbRolesPermissions]
        """
        return self._roles_permissions

    @roles_permissions.setter
    def roles_permissions(self, roles_permissions):
        """Sets the roles_permissions of this Bdb.

        A binding of role -> redis-acl  # noqa: E501

        :param roles_permissions: The roles_permissions of this Bdb.  # noqa: E501
        :type: list[BdbRolesPermissions]
        """

        self._roles_permissions = roles_permissions

    @property
    def shard_block_crossslot_keys(self):
        """Gets the shard_block_crossslot_keys of this Bdb.  # noqa: E501

        In Lua scripts, prevent use of keys from different hash slots within the range owned by the current shard  # noqa: E501

        :return: The shard_block_crossslot_keys of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._shard_block_crossslot_keys

    @shard_block_crossslot_keys.setter
    def shard_block_crossslot_keys(self, shard_block_crossslot_keys):
        """Sets the shard_block_crossslot_keys of this Bdb.

        In Lua scripts, prevent use of keys from different hash slots within the range owned by the current shard  # noqa: E501

        :param shard_block_crossslot_keys: The shard_block_crossslot_keys of this Bdb.  # noqa: E501
        :type: bool
        """

        self._shard_block_crossslot_keys = shard_block_crossslot_keys

    @property
    def shard_block_foreign_keys(self):
        """Gets the shard_block_foreign_keys of this Bdb.  # noqa: E501

        In Lua scripts, prevent use of keys which could reside in a different shard (foreign keys)  # noqa: E501

        :return: The shard_block_foreign_keys of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._shard_block_foreign_keys

    @shard_block_foreign_keys.setter
    def shard_block_foreign_keys(self, shard_block_foreign_keys):
        """Sets the shard_block_foreign_keys of this Bdb.

        In Lua scripts, prevent use of keys which could reside in a different shard (foreign keys)  # noqa: E501

        :param shard_block_foreign_keys: The shard_block_foreign_keys of this Bdb.  # noqa: E501
        :type: bool
        """

        self._shard_block_foreign_keys = shard_block_foreign_keys

    @property
    def shard_key_regex(self):
        """Gets the shard_key_regex of this Bdb.  # noqa: E501

        Custom keyname-based sharding rules. Custom keyname-based sharding rules. To use the default rules you should set the value to: [ { \\\"regex\\\": \\\".*\\\\\\\\\\\\\\\\\\\\\\\\{(?<tag>.*)\\\\\\\\\\\\\\\\\\\\\\\\}.*\\\" }, { \\\"regex\\\": \\\"(?<tag>.*)\\\" } ]  # noqa: E501

        :return: The shard_key_regex of this Bdb.  # noqa: E501
        :rtype: list[BdbShardKeyRegex]
        """
        return self._shard_key_regex

    @shard_key_regex.setter
    def shard_key_regex(self, shard_key_regex):
        """Sets the shard_key_regex of this Bdb.

        Custom keyname-based sharding rules. Custom keyname-based sharding rules. To use the default rules you should set the value to: [ { \\\"regex\\\": \\\".*\\\\\\\\\\\\\\\\\\\\\\\\{(?<tag>.*)\\\\\\\\\\\\\\\\\\\\\\\\}.*\\\" }, { \\\"regex\\\": \\\"(?<tag>.*)\\\" } ]  # noqa: E501

        :param shard_key_regex: The shard_key_regex of this Bdb.  # noqa: E501
        :type: list[BdbShardKeyRegex]
        """

        self._shard_key_regex = shard_key_regex

    @property
    def shard_list(self):
        """Gets the shard_list of this Bdb.  # noqa: E501

        Cluster unique IDs of all database shards.  # noqa: E501

        :return: The shard_list of this Bdb.  # noqa: E501
        :rtype: list[int]
        """
        return self._shard_list

    @shard_list.setter
    def shard_list(self, shard_list):
        """Sets the shard_list of this Bdb.

        Cluster unique IDs of all database shards.  # noqa: E501

        :param shard_list: The shard_list of this Bdb.  # noqa: E501
        :type: list[int]
        """

        self._shard_list = shard_list

    @property
    def sharding(self):
        """Gets the sharding of this Bdb.  # noqa: E501

        Cluster mode (server side sharding). When true, shard hashing rules must be provided by either oss_sharding or shard_key_regex  # noqa: E501

        :return: The sharding of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._sharding

    @sharding.setter
    def sharding(self, sharding):
        """Sets the sharding of this Bdb.

        Cluster mode (server side sharding). When true, shard hashing rules must be provided by either oss_sharding or shard_key_regex  # noqa: E501

        :param sharding: The sharding of this Bdb.  # noqa: E501
        :type: bool
        """

        self._sharding = sharding

    @property
    def shards_count(self):
        """Gets the shards_count of this Bdb.  # noqa: E501

        Number of database server-side shards  # noqa: E501

        :return: The shards_count of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._shards_count

    @shards_count.setter
    def shards_count(self, shards_count):
        """Sets the shards_count of this Bdb.

        Number of database server-side shards  # noqa: E501

        :param shards_count: The shards_count of this Bdb.  # noqa: E501
        :type: int
        """

        self._shards_count = shards_count

    @property
    def shards_placement(self):
        """Gets the shards_placement of this Bdb.  # noqa: E501

        Control the density of shards: should they reside on as few or as many nodes as possible  # noqa: E501

        :return: The shards_placement of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._shards_placement

    @shards_placement.setter
    def shards_placement(self, shards_placement):
        """Sets the shards_placement of this Bdb.

        Control the density of shards: should they reside on as few or as many nodes as possible  # noqa: E501

        :param shards_placement: The shards_placement of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["dense", "sparse"]  # noqa: E501
        if shards_placement not in allowed_values:
            raise ValueError(
                "Invalid value for `shards_placement` ({0}), must be one of {1}"  # noqa: E501
                .format(shards_placement, allowed_values)
            )

        self._shards_placement = shards_placement

    @property
    def skip_import_analyze(self):
        """Gets the skip_import_analyze of this Bdb.  # noqa: E501

        Enable/disable skipping the analysis stage when importing an RDB file  # noqa: E501

        :return: The skip_import_analyze of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._skip_import_analyze

    @skip_import_analyze.setter
    def skip_import_analyze(self, skip_import_analyze):
        """Sets the skip_import_analyze of this Bdb.

        Enable/disable skipping the analysis stage when importing an RDB file  # noqa: E501

        :param skip_import_analyze: The skip_import_analyze of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["enabled", "disabled"]  # noqa: E501
        if skip_import_analyze not in allowed_values:
            raise ValueError(
                "Invalid value for `skip_import_analyze` ({0}), must be one of {1}"  # noqa: E501
                .format(skip_import_analyze, allowed_values)
            )

        self._skip_import_analyze = skip_import_analyze

    @property
    def slave_ha(self):
        """Gets the slave_ha of this Bdb.  # noqa: E501

        Enable slave high availability mechanism for this bdb. default takes the cluster setting.  # noqa: E501

        :return: The slave_ha of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._slave_ha

    @slave_ha.setter
    def slave_ha(self, slave_ha):
        """Sets the slave_ha of this Bdb.

        Enable slave high availability mechanism for this bdb. default takes the cluster setting.  # noqa: E501

        :param slave_ha: The slave_ha of this Bdb.  # noqa: E501
        :type: bool
        """

        self._slave_ha = slave_ha

    @property
    def slave_ha_priority(self):
        """Gets the slave_ha_priority of this Bdb.  # noqa: E501

        Priority of the BDB in slave high availability mechanism.  # noqa: E501

        :return: The slave_ha_priority of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._slave_ha_priority

    @slave_ha_priority.setter
    def slave_ha_priority(self, slave_ha_priority):
        """Sets the slave_ha_priority of this Bdb.

        Priority of the BDB in slave high availability mechanism.  # noqa: E501

        :param slave_ha_priority: The slave_ha_priority of this Bdb.  # noqa: E501
        :type: int
        """

        self._slave_ha_priority = slave_ha_priority

    @property
    def snapshot_policy(self):
        """Gets the snapshot_policy of this Bdb.  # noqa: E501

        Policy for snapshot-based data persistence. Dataset snapshot will be taken every N secs if there are at least M writes changes in the dataset  # noqa: E501

        :return: The snapshot_policy of this Bdb.  # noqa: E501
        :rtype: AllOfbdbSnapshotPolicy
        """
        return self._snapshot_policy

    @snapshot_policy.setter
    def snapshot_policy(self, snapshot_policy):
        """Sets the snapshot_policy of this Bdb.

        Policy for snapshot-based data persistence. Dataset snapshot will be taken every N secs if there are at least M writes changes in the dataset  # noqa: E501

        :param snapshot_policy: The snapshot_policy of this Bdb.  # noqa: E501
        :type: AllOfbdbSnapshotPolicy
        """

        self._snapshot_policy = snapshot_policy

    @property
    def ssl(self):
        """Gets the ssl of this Bdb.  # noqa: E501

        (deprecated) Require SSL authenticated and encrypted connections to the database  # noqa: E501

        :return: The ssl of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._ssl

    @ssl.setter
    def ssl(self, ssl):
        """Sets the ssl of this Bdb.

        (deprecated) Require SSL authenticated and encrypted connections to the database  # noqa: E501

        :param ssl: The ssl of this Bdb.  # noqa: E501
        :type: bool
        """

        self._ssl = ssl

    @property
    def status(self):
        """Gets the status of this Bdb.  # noqa: E501

        Database life-cycle status. See the 'bdb -> status' section  # noqa: E501

        :return: The status of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Bdb.

        Database life-cycle status. See the 'bdb -> status' section  # noqa: E501

        :param status: The status of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["pending", "active", "active-change-pending", "delete-pending", "import-pending", "creation-failed", "recovery"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def sync(self):
        """Gets the sync of this Bdb.  # noqa: E501

        (deprecated, instead use replica_sync or crdt_sync) Allow to enable, disable or pause syncing from specified sync_sources. See the 'bdb -> replica_sync' section  # noqa: E501

        :return: The sync of this Bdb.  # noqa: E501
        :rtype: AllOfbdbSync
        """
        return self._sync

    @sync.setter
    def sync(self, sync):
        """Sets the sync of this Bdb.

        (deprecated, instead use replica_sync or crdt_sync) Allow to enable, disable or pause syncing from specified sync_sources. See the 'bdb -> replica_sync' section  # noqa: E501

        :param sync: The sync of this Bdb.  # noqa: E501
        :type: AllOfbdbSync
        """

        self._sync = sync

    @property
    def sync_sources(self):
        """Gets the sync_sources of this Bdb.  # noqa: E501

        (deprecated, instead use replica_sources or crdt_sources) Remote endpoints of database to sync from. See the 'bdb -> replica_sources' section  # noqa: E501

        :return: The sync_sources of this Bdb.  # noqa: E501
        :rtype: list[BdbSyncSources]
        """
        return self._sync_sources

    @sync_sources.setter
    def sync_sources(self, sync_sources):
        """Sets the sync_sources of this Bdb.

        (deprecated, instead use replica_sources or crdt_sources) Remote endpoints of database to sync from. See the 'bdb -> replica_sources' section  # noqa: E501

        :param sync_sources: The sync_sources of this Bdb.  # noqa: E501
        :type: list[BdbSyncSources]
        """

        self._sync_sources = sync_sources

    @property
    def syncer_mode(self):
        """Gets the syncer_mode of this Bdb.  # noqa: E501

        The syncer for replication between database instances is either on a single node (centralized) or on each node that has a proxy according to the proxy policy (distributed).  # noqa: E501

        :return: The syncer_mode of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._syncer_mode

    @syncer_mode.setter
    def syncer_mode(self, syncer_mode):
        """Sets the syncer_mode of this Bdb.

        The syncer for replication between database instances is either on a single node (centralized) or on each node that has a proxy according to the proxy policy (distributed).  # noqa: E501

        :param syncer_mode: The syncer_mode of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["distributed", "centralized"]  # noqa: E501
        if syncer_mode not in allowed_values:
            raise ValueError(
                "Invalid value for `syncer_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(syncer_mode, allowed_values)
            )

        self._syncer_mode = syncer_mode

    @property
    def tags(self):
        """Gets the tags of this Bdb.  # noqa: E501

        Optional list of tags objects attached to the database  # noqa: E501

        :return: The tags of this Bdb.  # noqa: E501
        :rtype: list[BdbTags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """Sets the tags of this Bdb.

        Optional list of tags objects attached to the database  # noqa: E501

        :param tags: The tags of this Bdb.  # noqa: E501
        :type: list[BdbTags]
        """

        self._tags = tags

    @property
    def tls_mode(self):
        """Gets the tls_mode of this Bdb.  # noqa: E501

        Require SSL authenticated and encrypted connections to the database  # noqa: E501

        :return: The tls_mode of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._tls_mode

    @tls_mode.setter
    def tls_mode(self, tls_mode):
        """Sets the tls_mode of this Bdb.

        Require SSL authenticated and encrypted connections to the database  # noqa: E501

        :param tls_mode: The tls_mode of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["enabled", "disabled", "replica_ssl"]  # noqa: E501
        if tls_mode not in allowed_values:
            raise ValueError(
                "Invalid value for `tls_mode` ({0}), must be one of {1}"  # noqa: E501
                .format(tls_mode, allowed_values)
            )

        self._tls_mode = tls_mode

    @property
    def type(self):
        """Gets the type of this Bdb.  # noqa: E501

        Type of database  # noqa: E501

        :return: The type of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this Bdb.

        Type of database  # noqa: E501

        :param type: The type of this Bdb.  # noqa: E501
        :type: str
        """
        allowed_values = ["redis", "memcached"]  # noqa: E501
        if type not in allowed_values:
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}"  # noqa: E501
                .format(type, allowed_values)
            )

        self._type = type

    @property
    def uid(self):
        """Gets the uid of this Bdb.  # noqa: E501

        Cluster unique ID of database. Can be set on Create, but can not be updated.  # noqa: E501

        :return: The uid of this Bdb.  # noqa: E501
        :rtype: int
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this Bdb.

        Cluster unique ID of database. Can be set on Create, but can not be updated.  # noqa: E501

        :param uid: The uid of this Bdb.  # noqa: E501
        :type: int
        """

        self._uid = uid

    @property
    def use_nodes(self):
        """Gets the use_nodes of this Bdb.  # noqa: E501

        Cluster node uids to use for bdb's shards and bound endpoints  # noqa: E501

        :return: The use_nodes of this Bdb.  # noqa: E501
        :rtype: list[str]
        """
        return self._use_nodes

    @use_nodes.setter
    def use_nodes(self, use_nodes):
        """Sets the use_nodes of this Bdb.

        Cluster node uids to use for bdb's shards and bound endpoints  # noqa: E501

        :param use_nodes: The use_nodes of this Bdb.  # noqa: E501
        :type: list[str]
        """

        self._use_nodes = use_nodes

    @property
    def version(self):
        """Gets the version of this Bdb.  # noqa: E501

        Database compatibility version: full redis / memcached version number, e.g. 6.0.6  # noqa: E501

        :return: The version of this Bdb.  # noqa: E501
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this Bdb.

        Database compatibility version: full redis / memcached version number, e.g. 6.0.6  # noqa: E501

        :param version: The version of this Bdb.  # noqa: E501
        :type: str
        """

        self._version = version

    @property
    def wait_command(self):
        """Gets the wait_command of this Bdb.  # noqa: E501

        Support Redis wait command.  # noqa: E501

        :return: The wait_command of this Bdb.  # noqa: E501
        :rtype: bool
        """
        return self._wait_command

    @wait_command.setter
    def wait_command(self, wait_command):
        """Sets the wait_command of this Bdb.

        Support Redis wait command.  # noqa: E501

        :param wait_command: The wait_command of this Bdb.  # noqa: E501
        :type: bool
        """

        self._wait_command = wait_command

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Bdb, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Bdb):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
