# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ServicesConfiguration(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'cm_server': 'ServicesConfigurationCmServer',
        'crdb_coordinator': 'ServicesConfigurationCrdbCoordinator',
        'crdb_worker': 'ServicesConfigurationCrdbWorker',
        'mdns_server': 'ServicesConfigurationMdnsServer',
        'pdns_server': 'ServicesConfigurationPdnsServer',
        'saslauthd': 'ServicesConfigurationSaslauthd',
        'stats_archiver': 'ServicesConfigurationStatsArchiver'
    }

    attribute_map = {
        'cm_server': 'cm_server',
        'crdb_coordinator': 'crdb_coordinator',
        'crdb_worker': 'crdb_worker',
        'mdns_server': 'mdns_server',
        'pdns_server': 'pdns_server',
        'saslauthd': 'saslauthd',
        'stats_archiver': 'stats_archiver'
    }

    def __init__(self, cm_server=None, crdb_coordinator=None, crdb_worker=None, mdns_server=None, pdns_server=None, saslauthd=None, stats_archiver=None):  # noqa: E501
        """ServicesConfiguration - a model defined in Swagger"""  # noqa: E501
        self._cm_server = None
        self._crdb_coordinator = None
        self._crdb_worker = None
        self._mdns_server = None
        self._pdns_server = None
        self._saslauthd = None
        self._stats_archiver = None
        self.discriminator = None
        if cm_server is not None:
            self.cm_server = cm_server
        if crdb_coordinator is not None:
            self.crdb_coordinator = crdb_coordinator
        if crdb_worker is not None:
            self.crdb_worker = crdb_worker
        if mdns_server is not None:
            self.mdns_server = mdns_server
        if pdns_server is not None:
            self.pdns_server = pdns_server
        if saslauthd is not None:
            self.saslauthd = saslauthd
        if stats_archiver is not None:
            self.stats_archiver = stats_archiver

    @property
    def cm_server(self):
        """Gets the cm_server of this ServicesConfiguration.  # noqa: E501


        :return: The cm_server of this ServicesConfiguration.  # noqa: E501
        :rtype: ServicesConfigurationCmServer
        """
        return self._cm_server

    @cm_server.setter
    def cm_server(self, cm_server):
        """Sets the cm_server of this ServicesConfiguration.


        :param cm_server: The cm_server of this ServicesConfiguration.  # noqa: E501
        :type: ServicesConfigurationCmServer
        """

        self._cm_server = cm_server

    @property
    def crdb_coordinator(self):
        """Gets the crdb_coordinator of this ServicesConfiguration.  # noqa: E501


        :return: The crdb_coordinator of this ServicesConfiguration.  # noqa: E501
        :rtype: ServicesConfigurationCrdbCoordinator
        """
        return self._crdb_coordinator

    @crdb_coordinator.setter
    def crdb_coordinator(self, crdb_coordinator):
        """Sets the crdb_coordinator of this ServicesConfiguration.


        :param crdb_coordinator: The crdb_coordinator of this ServicesConfiguration.  # noqa: E501
        :type: ServicesConfigurationCrdbCoordinator
        """

        self._crdb_coordinator = crdb_coordinator

    @property
    def crdb_worker(self):
        """Gets the crdb_worker of this ServicesConfiguration.  # noqa: E501


        :return: The crdb_worker of this ServicesConfiguration.  # noqa: E501
        :rtype: ServicesConfigurationCrdbWorker
        """
        return self._crdb_worker

    @crdb_worker.setter
    def crdb_worker(self, crdb_worker):
        """Sets the crdb_worker of this ServicesConfiguration.


        :param crdb_worker: The crdb_worker of this ServicesConfiguration.  # noqa: E501
        :type: ServicesConfigurationCrdbWorker
        """

        self._crdb_worker = crdb_worker

    @property
    def mdns_server(self):
        """Gets the mdns_server of this ServicesConfiguration.  # noqa: E501


        :return: The mdns_server of this ServicesConfiguration.  # noqa: E501
        :rtype: ServicesConfigurationMdnsServer
        """
        return self._mdns_server

    @mdns_server.setter
    def mdns_server(self, mdns_server):
        """Sets the mdns_server of this ServicesConfiguration.


        :param mdns_server: The mdns_server of this ServicesConfiguration.  # noqa: E501
        :type: ServicesConfigurationMdnsServer
        """

        self._mdns_server = mdns_server

    @property
    def pdns_server(self):
        """Gets the pdns_server of this ServicesConfiguration.  # noqa: E501


        :return: The pdns_server of this ServicesConfiguration.  # noqa: E501
        :rtype: ServicesConfigurationPdnsServer
        """
        return self._pdns_server

    @pdns_server.setter
    def pdns_server(self, pdns_server):
        """Sets the pdns_server of this ServicesConfiguration.


        :param pdns_server: The pdns_server of this ServicesConfiguration.  # noqa: E501
        :type: ServicesConfigurationPdnsServer
        """

        self._pdns_server = pdns_server

    @property
    def saslauthd(self):
        """Gets the saslauthd of this ServicesConfiguration.  # noqa: E501


        :return: The saslauthd of this ServicesConfiguration.  # noqa: E501
        :rtype: ServicesConfigurationSaslauthd
        """
        return self._saslauthd

    @saslauthd.setter
    def saslauthd(self, saslauthd):
        """Sets the saslauthd of this ServicesConfiguration.


        :param saslauthd: The saslauthd of this ServicesConfiguration.  # noqa: E501
        :type: ServicesConfigurationSaslauthd
        """

        self._saslauthd = saslauthd

    @property
    def stats_archiver(self):
        """Gets the stats_archiver of this ServicesConfiguration.  # noqa: E501


        :return: The stats_archiver of this ServicesConfiguration.  # noqa: E501
        :rtype: ServicesConfigurationStatsArchiver
        """
        return self._stats_archiver

    @stats_archiver.setter
    def stats_archiver(self, stats_archiver):
        """Sets the stats_archiver of this ServicesConfiguration.


        :param stats_archiver: The stats_archiver of this ServicesConfiguration.  # noqa: E501
        :type: ServicesConfigurationStatsArchiver
        """

        self._stats_archiver = stats_archiver

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ServicesConfiguration, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ServicesConfiguration):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
