# coding: utf-8

"""
    Redis Enterprise API

    REST API Specifications[¶](#rest-api-specifications \"Permalink to this headline\") =================================================================================  Key Concepts[¶](#key-concepts \"Permalink to this headline\") -----------------------------------------------------------  ### Clusters[¶](#clusters \"Permalink to this headline\")  Redis Labs clusters are a set of nodes, typically two or more, providing database services. Clusters are inherently multi-tenant, and a single cluster can manage multiple databases accessed through individual endpoints.  Protocol and Headers[¶](#protocol-and-headers \"Permalink to this headline\") ---------------------------------------------------------------------------  ### JSON Requests and Responses[¶](#json-requests-and-responses \"Permalink to this headline\")  The Redis Labs REST API uses the JavaScript Object Notation (JSON) for requests and responses.  Some responses may have an empty body, but indicate the response with standard HTTP codes. For more information, see RFC 4627 ([http://www.ietf.org/rfc/rfc4627.txt](http://www.ietf.org/rfc/rfc4627.txt)) and www.json.org.  Both requests and responses may include zero or more objects.  In case the request is for a single entity, the response shall return a single JSON object, or none. In case the request if for a list of entities, the response shall return a single JSON array with 0 or more elements.  Requests may be delivered with some JSON object fields missing. In this case, these fields will be assigned default values (often indicating they are not in use).  ### Request Headers[¶](#request-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Accept | application/json | | Content-Length | Length (in bytes) of request message. | | Content-Type | application/json |   ### Response Headers[¶](#response-headers \"Permalink to this headline\")  The Redis Labs REST API supports the following HTTP headers:  | Header | Supported/Required Values | |---|---| | Content-Type | application/json | | Content-Length | Length (in bytes) of request message. |   API Versions[¶](#api-versions \"Permalink to this headline\") -----------------------------------------------------------  All RLEC API operations are versioned, in order to minimize the impact of backwards-incompatible API changes and to coordinate between different versions operating in parallel.  Authentication[¶](#authentication \"Permalink to this headline\") ---------------------------------------------------------------  Authentication to RLEC API occurs via [Basic Auth](https://en.wikipedia.org/wiki/Basic_access_authentication). Provide your RLEC username and password as the basic auth credentials.  All calls must be made over SSL, to port 9443.  Example Request:  ```bash curl \\-u \"demo@redislabs.com:password\" https://localhost:9443/v1/bdbs ```  Common Responses[¶](#common-responses \"Permalink to this headline\") -------------------------------------------------------------------  The following are common responses which may be returned in some cases regardless of any specific request.  | Response | Condition / Required handling | |---|---| | 503 (Service Unavailable) | Contacted node is currently not a member of any active cluster. | | 505 (HTTP Version Not Supported) | An unsupported X-API-Version was used, see API Versions above. |   # noqa: E501

    OpenAPI spec version: 6.2.4-55
    Contact: matthew.royal@redis.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Shard(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'assigned_slots': 'str',
        'backup': 'ShardBackup',
        'bdb_uid': 'int',
        'bigstore_ram_weight': 'float',
        'detailed_status': 'str',
        'loading': 'ShardLoading',
        'node_uid': 'str',
        'redis_info': 'object',
        'report_timestamp': 'datetime',
        'role': 'str',
        'status': 'str',
        'sync': 'ShardSync',
        'uid': 'str'
    }

    attribute_map = {
        'assigned_slots': 'assigned_slots',
        'backup': 'backup',
        'bdb_uid': 'bdb_uid',
        'bigstore_ram_weight': 'bigstore_ram_weight',
        'detailed_status': 'detailed_status',
        'loading': 'loading',
        'node_uid': 'node_uid',
        'redis_info': 'redis_info',
        'report_timestamp': 'report_timestamp',
        'role': 'role',
        'status': 'status',
        'sync': 'sync',
        'uid': 'uid'
    }

    def __init__(self, assigned_slots=None, backup=None, bdb_uid=None, bigstore_ram_weight=None, detailed_status=None, loading=None, node_uid=None, redis_info=None, report_timestamp=None, role=None, status=None, sync=None, uid=None):  # noqa: E501
        """Shard - a model defined in Swagger"""  # noqa: E501
        self._assigned_slots = None
        self._backup = None
        self._bdb_uid = None
        self._bigstore_ram_weight = None
        self._detailed_status = None
        self._loading = None
        self._node_uid = None
        self._redis_info = None
        self._report_timestamp = None
        self._role = None
        self._status = None
        self._sync = None
        self._uid = None
        self.discriminator = None
        if assigned_slots is not None:
            self.assigned_slots = assigned_slots
        if backup is not None:
            self.backup = backup
        if bdb_uid is not None:
            self.bdb_uid = bdb_uid
        if bigstore_ram_weight is not None:
            self.bigstore_ram_weight = bigstore_ram_weight
        if detailed_status is not None:
            self.detailed_status = detailed_status
        if loading is not None:
            self.loading = loading
        if node_uid is not None:
            self.node_uid = node_uid
        if redis_info is not None:
            self.redis_info = redis_info
        if report_timestamp is not None:
            self.report_timestamp = report_timestamp
        if role is not None:
            self.role = role
        if status is not None:
            self.status = status
        if sync is not None:
            self.sync = sync
        if uid is not None:
            self.uid = uid

    @property
    def assigned_slots(self):
        """Gets the assigned_slots of this Shard.  # noqa: E501

        Shards hash slot range  # noqa: E501

        :return: The assigned_slots of this Shard.  # noqa: E501
        :rtype: str
        """
        return self._assigned_slots

    @assigned_slots.setter
    def assigned_slots(self, assigned_slots):
        """Sets the assigned_slots of this Shard.

        Shards hash slot range  # noqa: E501

        :param assigned_slots: The assigned_slots of this Shard.  # noqa: E501
        :type: str
        """

        self._assigned_slots = assigned_slots

    @property
    def backup(self):
        """Gets the backup of this Shard.  # noqa: E501


        :return: The backup of this Shard.  # noqa: E501
        :rtype: ShardBackup
        """
        return self._backup

    @backup.setter
    def backup(self, backup):
        """Sets the backup of this Shard.


        :param backup: The backup of this Shard.  # noqa: E501
        :type: ShardBackup
        """

        self._backup = backup

    @property
    def bdb_uid(self):
        """Gets the bdb_uid of this Shard.  # noqa: E501

        The ID of bdb this shard belongs to.  # noqa: E501

        :return: The bdb_uid of this Shard.  # noqa: E501
        :rtype: int
        """
        return self._bdb_uid

    @bdb_uid.setter
    def bdb_uid(self, bdb_uid):
        """Sets the bdb_uid of this Shard.

        The ID of bdb this shard belongs to.  # noqa: E501

        :param bdb_uid: The bdb_uid of this Shard.  # noqa: E501
        :type: int
        """

        self._bdb_uid = bdb_uid

    @property
    def bigstore_ram_weight(self):
        """Gets the bigstore_ram_weight of this Shard.  # noqa: E501

        Shards RAM distribution weight  # noqa: E501

        :return: The bigstore_ram_weight of this Shard.  # noqa: E501
        :rtype: float
        """
        return self._bigstore_ram_weight

    @bigstore_ram_weight.setter
    def bigstore_ram_weight(self, bigstore_ram_weight):
        """Sets the bigstore_ram_weight of this Shard.

        Shards RAM distribution weight  # noqa: E501

        :param bigstore_ram_weight: The bigstore_ram_weight of this Shard.  # noqa: E501
        :type: float
        """

        self._bigstore_ram_weight = bigstore_ram_weight

    @property
    def detailed_status(self):
        """Gets the detailed_status of this Shard.  # noqa: E501

        A more specific status of the shard  # noqa: E501

        :return: The detailed_status of this Shard.  # noqa: E501
        :rtype: str
        """
        return self._detailed_status

    @detailed_status.setter
    def detailed_status(self, detailed_status):
        """Sets the detailed_status of this Shard.

        A more specific status of the shard  # noqa: E501

        :param detailed_status: The detailed_status of this Shard.  # noqa: E501
        :type: str
        """
        allowed_values = ["ok", "importing", "timeout", "loading", "busy", "down", "trimming", "unknown"]  # noqa: E501
        if detailed_status not in allowed_values:
            raise ValueError(
                "Invalid value for `detailed_status` ({0}), must be one of {1}"  # noqa: E501
                .format(detailed_status, allowed_values)
            )

        self._detailed_status = detailed_status

    @property
    def loading(self):
        """Gets the loading of this Shard.  # noqa: E501


        :return: The loading of this Shard.  # noqa: E501
        :rtype: ShardLoading
        """
        return self._loading

    @loading.setter
    def loading(self, loading):
        """Sets the loading of this Shard.


        :param loading: The loading of this Shard.  # noqa: E501
        :type: ShardLoading
        """

        self._loading = loading

    @property
    def node_uid(self):
        """Gets the node_uid of this Shard.  # noqa: E501

        The ID of the node this shard is located on.  # noqa: E501

        :return: The node_uid of this Shard.  # noqa: E501
        :rtype: str
        """
        return self._node_uid

    @node_uid.setter
    def node_uid(self, node_uid):
        """Sets the node_uid of this Shard.

        The ID of the node this shard is located on.  # noqa: E501

        :param node_uid: The node_uid of this Shard.  # noqa: E501
        :type: str
        """

        self._node_uid = node_uid

    @property
    def redis_info(self):
        """Gets the redis_info of this Shard.  # noqa: E501

        A sub-dictionary of Redis INFO command. see https://redis.io/commands/info for detailed documentation  # noqa: E501

        :return: The redis_info of this Shard.  # noqa: E501
        :rtype: object
        """
        return self._redis_info

    @redis_info.setter
    def redis_info(self, redis_info):
        """Sets the redis_info of this Shard.

        A sub-dictionary of Redis INFO command. see https://redis.io/commands/info for detailed documentation  # noqa: E501

        :param redis_info: The redis_info of this Shard.  # noqa: E501
        :type: object
        """

        self._redis_info = redis_info

    @property
    def report_timestamp(self):
        """Gets the report_timestamp of this Shard.  # noqa: E501

        The time in which the shard's info was collected  # noqa: E501

        :return: The report_timestamp of this Shard.  # noqa: E501
        :rtype: datetime
        """
        return self._report_timestamp

    @report_timestamp.setter
    def report_timestamp(self, report_timestamp):
        """Sets the report_timestamp of this Shard.

        The time in which the shard's info was collected  # noqa: E501

        :param report_timestamp: The report_timestamp of this Shard.  # noqa: E501
        :type: datetime
        """

        self._report_timestamp = report_timestamp

    @property
    def role(self):
        """Gets the role of this Shard.  # noqa: E501

        Role of this shard (master or slave)  # noqa: E501

        :return: The role of this Shard.  # noqa: E501
        :rtype: str
        """
        return self._role

    @role.setter
    def role(self, role):
        """Sets the role of this Shard.

        Role of this shard (master or slave)  # noqa: E501

        :param role: The role of this Shard.  # noqa: E501
        :type: str
        """
        allowed_values = ["master", "slave"]  # noqa: E501
        if role not in allowed_values:
            raise ValueError(
                "Invalid value for `role` ({0}), must be one of {1}"  # noqa: E501
                .format(role, allowed_values)
            )

        self._role = role

    @property
    def status(self):
        """Gets the status of this Shard.  # noqa: E501

        The current status of the shard  # noqa: E501

        :return: The status of this Shard.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Shard.

        The current status of the shard  # noqa: E501

        :param status: The status of this Shard.  # noqa: E501
        :type: str
        """
        allowed_values = ["active", "inactive", "trimming"]  # noqa: E501
        if status not in allowed_values:
            raise ValueError(
                "Invalid value for `status` ({0}), must be one of {1}"  # noqa: E501
                .format(status, allowed_values)
            )

        self._status = status

    @property
    def sync(self):
        """Gets the sync of this Shard.  # noqa: E501


        :return: The sync of this Shard.  # noqa: E501
        :rtype: ShardSync
        """
        return self._sync

    @sync.setter
    def sync(self, sync):
        """Sets the sync of this Shard.


        :param sync: The sync of this Shard.  # noqa: E501
        :type: ShardSync
        """

        self._sync = sync

    @property
    def uid(self):
        """Gets the uid of this Shard.  # noqa: E501

        Cluster unique ID of shard.  # noqa: E501

        :return: The uid of this Shard.  # noqa: E501
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this Shard.

        Cluster unique ID of shard.  # noqa: E501

        :param uid: The uid of this Shard.  # noqa: E501
        :type: str
        """

        self._uid = uid

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Shard, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Shard):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
