# -*- coding: utf-8 -*-
from setuptools import setup

modules = \
['uploadgrampyapi']
setup_kwargs = {
    'name': 'uploadgrampyapi',
    'version': '1.6',
    'description': 'This API can upload, download, remove and rename any files from the service uploadgram.me',
    'long_description': '# UploadgramPyAPI\n![Alt](https://sun9-33.userapi.com/impg/uRrtaPGWd5M3u529Cr-PVUNORq-O4EwDjgwZyA/ak0CZq-ijFk.jpg?size=113x113&quality=96&sign=ce6642140fc672643d33e934d1235f7d&type=album "icon")\n\nThis API can upload, download, remove and rename any files from the service [uploadgram.me](https://uploadgram.me) - a simple and fast file uploader that uses Telegram network as file storage.\n\n__If you download this module, you confirm your agreement with the [Terms of Service](https://uploadgram.me/terms.html) and [DMCA Policy](https://uploadgram.me/dmca.html) of [Upoadgram.me](https://uploadgram.me/)__\n\n![GitHub Repo stars](https://img.shields.io/github/stars/tankalxat34/UploadgramPyAPI?style=social)\n\n[![Downloads](https://pepy.tech/badge/uploadgrampyapi)](https://pepy.tech/project/uploadgrampyapi)\n[![Downloads](https://pepy.tech/badge/uploadgrampyapi/month)](https://pepy.tech/project/uploadgrampyapi)\n[![Downloads](https://pepy.tech/badge/uploadgrampyapi/week)](https://pepy.tech/project/uploadgrampyapi)\n[![Supported Versions](https://img.shields.io/pypi/pyversions/uploadgrampyapi.svg)](https://pypi.org/project/uploadgrampyapi)\n[![PyPI](https://img.shields.io/pypi/v/uploadgrampyapi.svg)](https://pypi.org/project/uploadgrampyapi/)\n[![PyPi](https://img.shields.io/pypi/format/uploadgrampyapi)](https://pypi.org/project/uploadgrampyapi/)\n![GitHub top language](https://img.shields.io/github/languages/top/tankalxat34/UploadgramPyAPI)\n![GitHub last commit](https://img.shields.io/github/last-commit/tankalxat34/uploadgrampyapi)\n\n[![releases note](https://img.shields.io/badge/-releases%20note-blue?style=for-the-badge)](https://github.com/tankalxat34/UploadgramPyAPI/blob/main/releases_note.md)\n\n__Author: tankalxat34__\n\n# Install\nIn your CMD perform this command:\n\n```bat\npip install UploadgramPyAPI\n```\n\n# Quickstart\n## Upload any file\n```py\nimport UploadgramPyAPI\nup_file = UploadgramPyAPI.NewFile("D:\\\\image.jpg")\nup_file.upload()\n```\n\n## Delete any file\n```py\nimport UploadgramPyAPI\nup_file = UploadgramPyAPI.File("611e5e6237f6fg", "e3da26e9dddd2e01b8c0831370695e9088a96ff81e262fc2g")\nup_file.delete()\n```\n\n## Rename any file\n```py\nimport UploadgramPyAPI\nup_file = UploadgramPyAPI.File("611e5e6237f6fg", "e3da26e9dddd2e01b8c0831370695e9088a96ff81e262fc2g")\nup_file.rename("ItsNewNameForFile.jpg")\n```\n\n## Download any file\n```py\nimport UploadgramPyAPI\nup_file = UploadgramPyAPI.File("611e5e6237f6fg", "e3da26e9dddd2e01b8c0831370695e9088a96ff81e262fc2g")\nup_file.download()\n```\n\n# Using\nNow we can looking, how to use UploadgramPyAPI\n\n## Upload new file\n\n### Step 1\nFirstly, you need to import the library:\n\n```py\nimport UploadgramPyAPI\n```\n\n### Step 2\nNext if you want to upload new file on uploadgram.me you need write this in your file:\n\n```py\nup_file = UploadgramPyAPI.NewFile("D:\\\\image.jpg")\n```\n\nThis string will preparing your file to upload.\n\n### Step 3\nWrite this line after the previous one.\n\n```py\nup_file.upload()\n```\n\nNow file `image.jpg` was uploaded in uploadgram.me and you was get the dictionary like here\n```json\n{\n    "ok": "true", \n    "url": "https://dl.uploadgram.me/611e5e6237f6fg", \n    "delete": "e3da26e9dddd2e01b8c0831370695e9088a96ff81e262fc2g"\n}\n```\n\nUploadgramPyAPI can parse this json-responce and create new attributes: `url`, `key` and `url_import`. \n\n\n## Important thing\n_______\n___Attribute `key` is a very important string for renaming and removing the file. You need to save its, else you won\'t do it.___\n_______\n\n\n\n\n\nAttribute `url_import` it\'s a simple url for import your file in a dashboard in https://dl.uploadgram.me.\nIts look like this:\n\n```json\nhttps://uploadgram.me/upload/#import:{"e3da26e9dddd2e01b8c0831370695e9088a96ff81e262fc2g": {"filename": "image.jpg", "size": 55604, "url": "https://dl.uploadgram.me/611e5e6237f6fg"}}\n```\n\nOpen this url in your browser and uploaded file will appear on the website! You can see something like this:\n\n![Alt](https://sun9-54.userapi.com/impg/jppDL_T9_2FsDnc8pFLWdpqSzd91heDnbd8C4g/GJLh13On_aY.jpg?size=872x665&quality=96&sign=e32ba8f5877883060558882a1dd82345&type=album "slide")\n\nSo your code can be looking like this:\n```py\nimport UploadgramPyAPI\nup_file = UploadgramPyAPI.NewFile("D:\\\\image.jpg")\nup_file.upload()\n```\n\n## Delete file\n\nAlso you can delete the file. Look!\n\n### Step 1\n\nIf you have the `key` attribute for the file, you can delete its!\n\nFirstly, you need to write this strings for connect to server and file on it:\n\n```py\nimport UploadgramPyAPI\nup_file = UploadgramPyAPI.File("611e5e6237f6fg", "e3da26e9dddd2e01b8c0831370695e9088a96ff81e262fc2g")\nup_file.delete()\n```\n\nLast string deleted the `image.jpg` from `uploadgram.me`. If you want to make sure, you can open `url` in your browser. You will get the 404-error:\n\n![Alt](https://sun9-78.userapi.com/impg/jKe2pjbifNJ7QNR3wvkiVWV7wzHebukEwd4Xlw/HbreA_TjlIg.jpg?size=922x665&quality=96&sign=b37ab6325819b5589ee8bbed9af61252&type=album "slide")\n\n## Rename file\n\nUploadgramPyAPI can rename the file.\n\nWe need use the `key` attribute for rename the file. \n\nThe beginning is the same as in the previous steps:\n\n```py\nimport UploadgramPyAPI\nup_file = UploadgramPyAPI.File("611e5e6237f6fg", "e3da26e9dddd2e01b8c0831370695e9088a96ff81e262fc2g")\n\n# this string will rename the filename\nup_file.rename("ItsNewNameForFile.jpg")\n```\n\nAnd now you can see this situation:\n\n![Alt](https://sun9-80.userapi.com/impg/LQagHS9h8wcDdqMtDBCMeyUlU5QZ_PKJ2Fd3jA/QFax68p4K_0.jpg?size=872x665&quality=96&sign=fcd29c8114e651fbcae85d17293442e4&type=album "slide")\n\n## Download file\n\nYou can download the file from server:\n\n```py\nimport UploadgramPyAPI\nup_file = UploadgramPyAPI.File("611e5e6237f6fg", "e3da26e9dddd2e01b8c0831370695e9088a96ff81e262fc2g")\n\n# this string will help download the file in the default download\'s folder\nup_file.download()\n```\n\nFile will appear in the download\'s folder:\n\n![Alt](https://sun9-81.userapi.com/impg/2wvdZzEwgWKff9lzn2OIO1pXkG7yihLCMZxeyw/7Tzl3y78LJo.jpg?size=1021x850&quality=96&sign=6c43d00ea579a07566ba506b8032fa0e&type=album "slide")\n\nAlso you can write path to save file:\n\n```py\nup_file.download("D:\\\\MyMainFolder\\\\")\n```\n\nIt\'s enough! Successful use of the UploadgramPyAPI library!\n',
    'author': 'tankalxat34',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'py_modules': modules,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
