/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance;

import org.gephi.appearance.RankingImpl;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Index;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.types.TimeMap;

public class AttributeRankingImpl
extends RankingImpl {
    protected final Index index;
    protected final Column column;
    protected final Graph graph;

    public AttributeRankingImpl(Column column, Graph graph, Index index) {
        this.column = column;
        this.graph = graph;
        this.index = index;
    }

    @Override
    protected void refresh() {
        if (this.index != null && this.index.isSortable(this.column)) {
            this.min = this.index.getMinValue(this.column);
            this.max = this.index.getMaxValue(this.column);
        } else {
            ElementIterable<Node> iterable;
            ElementIterable<Node> elementIterable = iterable = AttributeUtils.isNodeColumn(this.column) ? this.graph.getNodes() : this.graph.getEdges();
            if (this.column.isDynamic()) {
                this.refreshDynamic(iterable);
            } else {
                this.refreshNotIndexed(iterable);
            }
        }
    }

    protected void refreshDynamic(ElementIterable<? extends Element> iterable) {
        double minN = Double.POSITIVE_INFINITY;
        double maxN = Double.NEGATIVE_INFINITY;
        for (Element element : iterable) {
            TimeMap timeMap = (TimeMap)element.getAttribute(this.column);
            if (timeMap == null) continue;
            double numMin = ((Number)timeMap.get(this.graph.getView().getTimeInterval(), Estimator.MIN)).doubleValue();
            double numMax = ((Number)timeMap.get(this.graph.getView().getTimeInterval(), Estimator.MAX)).doubleValue();
            if (numMin < minN) {
                minN = numMin;
            }
            if (!(numMax > maxN)) continue;
            maxN = numMax;
        }
        this.min = minN;
        this.max = maxN;
    }

    protected void refreshNotIndexed(ElementIterable<? extends Element> iterable) {
        double minN = Double.POSITIVE_INFINITY;
        double maxN = Double.NEGATIVE_INFINITY;
        for (Element element : iterable) {
            double num = ((Number)element.getAttribute(this.column)).doubleValue();
            if (num < minN) {
                minN = num;
            }
            if (!(num > maxN)) continue;
            maxN = num;
        }
        this.min = minN;
        this.max = maxN;
    }

    @Override
    public Number getValue(Element element, Graph gr) {
        if (this.graph != null) {
            return (Number)element.getAttribute(this.column, gr.getView());
        }
        return (Number)element.getAttribute(this.column);
    }

    public int hashCode() {
        int hash = 3;
        hash = 67 * hash + (this.column != null ? this.column.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeRankingImpl other = (AttributeRankingImpl)obj;
        return this.column == other.column || this.column != null && this.column.equals(other.column);
    }
}

