/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance.plugin;

import java.awt.Color;
import java.io.Serializable;
import java.util.Arrays;
import org.gephi.appearance.api.Interpolator;
import org.gephi.appearance.api.Ranking;
import org.gephi.appearance.spi.RankingTransformer;
import org.gephi.graph.api.Element;

public class RankingElementColorTransformer
implements RankingTransformer<Element> {
    protected final LinearGradient linearGradient = new LinearGradient(new Color[]{new Color(15595771), new Color(6734500), new Color(27948)}, new float[]{0.0f, 0.5f, 1.0f});

    @Override
    public void transform(Element element, Ranking ranking, Interpolator interpolator, Number value) {
        Color color = this.linearGradient.getValue(ranking.normalize(value, interpolator));
        element.setColor(color);
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public boolean isEdge() {
        return true;
    }

    public float[] getColorPositions() {
        return this.linearGradient.getPositions();
    }

    public Color[] getColors() {
        return this.linearGradient.getColors();
    }

    public void setColorPositions(float[] positions) {
        this.linearGradient.setPositions(positions);
    }

    public void setColors(Color[] colors) {
        this.linearGradient.setColors(colors);
    }

    public LinearGradient getLinearGradient() {
        return this.linearGradient;
    }

    public static class LinearGradient
    implements Serializable,
    Cloneable {
        private Color[] colors;
        private float[] positions;

        public LinearGradient(Color[] colors, float[] positions) {
            if (colors == null || positions == null) {
                throw new NullPointerException();
            }
            if (colors.length != positions.length) {
                throw new IllegalArgumentException();
            }
            this.colors = colors;
            this.positions = positions;
        }

        public Color getValue(float pos) {
            for (int a = 0; a < this.positions.length - 1; ++a) {
                if (this.positions[a] == pos) {
                    return this.colors[a];
                }
                if (!(this.positions[a] < pos) || !(pos < this.positions[a + 1])) continue;
                float v = (pos - this.positions[a]) / (this.positions[a + 1] - this.positions[a]);
                return this.tween(this.colors[a], this.colors[a + 1], v);
            }
            if (pos <= this.positions[0]) {
                return this.colors[0];
            }
            if (pos >= this.positions[this.positions.length - 1]) {
                return this.colors[this.colors.length - 1];
            }
            return null;
        }

        private Color tween(Color c1, Color c2, float p) {
            return new Color((int)((float)c1.getRed() * (1.0f - p) + (float)c2.getRed() * p), (int)((float)c1.getGreen() * (1.0f - p) + (float)c2.getGreen() * p), (int)((float)c1.getBlue() * (1.0f - p) + (float)c2.getBlue() * p), (int)((float)c1.getAlpha() * (1.0f - p) + (float)c2.getAlpha() * p));
        }

        public Color[] getColors() {
            return this.colors;
        }

        public float[] getPositions() {
            return this.positions;
        }

        public void setColors(Color[] colors) {
            this.colors = colors;
        }

        public void setPositions(float[] positions) {
            this.positions = positions;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LinearGradient other = (LinearGradient)obj;
            if (!Arrays.deepEquals(this.colors, other.colors)) {
                return false;
            }
            return Arrays.equals(this.positions, other.positions);
        }

        public int hashCode() {
            int hash = 3;
            hash = 17 * hash + Arrays.deepHashCode(this.colors);
            hash = 17 * hash + Arrays.hashCode(this.positions);
            return hash;
        }

        protected Object clone() throws CloneNotSupportedException {
            LinearGradient cl = new LinearGradient(this.colors, this.positions);
            return cl;
        }
    }
}

