/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.api;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.gephi.datalab.api.datatables.DataTablesController;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.Node;
import org.openide.util.Lookup;

public interface SearchReplaceController {
    public SearchResult findNext(SearchOptions var1);

    public SearchResult findNext(SearchResult var1);

    public boolean canReplace(SearchResult var1);

    public SearchResult replace(SearchResult var1, String var2);

    public int replaceAll(SearchOptions var1, String var2);

    public static class SearchResult {
        private SearchOptions searchOptions;
        private Node foundNode;
        private Edge foundEdge;
        private int foundRowIndex;
        private int foundColumnIndex;
        private int start;
        private int end;

        public SearchResult(SearchOptions searchOptions, Node foundNode, Edge foundEdge, int foundRowIndex, int foundColumnIndex, int start, int end) {
            this.searchOptions = searchOptions;
            this.foundNode = foundNode;
            this.foundEdge = foundEdge;
            this.foundRowIndex = foundRowIndex;
            this.foundColumnIndex = foundColumnIndex;
            this.start = start;
            this.end = end;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getFoundColumnIndex() {
            return this.foundColumnIndex;
        }

        public void setFoundColumnIndex(int foundColumnIndex) {
            this.foundColumnIndex = foundColumnIndex;
        }

        public Edge getFoundEdge() {
            return this.foundEdge;
        }

        public void setFoundEdge(Edge foundEdge) {
            this.foundEdge = foundEdge;
        }

        public Node getFoundNode() {
            return this.foundNode;
        }

        public void setFoundNode(Node foundNode) {
            this.foundNode = foundNode;
        }

        public int getFoundRowIndex() {
            return this.foundRowIndex;
        }

        public void setFoundRowIndex(int foundRowIndex) {
            this.foundRowIndex = foundRowIndex;
        }

        public SearchOptions getSearchOptions() {
            return this.searchOptions;
        }

        public void setSearchOptions(SearchOptions searchOptions) {
            this.searchOptions = searchOptions;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }
    }

    public static class SearchOptions {
        private boolean searchNodes;
        private Node[] nodesToSearch;
        private Edge[] edgesToSearch;
        private Integer startingRow = null;
        private Integer startingColumn = null;
        private HashSet<Integer> columnsToSearch = new HashSet();
        private boolean loopToBeginning = true;
        private Pattern regexPattern;
        private boolean useRegexReplaceMode = false;
        private int regionStart = 0;
        private boolean onlyMatchWholeAttributeValue;

        public void resetStatus() {
            this.regionStart = 0;
            this.startingRow = null;
            this.startingColumn = null;
        }

        private void checkNodesToSearch() {
            if (this.nodesToSearch == null || this.nodesToSearch.length == 0) {
                Graph graph = Lookup.getDefault().lookup(DataTablesController.class).isShowOnlyVisible() ? Lookup.getDefault().lookup(GraphController.class).getGraphModel().getGraphVisible() : Lookup.getDefault().lookup(GraphController.class).getGraphModel().getGraph();
                this.nodesToSearch = graph.getNodes().toArray();
            }
        }

        private void checkEdgesToSearch() {
            if (this.edgesToSearch == null || this.edgesToSearch.length == 0) {
                Graph hg = Lookup.getDefault().lookup(DataTablesController.class).isShowOnlyVisible() ? Lookup.getDefault().lookup(GraphController.class).getGraphModel().getGraphVisible() : Lookup.getDefault().lookup(GraphController.class).getGraphModel().getGraph();
                this.edgesToSearch = hg.getEdges().toArray();
            }
        }

        public SearchOptions(Node[] nodesToSearch, Pattern regexPattern) {
            this.nodesToSearch = nodesToSearch;
            this.regexPattern = regexPattern;
            this.searchNodes = true;
            this.checkNodesToSearch();
        }

        public SearchOptions(Edge[] edgesToSearch, Pattern regexPattern) {
            this.edgesToSearch = edgesToSearch;
            this.regexPattern = regexPattern;
            this.searchNodes = false;
            this.checkEdgesToSearch();
        }

        public SearchOptions(Node[] nodesToSearch, Pattern regexPattern, boolean onlyMatchWholeAttributeValue) {
            this.nodesToSearch = nodesToSearch;
            this.regexPattern = regexPattern;
            this.onlyMatchWholeAttributeValue = onlyMatchWholeAttributeValue;
            this.searchNodes = true;
        }

        public SearchOptions(Edge[] edgesToSearch, Pattern regexPattern, boolean onlyMatchWholeAttributeValue) {
            this.edgesToSearch = edgesToSearch;
            this.regexPattern = regexPattern;
            this.onlyMatchWholeAttributeValue = onlyMatchWholeAttributeValue;
            this.searchNodes = false;
        }

        public Edge[] getEdgesToSearch() {
            return this.edgesToSearch;
        }

        public Node[] getNodesToSearch() {
            return this.nodesToSearch;
        }

        public boolean isOnlyMatchWholeAttributeValue() {
            return this.onlyMatchWholeAttributeValue;
        }

        public void setOnlyMatchWholeAttributeValue(boolean onlyMatchWholeAttributeValue) {
            this.onlyMatchWholeAttributeValue = onlyMatchWholeAttributeValue;
        }

        public Pattern getRegexPattern() {
            return this.regexPattern;
        }

        public void setRegexPattern(Pattern regexPattern) {
            this.regexPattern = regexPattern;
        }

        public Integer getStartingColumn() {
            return this.startingColumn;
        }

        public void setStartingColumn(Integer startingColumn) {
            this.startingColumn = startingColumn;
        }

        public Integer getStartingRow() {
            return this.startingRow;
        }

        public void setStartingRow(Integer startingRow) {
            this.startingRow = startingRow;
        }

        public void setColumnsToSearch(int[] columnsToSearch) {
            this.columnsToSearch.clear();
            if (columnsToSearch != null) {
                int[] nArray = columnsToSearch;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    Integer i2 = nArray[i];
                    this.columnsToSearch.add(i2);
                }
            }
        }

        public void setColumnsToSearch(Column[] columnsToSearch) {
            this.columnsToSearch.clear();
            if (columnsToSearch != null) {
                for (Column c : columnsToSearch) {
                    this.columnsToSearch.add(c.getIndex());
                }
            }
        }

        public Set<Integer> getColumnsToSearch() {
            return this.columnsToSearch;
        }

        public boolean isSearchNodes() {
            return this.searchNodes;
        }

        public int getRegionStart() {
            return this.regionStart;
        }

        public void setRegionStart(int regionStart) {
            this.regionStart = regionStart;
        }

        public boolean isUseRegexReplaceMode() {
            return this.useRegexReplaceMode;
        }

        public void setUseRegexReplaceMode(boolean useRegexReplaceMode) {
            this.useRegexReplaceMode = useRegexReplaceMode;
        }

        public boolean isLoopToBeginning() {
            return this.loopToBeginning;
        }

        public void setLoopToBeginning(boolean loopToBeginning) {
            this.loopToBeginning = loopToBeginning;
        }
    }
}

