/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.FilterModelImpl;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphObserver;
import org.openide.util.Exceptions;

public class FilterAutoRefreshor
extends Thread {
    private static final int TIMER = 1000;
    private final GraphModel graphModel;
    private final FilterModelImpl filterModel;
    private GraphObserver observer;
    private boolean running = true;

    public FilterAutoRefreshor(FilterModelImpl filterModel, GraphModel graphModel) {
        super("Filter Auto-Refresh - " + filterModel.getWorkspace().toString());
        this.setDaemon(true);
        this.graphModel = graphModel;
        this.filterModel = filterModel;
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                if (this.observer != null && this.observer.hasGraphChanged()) {
                    this.manualRefresh();
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace(ex);
            }
        }
    }

    public void setEnable(boolean enable) {
        if (enable) {
            if (this.observer == null) {
                this.observer = this.graphModel.createGraphObserver(this.graphModel.getGraph(), false);
            }
        } else if (this.observer != null && !this.observer.isDestroyed()) {
            this.observer.destroy();
            this.observer = null;
        }
        if (!this.isAlive()) {
            this.start();
        }
    }

    public void setRunning(boolean running) {
        this.running = running;
        if (!running && this.observer != null && !this.observer.isDestroyed()) {
            this.observer.destroy();
            this.observer = null;
        }
    }

    public void manualRefresh() {
        if (this.filterModel.getFilterThread() != null && this.filterModel.getCurrentQuery() != null) {
            this.filterModel.getFilterThread().setRootQuery((AbstractQueryImpl)this.filterModel.getCurrentQuery());
        }
    }
}

