/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.gephi.filters.AbstractQueryImpl;
import org.gephi.filters.FilterModelImpl;
import org.gephi.filters.FilterProcessor;
import org.gephi.filters.api.PropertyExecutor;
import org.gephi.filters.api.Query;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.gephi.utils.progress.ProgressTicketProvider;
import org.gephi.visualization.api.VisualizationController;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class FilterThread
extends Thread {
    private final FilterModelImpl model;
    private final AtomicReference<AbstractQueryImpl> rootQuery;
    ConcurrentHashMap<String, PropertyModifier> modifiersMap;
    private boolean running = true;
    private final Object lock = new Object();
    private final boolean filtering;

    public FilterThread(FilterModelImpl model) {
        super("Filter Thread - " + model.getWorkspace().toString());
        this.setDaemon(true);
        this.model = model;
        this.filtering = model.isFiltering();
        this.rootQuery = new AtomicReference();
        this.modifiersMap = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Query q;
        while (this.running) {
            while ((q = (AbstractQueryImpl)this.rootQuery.getAndSet(null)) == null && this.running) {
                try {
                    Object object = this.lock;
                    synchronized (object) {
                        this.lock.wait();
                    }
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
            if (!this.running) {
                return;
            }
            Query modifiedQuery = null;
            Iterator<PropertyModifier> itr = this.modifiersMap.values().iterator();
            while (itr.hasNext()) {
                PropertyModifier pm = itr.next();
                itr.remove();
                pm.callback.setValue(pm.value);
                modifiedQuery = pm.query;
            }
            if (modifiedQuery != null) {
                this.model.updateParameters(modifiedQuery);
            }
            ProgressTicket progressTicket = null;
            ProgressTicketProvider progressTicketProvider = Lookup.getDefault().lookup(ProgressTicketProvider.class);
            if (progressTicketProvider != null) {
                String msg = NbBundle.getMessage(FilterThread.class, "FilterThread.progress.taskName", ((AbstractQueryImpl)q).getName());
                progressTicket = progressTicketProvider.createTicket(msg, null);
                Progress.start(progressTicket);
            }
            if (this.filtering) {
                this.filter((AbstractQueryImpl)q);
            } else {
                this.select((AbstractQueryImpl)q);
            }
            Progress.finish(progressTicket);
        }
        q = null;
        for (PropertyModifier pm : this.modifiersMap.values()) {
            pm.callback.setValue(pm.value);
            q = pm.query;
        }
        this.modifiersMap.clear();
        if (q != null) {
            this.model.updateParameters(q);
        }
    }

    private void filter(AbstractQueryImpl query) {
        FilterProcessor processor = new FilterProcessor();
        GraphModel graphModel = this.model.getGraphModel();
        Graph result = processor.process(query, graphModel);
        if (this.running) {
            GraphView view = result.getView();
            graphModel.setVisibleView(view);
            if (this.model.getCurrentResult() != null) {
                graphModel.destroyView(this.model.getCurrentResult());
            }
            this.model.setCurrentResult(view);
        } else {
            graphModel.destroyView(result.getView());
        }
    }

    private void select(AbstractQueryImpl query) {
        FilterProcessor processor = new FilterProcessor();
        GraphModel graphModel = this.model.getGraphModel();
        Graph result = processor.process(query, graphModel);
        if (this.running) {
            VisualizationController visController = Lookup.getDefault().lookup(VisualizationController.class);
            if (visController != null) {
                visController.resetSelection();
                visController.selectNodes(result.getNodes().toArray());
                visController.selectEdges(result.getEdges().toArray());
            }
            GraphView view = result.getView();
            this.model.setCurrentResult(view);
        } else {
            graphModel.destroyView(result.getView());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootQuery(AbstractQueryImpl rootQuery) {
        this.rootQuery.set(rootQuery);
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public AbstractQueryImpl getRootQuery() {
        return this.rootQuery.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunning(boolean running) {
        this.running = running;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
    }

    public void addModifier(PropertyModifier modifier) {
        this.modifiersMap.put(modifier.property.getName(), modifier);
    }

    protected static class PropertyModifier {
        protected final Object value;
        protected final PropertyExecutor.Callback callback;
        protected final FilterProperty property;
        protected final Query query;

        public PropertyModifier(Query query, FilterProperty property, Object value, PropertyExecutor.Callback callback) {
            this.query = query;
            this.property = property;
            this.value = value;
            this.callback = callback;
        }
    }
}

