/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.edge;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.AbstractFilter;
import org.gephi.filters.plugin.edge.EdgeTypeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EdgeTypeBuilder
implements FilterBuilder {
    @Override
    public Category getCategory() {
        return FilterLibrary.EDGE;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(EdgeTypeBuilder.class, "EdgeTypeBuilder.name");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(EdgeTypeBuilder.class, "EdgeTypeBuilder.description");
    }

    @Override
    public Filter getFilter(Workspace workspace) {
        GraphModel am = Lookup.getDefault().lookup(GraphController.class).getGraphModel(workspace);
        return new EdgeTypeFilter(am);
    }

    @Override
    public JPanel getPanel(Filter filter) {
        EdgeTypeFilter edgeTypeFilter = (EdgeTypeFilter)filter;
        EdgeTypeUI ui = Lookup.getDefault().lookup(EdgeTypeUI.class);
        if (ui != null) {
            return ui.getPanel(edgeTypeFilter);
        }
        return null;
    }

    @Override
    public void destroy(Filter filter) {
    }

    public static class EdgeTypeFilter
    extends AbstractFilter
    implements EdgeFilter {
        private final GraphModel graphModel;
        private Integer type;

        public EdgeTypeFilter(GraphModel graphModel) {
            super(NbBundle.getMessage(EdgeTypeBuilder.class, "EdgeTypeBuilder.name"));
            this.graphModel = graphModel;
            this.addProperty(Integer.class, "type");
        }

        @Override
        public boolean init(Graph graph) {
            return true;
        }

        @Override
        public boolean evaluate(Graph graph, Edge edge) {
            return this.type.equals(edge.getType());
        }

        @Override
        public void finish() {
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Collection getEdgeTypeLabels() {
            Graph graph = this.graphModel.getGraph();
            Object[] labels = this.graphModel.getEdgeTypeLabels();
            ArrayList<Object> col = new ArrayList<Object>(labels.length);
            for (Object l : labels) {
                if (graph.getEdgeCount(this.graphModel.getEdgeType(l)) <= 0) continue;
                col.add(l);
            }
            return col;
        }

        public void setEdgeTypeLabel(Object obj) {
            int id = this.graphModel.getEdgeType(obj);
            if (id != -1) {
                this.getProperties()[0].setValue(id);
            }
        }
    }
}

