/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.edge;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.AbstractFilter;
import org.gephi.filters.plugin.graph.RangeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.RangeFilter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class EdgeWeightBuilder
implements FilterBuilder {
    @Override
    public Category getCategory() {
        return FilterLibrary.EDGE;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(EdgeWeightBuilder.class, "EdgeWeightBuilder.name");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(EdgeWeightBuilder.class, "EdgeWeightBuilder.description");
    }

    @Override
    public Filter getFilter(Workspace workspace) {
        return new EdgeWeightFilter();
    }

    @Override
    public JPanel getPanel(Filter filter) {
        RangeUI ui = Lookup.getDefault().lookup(RangeUI.class);
        if (ui != null) {
            return ui.getPanel((EdgeWeightFilter)filter);
        }
        return null;
    }

    @Override
    public void destroy(Filter filter) {
    }

    public static class EdgeWeightFilter
    extends AbstractFilter
    implements RangeFilter,
    EdgeFilter {
        private Range range;

        public EdgeWeightFilter() {
            super(NbBundle.getMessage(EdgeWeightBuilder.class, "EdgeWeightBuilder.name"));
            this.addProperty(Range.class, "range");
        }

        @Override
        public boolean init(Graph graph) {
            return graph.getEdgeCount() != 0;
        }

        @Override
        public boolean evaluate(Graph graph, Edge edge) {
            double weight = edge.getWeight(graph.getView());
            return this.range.isInRange(weight);
        }

        @Override
        public void finish() {
        }

        @Override
        public Number[] getValues(Graph graph) {
            ArrayList<Double> values = new ArrayList<Double>();
            for (Edge e : graph.getEdges()) {
                double weight = e.getWeight(graph.getView());
                values.add(weight);
            }
            return values.toArray(new Number[0]);
        }

        @Override
        public FilterProperty getRangeProperty() {
            return this.getProperties()[0];
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }
    }
}

