/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.edge;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.AbstractFilter;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.project.api.Workspace;
import org.openide.util.NbBundle;

public class MutualEdgeBuilder
implements FilterBuilder {
    @Override
    public Category getCategory() {
        return FilterLibrary.EDGE;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(MutualEdgeBuilder.class, "MutualEdgeBuilder.name");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(MutualEdgeBuilder.class, "MutualEdgeBuilder.description");
    }

    @Override
    public Filter getFilter(Workspace workspace) {
        return new MutualEdgeFilter();
    }

    @Override
    public JPanel getPanel(Filter filter) {
        return null;
    }

    @Override
    public void destroy(Filter filter) {
    }

    public static class MutualEdgeFilter
    extends AbstractFilter
    implements EdgeFilter {
        public MutualEdgeFilter() {
            super(NbBundle.getMessage(MutualEdgeBuilder.class, "MutualEdgeBuilder.name"));
        }

        @Override
        public boolean init(Graph graph) {
            return !graph.isUndirected();
        }

        @Override
        public boolean evaluate(Graph graph, Edge edge) {
            if (edge.isDirected()) {
                DirectedGraph directedGraph = (DirectedGraph)graph;
                return directedGraph.getMutualEdge(edge) != null;
            }
            return false;
        }

        @Override
        public void finish() {
        }
    }
}

