/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.UndirectedSubgraph;
import org.gephi.project.api.Workspace;
import org.gephi.statistics.plugin.ConnectedComponents;
import org.openide.util.NbBundle;

public class GiantComponentBuilder
implements FilterBuilder {
    @Override
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(GiantComponentBuilder.class, "GiantComponentBuilder.name");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(GiantComponentBuilder.class, "GiantComponentBuilder.description");
    }

    @Override
    public Filter getFilter(Workspace workspace) {
        return new GiantComponentFilter();
    }

    @Override
    public JPanel getPanel(Filter filter) {
        return null;
    }

    @Override
    public void destroy(Filter filter) {
    }

    public static class GiantComponentFilter
    implements NodeFilter {
        private int componentId;
        private Column column;

        @Override
        public boolean init(Graph graph) {
            ConnectedComponents cc = new ConnectedComponents();
            UndirectedSubgraph undirectedGraph = graph.getModel().getUndirectedGraph(graph.getView());
            cc.weaklyConnected(undirectedGraph);
            this.componentId = cc.getGiantComponent();
            this.column = graph.getModel().getNodeTable().getColumn("componentnumber");
            return this.column != null && this.componentId != -1;
        }

        @Override
        public boolean evaluate(Graph graph, Node node) {
            Integer component = (Integer)node.getAttribute(this.column);
            if (component != null) {
                return component.equals(this.componentId);
            }
            return false;
        }

        @Override
        public void finish() {
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(GiantComponentBuilder.class, "GiantComponentBuilder.name");
        }

        @Override
        public FilterProperty[] getProperties() {
            return new FilterProperty[0];
        }
    }
}

