/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.NbBundle;

public class HasSelfLoopBuilder
implements FilterBuilder {
    @Override
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(HasSelfLoopBuilder.class, "HasSelfLoopBuilder.name");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(HasSelfLoopBuilder.class, "HasSelfLoopBuilder.description");
    }

    @Override
    public Filter getFilter(Workspace workspace) {
        return new HasSelfLoopFilter();
    }

    @Override
    public JPanel getPanel(Filter filter) {
        return null;
    }

    @Override
    public void destroy(Filter filter) {
    }

    public static class HasSelfLoopFilter
    implements NodeFilter {
        @Override
        public boolean init(Graph graph) {
            return true;
        }

        @Override
        public boolean evaluate(Graph graph, Node node) {
            EdgeIterable edgeIterable = graph.getEdges(node);
            for (Edge e : edgeIterable) {
                if (!e.isSelfLoop()) continue;
                edgeIterable.doBreak();
                return true;
            }
            return false;
        }

        @Override
        public void finish() {
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(HasSelfLoopBuilder.class, "HasSelfLoopBuilder.name");
        }

        @Override
        public FilterProperty[] getProperties() {
            return new FilterProperty[0];
        }
    }
}

