/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.graph.KCoreUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.ComplexFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class KCoreBuilder
implements FilterBuilder {
    @Override
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(KCoreBuilder.class, "KCoreBuilder.name");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(KCoreBuilder.class, "KCoreBuilder.description");
    }

    @Override
    public Filter getFilter(Workspace workspace) {
        return new KCoreFilter();
    }

    @Override
    public JPanel getPanel(Filter filter) {
        KCoreUI ui = Lookup.getDefault().lookup(KCoreUI.class);
        if (ui != null) {
            return ui.getPanel((KCoreFilter)filter);
        }
        return null;
    }

    @Override
    public void destroy(Filter filter) {
    }

    public static class KCoreFilter
    implements ComplexFilter {
        private FilterProperty[] filterProperties;
        private Integer k = 1;

        @Override
        public Graph filter(Graph graph) {
            int removed = 0;
            do {
                removed = 0;
                for (Node n : graph.getNodes().toArray()) {
                    if (graph.getDegree(n) >= this.k) continue;
                    graph.removeNode(n);
                    ++removed;
                }
            } while (removed > 0);
            return graph;
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(KCoreBuilder.class, "KCoreBuilder.name");
        }

        @Override
        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty(this, Integer.class, "k")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
            return this.filterProperties;
        }

        public Integer getK() {
            return this.k;
        }

        public void setK(Integer k) {
            this.k = k;
        }
    }
}

