/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import java.util.Collection;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.graph.NeighborsUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.ComplexFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class NeighborsBuilder
implements FilterBuilder {
    @Override
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(NeighborsBuilder.class, "NeighborsBuilder.name");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(NeighborsBuilder.class, "NeighborsBuilder.description");
    }

    @Override
    public Filter getFilter(Workspace workspace) {
        return new NeighborsFilter();
    }

    @Override
    public JPanel getPanel(Filter filter) {
        NeighborsUI ui = Lookup.getDefault().lookup(NeighborsUI.class);
        if (ui != null) {
            return ui.getPanel((NeighborsFilter)filter);
        }
        return null;
    }

    @Override
    public void destroy(Filter filter) {
    }

    public static class NeighborsFilter
    implements ComplexFilter {
        private boolean self = true;
        private int depth = 1;

        @Override
        public Graph filter(Graph graph) {
            GraphView graphView = graph.getView();
            Collection<Node> nodes = graph.getNodes().toCollection();
            HashSet<Node> result = new HashSet<Node>();
            HashSet<Node> neighbours = new HashSet<Node>();
            neighbours.addAll(nodes);
            Graph mainGraph = graph.getModel().getGraph();
            for (int i = 0; i < this.depth; ++i) {
                Node[] nei = neighbours.toArray(new Node[0]);
                neighbours.clear();
                for (Node n : nei) {
                    for (Node neighbor : mainGraph.getNeighbors(n)) {
                        neighbours.add(neighbor);
                        result.add(neighbor);
                    }
                }
                if (neighbours.isEmpty()) break;
            }
            if (this.self) {
                result.addAll(nodes);
            } else {
                result.removeAll(nodes);
            }
            for (Node node : mainGraph.getNodes()) {
                if (result.contains(node)) {
                    graph.addNode(node);
                    continue;
                }
                if (!graph.contains(node)) continue;
                graph.removeNode(node);
            }
            for (Edge edge : mainGraph.getEdges()) {
                if (!graph.contains(edge.getSource()) || !graph.contains(edge.getTarget())) continue;
                graph.addEdge(edge);
            }
            return graph;
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(NeighborsBuilder.class, "NeighborsBuilder.name");
        }

        @Override
        public FilterProperty[] getProperties() {
            try {
                return new FilterProperty[]{FilterProperty.createProperty(this, Integer.class, "depth"), FilterProperty.createProperty(this, Boolean.class, "self")};
            }
            catch (NoSuchMethodException ex) {
                Exceptions.printStackTrace(ex);
                return new FilterProperty[0];
            }
        }

        public Integer getDepth() {
            return this.depth;
        }

        public void setDepth(Integer depth) {
            this.depth = depth;
        }

        public boolean isSelf() {
            return this.self;
        }

        public void setSelf(boolean self) {
            this.self = self;
        }
    }
}

