/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.operator;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Subgraph;
import org.gephi.project.api.Workspace;
import org.openide.util.NbBundle;

public class INTERSECTIONBuilder
implements FilterBuilder {
    @Override
    public Category getCategory() {
        return new Category(NbBundle.getMessage(INTERSECTIONBuilder.class, "Operator.category"));
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(INTERSECTIONBuilder.class, "INTERSECTIONBuilder.name");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(INTERSECTIONBuilder.class, "INTERSECTIONBuilder.description");
    }

    @Override
    public Filter getFilter(Workspace workspace) {
        return new IntersectionOperator();
    }

    @Override
    public JPanel getPanel(Filter filter) {
        return null;
    }

    @Override
    public void destroy(Filter filter) {
    }

    public static class IntersectionOperator
    implements Operator {
        @Override
        public int getInputCount() {
            return Integer.MAX_VALUE;
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(INTERSECTIONBuilder.class, "INTERSECTIONBuilder.name");
        }

        @Override
        public FilterProperty[] getProperties() {
            return null;
        }

        @Override
        public Graph filter(Subgraph[] graphs) {
            Subgraph subgraph = graphs[0];
            for (int i = 1; i < graphs.length; ++i) {
                subgraph.intersection(graphs[i]);
            }
            return subgraph;
        }

        @Override
        public Graph filter(Graph graph, Filter[] filters) {
            Iterator itr;
            ArrayList<NodeFilter> nodeFilters = new ArrayList<NodeFilter>();
            ArrayList<EdgeFilter> edgeFilters = new ArrayList<EdgeFilter>();
            for (Filter f : filters) {
                if (f instanceof NodeFilter) {
                    nodeFilters.add((NodeFilter)f);
                    continue;
                }
                if (!(f instanceof EdgeFilter)) continue;
                edgeFilters.add((EdgeFilter)f);
            }
            if (nodeFilters.size() > 0) {
                itr = nodeFilters.iterator();
                while (itr.hasNext()) {
                    NodeFilter nf = (NodeFilter)itr.next();
                    if (nf.init(graph)) continue;
                    itr.remove();
                }
                ArrayList<Node> nodesToRemove = new ArrayList<Node>();
                block2: for (Node n : graph.getNodes()) {
                    for (NodeFilter nf : nodeFilters) {
                        if (nf.evaluate(graph, n)) continue;
                        nodesToRemove.add(n);
                        continue block2;
                    }
                }
                for (Node n : nodesToRemove) {
                    graph.removeNode(n);
                }
                for (NodeFilter nf : nodeFilters) {
                    nf.finish();
                }
            }
            if (edgeFilters.size() > 0) {
                itr = edgeFilters.iterator();
                while (itr.hasNext()) {
                    EdgeFilter ef = (EdgeFilter)itr.next();
                    if (ef.init(graph)) continue;
                    itr.remove();
                }
                ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
                block7: for (Edge e : graph.getEdges()) {
                    for (EdgeFilter ef : edgeFilters) {
                        if (ef.evaluate(graph, e)) continue;
                        edgesToRemove.add(e);
                        continue block7;
                    }
                }
                for (Edge e : edgesToRemove) {
                    graph.removeEdge(e);
                }
                for (EdgeFilter ef : edgeFilters) {
                    ef.finish();
                }
            }
            return graph;
        }
    }
}

