/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.operator;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.Operator;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Subgraph;
import org.gephi.project.api.Workspace;
import org.openide.util.NbBundle;

public class NOTBuilderNode
implements FilterBuilder {
    @Override
    public Category getCategory() {
        return new Category(NbBundle.getMessage(NOTBuilderNode.class, "Operator.category"));
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(NOTBuilderNode.class, "NOTBuilderNode.name");
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getDescription() {
        return NbBundle.getMessage(NOTBuilderNode.class, "NOTBuilderNode.description");
    }

    @Override
    public Filter getFilter(Workspace workspace) {
        return new NOTOperatorNode();
    }

    @Override
    public JPanel getPanel(Filter filter) {
        return null;
    }

    @Override
    public void destroy(Filter filter) {
    }

    public static class NOTOperatorNode
    implements Operator {
        @Override
        public int getInputCount() {
            return 1;
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(NOTBuilderNode.class, "NOTBuilderNode.name");
        }

        @Override
        public FilterProperty[] getProperties() {
            return null;
        }

        @Override
        public Graph filter(Subgraph[] graphs) {
            if (graphs.length > 1) {
                throw new IllegalArgumentException("Not Filter accepts a single graph in parameter");
            }
            Subgraph graph = graphs[0];
            Graph mainGraph = graph.getView().getGraphModel().getGraph();
            for (Node n : mainGraph.getNodes().toArray()) {
                if (!graph.contains(n)) {
                    graph.addNode(n);
                    continue;
                }
                graph.removeNode(n);
            }
            for (Edge e : mainGraph.getEdges()) {
                Edge edgeInGraph;
                Node source = e.getSource();
                Node target = e.getTarget();
                if (!graph.contains(source) || !graph.contains(target) || (edgeInGraph = graph.getEdge(source, target, e.getType())) != null) continue;
                graph.addEdge(e);
            }
            return graph;
        }

        @Override
        public Graph filter(Graph graph, Filter[] filters) {
            if (filters.length > 1) {
                throw new IllegalArgumentException("Not Filter accepts a single filter in parameter");
            }
            Filter filter = filters[0];
            if (filter instanceof NodeFilter && ((NodeFilter)filter).init(graph)) {
                ArrayList<Node> nodeToRemove = new ArrayList<Node>();
                NodeFilter nodeFilter = (NodeFilter)filter;
                for (Node n : graph.getNodes()) {
                    if (!nodeFilter.evaluate(graph, n)) continue;
                    nodeToRemove.add(n);
                }
                graph.removeAllNodes(nodeToRemove);
                nodeFilter.finish();
            }
            return graph;
        }
    }
}

