/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.partition;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.appearance.api.AppearanceController;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.partition.IntraEdgesBuilder;
import org.gephi.filters.plugin.partition.PartitionBuilder;
import org.gephi.filters.plugin.partition.PartitionUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class InterEdgesBuilder
implements CategoryBuilder {
    public static final Category INTER_EDGES = new Category(NbBundle.getMessage(InterEdgesBuilder.class, "InterEdgesBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    @Override
    public Category getCategory() {
        return INTER_EDGES;
    }

    @Override
    public FilterBuilder[] getBuilders(Workspace workspace) {
        ArrayList<InterEdgesFilterBuilder> builders = new ArrayList<InterEdgesFilterBuilder>();
        GraphModel gm = Lookup.getDefault().lookup(GraphController.class).getGraphModel(workspace);
        Graph graph = gm.getGraph();
        AppearanceModel am = Lookup.getDefault().lookup(AppearanceController.class).getModel(workspace);
        am.getNodeFunctions(graph);
        for (Column nodeCol : gm.getNodeTable()) {
            if (nodeCol.isProperty() || am.getNodePartition(graph, nodeCol) == null) continue;
            InterEdgesFilterBuilder builder = new InterEdgesFilterBuilder(nodeCol, am);
            builders.add(builder);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static class InterEdgesFilter
    extends PartitionBuilder.PartitionFilter
    implements EdgeFilter {
        public InterEdgesFilter(Column column, AppearanceModel model) {
            super(column, model);
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(IntraEdgesBuilder.class, "InterEdgesBuilder.name") + " (" + this.column.getTitle() + ")";
        }

        @Override
        public boolean init(Graph graph) {
            this.partition = this.appearanceModel.getNodePartition(graph.getModel().getGraph(), this.column);
            return this.partition != null;
        }

        @Override
        public boolean evaluate(Graph graph, Edge edge) {
            Object srcValue = this.partition.getValue(edge.getSource(), graph);
            Object destValue = this.partition.getValue(edge.getTarget(), graph);
            srcValue = srcValue == null ? NULL : srcValue;
            destValue = destValue == null ? NULL : destValue;
            return this.parts.contains(srcValue) && this.parts.contains(destValue) && srcValue.equals(destValue);
        }

        @Override
        public void finish() {
        }
    }

    private static class InterEdgesFilterBuilder
    implements FilterBuilder {
        private final Column column;
        private final AppearanceModel model;

        public InterEdgesFilterBuilder(Column column, AppearanceModel model) {
            this.column = column;
            this.model = model;
        }

        @Override
        public Category getCategory() {
            return INTER_EDGES;
        }

        @Override
        public String getName() {
            return this.column.getTitle();
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(InterEdgesBuilder.class, "InterEdgesBuilder.description");
        }

        @Override
        public InterEdgesFilter getFilter(Workspace workspace) {
            return new InterEdgesFilter(this.column, this.model);
        }

        @Override
        public JPanel getPanel(Filter filter) {
            PartitionUI ui = Lookup.getDefault().lookup(PartitionUI.class);
            if (ui != null) {
                return ui.getPanel((PartitionBuilder.PartitionFilter)filter);
            }
            return null;
        }

        @Override
        public void destroy(Filter filter) {
        }
    }
}

