/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.partition;

import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.appearance.api.AppearanceController;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.partition.PartitionBuilder;
import org.gephi.filters.plugin.partition.PartitionUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class IntraEdgesBuilder
implements CategoryBuilder {
    public static final Category INTRA_EDGES = new Category(NbBundle.getMessage(IntraEdgesBuilder.class, "IntraEdgesBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    @Override
    public Category getCategory() {
        return INTRA_EDGES;
    }

    @Override
    public FilterBuilder[] getBuilders(Workspace workspace) {
        ArrayList<IntraEdgesFilterBuilder> builders = new ArrayList<IntraEdgesFilterBuilder>();
        GraphModel gm = Lookup.getDefault().lookup(GraphController.class).getGraphModel(workspace);
        Graph graph = gm.getGraph();
        AppearanceModel am = Lookup.getDefault().lookup(AppearanceController.class).getModel(workspace);
        am.getNodeFunctions(graph);
        for (Column nodeCol : gm.getNodeTable()) {
            if (nodeCol.isProperty() || am.getNodePartition(graph, nodeCol) == null) continue;
            IntraEdgesFilterBuilder builder = new IntraEdgesFilterBuilder(nodeCol, am);
            builders.add(builder);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static class IntraEdgesFilter
    extends PartitionBuilder.PartitionFilter
    implements EdgeFilter {
        public IntraEdgesFilter(Column column, AppearanceModel model) {
            super(column, model);
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(IntraEdgesBuilder.class, "IntraEdgesBuilder.name") + " (" + this.column.getTitle() + ")";
        }

        @Override
        public boolean init(Graph graph) {
            this.partition = this.appearanceModel.getNodePartition(graph.getModel().getGraph(), this.column);
            return this.partition != null;
        }

        @Override
        public boolean evaluate(Graph graph, Edge edge) {
            Object srcValue = this.partition.getValue(edge.getSource(), graph);
            Object destValue = this.partition.getValue(edge.getTarget(), graph);
            srcValue = srcValue == null ? NULL : srcValue;
            destValue = destValue == null ? NULL : destValue;
            return this.parts.contains(srcValue) && this.parts.contains(destValue) && !srcValue.equals(destValue);
        }
    }

    private static class IntraEdgesFilterBuilder
    implements FilterBuilder {
        private final Column column;
        private final AppearanceModel model;

        public IntraEdgesFilterBuilder(Column column, AppearanceModel model) {
            this.column = column;
            this.model = model;
        }

        @Override
        public Category getCategory() {
            return INTRA_EDGES;
        }

        @Override
        public String getName() {
            return this.column.getTitle();
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(IntraEdgesBuilder.class, "IntraEdgesBuilder.description");
        }

        @Override
        public IntraEdgesFilter getFilter(Workspace workspace) {
            return new IntraEdgesFilter(this.column, this.model);
        }

        @Override
        public JPanel getPanel(Filter filter) {
            PartitionUI ui = Lookup.getDefault().lookup(PartitionUI.class);
            if (ui != null) {
                return ui.getPanel((PartitionBuilder.PartitionFilter)filter);
            }
            return null;
        }

        @Override
        public void destroy(Filter filter) {
        }
    }
}

