/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.partition;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.appearance.api.AppearanceController;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.Partition;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.partition.PartitionUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PartitionBuilder
implements CategoryBuilder {
    private static final Category PARTITION = new Category(NbBundle.getMessage(PartitionBuilder.class, "PartitionBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    @Override
    public Category getCategory() {
        return PARTITION;
    }

    @Override
    public FilterBuilder[] getBuilders(Workspace workspace) {
        PartitionFilterBuilder builder;
        ArrayList<PartitionFilterBuilder> builders = new ArrayList<PartitionFilterBuilder>();
        GraphModel gm = Lookup.getDefault().lookup(GraphController.class).getGraphModel(workspace);
        Graph graph = gm.getGraph();
        AppearanceModel am = Lookup.getDefault().lookup(AppearanceController.class).getModel(workspace);
        am.getNodeFunctions(graph);
        for (Column nodeCol : gm.getNodeTable()) {
            if (nodeCol.isProperty() || am.getNodePartition(graph, nodeCol) == null) continue;
            builder = new PartitionFilterBuilder(nodeCol, am);
            builders.add(builder);
        }
        for (Column edgeCol : gm.getEdgeTable()) {
            if (edgeCol.isProperty() || am.getEdgePartition(graph, edgeCol) == null) continue;
            builder = new PartitionFilterBuilder(edgeCol, am);
            builders.add(builder);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static abstract class PartitionFilter
    implements Filter {
        protected static final Object NULL = new Object();
        protected AppearanceModel appearanceModel;
        protected Column column;
        protected Partition partition;
        protected FilterProperty[] filterProperties;
        protected Set<Object> parts;

        public PartitionFilter(Column column, AppearanceModel model) {
            this.column = column;
            this.appearanceModel = model;
            this.parts = new HashSet<Object>();
        }

        @Override
        public String getName() {
            return NbBundle.getMessage(PartitionBuilder.class, "PartitionBuilder.name") + " (" + this.column.getTitle() + ")";
        }

        public boolean evaluate(Graph graph, Node node) {
            Object value = this.partition.getValue(node, graph);
            if (value == null) {
                return this.parts.contains(NULL);
            }
            return this.parts.contains(value);
        }

        public boolean evaluate(Graph graph, Edge edge) {
            Object value = this.partition.getValue(edge, graph);
            if (value == null) {
                return this.parts.contains(NULL);
            }
            return this.parts.contains(value);
        }

        public void finish() {
        }

        public void addPart(Object value) {
            if (value == null) {
                if (this.parts.add(NULL)) {
                    this.getProperties()[1].setValue(this.parts);
                }
            } else if (this.parts.add(value)) {
                this.getProperties()[1].setValue(this.parts);
            }
        }

        public void removePart(Object value) {
            if (value == null) {
                if (this.parts.remove(NULL)) {
                    this.getProperties()[1].setValue(this.parts);
                }
            } else if (this.parts.remove(value)) {
                this.getProperties()[1].setValue(this.parts);
            }
        }

        public void unselectAll() {
            this.getProperties()[1].setValue(new HashSet());
        }

        public void selectAll() {
            this.getProperties()[1].setValue(new HashSet(this.partition.getValues()));
        }

        @Override
        public FilterProperty[] getProperties() {
            if (this.filterProperties == null) {
                this.filterProperties = new FilterProperty[0];
                try {
                    this.filterProperties = new FilterProperty[]{FilterProperty.createProperty(this, Column.class, "column"), FilterProperty.createProperty(this, Set.class, "parts")};
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
            return this.filterProperties;
        }

        public Partition getPartition() {
            return this.partition;
        }

        public Set<Object> getParts() {
            return this.parts;
        }

        public Column getColumn() {
            return this.column;
        }

        public void setColumn(Column column) {
        }

        public void setParts(Set<Object> parts) {
            this.parts = parts;
        }
    }

    public static class EdgePartitionFilter
    extends PartitionFilter
    implements EdgeFilter {
        public EdgePartitionFilter(Column column, AppearanceModel model) {
            super(column, model);
        }

        @Override
        public boolean init(Graph graph) {
            this.partition = this.appearanceModel.getEdgePartition(graph.getModel().getGraph(), this.column);
            return this.partition != null;
        }
    }

    public static class NodePartitionFilter
    extends PartitionFilter
    implements NodeFilter {
        public NodePartitionFilter(Column column, AppearanceModel model) {
            super(column, model);
        }

        @Override
        public boolean init(Graph graph) {
            this.partition = this.appearanceModel.getNodePartition(graph.getModel().getGraph(), this.column);
            return this.partition != null;
        }
    }

    private static class PartitionFilterBuilder
    implements FilterBuilder {
        private final Column column;
        private final AppearanceModel model;

        public PartitionFilterBuilder(Column column, AppearanceModel model) {
            this.column = column;
            this.model = model;
        }

        @Override
        public Category getCategory() {
            return PARTITION;
        }

        @Override
        public String getName() {
            return this.column.getTitle() + " (" + (AttributeUtils.isNodeColumn(this.column) ? NbBundle.getMessage(PartitionFilterBuilder.class, "PartitionFilterBuilder.name.node") : NbBundle.getMessage(PartitionFilterBuilder.class, "PartitionFilterBuilder.name.edge")) + ")";
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(PartitionBuilder.class, "PartitionBuilder.description");
        }

        @Override
        public PartitionFilter getFilter(Workspace workspace) {
            if (AttributeUtils.isNodeColumn(this.column)) {
                return new NodePartitionFilter(this.column, this.model);
            }
            return new EdgePartitionFilter(this.column, this.model);
        }

        @Override
        public JPanel getPanel(Filter filter) {
            PartitionUI ui = Lookup.getDefault().lookup(PartitionUI.class);
            if (ui != null) {
                return ui.getPanel((PartitionFilter)filter);
            }
            return null;
        }

        @Override
        public void destroy(Filter filter) {
        }
    }
}

