/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.partition;

import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JPanel;
import org.gephi.appearance.api.AppearanceController;
import org.gephi.appearance.api.AppearanceModel;
import org.gephi.appearance.api.Partition;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.api.Range;
import org.gephi.filters.plugin.AbstractAttributeFilter;
import org.gephi.filters.plugin.AbstractAttributeFilterBuilder;
import org.gephi.filters.plugin.graph.RangeUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.CategoryBuilder;
import org.gephi.filters.spi.EdgeFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.filters.spi.NodeFilter;
import org.gephi.filters.spi.RangeFilter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PartitionCountBuilder
implements CategoryBuilder {
    private static final Category PARTITION_COUNT = new Category(NbBundle.getMessage(PartitionCountBuilder.class, "PartitionCountBuilder.name"), null, FilterLibrary.ATTRIBUTES);

    @Override
    public Category getCategory() {
        return PARTITION_COUNT;
    }

    @Override
    public FilterBuilder[] getBuilders(Workspace workspace) {
        PartitionCountFilterBuilder builder;
        ArrayList<PartitionCountFilterBuilder> builders = new ArrayList<PartitionCountFilterBuilder>();
        GraphModel gm = Lookup.getDefault().lookup(GraphController.class).getGraphModel(workspace);
        Graph graph = gm.getGraph();
        AppearanceModel am = Lookup.getDefault().lookup(AppearanceController.class).getModel(workspace);
        am.getNodeFunctions(graph);
        for (Column nodeCol : gm.getNodeTable()) {
            if (nodeCol.isProperty() || am.getNodePartition(graph, nodeCol) == null) continue;
            builder = new PartitionCountFilterBuilder(nodeCol, am);
            builders.add(builder);
        }
        for (Column edgeCol : gm.getEdgeTable()) {
            if (edgeCol.isProperty() || am.getEdgePartition(graph, edgeCol) == null) continue;
            builder = new PartitionCountFilterBuilder(edgeCol, am);
            builders.add(builder);
        }
        return builders.toArray(new FilterBuilder[0]);
    }

    public static abstract class PartitionCountFilter<K extends Element>
    extends AbstractAttributeFilter<K>
    implements RangeFilter {
        protected AppearanceModel appearanceModel;
        private Range range;
        protected Partition partition;

        public PartitionCountFilter(Column column, AppearanceModel model) {
            super(NbBundle.getMessage(PartitionCountBuilder.class, "PartitionCountBuilder.name"), column);
            this.column = column;
            this.appearanceModel = model;
            this.addProperty(Range.class, "range");
        }

        @Override
        public boolean evaluate(Graph graph, Element element) {
            Object p = this.partition.getValue(element, graph);
            int partCount = this.partition.count(p);
            return this.range.isInRange(partCount);
        }

        @Override
        public void finish() {
        }

        @Override
        public Number[] getValues(Graph graph) {
            if (this.init(graph)) {
                Collection vals = this.partition.getValues();
                Number[] values = new Integer[vals.size()];
                int i = 0;
                for (Object v : vals) {
                    values[i++] = this.partition.count(v);
                }
                return values;
            }
            return new Integer[0];
        }

        @Override
        public FilterProperty getRangeProperty() {
            return this.getProperties()[1];
        }

        public Range getRange() {
            return this.range;
        }

        public void setRange(Range range) {
            this.range = range;
        }

        public static class Edge
        extends PartitionCountFilter<org.gephi.graph.api.Edge>
        implements EdgeFilter {
            public Edge(Column column, AppearanceModel model) {
                super(column, model);
            }

            @Override
            public boolean init(Graph graph) {
                this.partition = this.appearanceModel.getEdgePartition(graph.getModel().getGraph(), this.column);
                return this.partition != null;
            }
        }

        public static class Node
        extends PartitionCountFilter<org.gephi.graph.api.Node>
        implements NodeFilter {
            public Node(Column column, AppearanceModel model) {
                super(column, model);
            }

            @Override
            public boolean init(Graph graph) {
                this.partition = this.appearanceModel.getNodePartition(graph.getModel().getGraph(), this.column);
                return this.partition != null;
            }
        }
    }

    private static class PartitionCountFilterBuilder
    extends AbstractAttributeFilterBuilder {
        private final AppearanceModel model;

        public PartitionCountFilterBuilder(Column column, AppearanceModel model) {
            super(column, PARTITION_COUNT, NbBundle.getMessage(PartitionCountBuilder.class, "PartitionCountBuilder.description"), null);
            this.model = model;
        }

        @Override
        public PartitionCountFilter getFilter(Workspace workspace) {
            if (AttributeUtils.isNodeColumn(this.column)) {
                return new PartitionCountFilter.Node(this.column, this.model);
            }
            return new PartitionCountFilter.Edge(this.column, this.model);
        }

        @Override
        public JPanel getPanel(Filter filter) {
            RangeUI ui = Lookup.getDefault().lookup(RangeUI.class);
            if (ui != null) {
                return ui.getPanel((PartitionCountFilter)filter);
            }
            return null;
        }
    }
}

