/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.gephi.graph.LegacyMapHelper;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.types.IntervalBooleanMap;
import org.gephi.graph.api.types.IntervalByteMap;
import org.gephi.graph.api.types.IntervalCharMap;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.IntervalFloatMap;
import org.gephi.graph.api.types.IntervalIntegerMap;
import org.gephi.graph.api.types.IntervalLongMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.IntervalShortMap;
import org.gephi.graph.api.types.IntervalStringMap;
import org.gephi.project.api.Workspace;
import org.gephi.project.spi.WorkspaceXMLPersistenceProvider;

public class LegacyAttributePersistenceProvider
implements WorkspaceXMLPersistenceProvider {
    private static final String ELEMENT_MODEL = "attributemodel";
    private static final String ELEMENT_TABLE = "table";
    private static final String ELEMENT_COLUMN = "column";
    private static final String ELEMENT_COLUMN_INDEX = "index";
    private static final String ELEMENT_COLUMN_ID = "id";
    private static final String ELEMENT_COLUMN_TITLE = "title";
    private static final String ELEMENT_COLUMN_TYPE = "type";
    private static final String ELEMENT_COLUMN_DEFAULT = "default";

    @Override
    public void writeXML(XMLStreamWriter writer, Workspace workspace) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void readXML(XMLStreamReader reader, Workspace workspace) {
        GraphModel model = LegacyMapHelper.getGraphModel(workspace);
        LegacyMapHelper helper = LegacyMapHelper.get(workspace);
        try {
            this.readModel(reader, model, helper);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getIdentifier() {
        return ELEMENT_MODEL;
    }

    public void readModel(XMLStreamReader reader, GraphModel graphModel, LegacyMapHelper mapHelper) throws XMLStreamException {
        boolean end = false;
        block4: while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!ELEMENT_TABLE.equalsIgnoreCase(name)) break;
                    Table table = null;
                    if (Boolean.parseBoolean(reader.getAttributeValue(null, "nodetable"))) {
                        table = graphModel.getNodeTable();
                    } else if (Boolean.parseBoolean(reader.getAttributeValue(null, "edgetable"))) {
                        table = graphModel.getEdgeTable();
                    }
                    if (table == null) continue block4;
                    this.readTable(reader, table, mapHelper);
                    break;
                }
                case 2: {
                    if (!ELEMENT_MODEL.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    public void readTable(XMLStreamReader reader, Table table, LegacyMapHelper mapHelper) throws XMLStreamException {
        boolean end = false;
        while (reader.hasNext() && !end) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    String name = reader.getLocalName();
                    if (!ELEMENT_COLUMN.equalsIgnoreCase(name)) break;
                    this.readColumn(reader, table, mapHelper);
                    break;
                }
                case 2: {
                    if (!ELEMENT_TABLE.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
    }

    public void readColumn(XMLStreamReader reader, Table table, LegacyMapHelper mapHelper) throws XMLStreamException {
        int index = 0;
        String id = "";
        String title = "";
        Class type = null;
        String defaultValue = "";
        boolean end = false;
        String name = null;
        block7: while (reader.hasNext() && !end) {
            int t = reader.next();
            switch (t) {
                case 1: {
                    name = reader.getLocalName();
                    break;
                }
                case 4: {
                    if (reader.isWhiteSpace()) break;
                    if (ELEMENT_COLUMN_INDEX.equalsIgnoreCase(name)) {
                        index = Integer.parseInt(reader.getText());
                        break;
                    }
                    if (ELEMENT_COLUMN_ID.equalsIgnoreCase(name)) {
                        id = id + reader.getText();
                        break;
                    }
                    if (ELEMENT_COLUMN_TITLE.equalsIgnoreCase(name)) {
                        title = title + reader.getText();
                        break;
                    }
                    if (ELEMENT_COLUMN_TYPE.equalsIgnoreCase(name)) {
                        String typeText = reader.getText();
                        if (typeText.equalsIgnoreCase("byte")) {
                            type = Byte.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("short")) {
                            type = Short.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("int")) {
                            type = Integer.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("long")) {
                            type = Long.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("float")) {
                            type = Float.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("double")) {
                            type = Double.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("boolean")) {
                            type = Boolean.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("char")) {
                            type = Character.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("string")) {
                            type = String.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("biginteger")) {
                            type = BigInteger.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("bigdecimal")) {
                            type = BigDecimal.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("dynamic_byte")) {
                            type = IntervalByteMap.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("dynamic_short")) {
                            type = IntervalShortMap.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("dynamic_int")) {
                            type = IntervalIntegerMap.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("dynamic_long")) {
                            type = IntervalLongMap.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("dynamic_float")) {
                            type = IntervalFloatMap.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("dynamic_double")) {
                            type = IntervalDoubleMap.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("dynamic_boolean")) {
                            type = IntervalBooleanMap.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("dynamic_char")) {
                            type = IntervalCharMap.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("dynamic_string")) {
                            type = IntervalStringMap.class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("dynamic_biginteger") || typeText.equalsIgnoreCase("dynamic_bigdecimal")) break;
                        if (typeText.equalsIgnoreCase("list_byte")) {
                            type = byte[].class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("list_short")) {
                            type = short[].class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("list_integer")) {
                            type = int[].class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("list_long")) {
                            type = long[].class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("list_float")) {
                            type = float[].class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("list_double")) {
                            type = double[].class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("list_boolean")) {
                            type = boolean[].class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("list_character")) {
                            type = char[].class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("list_string")) {
                            type = String[].class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("list_biginteger")) {
                            type = BigInteger[].class;
                            break;
                        }
                        if (typeText.equalsIgnoreCase("list_bigdecimal")) {
                            type = BigDecimal[].class;
                            break;
                        }
                        if (!typeText.equalsIgnoreCase("time_interval")) continue block7;
                        type = IntervalSet.class;
                        break;
                    }
                    if (!ELEMENT_COLUMN_DEFAULT.equalsIgnoreCase(name) || reader.getText().isEmpty()) break;
                    defaultValue = defaultValue + reader.getText();
                    break;
                }
                case 2: {
                    if (!ELEMENT_COLUMN.equalsIgnoreCase(reader.getLocalName())) break;
                    end = true;
                }
            }
        }
        if (type != null && type.equals(IntervalSet.class)) {
            id = "timeset";
        }
        if (type != null) {
            if (!table.hasColumn(id)) {
                Object defaultVal = null;
                try {
                    defaultVal = !defaultValue.isEmpty() ? AttributeUtils.parse(defaultValue, type) : null;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                table.addColumn(id, title, type, Origin.DATA, defaultVal, true);
            }
            if (table.getElementClass().equals(Node.class)) {
                mapHelper.nodeIndexToIds.put(index, id);
            } else {
                mapHelper.edgeIndexToIds.put(index, id);
            }
        }
    }
}

