/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Collections;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphDiff;
import org.gephi.graph.api.GraphObserver;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphVersion;
import org.gephi.graph.impl.NodeImpl;

public class GraphObserverImpl
implements GraphObserver {
    protected final GraphStore graphStore;
    protected final Graph graph;
    protected final GraphVersion graphVersion;
    protected final boolean withDiff;
    protected int nodeVersion = Integer.MIN_VALUE;
    protected int edgeVersion = Integer.MIN_VALUE;
    protected boolean destroyed;
    protected boolean newObserver = true;
    protected GraphDiffImpl graphDiff;
    protected NodeImpl[] nodeCache;
    protected EdgeImpl[] edgeCache;

    public GraphObserverImpl(GraphStore store, GraphVersion graphVersion, Graph graph, boolean withDiff) {
        this.graphStore = store;
        this.graphVersion = graphVersion;
        this.graph = graph;
        this.withDiff = withDiff;
        if (withDiff) {
            this.readLock();
            this.initCache();
            this.readUnlock();
        }
        this.nodeVersion = graphVersion.nodeVersion;
        this.edgeVersion = graphVersion.edgeVersion;
    }

    @Override
    public boolean hasGraphChanged() {
        if (!this.destroyed) {
            this.readLock();
            try {
                if (this.nodeVersion < this.graphVersion.nodeVersion || this.edgeVersion < this.graphVersion.edgeVersion) {
                    if (this.withDiff) {
                        this.refreshDiff();
                    }
                    this.nodeVersion = this.graphVersion.nodeVersion;
                    this.edgeVersion = this.graphVersion.edgeVersion;
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                this.readUnlock();
                this.newObserver = false;
            }
        }
        return false;
    }

    @Override
    public GraphDiff getDiff() {
        if (!this.withDiff) {
            throw new RuntimeException("This observer doesn't compute diffs, set diff setting to true");
        }
        if (this.graphDiff == null) {
            throw new IllegalStateException("The hasGraphChanged() method should be called first and getDiff() only once then");
        }
        GraphDiffImpl diff = this.graphDiff;
        this.graphDiff = null;
        return diff;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    private void initCache() {
        int maxNodeStoreId = this.graphStore.nodeStore.maxStoreId();
        this.nodeCache = new NodeImpl[maxNodeStoreId];
        for (Node n : this.graph.getNodes()) {
            NodeImpl nImpl;
            this.nodeCache[nImpl.storeId] = nImpl = (NodeImpl)n;
        }
        int maxEdgeStoreId = this.graphStore.edgeStore.maxStoreId();
        this.edgeCache = new EdgeImpl[maxEdgeStoreId];
        for (Edge e : this.graph.getEdges()) {
            EdgeImpl eImpl;
            this.edgeCache[eImpl.storeId] = eImpl = (EdgeImpl)e;
        }
    }

    protected void refreshDiff() {
        Object newCache;
        int maxStoreId;
        this.graphDiff = new GraphDiffImpl();
        if (this.nodeVersion < this.graphVersion.nodeVersion) {
            maxStoreId = this.graphStore.nodeStore.maxStoreId();
            for (NodeImpl n : this.nodeCache) {
                NodeImpl nImpl = n;
                if (nImpl == null || this.graph.contains(nImpl)) continue;
                this.graphDiff.removedNodes.add(nImpl);
            }
            if (maxStoreId > this.nodeCache.length || maxStoreId < this.nodeCache.length) {
                newCache = new NodeImpl[maxStoreId];
                System.arraycopy(this.nodeCache, 0, newCache, 0, maxStoreId > this.nodeCache.length ? this.nodeCache.length : maxStoreId);
                this.nodeCache = newCache;
            }
            for (Node n : this.graph.getNodes()) {
                NodeImpl nImpl = (NodeImpl)n;
                int storeId = nImpl.storeId;
                NodeImpl cachedNode = this.nodeCache[storeId];
                if (cachedNode != null && cachedNode == nImpl) continue;
                this.graphDiff.addedNodes.add(nImpl);
                this.nodeCache[storeId] = nImpl;
            }
        }
        if (this.edgeVersion < this.graphVersion.edgeVersion) {
            maxStoreId = this.graphStore.edgeStore.maxStoreId();
            for (EdgeImpl e : this.edgeCache) {
                EdgeImpl eImpl = e;
                if (eImpl == null || this.graph.contains(eImpl)) continue;
                this.graphDiff.removedEdges.add(eImpl);
            }
            if (maxStoreId > this.edgeCache.length || maxStoreId < this.edgeCache.length) {
                newCache = new EdgeImpl[maxStoreId];
                System.arraycopy(this.edgeCache, 0, newCache, 0, maxStoreId > this.edgeCache.length ? this.edgeCache.length : maxStoreId);
                this.edgeCache = newCache;
            }
            for (Edge e : this.graph.getEdges()) {
                EdgeImpl eImpl = (EdgeImpl)e;
                int storeId = eImpl.storeId;
                EdgeImpl cachedEdge = this.edgeCache[storeId];
                if (cachedEdge != null && cachedEdge == eImpl) continue;
                this.graphDiff.addedEdges.add(eImpl);
                this.edgeCache[storeId] = eImpl;
            }
        }
    }

    protected void resetNodeVersion() {
        this.nodeVersion = Integer.MIN_VALUE;
    }

    protected void resetEdgeVersion() {
        this.edgeVersion = Integer.MIN_VALUE;
    }

    @Override
    public void destroy() {
        this.checkNotDestroyed();
        this.graphStore.graphModel.destroyGraphObserver(this);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isNew() {
        return !this.destroyed && this.newObserver;
    }

    public void destroyObserver() {
        this.checkNotDestroyed();
        this.nodeCache = null;
        this.edgeCache = null;
        this.destroyed = true;
    }

    private void checkNotDestroyed() {
        if (this.destroyed) {
            throw new RuntimeException("This observer has already been destroyed");
        }
    }

    private void readLock() {
        this.graphStore.autoReadLock();
    }

    private void readUnlock() {
        this.graphStore.autoReadUnlock();
    }

    protected final class GraphDiffImpl
    implements GraphDiff {
        protected final ObjectList<Node> addedNodes = new ObjectArrayList<Node>();
        protected final ObjectList<Node> removedNodes = new ObjectArrayList<Node>();
        protected final ObjectList<Edge> addedEdges = new ObjectArrayList<Edge>();
        protected final ObjectList<Edge> removedEdges = new ObjectArrayList<Edge>();

        @Override
        public NodeIterable getAddedNodes() {
            if (!this.addedNodes.isEmpty()) {
                return GraphObserverImpl.this.graphStore.getNodeIterableWrapper(Collections.unmodifiableList(this.addedNodes).iterator(), false);
            }
            return NodeIterable.EMPTY;
        }

        @Override
        public NodeIterable getRemovedNodes() {
            if (!this.removedNodes.isEmpty()) {
                return GraphObserverImpl.this.graphStore.getNodeIterableWrapper(Collections.unmodifiableList(this.removedNodes).iterator(), false);
            }
            return NodeIterable.EMPTY;
        }

        @Override
        public EdgeIterable getAddedEdges() {
            if (!this.addedEdges.isEmpty()) {
                return GraphObserverImpl.this.graphStore.getEdgeIterableWrapper(Collections.unmodifiableList(this.addedEdges).iterator(), false);
            }
            return EdgeIterable.EMPTY;
        }

        @Override
        public EdgeIterable getRemovedEdges() {
            if (!this.removedEdges.isEmpty()) {
                return GraphObserverImpl.this.graphStore.getEdgeIterableWrapper(Collections.unmodifiableList(this.removedEdges).iterator(), false);
            }
            return EdgeIterable.EMPTY;
        }
    }
}

