/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.bytes.ByteArrays;
import it.unimi.dsi.fastutil.chars.Char2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.chars.CharArrays;
import it.unimi.dsi.fastutil.doubles.Double2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.doubles.DoubleArrays;
import it.unimi.dsi.fastutil.floats.Float2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.floats.FloatArrays;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.objects.Object2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.shorts.Short2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Index;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.TableLock;

public class IndexImpl<T extends Element>
implements Index<T> {
    protected final TableLock lock;
    protected final ColumnStore<T> columnStore;
    protected AbstractIndex[] columns;
    protected int columnsCount;

    public IndexImpl(ColumnStore<T> columnStore) {
        this.columnStore = columnStore;
        this.columns = new AbstractIndex[0];
        this.lock = columnStore.lock;
    }

    @Override
    public Class<T> getIndexClass() {
        return this.columnStore.elementType;
    }

    @Override
    public String getIndexName() {
        return "index_" + this.columnStore.elementType.getCanonicalName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(Column column, Object value) {
        this.checkNonNullColumnObject(column);
        this.lock();
        try {
            AbstractIndex index = this.getIndex((ColumnImpl)column);
            int n = index.getCount(value);
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public int count(String key, Object value) {
        this.checkNonNullObject(key);
        AbstractIndex index = this.getIndex(key);
        return index.getCount(value);
    }

    public Iterable<T> get(String key, Object value) {
        this.checkNonNullObject(key);
        AbstractIndex index = this.getIndex(key);
        return index.getValueSet(value);
    }

    @Override
    public Iterable<T> get(Column column, Object value) {
        this.checkNonNullColumnObject(column);
        if (this.lock != null) {
            this.lock.lock();
            AbstractIndex index = this.getIndex((ColumnImpl)column);
            Set valueSet = index.getValueSet(value);
            return valueSet == null ? null : new LockableIterable(index.getValueSet(value));
        }
        AbstractIndex index = this.getIndex((ColumnImpl)column);
        return index.getValueSet(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSortable(Column column) {
        this.checkNonNullColumnObject(column);
        this.lock();
        try {
            AbstractIndex index = this.getIndex((ColumnImpl)column);
            boolean bl = index.isSortable();
            return bl;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Number getMinValue(Column column) {
        this.checkNonNullColumnObject(column);
        this.lock();
        try {
            AbstractIndex index = this.getIndex((ColumnImpl)column);
            Number number = index.getMinValue();
            return number;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Number getMaxValue(Column column) {
        this.checkNonNullColumnObject(column);
        this.lock();
        try {
            AbstractIndex index = this.getIndex((ColumnImpl)column);
            Number number = index.getMaxValue();
            return number;
        }
        finally {
            this.unlock();
        }
    }

    public Iterable<Map.Entry<Object, Set<T>>> get(Column column) {
        this.checkNonNullColumnObject(column);
        AbstractIndex index = this.getIndex((ColumnImpl)column);
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection values(Column column) {
        this.checkNonNullColumnObject(column);
        this.lock();
        try {
            AbstractIndex index = this.getIndex((ColumnImpl)column);
            ArrayList arrayList = new ArrayList(index.values());
            return arrayList;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countValues(Column column) {
        this.checkNonNullColumnObject(column);
        this.lock();
        try {
            AbstractIndex index = this.getIndex((ColumnImpl)column);
            int n = index.countValues();
            return n;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countElements(Column column) {
        this.checkNonNullColumnObject(column);
        this.lock();
        try {
            AbstractIndex index = this.getIndex((ColumnImpl)column);
            int n = index.elements;
            return n;
        }
        finally {
            this.unlock();
        }
    }

    public Object put(String key, Object value, T element) {
        this.checkNonNullObject(key);
        AbstractIndex index = this.getIndex(key);
        return index.putValue(element, value);
    }

    public Object put(Column column, Object value, T element) {
        this.checkNonNullColumnObject(column);
        AbstractIndex index = this.getIndex((ColumnImpl)column);
        return index.putValue(element, value);
    }

    public void remove(String key, Object value, T element) {
        this.checkNonNullObject(key);
        AbstractIndex index = this.getIndex(key);
        index.removeValue(element, value);
    }

    public void remove(Column column, Object value, T element) {
        this.checkNonNullColumnObject(column);
        AbstractIndex index = this.getIndex((ColumnImpl)column);
        index.removeValue(element, value);
    }

    public Object set(String key, Object oldValue, Object value, T element) {
        this.checkNonNullObject(key);
        AbstractIndex index = this.getIndex(key);
        return index.replaceValue(element, oldValue, value);
    }

    public Object set(Column column, Object oldValue, Object value, T element) {
        this.checkNonNullColumnObject(column);
        AbstractIndex index = this.getIndex((ColumnImpl)column);
        return index.replaceValue(element, oldValue, value);
    }

    public void clear() {
        for (AbstractIndex ai : this.columns) {
            if (ai == null) continue;
            ai.clear();
        }
    }

    protected void addColumn(ColumnImpl col) {
        if (col.isIndexed()) {
            AbstractIndex index;
            this.ensureColumnSize(col.storeId);
            this.columns[col.storeId] = index = this.createIndex(col);
            ++this.columnsCount;
        }
    }

    protected void addAllColumns(ColumnImpl[] cols) {
        this.ensureColumnSize(cols.length);
        for (ColumnImpl col : cols) {
            AbstractIndex index;
            if (!col.isIndexed()) continue;
            this.columns[col.storeId] = index = this.createIndex(col);
            ++this.columnsCount;
        }
    }

    protected void removeColumn(ColumnImpl col) {
        if (col.isIndexed()) {
            AbstractIndex index = this.columns[col.storeId];
            index.destroy();
            this.columns[col.storeId] = null;
            --this.columnsCount;
        }
    }

    protected boolean hasColumn(ColumnImpl col) {
        int id;
        return col.isIndexed() && (id = col.storeId) != -1 && this.columns.length > id && this.columns[id].column == col;
    }

    protected AbstractIndex getIndex(ColumnImpl col) {
        AbstractIndex index;
        int id;
        if (col.isIndexed() && (id = col.storeId) != -1 && this.columns.length > id && (index = this.columns[id]) != null && index.column == col) {
            return index;
        }
        return null;
    }

    protected AbstractIndex getIndex(String key) {
        int id = this.columnStore.getColumnIndex(key);
        if (id != -1 && this.columns.length > id) {
            return this.columns[id];
        }
        return null;
    }

    protected void destroy() {
        for (AbstractIndex ai : this.columns) {
            if (ai == null) continue;
            ai.destroy();
        }
        this.columns = new AbstractIndex[0];
        this.columnsCount = 0;
    }

    protected int size() {
        return this.columnsCount;
    }

    AbstractIndex createIndex(ColumnImpl column) {
        if (column.getTypeClass().equals(Byte.class)) {
            return new ByteIndex(column);
        }
        if (column.getTypeClass().equals(Short.class)) {
            return new ShortIndex(column);
        }
        if (column.getTypeClass().equals(Integer.class)) {
            return new IntegerIndex(column);
        }
        if (column.getTypeClass().equals(Long.class)) {
            return new LongIndex(column);
        }
        if (column.getTypeClass().equals(Float.class)) {
            return new FloatIndex(column);
        }
        if (column.getTypeClass().equals(Double.class)) {
            return new DoubleIndex(column);
        }
        if (Number.class.isAssignableFrom(column.getTypeClass())) {
            return new GenericNumberIndex(column);
        }
        if (column.getTypeClass().equals(Boolean.class)) {
            return new BooleanIndex(column);
        }
        if (column.getTypeClass().equals(Character.class)) {
            return new CharIndex(column);
        }
        if (column.getTypeClass().equals(String.class)) {
            return new DefaultIndex(column);
        }
        if (column.getTypeClass().equals(byte[].class)) {
            return new ByteArrayIndex(column);
        }
        if (column.getTypeClass().equals(short[].class)) {
            return new ShortArrayIndex(column);
        }
        if (column.getTypeClass().equals(int[].class)) {
            return new IntegerArrayIndex(column);
        }
        if (column.getTypeClass().equals(long[].class)) {
            return new LongArrayIndex(column);
        }
        if (column.getTypeClass().equals(float[].class)) {
            return new FloatArrayIndex(column);
        }
        if (column.getTypeClass().equals(double[].class)) {
            return new DoubleArrayIndex(column);
        }
        if (column.getTypeClass().equals(boolean[].class)) {
            return new BooleanArrayIndex(column);
        }
        if (column.getTypeClass().equals(char[].class)) {
            return new CharArrayIndex(column);
        }
        if (column.getTypeClass().equals(String[].class)) {
            return new DefaultArrayIndex(column);
        }
        if (column.getTypeClass().isArray()) {
            return new DefaultArrayIndex(column);
        }
        return new DefaultIndex(column);
    }

    private void ensureColumnSize(int index) {
        if (index >= this.columns.length) {
            AbstractIndex[] newArray = new AbstractIndex[index + 1];
            System.arraycopy(this.columns, 0, newArray, 0, this.columns.length);
            this.columns = newArray;
        }
    }

    void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }

    void checkNonNullObject(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    void checkNonNullColumnObject(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof ColumnImpl)) {
            throw new ClassCastException("Must be ColumnImpl object");
        }
    }

    private class LockableIterator<T>
    implements Iterator<T> {
        private final Iterator<T> itr;

        public LockableIterator(Iterator<T> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            boolean n = this.itr.hasNext();
            if (!n) {
                IndexImpl.this.lock.unlock();
            }
            return n;
        }

        @Override
        public T next() {
            return this.itr.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private class LockableIterable<T>
    implements Iterable<T> {
        private final Iterable<T> ite;

        public LockableIterable(Iterable<T> ite) {
            this.ite = ite;
        }

        @Override
        public Iterator<T> iterator() {
            return new LockableIterator<T>(this.ite.iterator());
        }
    }

    protected class CharArrayIndex
    extends AbstractIndex<char[]> {
        public CharArrayIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(CharArrays.HASH_STRATEGY);
        }
    }

    protected class ByteArrayIndex
    extends AbstractIndex<byte[]> {
        public ByteArrayIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(ByteArrays.HASH_STRATEGY);
        }
    }

    protected class ShortArrayIndex
    extends AbstractIndex<short[]> {
        public ShortArrayIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(ShortArrays.HASH_STRATEGY);
        }
    }

    protected class LongArrayIndex
    extends AbstractIndex<long[]> {
        public LongArrayIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(LongArrays.HASH_STRATEGY);
        }
    }

    protected class FloatArrayIndex
    extends AbstractIndex<float[]> {
        public FloatArrayIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(FloatArrays.HASH_STRATEGY);
        }
    }

    protected class IntegerArrayIndex
    extends AbstractIndex<int[]> {
        public IntegerArrayIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(IntArrays.HASH_STRATEGY);
        }
    }

    protected class DoubleArrayIndex
    extends AbstractIndex<double[]> {
        public DoubleArrayIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(DoubleArrays.HASH_STRATEGY);
        }
    }

    protected class BooleanArrayIndex
    extends AbstractIndex<boolean[]> {
        public BooleanArrayIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(BooleanArrays.HASH_STRATEGY);
        }
    }

    protected class DefaultArrayIndex
    extends AbstractIndex<Object[]> {
        public DefaultArrayIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenCustomHashMap(ObjectArrays.HASH_STRATEGY);
        }
    }

    protected class CharIndex
    extends AbstractIndex<Character> {
        public CharIndex(ColumnImpl column) {
            super(column);
            this.map = new Char2ObjectAVLTreeMap();
        }
    }

    protected class GenericNumberIndex
    extends AbstractIndex<Number> {
        public GenericNumberIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectAVLTreeMap();
        }
    }

    protected class ByteIndex
    extends AbstractIndex<Byte> {
        public ByteIndex(ColumnImpl column) {
            super(column);
            this.map = new Byte2ObjectAVLTreeMap();
        }
    }

    protected class ShortIndex
    extends AbstractIndex<Short> {
        public ShortIndex(ColumnImpl column) {
            super(column);
            this.map = new Short2ObjectAVLTreeMap();
        }
    }

    protected class LongIndex
    extends AbstractIndex<Long> {
        public LongIndex(ColumnImpl column) {
            super(column);
            this.map = new Long2ObjectAVLTreeMap();
        }
    }

    protected class FloatIndex
    extends AbstractIndex<Float> {
        public FloatIndex(ColumnImpl column) {
            super(column);
            this.map = new Float2ObjectAVLTreeMap();
        }
    }

    protected class IntegerIndex
    extends AbstractIndex<Integer> {
        public IntegerIndex(ColumnImpl column) {
            super(column);
            this.map = new Int2ObjectAVLTreeMap();
        }
    }

    protected class DoubleIndex
    extends AbstractIndex<Double> {
        public DoubleIndex(ColumnImpl column) {
            super(column);
            this.map = new Double2ObjectAVLTreeMap();
        }
    }

    protected class BooleanIndex
    extends AbstractIndex<Boolean> {
        public BooleanIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenHashMap();
        }
    }

    protected class DefaultIndex
    extends AbstractIndex<Object> {
        public DefaultIndex(ColumnImpl column) {
            super(column);
            this.map = new Object2ObjectOpenHashMap();
        }
    }

    private static final class ValueSet<K, T>
    implements Set<T> {
        private final K value;
        private final Set<T> set;

        public ValueSet(K value) {
            this.value = value;
            this.set = new ObjectOpenHashSet<T>();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        public Iterator<T> iterator() {
            return this.set.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        public <T> T[] toArray(T[] ts) {
            return this.set.toArray(ts);
        }

        @Override
        public boolean add(T e) {
            return this.set.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.set.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> clctn) {
            return this.set.containsAll(clctn);
        }

        @Override
        public boolean addAll(Collection<? extends T> clctn) {
            throw new UnsupportedOperationException("Not supported operation.");
        }

        @Override
        public boolean retainAll(Collection<?> clctn) {
            throw new UnsupportedOperationException("Not supported operation.");
        }

        @Override
        public boolean removeAll(Collection<?> clctn) {
            throw new UnsupportedOperationException("Not supported operation.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported operation.");
        }

        @Override
        public boolean equals(Object o) {
            return this.set.equals(o);
        }

        @Override
        public int hashCode() {
            return this.set.hashCode();
        }
    }

    protected abstract class AbstractIndex<K>
    implements Iterable<Map.Entry<K, Set<T>>> {
        public static final boolean TRIMMING_ENABLED = false;
        public static final int TRIMMING_FREQUENCY = 30;
        protected final ColumnImpl column;
        protected final Set<T> nullSet;
        protected Map<K, Set<T>> map;
        protected int elements;

        public AbstractIndex(ColumnImpl column) {
            this.column = column;
            this.nullSet = new ObjectOpenHashSet();
        }

        public Object putValue(T element, Object value) {
            if (value == null) {
                if (this.nullSet.add(element)) {
                    ++this.elements;
                }
            } else {
                Set set = this.getValueSet(value);
                if (set == null) {
                    set = this.addValue(value);
                }
                value = ((ValueSet)set).value;
                if (set.add(element)) {
                    ++this.elements;
                }
            }
            return value;
        }

        public void removeValue(T element, Object value) {
            if (value == null) {
                if (this.nullSet.remove(element)) {
                    --this.elements;
                }
            } else {
                Set set = this.getValueSet(value);
                if (set.remove(element)) {
                    --this.elements;
                }
                if (set.isEmpty()) {
                    this.removeValue(value);
                }
            }
        }

        public Object replaceValue(T element, K oldValue, K newValue) {
            this.removeValue(element, oldValue);
            return this.putValue(element, newValue);
        }

        public int getCount(K value) {
            if (value == null) {
                return this.nullSet.size();
            }
            Set valueSet = this.getValueSet(value);
            if (valueSet != null) {
                return valueSet.size();
            }
            return 0;
        }

        public Collection values() {
            return new WithNullDecorator();
        }

        public int countValues() {
            return (this.nullSet.isEmpty() ? 0 : 1) + this.map.size();
        }

        public Number getMinValue() {
            if (this.isSortable()) {
                if (this.map.isEmpty()) {
                    return null;
                }
                return (Number)((SortedMap)this.map).firstKey();
            }
            throw new UnsupportedOperationException("'" + this.column.getId() + "' is not a sortable column (" + this.column.getTypeClass().getSimpleName() + ").");
        }

        public Number getMaxValue() {
            if (this.isSortable()) {
                if (this.map.isEmpty()) {
                    return null;
                }
                return (Number)((SortedMap)this.map).lastKey();
            }
            throw new UnsupportedOperationException("'" + this.column.getId() + "' is not a sortable column (" + this.column.getTypeClass().getSimpleName() + ").");
        }

        protected void destroy() {
            this.map = null;
            this.nullSet.clear();
            this.elements = 0;
        }

        protected void clear() {
            this.map.clear();
            this.nullSet.clear();
            this.elements = 0;
        }

        @Override
        public Iterator<Map.Entry<K, Set<T>>> iterator() {
            return new EntryIterator();
        }

        protected Set<T> getValueSet(K value) {
            if (value == null) {
                return this.nullSet;
            }
            return this.map.get(value);
        }

        protected void removeValue(K value) {
            this.map.remove(value);
        }

        protected Set<T> addValue(K value) {
            ValueSet valueSet = new ValueSet(value);
            this.map.put(value, valueSet);
            return valueSet;
        }

        protected boolean isSortable() {
            return Number.class.isAssignableFrom(this.column.getTypeClass()) && this.map instanceof SortedMap;
        }

        private class NullEntry
        implements Map.Entry<K, Set<T>> {
            private NullEntry() {
            }

            @Override
            public K getKey() {
                return null;
            }

            @Override
            public Set<T> getValue() {
                return AbstractIndex.this.nullSet;
            }

            @Override
            public Set<T> setValue(Set<T> v) {
                throw new UnsupportedOperationException("Not supported operation.");
            }
        }

        private final class EntryIterator
        implements Iterator<Map.Entry<K, Set<T>>> {
            private final Iterator<Map.Entry<K, Set<T>>> mapIterator;
            private NullEntry nullEntry;

            public EntryIterator() {
                if (!AbstractIndex.this.nullSet.isEmpty()) {
                    this.nullEntry = new NullEntry();
                }
                this.mapIterator = AbstractIndex.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.nullEntry != null) {
                    return true;
                }
                return this.mapIterator.hasNext();
            }

            @Override
            public Map.Entry<K, Set<T>> next() {
                if (this.nullEntry != null) {
                    NullEntry ne = this.nullEntry;
                    this.nullEntry = null;
                    return ne;
                }
                return this.mapIterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported operation.");
            }
        }

        protected final class WithNullDecorator
        implements Collection<K> {
            protected WithNullDecorator() {
            }

            private boolean hasNull() {
                return !AbstractIndex.this.nullSet.isEmpty();
            }

            @Override
            public int size() {
                return (this.hasNull() ? 1 : 0) + AbstractIndex.this.map.size();
            }

            @Override
            public boolean isEmpty() {
                return !this.hasNull() && AbstractIndex.this.map.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (o == null && this.hasNull()) {
                    return true;
                }
                if (o != null) {
                    return AbstractIndex.this.map.containsKey(o);
                }
                return false;
            }

            @Override
            public Iterator iterator() {
                return new WithNullIterator();
            }

            @Override
            public Object[] toArray() {
                if (this.hasNull()) {
                    Object[] res = new Object[AbstractIndex.this.map.size() + 1];
                    res[0] = null;
                    System.arraycopy(AbstractIndex.this.map.keySet().toArray(), 0, res, 1, AbstractIndex.this.map.size());
                    return res;
                }
                return AbstractIndex.this.map.keySet().toArray();
            }

            @Override
            public Object[] toArray(Object[] array) {
                if (this.hasNull()) {
                    if (array.length < this.size()) {
                        array = (Object[])Array.newInstance(array.getClass().getComponentType(), AbstractIndex.this.map.size() + 1);
                    }
                    array[0] = null;
                    System.arraycopy(AbstractIndex.this.map.keySet().toArray(), 0, array, 1, AbstractIndex.this.map.size());
                    return array;
                }
                return AbstractIndex.this.map.keySet().toArray(array);
            }

            @Override
            public boolean add(Object e) {
                throw new UnsupportedOperationException("Not supported");
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException("Not supported");
            }

            @Override
            public boolean containsAll(Collection clctn) {
                for (Object o : clctn) {
                    if (o == null && AbstractIndex.this.nullSet.isEmpty()) {
                        return false;
                    }
                    if (o == null || AbstractIndex.this.map.containsKey(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean addAll(Collection clctn) {
                throw new UnsupportedOperationException("Not supported");
            }

            @Override
            public boolean removeAll(Collection clctn) {
                throw new UnsupportedOperationException("Not supported");
            }

            @Override
            public boolean retainAll(Collection clctn) {
                throw new UnsupportedOperationException("Not supported");
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException("Not supported");
            }

            private final class WithNullIterator
            implements Iterator<K> {
                private final Iterator<K> mapIterator;
                private boolean hasNull;

                public WithNullIterator() {
                    this.hasNull = WithNullDecorator.this.hasNull();
                    this.mapIterator = AbstractIndex.this.map.keySet().iterator();
                }

                @Override
                public boolean hasNext() {
                    if (this.hasNull) {
                        return true;
                    }
                    return this.mapIterator.hasNext();
                }

                @Override
                public K next() {
                    if (this.hasNull) {
                        this.hasNull = false;
                        return null;
                    }
                    return this.mapIterator.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Not supported operation.");
                }
            }
        }
    }
}

