/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Node;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.ElementImpl;
import org.gephi.graph.impl.GraphViewImpl;
import org.gephi.graph.impl.IndexImpl;
import org.gephi.graph.impl.TableLock;

public class IndexStore<T extends Element> {
    protected final ColumnStore<T> columnStore;
    protected final TableLock lock;
    protected final IndexImpl<T> mainIndex;
    protected final Map<GraphView, IndexImpl<T>> viewIndexes;

    public IndexStore(ColumnStore<T> columnStore) {
        this.columnStore = columnStore;
        this.mainIndex = new IndexImpl<T>(columnStore);
        this.viewIndexes = new Object2ObjectOpenHashMap<GraphView, IndexImpl<T>>();
        this.lock = columnStore.lock;
    }

    protected void addColumn(ColumnImpl col) {
        this.mainIndex.addColumn(col);
        for (IndexImpl<T> index : this.viewIndexes.values()) {
            index.addColumn(col);
        }
    }

    protected void removeColumn(ColumnImpl col) {
        this.mainIndex.removeColumn(col);
        for (IndexImpl<T> index : this.viewIndexes.values()) {
            index.removeColumn(col);
        }
    }

    protected boolean hasColumn(ColumnImpl col) {
        return this.mainIndex.hasColumn(col);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexImpl getIndex(Graph graph) {
        GraphView view = graph.getView();
        if (view.isMainView()) {
            return this.mainIndex;
        }
        this.lock();
        try {
            IndexImpl viewIndex = this.viewIndexes.get(graph.getView());
            if (viewIndex == null) {
                viewIndex = this.createViewIndex(graph);
            }
            IndexImpl indexImpl = viewIndex;
            return indexImpl;
        }
        finally {
            this.unlock();
        }
    }

    protected IndexImpl createViewIndex(Graph graph) {
        if (graph.getView().isMainView()) {
            throw new IllegalArgumentException("Can't create a view index for the main view");
        }
        IndexImpl<T> viewIndex = new IndexImpl<T>(this.columnStore);
        ColumnImpl[] columns = this.columnStore.toArray();
        viewIndex.addAllColumns(columns);
        this.viewIndexes.put(graph.getView(), viewIndex);
        this.indexView(graph);
        return viewIndex;
    }

    protected void deleteViewIndex(Graph graph) {
        if (graph.getView().isMainView()) {
            throw new IllegalArgumentException("Can't delete a view index for the main view");
        }
        this.lock();
        try {
            IndexImpl<T> index = this.viewIndexes.remove(graph.getView());
            if (index != null) {
                index.destroy();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(Column column, Object oldValue, Object value, T element) {
        this.lock();
        try {
            value = this.mainIndex.set(column, oldValue, (Object)value, element);
            if (!this.viewIndexes.isEmpty()) {
                for (Map.Entry<GraphView, IndexImpl<T>> entry : this.viewIndexes.entrySet()) {
                    GraphViewImpl graphView = (GraphViewImpl)entry.getKey();
                    DirectedSubgraph graph = graphView.getDirectedGraph();
                    boolean inView = element instanceof Node ? graph.contains((Node)element) : graph.contains((Edge)element);
                    if (!inView) continue;
                    entry.getValue().set(column, oldValue, value, element);
                }
            }
            Iterator<Map.Entry<GraphView, IndexImpl<T>>> iterator = value;
            return iterator;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(T element) {
        ElementImpl elementImpl = (ElementImpl)element;
        this.lock();
        try {
            int length = this.columnStore.length;
            ColumnImpl[] cols = this.columnStore.columns;
            for (int i = 0; i < length; ++i) {
                ColumnImpl c = cols[i];
                if (c == null || !c.isIndexed() || elementImpl.attributes.length <= c.getIndex()) continue;
                Object value = elementImpl.attributes[c.getIndex()];
                this.mainIndex.remove(c, value, element);
                for (Map.Entry<GraphView, IndexImpl<T>> entry : this.viewIndexes.entrySet()) {
                    GraphViewImpl graphView = (GraphViewImpl)entry.getKey();
                    DirectedSubgraph graph = graphView.getDirectedGraph();
                    boolean inView = element instanceof Node ? graph.contains((Node)element) : graph.contains((Edge)element);
                    if (!inView) continue;
                    entry.getValue().remove(c, value, element);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(T element) {
        ElementImpl elementImpl = (ElementImpl)element;
        this.lock();
        try {
            this.ensureAttributeArrayLength(elementImpl, this.columnStore.length);
            int length = this.columnStore.length;
            ColumnImpl[] cols = this.columnStore.columns;
            for (int i = 0; i < length; ++i) {
                ColumnImpl c = cols[i];
                if (c == null || !c.isIndexed()) continue;
                Object value = elementImpl.attributes[c.getIndex()];
                elementImpl.attributes[c.getIndex()] = value = this.mainIndex.put(c, value, element);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void indexView(Graph graph) {
        IndexImpl<ElementImpl> viewIndex = this.viewIndexes.get(graph.getView());
        if (viewIndex == null) return;
        graph.readLock();
        try {
            Iterator<Element> iterator = null;
            if (this.columnStore.elementType.equals(Node.class)) {
                iterator = graph.getNodes().iterator();
            } else if (this.columnStore.elementType.equals(Edge.class)) {
                iterator = graph.getEdges().iterator();
            }
            if (iterator == null) return;
            while (iterator.hasNext()) {
                ElementImpl element = (ElementImpl)iterator.next();
                this.ensureAttributeArrayLength(element, this.columnStore.length);
                ColumnImpl[] cols = this.columnStore.columns;
                ElementImpl elementImpl = element;
                synchronized (elementImpl) {
                    int length = this.columnStore.length;
                    for (int i = 0; i < length; ++i) {
                        ColumnImpl c = cols[i];
                        if (c == null || !c.isIndexed()) continue;
                        Object value = element.attributes[c.getIndex()];
                        viewIndex.put(c, value, element);
                    }
                }
            }
            return;
        }
        finally {
            graph.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexInView(T element, GraphView view) {
        ElementImpl elementImpl = (ElementImpl)element;
        this.lock();
        try {
            IndexImpl<T> index = this.viewIndexes.get(view);
            if (index != null) {
                int length = this.columnStore.length;
                ColumnImpl[] cols = this.columnStore.columns;
                for (int i = 0; i < length; ++i) {
                    ColumnImpl c = cols[i];
                    if (c == null || !c.isIndexed()) continue;
                    Object value = elementImpl.attributes[c.getIndex()];
                    index.put(c, value, element);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInView(T element, GraphView view) {
        ElementImpl elementImpl = (ElementImpl)element;
        this.lock();
        try {
            IndexImpl<T> index = this.viewIndexes.get(view);
            if (index != null) {
                int length = this.columnStore.length;
                ColumnImpl[] cols = this.columnStore.columns;
                for (int i = 0; i < length; ++i) {
                    ColumnImpl c = cols[i];
                    if (c == null || !c.isIndexed()) continue;
                    Object value = elementImpl.attributes[c.getIndex()];
                    index.remove(c, value, element);
                }
            }
        }
        finally {
            this.unlock();
        }
    }

    public void clear(GraphView view) {
        this.lock();
        try {
            IndexImpl<T> index = this.viewIndexes.get(view);
            if (index != null) {
                index.clear();
            }
        }
        finally {
            this.unlock();
        }
    }

    public void clear() {
        this.lock();
        try {
            this.mainIndex.clear();
            for (IndexImpl<T> index : this.viewIndexes.values()) {
                index.clear();
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureAttributeArrayLength(ElementImpl element, int size) {
        ElementImpl elementImpl = element;
        synchronized (elementImpl) {
            Object[] attributes = element.attributes;
            if (size > attributes.length) {
                Object[] newArray = new Object[size];
                System.arraycopy(attributes, 0, newArray, 0, attributes.length);
                element.attributes = newArray;
            }
        }
    }

    private void lock() {
        if (this.lock != null) {
            this.lock.lock();
        }
    }

    private void unlock() {
        if (this.lock != null) {
            this.lock.unlock();
        }
    }
}

