/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.impl.EdgeStore;
import org.gephi.graph.impl.GraphLock;
import org.gephi.graph.impl.GraphVersion;
import org.gephi.graph.impl.GraphViewStore;
import org.gephi.graph.impl.NodeImpl;

public class NodeStore
implements Collection<Node>,
NodeIterable {
    protected static final int NULL_ID = -1;
    protected final EdgeStore edgeStore;
    protected final GraphLock lock;
    protected final GraphVersion version;
    protected int size;
    protected int garbageSize;
    protected int blocksCount;
    protected int currentBlockIndex;
    protected NodeBlock[] blocks;
    protected NodeBlock currentBlock;
    protected Object2IntOpenHashMap dictionary;
    protected final GraphViewStore viewStore;

    public NodeStore() {
        this.initStore();
        this.lock = null;
        this.edgeStore = null;
        this.viewStore = null;
        this.version = null;
    }

    public NodeStore(EdgeStore edgeStore, GraphLock lock, GraphViewStore viewStore, GraphVersion graphVersion) {
        this.initStore();
        this.lock = lock;
        this.edgeStore = edgeStore;
        this.viewStore = viewStore;
        this.version = graphVersion;
    }

    private void initStore() {
        this.size = 0;
        this.garbageSize = 0;
        this.blocksCount = 1;
        this.currentBlockIndex = 0;
        this.blocks = new NodeBlock[10];
        this.blocks[0] = new NodeBlock(0);
        this.currentBlock = this.blocks[this.currentBlockIndex];
        this.dictionary = new Object2IntOpenHashMap(1000, 0.7f);
        this.dictionary.defaultReturnValue(-1);
    }

    private void ensureCapacity(int capacity) {
        assert (capacity > 0);
        int blockCapacity = this.currentBlock.getCapacity();
        while (capacity > blockCapacity) {
            if (this.currentBlockIndex == this.blocksCount - 1) {
                int blocksNeeded = (int)Math.ceil((double)(capacity - blockCapacity) / 5000.0);
                for (int i = 0; i < blocksNeeded; ++i) {
                    NodeBlock block;
                    if (this.blocksCount == this.blocks.length) {
                        NodeBlock[] newBlocks = new NodeBlock[this.blocksCount + 1];
                        System.arraycopy(this.blocks, 0, newBlocks, 0, this.blocks.length);
                        this.blocks = newBlocks;
                    }
                    if ((block = this.blocks[this.blocksCount]) == null) {
                        this.blocks[this.blocksCount] = block = new NodeBlock(this.blocksCount);
                    }
                    if (blockCapacity == 0 && i == 0) {
                        this.currentBlockIndex = this.blocksCount;
                        this.currentBlock = block;
                    }
                    ++this.blocksCount;
                }
                break;
            }
            ++this.currentBlockIndex;
            this.currentBlock = this.blocks[this.currentBlockIndex];
            blockCapacity = this.currentBlock.getCapacity();
        }
    }

    private void trimDictionary() {
        this.dictionary.trim(Math.max(5000, this.size * 2));
    }

    public NodeImpl get(int id) {
        this.checkValidId(id);
        return this.blocks[id / 5000].get(id);
    }

    public NodeImpl get(Object id) {
        int index = this.dictionary.getInt(id);
        if (index != -1) {
            return this.get(index);
        }
        return null;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.incrementVersion();
        }
        NodeStoreIterator itr = new NodeStoreIterator();
        while (itr.hasNext()) {
            NodeImpl node = itr.next();
            node.setStoreId(-1);
        }
        this.initStore();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public NodeStoreIterator iterator() {
        return new NodeStoreIterator();
    }

    public NodeImpl[] toArray() {
        this.readLock();
        NodeImpl[] array = new NodeImpl[this.size];
        if (this.garbageSize == 0) {
            for (int i = 0; i < this.blocksCount; ++i) {
                NodeBlock block = this.blocks[i];
                System.arraycopy(block.backingArray, 0, array, block.offset, block.nodeLength);
            }
        } else {
            NodeStoreIterator itr = this.iterator();
            int offset = 0;
            while (itr.hasNext()) {
                NodeImpl n = itr.next();
                array[offset++] = n;
            }
        }
        this.readUnlock();
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        this.checkNonNullObject(array);
        this.readLock();
        if (array.length < this.size()) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size());
        }
        if (this.garbageSize == 0) {
            for (int i = 0; i < this.blocksCount; ++i) {
                NodeBlock block = this.blocks[i];
                System.arraycopy(block.backingArray, 0, array, block.offset, block.nodeLength);
            }
        } else {
            NodeStoreIterator itr = this.iterator();
            int offset = 0;
            while (itr.hasNext()) {
                NodeImpl n = itr.next();
                array[offset++] = n;
            }
        }
        this.readUnlock();
        return array;
    }

    @Override
    public Collection<Node> toCollection() {
        this.readLock();
        ArrayList<Node> list = new ArrayList<Node>(this.size);
        for (NodeImpl n : this) {
            list.add(n);
        }
        this.readUnlock();
        return list;
    }

    @Override
    public boolean add(Node n) {
        this.checkNonNullNodeObject(n);
        NodeImpl node = (NodeImpl)n;
        if (node.storeId == -1) {
            this.checkIdDoesntExist(n.getId());
            this.incrementVersion();
            if (this.garbageSize > 0) {
                for (int i = 0; i < this.blocksCount; ++i) {
                    NodeBlock nodeBlock = this.blocks[i];
                    if (!nodeBlock.hasGarbage()) continue;
                    nodeBlock.set(node);
                    --this.garbageSize;
                    this.dictionary.put(node.getId(), node.storeId);
                    break;
                }
            } else {
                this.ensureCapacity(1);
                this.currentBlock.add(node);
                this.dictionary.put(node.getId(), node.storeId);
            }
            if (this.viewStore != null) {
                this.viewStore.addNode(node);
            }
            node.indexAttributes();
            ++this.size;
            return true;
        }
        if (this.isValidIndex(node.storeId) && this.get(node.storeId) == node) {
            return false;
        }
        throw new IllegalArgumentException("The node already belongs to another store");
    }

    @Override
    public boolean remove(Object o) {
        this.checkNonNullNodeObject(o);
        NodeImpl node = (NodeImpl)o;
        int id = node.storeId;
        if (id != -1) {
            this.checkNodeExists(node);
            if (this.viewStore != null) {
                this.viewStore.removeNode(node);
            }
            node.clearAttributes();
            this.incrementVersion();
            int storeIndex = id / 5000;
            NodeBlock block = this.blocks[storeIndex];
            block.remove(node);
            --this.size;
            ++this.garbageSize;
            this.dictionary.remove(node.getId());
            this.trimDictionary();
            int i = storeIndex;
            while (i == this.blocksCount - 1 && block.garbageLength == block.nodeLength && i >= 0) {
                if (i != 0) {
                    this.blocks[i] = null;
                    --this.blocksCount;
                    this.garbageSize -= block.nodeLength;
                    this.currentBlock = block = this.blocks[--i];
                    --this.currentBlockIndex;
                    continue;
                }
                this.currentBlock.clear();
                this.garbageSize = 0;
                break;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        this.checkNonNullNodeObject(o);
        NodeImpl node = (NodeImpl)o;
        int id = node.getStoreId();
        return id != -1 && this.get(id) == node;
    }

    public boolean containsId(Object id) {
        this.checkNonNullObject(id);
        return this.dictionary.containsKey(id);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.checkCollection(c);
        if (!c.isEmpty()) {
            int found = 0;
            for (Object o : c) {
                if (!this.contains((NodeImpl)o)) continue;
                ++found;
            }
            return found == c.size();
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Node> c) {
        this.checkCollection(c);
        if (!c.isEmpty()) {
            int capacityNeeded = c.size() - this.garbageSize;
            if (capacityNeeded > 0) {
                this.ensureCapacity(capacityNeeded);
            }
            boolean changed = false;
            for (Node node : c) {
                if (!this.add(node)) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkCollection(c);
        if (!c.isEmpty()) {
            boolean changed = false;
            for (Object o : c) {
                if (!this.remove(o)) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkCollection(c);
        if (!c.isEmpty()) {
            ObjectOpenHashSet set = new ObjectOpenHashSet(c.size());
            for (Object o : c) {
                this.checkNonNullObject(o);
                this.checkNodeExists((NodeImpl)o);
                set.add((NodeImpl)o);
            }
            boolean changed = false;
            NodeStoreIterator itr = this.iterator();
            while (itr.hasNext()) {
                NodeImpl e = itr.next();
                if (set.contains(e)) continue;
                itr.remove();
                changed = true;
            }
            return changed;
        }
        this.clear();
        return false;
    }

    public int deepHashCode() {
        int hash = 7;
        hash = 67 * hash + this.size;
        NodeStoreIterator itr = this.iterator();
        while (itr.hasNext()) {
            hash = 67 * hash + itr.next().hashCode();
        }
        return hash;
    }

    public boolean deepEquals(NodeStore obj) {
        if (obj == null) {
            return false;
        }
        if (this.size != obj.size) {
            return false;
        }
        NodeStoreIterator itr1 = this.iterator();
        NodeStoreIterator itr2 = obj.iterator();
        while (itr1.hasNext()) {
            if (!itr2.hasNext()) {
                return false;
            }
            if (itr1.next().equals(itr2.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void doBreak() {
        this.readUnlock();
    }

    void readLock() {
        if (this.lock != null) {
            this.lock.readLock();
        }
    }

    void readUnlock() {
        if (this.lock != null) {
            this.lock.readUnlock();
        }
    }

    void checkWriteLock() {
        if (this.lock != null) {
            this.lock.checkHoldWriteLock();
        }
    }

    private void checkIdDoesntExist(Object id) {
        if (this.dictionary.containsKey(id)) {
            throw new IllegalArgumentException("The node id already exist");
        }
    }

    private int incrementVersion() {
        if (this.version != null) {
            return this.version.incrementAndGetNodeVersion();
        }
        return 0;
    }

    protected boolean isValidIndex(int id) {
        return id >= 0 && id < this.currentBlock.offset + this.currentBlock.nodeLength;
    }

    private void checkNonNullObject(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    void checkNonNullNodeObject(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof NodeImpl)) {
            throw new ClassCastException("Object must be a NodeImpl object");
        }
    }

    void checkNodeExists(NodeImpl node) {
        if (this.get(node.storeId) != node) {
            throw new IllegalArgumentException("The node is invalid");
        }
    }

    private void checkValidId(int id) {
        if (id < 0 || !this.isValidIndex(id)) {
            throw new IllegalArgumentException("Node id=" + id + " is invalid");
        }
    }

    private void checkCollection(Collection<?> collection) {
        if (collection == this) {
            throw new IllegalArgumentException("Can't pass itself");
        }
    }

    int maxStoreId() {
        return this.currentBlock.offset + this.currentBlock.nodeLength;
    }

    protected final class NodeStoreIterator
    implements Iterator<Node> {
        protected int blockIndex;
        protected NodeImpl[] backingArray;
        protected int blockLength;
        protected int cursor;
        protected NodeImpl pointer;

        public NodeStoreIterator() {
            this.backingArray = NodeStore.this.blocks[this.blockIndex].backingArray;
            this.blockLength = NodeStore.this.blocks[this.blockIndex].nodeLength;
            NodeStore.this.readLock();
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.cursor == this.blockLength || (this.pointer = this.backingArray[this.cursor++]) == null) {
                if (this.cursor != this.blockLength) continue;
                if (++this.blockIndex >= NodeStore.this.blocksCount) break;
                this.backingArray = NodeStore.this.blocks[this.blockIndex].backingArray;
                this.blockLength = NodeStore.this.blocks[this.blockIndex].nodeLength;
                this.cursor = 0;
            }
            if (this.pointer == null) {
                NodeStore.this.readUnlock();
                return false;
            }
            return true;
        }

        @Override
        public NodeImpl next() {
            return this.pointer;
        }

        @Override
        public void remove() {
            NodeStore.this.checkWriteLock();
            if (NodeStore.this.edgeStore != null) {
                EdgeStore.EdgeInOutIterator edgeIterator = NodeStore.this.edgeStore.edgeIterator(this.pointer);
                while (edgeIterator.hasNext()) {
                    edgeIterator.next();
                    edgeIterator.remove();
                }
            }
            NodeStore.this.remove(this.pointer);
        }
    }

    protected static class NodeBlock {
        protected final int offset;
        protected final short[] garbageArray;
        protected final NodeImpl[] backingArray;
        protected int nodeLength;
        protected int garbageLength;

        public NodeBlock(int index) {
            this.offset = index * 5000;
            this.garbageArray = new short[5000];
            this.backingArray = new NodeImpl[5000];
        }

        public boolean hasGarbage() {
            return this.garbageLength > 0;
        }

        public int getCapacity() {
            return 5000 - this.nodeLength - this.garbageLength;
        }

        public void add(NodeImpl k) {
            int i = this.nodeLength++;
            this.backingArray[i] = k;
            k.setStoreId(i + this.offset);
        }

        public void set(NodeImpl k) {
            int i = this.garbageArray[--this.garbageLength] - Short.MIN_VALUE;
            this.backingArray[i] = k;
            k.setStoreId(i + this.offset);
        }

        public NodeImpl get(int id) {
            return this.backingArray[id - this.offset];
        }

        public void remove(NodeImpl k) {
            int i = k.getStoreId() - this.offset;
            this.backingArray[i] = null;
            this.garbageArray[this.garbageLength++] = (short)(i + Short.MIN_VALUE);
            k.setStoreId(-1);
        }

        public void clear() {
            this.nodeLength = 0;
            this.garbageLength = 0;
        }
    }
}

