/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.api.TimeIndex;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.impl.GraphLock;
import org.gephi.graph.impl.TimeIndexStore;

public abstract class TimeIndexImpl<T extends Element, K, S extends TimeSet<K>, M extends TimeMap<K, ?>>
implements TimeIndex<T> {
    protected final GraphLock lock;
    protected final TimeIndexStore<T, K, S, M> timestampIndexStore;
    protected final boolean mainIndex;
    protected TimeIndexEntry[] timestamps;
    protected int elementCount;

    protected TimeIndexImpl(TimeIndexStore<T, K, S, M> store, boolean main) {
        this.timestampIndexStore = store;
        this.mainIndex = main;
        this.timestamps = new TimeIndexEntry[0];
        this.lock = store.graphLock;
    }

    public boolean hasElements() {
        return this.elementCount > 0;
    }

    public void clear() {
        this.timestamps = new TimeIndexEntry[0];
        this.elementCount = 0;
    }

    protected void add(int timestampIndex, Element element) {
        this.ensureArraySize(timestampIndex);
        TimeIndexEntry entry = this.timestamps[timestampIndex];
        if (entry == null) {
            entry = this.addTimestamp(timestampIndex);
        }
        if (entry.add(element)) {
            ++this.elementCount;
        }
    }

    protected void remove(int timestampIndex, Element element) {
        TimeIndexEntry entry = this.timestamps[timestampIndex];
        if (entry.remove(element)) {
            --this.elementCount;
            if (entry.isEmpty()) {
                this.clearEntry(timestampIndex);
            }
        }
    }

    protected TimeIndexEntry addTimestamp(int index) {
        TimeIndexEntry entry;
        this.ensureArraySize(index);
        this.timestamps[index] = entry = new TimeIndexEntry();
        return entry;
    }

    private void ensureArraySize(int index) {
        if (index >= this.timestamps.length) {
            TimeIndexEntry[] newArray = new TimeIndexEntry[index + 1];
            System.arraycopy(this.timestamps, 0, newArray, 0, this.timestamps.length);
            this.timestamps = newArray;
        }
    }

    private void clearEntry(int index) {
        this.timestamps[index] = null;
    }

    protected void checkDouble(double timestamp) {
        if (Double.isInfinite(timestamp) || Double.isNaN(timestamp)) {
            throw new IllegalArgumentException("Timestamp can' be NaN or infinity");
        }
    }

    protected void readLock() {
        if (this.lock != null) {
            this.lock.readLock();
        }
    }

    protected void readUnlock() {
        if (this.lock != null) {
            this.lock.readUnlock();
        }
    }

    protected void writeLock() {
        if (this.lock != null) {
            this.lock.writeLock();
        }
    }

    protected void writeUnlock() {
        if (this.lock != null) {
            this.lock.writeUnlock();
        }
    }

    protected class ElementIterableImpl
    implements ElementIterable {
        protected final Iterator<Element> iterator;

        public ElementIterableImpl(Iterator<Element> iterator) {
            this.iterator = iterator;
        }

        @Override
        public Iterator<Element> iterator() {
            return this.iterator;
        }

        public Element[] toArray() {
            ArrayList<Element> list = new ArrayList<Element>();
            while (this.iterator.hasNext()) {
                list.add(this.iterator.next());
            }
            return list.toArray(new Element[0]);
        }

        public Collection<Element> toCollection() {
            ArrayList<Element> list = new ArrayList<Element>();
            while (this.iterator.hasNext()) {
                list.add(this.iterator.next());
            }
            return list;
        }

        @Override
        public void doBreak() {
            TimeIndexImpl.this.readUnlock();
        }
    }

    protected class ElementIteratorImpl
    implements Iterator<Element> {
        private final ObjectIterator<Element> itr;

        public ElementIteratorImpl(ObjectIterator<Element> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.itr.hasNext();
            if (!hasNext) {
                TimeIndexImpl.this.readUnlock();
            }
            return hasNext;
        }

        @Override
        public Element next() {
            return (Element)this.itr.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    protected static class TimeIndexEntry {
        protected final ObjectSet<Element> elementSet = new ObjectOpenHashSet<Element>();

        public boolean add(Element element) {
            return this.elementSet.add(element);
        }

        public boolean remove(Element element) {
            return this.elementSet.remove(element);
        }

        public boolean isEmpty() {
            return this.elementSet.isEmpty();
        }
    }
}

