/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeFormat;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.joda.time.DateTimeZone;

public class ExporterSpreadsheet
implements GraphExporter,
CharacterExporter,
LongTask {
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("0.######");
    private boolean exportVisible;
    private ExportTable tableToExport = null;
    private char fieldDelimiter = (char)44;
    private LinkedHashSet<String> columnIdsToExport = null;
    private Workspace workspace;
    private Writer writer;
    private boolean cancel = false;
    private ProgressTicket progressTicket;

    @Override
    public boolean execute() {
        GraphModel graphModel = this.workspace.getLookup().lookup(GraphModel.class);
        Graph graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        graph.readLock();
        try {
            this.exportData(graph);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            graph.readUnlock();
            Progress.finish(this.progressTicket);
        }
        return !this.cancel;
    }

    private void exportData(Graph graph) throws Exception {
        CSVFormat format = CSVFormat.DEFAULT.withDelimiter(this.fieldDelimiter);
        try (CSVPrinter csvWriter = new CSVPrinter(this.writer, format);){
            boolean isEdgeTable = this.tableToExport != ExportTable.NODES;
            Table table = isEdgeTable ? graph.getModel().getEdgeTable() : graph.getModel().getNodeTable();
            Object[] edgeLabels = graph.getModel().getEdgeTypeLabels();
            boolean includeEdgeKindColumn = false;
            for (Object edgeLabel : edgeLabels) {
                if (edgeLabel == null || edgeLabel.toString().isEmpty()) continue;
                includeEdgeKindColumn = true;
            }
            TimeFormat timeFormat = graph.getModel().getTimeFormat();
            DateTimeZone timeZone = graph.getModel().getTimeZone();
            ArrayList<Column> columns = new ArrayList<Column>();
            if (this.columnIdsToExport != null) {
                for (String string : this.columnIdsToExport) {
                    Column column = table.getColumn(string);
                    if (column == null) continue;
                    columns.add(column);
                }
            } else {
                for (Column column : table) {
                    columns.add(column);
                }
            }
            if (isEdgeTable) {
                csvWriter.print("Source");
                csvWriter.print("Target");
                csvWriter.print("Type");
                if (includeEdgeKindColumn) {
                    csvWriter.print("Kind");
                }
            }
            for (Column column : columns) {
                String columnTitle;
                String columnId = column.getId();
                String columnHeader = columnId.equalsIgnoreCase(columnTitle = column.getTitle()) ? columnTitle : columnId;
                csvWriter.print(columnHeader);
            }
            csvWriter.println();
            ElementIterable<Edge> rows = isEdgeTable ? graph.getEdges() : graph.getNodes();
            for (Element element : rows) {
                if (isEdgeTable) {
                    Edge edge = (Edge)element;
                    csvWriter.print(edge.getSource().getId());
                    csvWriter.print(edge.getTarget().getId());
                    csvWriter.print(edge.isDirected() ? "Directed" : "Undirected");
                    if (includeEdgeKindColumn) {
                        csvWriter.print(edge.getTypeLabel().toString());
                    }
                }
                for (Column column : columns) {
                    Object value = element.getAttribute(column);
                    String text = value != null ? (value instanceof Number ? NUMBER_FORMAT.format(value) : AttributeUtils.print(value, timeFormat, timeZone)) : "";
                    csvWriter.print(text);
                }
                csvWriter.println();
            }
        }
    }

    @Override
    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    @Override
    public boolean isExportVisible() {
        return this.exportVisible;
    }

    @Override
    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    @Override
    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public LinkedHashSet<String> getColumnIdsToExport() {
        return new LinkedHashSet<String>(this.columnIdsToExport);
    }

    public void setColumnIdsToExport(LinkedHashSet<String> columnIdsToExport) {
        this.columnIdsToExport = columnIdsToExport != null ? new LinkedHashSet<String>(columnIdsToExport) : null;
    }

    public ExportTable getTableToExport() {
        return this.tableToExport;
    }

    public void setTableToExport(ExportTable tableToExport) {
        this.tableToExport = tableToExport;
    }

    static {
        DecimalFormatSymbols symbols = DecimalFormatSymbols.getInstance(Locale.ENGLISH);
        symbols.setInfinity("Infinity");
        NUMBER_FORMAT.setDecimalFormatSymbols(symbols);
    }

    public static enum ExportTable {
        NODES,
        EDGES;

    }
}

