/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.preview;

import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.gephi.io.exporter.spi.ByteExporter;
import org.gephi.io.exporter.spi.VectorExporter;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.PreviewController;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.project.api.Workspace;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Lookup;

public class PNGExporter
implements VectorExporter,
ByteExporter,
LongTask {
    private ProgressTicket progress;
    private boolean cancel = false;
    private Workspace workspace;
    private OutputStream stream;
    private int width = 1024;
    private int height = 1024;
    private boolean transparentBackground = false;
    private int margin = 4;
    private G2DTarget target;
    private Color oldColor;

    @Override
    public boolean execute() {
        Progress.start(this.progress);
        PreviewController ctrl = Lookup.getDefault().lookup(PreviewController.class);
        PreviewModel m = ctrl.getModel(this.workspace);
        this.setExportProperties(m);
        ctrl.refreshPreview(this.workspace);
        this.target = (G2DTarget)ctrl.getRenderTarget("g2d", this.workspace);
        if (this.target instanceof LongTask) {
            ((LongTask)((Object)this.target)).setProgressTicket(this.progress);
        }
        try {
            this.target.refresh();
            Progress.switchToIndeterminate(this.progress);
            Image sourceImg = this.target.getImage();
            BufferedImage img = new BufferedImage(this.width, this.height, 2);
            img.getGraphics().drawImage(sourceImg, 0, 0, null);
            ImageIO.write((RenderedImage)img, "png", this.stream);
            this.stream.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.discardExportProperties(m);
        Progress.finish(this.progress);
        return !this.cancel;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public boolean isTransparentBackground() {
        return this.transparentBackground;
    }

    public void setTransparentBackground(boolean transparentBackground) {
        this.transparentBackground = transparentBackground;
    }

    @Override
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    @Override
    public boolean cancel() {
        this.cancel = true;
        if (this.target instanceof LongTask) {
            ((LongTask)((Object)this.target)).cancel();
        }
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    private synchronized void setExportProperties(PreviewModel m) {
        PreviewProperties props = m.getProperties();
        props.putValue("visibility-ratio", Float.valueOf(1.0f));
        props.putValue("width", this.width);
        props.putValue("height", this.height);
        this.oldColor = props.getColorValue("background-color");
        if (this.transparentBackground) {
            props.putValue("background-color", null);
        }
        props.putValue("margin", new Float(this.margin));
    }

    private synchronized void discardExportProperties(PreviewModel m) {
        PreviewProperties props = m.getProperties();
        props.removeSimpleValue("width");
        props.removeSimpleValue("height");
        props.removeSimpleValue("margin");
        props.putValue("background-color", this.oldColor);
    }
}

