/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.generator.plugin;

import java.util.Random;
import org.gephi.io.generator.spi.Generator;
import org.gephi.io.generator.spi.GeneratorUI;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class MultiGraph
implements Generator {
    protected int numberOfNodes = 50;
    protected double wiringProbability = 0.05;
    protected int numberOfEdgeTypes = 3;

    @Override
    public void generate(ContainerLoader container) {
        NodeDraft[] nodeArray = new NodeDraft[this.numberOfNodes];
        for (int i = 0; i < this.numberOfNodes; ++i) {
            NodeDraft nodeDraft = container.factory().newNodeDraft("n" + i);
            container.addNode(nodeDraft);
            nodeArray[i] = nodeDraft;
        }
        String[] edgeTypes = new String[this.numberOfEdgeTypes];
        for (int i = 0; i < edgeTypes.length; ++i) {
            edgeTypes[i] = "Type " + i;
        }
        Random random = new Random();
        if (this.wiringProbability > 0.0) {
            for (int i = 0; i < this.numberOfNodes - 1; ++i) {
                NodeDraft node1 = nodeArray[i];
                for (int j = i + 1; j < this.numberOfNodes; ++j) {
                    NodeDraft node2 = nodeArray[j];
                    if (!(random.nextDouble() < this.wiringProbability)) continue;
                    if (random.nextDouble() < 0.3) {
                        EdgeDraft edgeDraft1 = container.factory().newEdgeDraft();
                        edgeDraft1.setSource(node1);
                        edgeDraft1.setTarget(node2);
                        edgeDraft1.setType(edgeTypes[0]);
                        edgeDraft1.setLabel((String)edgeDraft1.getType());
                        container.addEdge(edgeDraft1);
                        EdgeDraft edgeDraft2 = container.factory().newEdgeDraft();
                        edgeDraft2.setSource(node1);
                        edgeDraft2.setTarget(node2);
                        edgeDraft2.setType(edgeTypes[1]);
                        edgeDraft2.setLabel((String)edgeDraft2.getType());
                        container.addEdge(edgeDraft2);
                        continue;
                    }
                    EdgeDraft edgeDraft = container.factory().newEdgeDraft();
                    edgeDraft.setSource(node1);
                    edgeDraft.setTarget(node2);
                    edgeDraft.setType(edgeTypes[random.nextInt(edgeTypes.length)]);
                    edgeDraft.setLabel((String)edgeDraft.getType());
                    container.addEdge(edgeDraft);
                }
            }
        }
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(MultiGraph.class, "MultiGraph.name");
    }

    @Override
    public GeneratorUI getUI() {
        return null;
    }

    @Override
    public boolean cancel() {
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket progressTicket) {
    }
}

