/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.api;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.gephi.utils.CharsetToolkit;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ImportUtils {
    private static final Map<String, Integer> COLORS = new HashMap<String, Integer>();

    public static LineNumberReader getTextReader(FileObject fileObject) throws IOException {
        try {
            return ImportUtils.getTextReader(fileObject.getInputStream());
        }
        catch (IOException ex) {
            throw new IOException(NbBundle.getMessage(ImportUtils.class, "ImportUtils.error_file_not_found"));
        }
    }

    public static Color parseColor(String colorString) {
        Integer colorInt;
        Color cl;
        colorString = colorString.toLowerCase().replace(" ", "");
        try {
            Field field = Color.class.getField(colorString);
            cl = (Color)field.get(null);
        }
        catch (NoSuchFieldException e) {
            cl = null;
        }
        catch (SecurityException e) {
            cl = null;
        }
        catch (IllegalArgumentException e) {
            cl = null;
        }
        catch (IllegalAccessException e) {
            cl = null;
        }
        if (cl == null && (colorInt = COLORS.get(colorString)) != null) {
            cl = new Color(colorInt);
        }
        if (cl == null) {
            try {
                cl = Color.decode(colorString);
            }
            catch (NumberFormatException e) {
                cl = null;
            }
        }
        return cl;
    }

    public static LineNumberReader getTextReader(InputStream stream) throws IOException {
        CharsetToolkit charsetToolkit = new CharsetToolkit(stream);
        LineNumberReader reader = (LineNumberReader)charsetToolkit.getReader();
        return reader;
    }

    public static LineNumberReader getTextReader(Reader reader) {
        LineNumberReader lineNumberReader = new LineNumberReader(reader);
        return lineNumberReader;
    }

    public static Document getXMLDocument(InputStream stream) throws RuntimeException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(stream);
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, "ImportUtils.error_missing_document_instance_factory"));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, "ImportUtils.error_file_not_found"));
        }
        catch (SAXException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, "ImportUtils.error_sax"));
        }
        catch (IOException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, "ImportUtils.error_io"));
        }
    }

    public static Document getXMLDocument(Reader reader) throws RuntimeException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new InputSource(reader));
            return document;
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, "ImportUtils.error_missing_document_instance_factory"));
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, "ImportUtils.error_file_not_found"));
        }
        catch (SAXException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, "ImportUtils.error_sax"));
        }
        catch (IOException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, "ImportUtils.error_io"));
        }
    }

    public static Document getXMLDocument(FileObject fileObject) throws RuntimeException {
        try {
            InputStream stream = fileObject.getInputStream();
            return ImportUtils.getXMLDocument(stream);
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, "ImportUtils.error_file_not_found"));
        }
    }

    public static XMLStreamReader getXMLReader(Reader reader) {
        try {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            if (inputFactory.isPropertySupported("javax.xml.stream.isValidating")) {
                inputFactory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
            }
            inputFactory.setXMLReporter(new XMLReporter(){

                @Override
                public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
                    throw new RuntimeException("Error:" + errorType + ", message : " + message);
                }
            });
            return inputFactory.createXMLStreamReader(reader);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(NbBundle.getMessage(ImportUtils.class, "ImportUtils.error_io"));
        }
    }

    public static FileObject getArchivedFile(FileObject fileObject) {
        if (fileObject == null) {
            return null;
        }
        if (fileObject.getExt().toLowerCase().startsWith("xls")) {
            return fileObject;
        }
        if (FileUtil.isArchiveFile(fileObject)) {
            FileObject[] children = FileUtil.getArchiveRoot(fileObject).getChildren();
            fileObject = children.length > 0 ? children[0] : null;
        } else {
            boolean isGz = fileObject.getExt().equalsIgnoreCase("gz");
            boolean isBzip = fileObject.getExt().equalsIgnoreCase("bz2");
            if (isGz || isBzip) {
                try {
                    File tempFile;
                    String[] splittedFileName = fileObject.getName().split("\\.");
                    if (splittedFileName.length < 2) {
                        return fileObject;
                    }
                    String fileExt1 = splittedFileName[splittedFileName.length - 1];
                    String fileExt2 = splittedFileName[splittedFileName.length - 2];
                    if (fileExt1.equalsIgnoreCase("tar")) {
                        String fname = fileObject.getName().replaceAll("\\.tar$", "");
                        fname = fname.replace(fileExt2, "");
                        tempFile = File.createTempFile(fname, "." + fileExt2);
                        tempFile = isGz ? ImportUtils.getGzFile(fileObject, tempFile, true) : ImportUtils.getBzipFile(fileObject, tempFile, true);
                    } else {
                        String fname = fileObject.getName();
                        fname = fname.replace(fileExt1, "");
                        tempFile = File.createTempFile(fname, "." + fileExt1);
                        tempFile = isGz ? ImportUtils.getGzFile(fileObject, tempFile, false) : ImportUtils.getBzipFile(fileObject, tempFile, false);
                    }
                    tempFile.deleteOnExit();
                    tempFile = FileUtil.normalizeFile(tempFile);
                    fileObject = FileUtil.toFileObject(tempFile);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace(ex);
                }
            }
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getBzipFile(FileObject in, File out, boolean isTar) throws IOException {
        int BUFF_SIZE = 8192;
        byte[] buffer = new byte[8192];
        BZip2CompressorInputStream inputStream = null;
        FileOutputStream outStream = null;
        try {
            FileInputStream is = new FileInputStream(in.getPath());
            inputStream = new BZip2CompressorInputStream(is);
            outStream = new FileOutputStream(out.getAbsolutePath());
            if (isTar) {
                int nRead;
                int remainingBytes = ImportUtils.readTarHeader(inputStream);
                ByteBuffer bb = ByteBuffer.allocateDirect(32768);
                byte[] tmpCache = new byte[8192];
                while ((nRead = inputStream.read(tmpCache)) != -1) {
                    if (nRead == 0) continue;
                    bb.put(tmpCache);
                    bb.position(0);
                    bb.limit(nRead);
                    while (bb.hasRemaining() && remainingBytes > 0) {
                        int nGet = Math.min(bb.remaining(), 8192);
                        nGet = Math.min(nGet, remainingBytes);
                        bb.get(buffer, 0, nGet);
                        outStream.write(buffer, 0, nGet);
                        remainingBytes -= nGet;
                    }
                    bb.clear();
                }
            } else {
                int len;
                while ((len = inputStream.read(buffer)) > 0) {
                    outStream.write(buffer, 0, len);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getGzFile(FileObject in, File out, boolean isTar) throws IOException {
        int BUFF_SIZE = 8192;
        byte[] buffer = new byte[8192];
        GZIPInputStream inputStream = null;
        FileOutputStream outStream = null;
        try {
            inputStream = new GZIPInputStream(new FileInputStream(in.getPath()));
            outStream = new FileOutputStream(out);
            if (isTar) {
                int nRead;
                int remainingBytes = ImportUtils.readTarHeader(inputStream);
                ByteBuffer bb = ByteBuffer.allocateDirect(32768);
                byte[] tmpCache = new byte[8192];
                while ((nRead = inputStream.read(tmpCache)) != -1) {
                    if (nRead == 0) continue;
                    bb.put(tmpCache);
                    bb.position(0);
                    bb.limit(nRead);
                    while (bb.hasRemaining() && remainingBytes > 0) {
                        int nGet = Math.min(bb.remaining(), 8192);
                        nGet = Math.min(nGet, remainingBytes);
                        bb.get(buffer, 0, nGet);
                        outStream.write(buffer, 0, nGet);
                        remainingBytes -= nGet;
                    }
                    bb.clear();
                }
            } else {
                int len;
                while ((len = inputStream.read(buffer)) > 0) {
                    outStream.write(buffer, 0, len);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace(ex);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outStream != null) {
                outStream.close();
            }
        }
        return out;
    }

    private static int readTarHeader(InputStream inputStream) throws IOException {
        int FILE_SIZE_OFFSET = 124;
        int FILE_SIZE_LENGTH = 12;
        int HEADER_LENGTH = 512;
        ImportUtils.ignoreBytes(inputStream, 124);
        String fileSizeLengthOctalString = ImportUtils.readString(inputStream, 12).trim();
        int fileSize = Integer.parseInt(fileSizeLengthOctalString, 8);
        ImportUtils.ignoreBytes(inputStream, 376);
        return fileSize;
    }

    private static void ignoreBytes(InputStream inputStream, int numberOfBytes) throws IOException {
        for (int counter = 0; counter < numberOfBytes; ++counter) {
            inputStream.read();
        }
    }

    private static String readString(InputStream inputStream, int numberOfBytes) throws IOException {
        return new String(ImportUtils.readBytes(inputStream, numberOfBytes));
    }

    private static byte[] readBytes(InputStream inputStream, int numberOfBytes) throws IOException {
        byte[] readBytes = new byte[numberOfBytes];
        inputStream.read(readBytes);
        return readBytes;
    }

    static {
        COLORS.put("gray30", 0x4D4D4D);
        COLORS.put("cadetblue", 11581382);
        COLORS.put("gray35", 0x595959);
        COLORS.put("lightorange", 16740122);
        COLORS.put("gray75", 0xBFBFBF);
        COLORS.put("apricot", 16636341);
        COLORS.put("canary", 0xFFFF99);
        COLORS.put("rubinered", 13238365);
        COLORS.put("gray80", 0xCCCCCC);
        COLORS.put("gray20", 0x333333);
        COLORS.put("processblue", 4286945);
        COLORS.put("gray25", 0x404040);
        COLORS.put("emerald", 5294200);
        COLORS.put("lightpurple", 14706431);
        COLORS.put("forestgreen", 7188097);
        COLORS.put("maroon", 13121626);
        COLORS.put("gray40", 0x666666);
        COLORS.put("seagreen", 10478271);
        COLORS.put("thistle", 14204888);
        COLORS.put("olivegreen", 12236908);
        COLORS.put("gray45", 0x737373);
        COLORS.put("cerulean", 1944790);
        COLORS.put("skyblue", 8444651);
        COLORS.put("violetred", 16208788);
        COLORS.put("lskyblue", 8900346);
        COLORS.put("gray85", 0xD9D9D9);
        COLORS.put("navyblue", 1668306);
        COLORS.put("lavender", 16561365);
        COLORS.put("lightmagenta", 0xFF00FF);
        COLORS.put("yellowgreen", 12968836);
        COLORS.put("plum", 9323909);
        COLORS.put("gray90", 0xE5E5E5);
        COLORS.put("gray10", 0x1A1A1A);
        COLORS.put("melon", 16628916);
        COLORS.put("turquoise", 0x77DDE7);
        COLORS.put("midnightblue", 1722486);
        COLORS.put("gray15", 0x262626);
        COLORS.put("royalpurple", 7885225);
        COLORS.put("gray95", 0xF2F2F2);
        COLORS.put("brickred", 13320532);
        COLORS.put("salmon", 16751530);
        COLORS.put("rhodamine", 14684573);
        COLORS.put("lfadedgreen", 5540692);
        COLORS.put("tan", 16426860);
        COLORS.put("rawsienna", 14060121);
        COLORS.put("sepia", 10840399);
        COLORS.put("lightyellow", 0xFFFFE0);
        COLORS.put("gray55", 0x8C8C8C);
        COLORS.put("bluegreen", 1679037);
        COLORS.put("lightgreen", 0x90EE90);
        COLORS.put("burntorange", 16744265);
        COLORS.put("goldenrod", 16570741);
        COLORS.put("blueviolet", 7562941);
        COLORS.put("periwinkle", 12964070);
        COLORS.put("aquamarine", 7920610);
        COLORS.put("redorange", 16733001);
        COLORS.put("greenyellow", 15788177);
        COLORS.put("mulberry", 11169951);
        COLORS.put("limegreen", 3329330);
        COLORS.put("darkorchid", 16636797);
        COLORS.put("pinegreen", 1409144);
        COLORS.put("gray60", 0x999999);
        COLORS.put("tealblue", 32896);
        COLORS.put("gray05", 855309);
        COLORS.put("purple", 9596590);
        COLORS.put("gray65", 0xA6A6A6);
        COLORS.put("cornflowerblue", 10145515);
        COLORS.put("redviolet", 12600463);
        COLORS.put("peach", 16764843);
        COLORS.put("springgreen", 15526590);
        COLORS.put("royalblue", 4286945);
        COLORS.put("mahogany", 13453898);
        COLORS.put("wildstrawberry", 16728996);
        COLORS.put("lightcyan", 0xE0FFFF);
        COLORS.put("orangered", 16733001);
        COLORS.put("orchid", 15116503);
        COLORS.put("dandelion", 16636781);
        COLORS.put("violet", 9596590);
        COLORS.put("fuchsia", 12805317);
        COLORS.put("gray70", 0xB3B3B3);
        COLORS.put("brown", 11822925);
        COLORS.put("carnationpink", 0xFFAACC);
        COLORS.put("bittersweet", 16612462);
        COLORS.put("junglegreen", 3911823);
        COLORS.put("yelloworange", 16758355);
        COLORS.put("navajowhite", 16768685);
        COLORS.put("deeppink4", 9112144);
        COLORS.put("deeppink3", 13439094);
        COLORS.put("deeppink2", 15602313);
        COLORS.put("saddlebrown", 9127187);
        COLORS.put("deeppink1", 16716947);
        COLORS.put("burlywood3", 13478525);
        COLORS.put("burlywood4", 9139029);
        COLORS.put("lightblue", 11393254);
        COLORS.put("burlywood1", 16765851);
        COLORS.put("burlywood2", 15648145);
        COLORS.put("sienna3", 13461561);
        COLORS.put("peachpuff3", 13479829);
        COLORS.put("sienna2", 15628610);
        COLORS.put("peachpuff2", 15649709);
        COLORS.put("sienna4", 9127718);
        COLORS.put("peachpuff4", 9140069);
        COLORS.put("peachpuff1", 16767673);
        COLORS.put("orangered4", 9118976);
        COLORS.put("purple4", 5577355);
        COLORS.put("orangered3", 13448960);
        COLORS.put("purple3", 8201933);
        COLORS.put("purple2", 9514222);
        COLORS.put("purple1", 10170623);
        COLORS.put("lavenderblush", 0xFFF0F5);
        COLORS.put("palegreen2", 0x90EE90);
        COLORS.put("orangered1", 16729344);
        COLORS.put("palegreen1", 0x9AFF9A);
        COLORS.put("orangered2", 0xEE4000);
        COLORS.put("palegreen4", 5540692);
        COLORS.put("sgiindigo2", 2197608);
        COLORS.put("palegreen3", 0x7CCD7C);
        COLORS.put("mediumslateblue", 8087790);
        COLORS.put("linen", 16445670);
        COLORS.put("chartreuse3", 6737152);
        COLORS.put("mediumorchid", 12211667);
        COLORS.put("chartreuse2", 7794176);
        COLORS.put("chartreuse4", 4557568);
        COLORS.put("chartreuse1", 0x7FFF00);
        COLORS.put("salmon2", 15630946);
        COLORS.put("salmon3", 13463636);
        COLORS.put("salmon4", 9129017);
        COLORS.put("salmon1", 16747625);
        COLORS.put("dodgerblue", 2003199);
        COLORS.put("grey", 0xBEBEBE);
        COLORS.put("dodgerblue3", 1602765);
        COLORS.put("dodgerblue4", 1068683);
        COLORS.put("papayawhip", 16773077);
        COLORS.put("dodgerblue1", 2003199);
        COLORS.put("dodgerblue2", 1869550);
        COLORS.put("slategrey", 7372944);
        COLORS.put("paleturquoise1", 0xBBFFFF);
        COLORS.put("darkgoldenrod1", 16759055);
        COLORS.put("paleturquoise2", 0xAEEEEE);
        COLORS.put("aquamarine1", 8388564);
        COLORS.put("chocolate", 13789470);
        COLORS.put("darkgoldenrod3", 13473036);
        COLORS.put("darkgoldenrod2", 15641870);
        COLORS.put("aquamarine3", 6737322);
        COLORS.put("coral2", 15624784);
        COLORS.put("aquamarine2", 7794374);
        COLORS.put("coral1", 16740950);
        COLORS.put("darkgoldenrod4", 9135368);
        COLORS.put("paleturquoise3", 9883085);
        COLORS.put("coral4", 9125423);
        COLORS.put("paleturquoise4", 0x668B8B);
        COLORS.put("aquamarine4", 4557684);
        COLORS.put("coral3", 13458245);
        COLORS.put("mediumseagreen", 3978097);
        COLORS.put("slategray1", 13034239);
        COLORS.put("gray0", 0);
        COLORS.put("slategray3", 10467021);
        COLORS.put("mistyrose2", 15652306);
        COLORS.put("gray2", 328965);
        COLORS.put("slategray2", 12178414);
        COLORS.put("mistyrose1", 16770273);
        COLORS.put("gray1", 197379);
        COLORS.put("oldlace", 16643558);
        COLORS.put("mistyrose4", 9141627);
        COLORS.put("slategray4", 7109515);
        COLORS.put("mistyrose3", 13481909);
        COLORS.put("paleturquoise", 0xAFEEEE);
        COLORS.put("gray22", 0x383838);
        COLORS.put("gray21", 0x363636);
        COLORS.put("gray26", 0x424242);
        COLORS.put("powderblue", 11591910);
        COLORS.put("gray24", 0x3D3D3D);
        COLORS.put("gray23", 0x3B3B3B);
        COLORS.put("gray7", 0x121212);
        COLORS.put("gray8", 0x141414);
        COLORS.put("gray29", 0x4A4A4A);
        COLORS.put("palevioletred", 14381203);
        COLORS.put("gray9", 0x171717);
        COLORS.put("gray28", 0x474747);
        COLORS.put("gray27", 0x454545);
        COLORS.put("gray3", 526344);
        COLORS.put("gray4", 657930);
        COLORS.put("gray5", 855309);
        COLORS.put("azure", 0xF0FFFF);
        COLORS.put("gray6", 986895);
        COLORS.put("lightskyblue2", 10802158);
        COLORS.put("lightblue4", 6849419);
        COLORS.put("lightskyblue1", 11592447);
        COLORS.put("lightskyblue4", 6323083);
        COLORS.put("cyan1", 65535);
        COLORS.put("lightskyblue3", 9287373);
        COLORS.put("cyan2", 61166);
        COLORS.put("lightblue1", 0xBFEFFF);
        COLORS.put("lightblue2", 11722734);
        COLORS.put("lightblue3", 10141901);
        COLORS.put("gray11", 0x1C1C1C);
        COLORS.put("gray13", 0x212121);
        COLORS.put("gray12", 0x1F1F1F);
        COLORS.put("gray14", 0x242424);
        COLORS.put("gray17", 0x2B2B2B);
        COLORS.put("violetred1", 16727702);
        COLORS.put("gray16", 0x292929);
        COLORS.put("gold4", 9139456);
        COLORS.put("gray19", 0x303030);
        COLORS.put("gray18", 0x2E2E2E);
        COLORS.put("gold2", 15649024);
        COLORS.put("cyan4", 35723);
        COLORS.put("gold3", 13479168);
        COLORS.put("cyan3", 52685);
        COLORS.put("gold1", 16766720);
        COLORS.put("darkolivegreen", 5597999);
        COLORS.put("violetred3", 13447800);
        COLORS.put("tan3", 13468991);
        COLORS.put("violetred2", 15612556);
        COLORS.put("tan4", 9132587);
        COLORS.put("darkgoldenrod", 12092939);
        COLORS.put("tan1", 16753999);
        COLORS.put("violetred4", 9118290);
        COLORS.put("tan2", 15637065);
        COLORS.put("palegreen", 10025880);
        COLORS.put("darkorange4", 9127168);
        COLORS.put("darkseagreen", 9419919);
        COLORS.put("springgreen4", 35653);
        COLORS.put("springgreen3", 52582);
        COLORS.put("springgreen2", 61046);
        COLORS.put("springgreen1", 65407);
        COLORS.put("ivory2", 0xEEEEE0);
        COLORS.put("ivory1", 0xFFFFF0);
        COLORS.put("ivory4", 0x8B8B83);
        COLORS.put("ivory3", 0xCDCDC1);
        COLORS.put("beige", 16119260);
        COLORS.put("darkorange3", 13460992);
        COLORS.put("darkorange2", 15627776);
        COLORS.put("darkorange1", 0xFF7F00);
        COLORS.put("mediumorchid3", 11817677);
        COLORS.put("mediumorchid2", 13721582);
        COLORS.put("mediumorchid1", 14706431);
        COLORS.put("mediumorchid4", 8009611);
        COLORS.put("khaki", 15787660);
        COLORS.put("slategray", 7372944);
        COLORS.put("mintcream", 0xF5FFFA);
        COLORS.put("mistyrose", 16770273);
        COLORS.put("tomato", 16737095);
        COLORS.put("moccasin", 16770229);
        COLORS.put("royalblue3", 3825613);
        COLORS.put("blue1", 255);
        COLORS.put("royalblue4", 2572427);
        COLORS.put("royalblue1", 4749055);
        COLORS.put("royalblue2", 4419310);
        COLORS.put("blue4", 139);
        COLORS.put("lightslategrey", 0x778899);
        COLORS.put("blue3", 205);
        COLORS.put("blue2", 238);
        COLORS.put("indigo", 4915330);
        COLORS.put("darkviolet", 9699539);
        COLORS.put("darkred", 0x8B0000);
        COLORS.put("lightcyan1", 0xE0FFFF);
        COLORS.put("lightcyan2", 0xD1EEEE);
        COLORS.put("lightcyan3", 11849165);
        COLORS.put("lightcyan4", 8031115);
        COLORS.put("darkmagenta", 0x8B008B);
        COLORS.put("darkcyan", 35723);
        COLORS.put("grey89", 0xE3E3E3);
        COLORS.put("lightgoldenrodyellow", 16448210);
        COLORS.put("grey91", 0xE8E8E8);
        COLORS.put("darkseagreen1", 0xC1FFC1);
        COLORS.put("grey90", 0xE5E5E5);
        COLORS.put("peachpuff", 16767673);
        COLORS.put("mediumvioletred", 13047173);
        COLORS.put("grey99", 0xFCFCFC);
        COLORS.put("grey98", 0xFAFAFA);
        COLORS.put("grey97", 0xF7F7F7);
        COLORS.put("grey96", 0xF5F5F5);
        COLORS.put("darkseagreen4", 6916969);
        COLORS.put("grey95", 0xF2F2F2);
        COLORS.put("grey94", 0xF0F0F0);
        COLORS.put("darkseagreen2", 0xB4EEB4);
        COLORS.put("grey93", 0xEDEDED);
        COLORS.put("darkseagreen3", 10210715);
        COLORS.put("grey92", 0xEBEBEB);
        COLORS.put("khaki1", 0xFFF68F);
        COLORS.put("grey78", 0xC7C7C7);
        COLORS.put("grey79", 0xC9C9C9);
        COLORS.put("darkslateblue", 4734347);
        COLORS.put("antiquewhite", 16444375);
        COLORS.put("bisque3", 13481886);
        COLORS.put("bisque4", 9141611);
        COLORS.put("bisque1", 16770244);
        COLORS.put("bisque2", 15652279);
        COLORS.put("grey80", 0xCCCCCC);
        COLORS.put("grey86", 0xDBDBDB);
        COLORS.put("grey85", 0xD9D9D9);
        COLORS.put("grey88", 0xE0E0E0);
        COLORS.put("grey87", 0xDEDEDE);
        COLORS.put("grey82", 0xD1D1D1);
        COLORS.put("khaki4", 9143886);
        COLORS.put("grey81", 0xCFCFCF);
        COLORS.put("khaki3", 13485683);
        COLORS.put("grey84", 0xD6D6D6);
        COLORS.put("grey83", 0xD4D4D4);
        COLORS.put("khaki2", 15656581);
        COLORS.put("red3", 0xCD0000);
        COLORS.put("red4", 0x8B0000);
        COLORS.put("red1", 0xFF0000);
        COLORS.put("honeydew", 0xF0FFF0);
        COLORS.put("red2", 0xEE0000);
        COLORS.put("mediumpurple", 9662683);
        COLORS.put("darkolivegreen2", 12381800);
        COLORS.put("brown1", 0xFF4040);
        COLORS.put("darkolivegreen3", 10669402);
        COLORS.put("darkolivegreen4", 7244605);
        COLORS.put("brown4", 9118499);
        COLORS.put("brown2", 0xEE3B3B);
        COLORS.put("lightslategray", 0x778899);
        COLORS.put("brown3", 0xCD3333);
        COLORS.put("darkolivegreen1", 13303664);
        COLORS.put("slateblue3", 6904269);
        COLORS.put("slateblue4", 4668555);
        COLORS.put("lightcoral", 0xF08080);
        COLORS.put("seagreen4", 3050327);
        COLORS.put("slateblue2", 8021998);
        COLORS.put("seagreen1", 5570463);
        COLORS.put("slateblue1", 8613887);
        COLORS.put("seagreen3", 4443520);
        COLORS.put("seagreen2", 0x4EEE94);
        COLORS.put("cadetblue2", 0x8EE5EE);
        COLORS.put("darkorchid2", 11680494);
        COLORS.put("cadetblue1", 10024447);
        COLORS.put("darkorchid1", 12533503);
        COLORS.put("darkorchid4", 6824587);
        COLORS.put("darkorchid3", 10105549);
        COLORS.put("cadetblue4", 5473931);
        COLORS.put("cadetblue3", 8046029);
        COLORS.put("coral", 16744272);
        COLORS.put("darksalmon", 15308410);
        COLORS.put("grey100", 0xFFFFFF);
        COLORS.put("palegoldenrod", 0xEEE8AA);
        COLORS.put("azure2", 0xE0EEEE);
        COLORS.put("azure1", 0xF0FFFF);
        COLORS.put("azure4", 0x838B8B);
        COLORS.put("honeydew3", 0xC1CDC1);
        COLORS.put("azure3", 0xC1CDCD);
        COLORS.put("honeydew4", 0x838B83);
        COLORS.put("honeydew1", 0xF0FFF0);
        COLORS.put("honeydew2", 0xE0EEE0);
        COLORS.put("cornsilk2", 15657165);
        COLORS.put("cornsilk1", 16775388);
        COLORS.put("darkturquoise", 52945);
        COLORS.put("cornsilk4", 0x8B8878);
        COLORS.put("cornsilk3", 13486257);
        COLORS.put("steelblue4", 3564683);
        COLORS.put("steelblue3", 5215437);
        COLORS.put("sandybrown", 16032864);
        COLORS.put("steelblue2", 6073582);
        COLORS.put("sienna1", 16745031);
        COLORS.put("steelblue1", 6535423);
        COLORS.put("navy", 128);
        COLORS.put("hotpink", 16738740);
        COLORS.put("green3", 52480);
        COLORS.put("green4", 35584);
        COLORS.put("grey22", 0x383838);
        COLORS.put("grey21", 0x363636);
        COLORS.put("grey20", 0x333333);
        COLORS.put("grey18", 0x2E2E2E);
        COLORS.put("grey19", 0x303030);
        COLORS.put("grey16", 0x292929);
        COLORS.put("grey17", 0x2B2B2B);
        COLORS.put("grey14", 0x242424);
        COLORS.put("grey15", 0x262626);
        COLORS.put("grey12", 0x1F1F1F);
        COLORS.put("snow", 0xFFFAFA);
        COLORS.put("grey13", 0x212121);
        COLORS.put("green2", 60928);
        COLORS.put("green1", 65280);
        COLORS.put("plum4", 0x8B668B);
        COLORS.put("plum1", 0xFFBBFF);
        COLORS.put("thistle3", 13481421);
        COLORS.put("plum2", 0xEEAEEE);
        COLORS.put("thistle4", 0x8B7B8B);
        COLORS.put("plum3", 13473485);
        COLORS.put("thistle1", 0xFFE1FF);
        COLORS.put("ghostwhite", 0xF8F8FF);
        COLORS.put("thistle2", 0xEED2EE);
        COLORS.put("grey31", 0x4F4F4F);
        COLORS.put("grey30", 0x4D4D4D);
        COLORS.put("snow4", 0x8B8989);
        COLORS.put("grey33", 0x545454);
        COLORS.put("snow3", 0xCDC9C9);
        COLORS.put("grey32", 0x525252);
        COLORS.put("darkslategrey", 0x2F4F4F);
        COLORS.put("grey27", 0x454545);
        COLORS.put("grey28", 0x474747);
        COLORS.put("grey29", 0x4A4A4A);
        COLORS.put("snow1", 0xFFFAFA);
        COLORS.put("grey23", 0x3B3B3B);
        COLORS.put("gray100", 0xFFFFFF);
        COLORS.put("snow2", 0xEEE9E9);
        COLORS.put("grey24", 0x3D3D3D);
        COLORS.put("grey25", 0x404040);
        COLORS.put("grey26", 0x424242);
        COLORS.put("turquoise4", 34443);
        COLORS.put("turquoise3", 50637);
        COLORS.put("turquoise2", 58862);
        COLORS.put("turquoise1", 62975);
        COLORS.put("seashell2", 0xEEE5DE);
        COLORS.put("seashell1", 0xFFF5EE);
        COLORS.put("seashell4", 9143938);
        COLORS.put("seashell3", 13485503);
        COLORS.put("sienna", 10506797);
        COLORS.put("peru", 13468991);
        COLORS.put("orchid2", 15629033);
        COLORS.put("orchid1", 16745466);
        COLORS.put("lightsteelblue", 11584734);
        COLORS.put("orchid3", 13461961);
        COLORS.put("orchid4", 9127817);
        COLORS.put("gold", 16766720);
        COLORS.put("darkgray", 0xA9A9A9);
        COLORS.put("grey11", 0x1C1C1C);
        COLORS.put("grey10", 0x1A1A1A);
        COLORS.put("goldenrod1", 16761125);
        COLORS.put("chocolate4", 9127187);
        COLORS.put("goldenrod4", 9136404);
        COLORS.put("goldenrod3", 13474589);
        COLORS.put("goldenrod2", 15643682);
        COLORS.put("lightsalmon", 16752762);
        COLORS.put("chocolate1", 16744228);
        COLORS.put("chocolate3", 13461021);
        COLORS.put("chocolate2", 15627809);
        COLORS.put("grey65", 0xA6A6A6);
        COLORS.put("grey9", 0x171717);
        COLORS.put("grey66", 0xA8A8A8);
        COLORS.put("grey8", 0x141414);
        COLORS.put("grey63", 0xA1A1A1);
        COLORS.put("grey7", 0x121212);
        COLORS.put("grey64", 0xA3A3A3);
        COLORS.put("grey61", 0x9C9C9C);
        COLORS.put("grey62", 0x9E9E9E);
        COLORS.put("grey60", 0x999999);
        COLORS.put("grey2", 328965);
        COLORS.put("grey1", 197379);
        COLORS.put("grey0", 0);
        COLORS.put("grey6", 986895);
        COLORS.put("grey5", 855309);
        COLORS.put("grey4", 657930);
        COLORS.put("grey3", 526344);
        COLORS.put("darkblue", 139);
        COLORS.put("firebrick1", 0xFF3030);
        COLORS.put("firebrick2", 0xEE2C2C);
        COLORS.put("firebrick3", 13444646);
        COLORS.put("firebrick4", 9116186);
        COLORS.put("lightslateblue", 8679679);
        COLORS.put("grey59", 0x969696);
        COLORS.put("grey58", 0x949494);
        COLORS.put("grey57", 0x919191);
        COLORS.put("grey56", 0x8F8F8F);
        COLORS.put("grey74", 0xBDBDBD);
        COLORS.put("grey75", 0xBFBFBF);
        COLORS.put("lawngreen", 8190976);
        COLORS.put("grey76", 0xC2C2C2);
        COLORS.put("grey77", 0xC4C4C4);
        COLORS.put("grey70", 0xB3B3B3);
        COLORS.put("grey71", 0xB5B5B5);
        COLORS.put("grey72", 0xB8B8B8);
        COLORS.put("grey73", 0xBABABA);
        COLORS.put("mediumspringgreen", 64154);
        COLORS.put("lightsalmon4", 9131842);
        COLORS.put("mediumpurple3", 9005261);
        COLORS.put("lightsalmon1", 16752762);
        COLORS.put("mediumpurple4", 6113163);
        COLORS.put("gainsboro", 0xDCDCDC);
        COLORS.put("mediumpurple1", 11240191);
        COLORS.put("lightsalmon3", 13468002);
        COLORS.put("mediumpurple2", 10451438);
        COLORS.put("lightsalmon2", 15635826);
        COLORS.put("floralwhite", 0xFFFAF0);
        COLORS.put("bisque", 16770244);
        COLORS.put("lightgoldenrod4", 9142604);
        COLORS.put("grey68", 0xADADAD);
        COLORS.put("lightgoldenrod1", 16772235);
        COLORS.put("grey67", 0xABABAB);
        COLORS.put("lightgoldenrod2", 15654018);
        COLORS.put("lightgoldenrod3", 13483632);
        COLORS.put("grey69", 0xB0B0B0);
        COLORS.put("grey40", 0x666666);
        COLORS.put("grey43", 0x6E6E6E);
        COLORS.put("grey44", 0x707070);
        COLORS.put("grey41", 0x696969);
        COLORS.put("grey42", 0x6B6B6B);
        COLORS.put("lightseagreen", 2142890);
        COLORS.put("lightskyblue", 8900346);
        COLORS.put("grey37", 0x5E5E5E);
        COLORS.put("grey36", 0x5C5C5C);
        COLORS.put("grey35", 0x595959);
        COLORS.put("ivory", 0xFFFFF0);
        COLORS.put("grey34", 0x575757);
        COLORS.put("grey39", 0x636363);
        COLORS.put("grey38", 0x616161);
        COLORS.put("grey50", 0x7F7F7F);
        COLORS.put("grey51", 0x828282);
        COLORS.put("grey52", 0x858585);
        COLORS.put("grey53", 0x878787);
        COLORS.put("dimgray", 0x696969);
        COLORS.put("grey54", 0x8A8A8A);
        COLORS.put("grey55", 0x8C8C8C);
        COLORS.put("darkorange", 16747520);
        COLORS.put("indianred", 0xCD5C5C);
        COLORS.put("grey46", 0x757575);
        COLORS.put("grey45", 0x737373);
        COLORS.put("lightsteelblue3", 10663373);
        COLORS.put("grey48", 0x7A7A7A);
        COLORS.put("lightsteelblue4", 7240587);
        COLORS.put("grey47", 0x787878);
        COLORS.put("lightsteelblue1", 13296127);
        COLORS.put("lightsteelblue2", 12374766);
        COLORS.put("grey49", 0x7D7D7D);
        COLORS.put("gray32", 0x525252);
        COLORS.put("gray33", 0x545454);
        COLORS.put("rosybrown3", 13474715);
        COLORS.put("rosybrown4", 9136489);
        COLORS.put("gray31", 0x4F4F4F);
        COLORS.put("gray36", 0x5C5C5C);
        COLORS.put("gray37", 0x5E5E5E);
        COLORS.put("gray34", 0x575757);
        COLORS.put("hotpink2", 15624871);
        COLORS.put("lightgoldenrod", 15654274);
        COLORS.put("hotpink1", 16740020);
        COLORS.put("gray38", 0x616161);
        COLORS.put("gray39", 0x636363);
        COLORS.put("blanchedalmond", 16772045);
        COLORS.put("tomato4", 9123366);
        COLORS.put("tomato3", 13455161);
        COLORS.put("tomato2", 15621186);
        COLORS.put("darkkhaki", 12433259);
        COLORS.put("yellow4", 0x8B8B00);
        COLORS.put("hotpink3", 13459600);
        COLORS.put("hotpink4", 9124450);
        COLORS.put("tomato1", 16737095);
        COLORS.put("lightgrey", 0xD3D3D3);
        COLORS.put("lavenderblush2", 0xEEE0E5);
        COLORS.put("gray41", 0x696969);
        COLORS.put("lavenderblush1", 0xFFF0F5);
        COLORS.put("gray42", 0x6B6B6B);
        COLORS.put("lavenderblush4", 9143174);
        COLORS.put("gray43", 0x6E6E6E);
        COLORS.put("lavenderblush3", 13484485);
        COLORS.put("gray44", 0x707070);
        COLORS.put("gray46", 0x757575);
        COLORS.put("gray47", 0x787878);
        COLORS.put("gray48", 0x7A7A7A);
        COLORS.put("gray49", 0x7D7D7D);
        COLORS.put("skyblue3", 7120589);
        COLORS.put("lightyellow1", 0xFFFFE0);
        COLORS.put("skyblue4", 4878475);
        COLORS.put("navajowhite1", 16768685);
        COLORS.put("navajowhite2", 15650721);
        COLORS.put("navajowhite3", 13480843);
        COLORS.put("mediumturquoise", 4772300);
        COLORS.put("aliceblue", 0xF0F8FF);
        COLORS.put("navajowhite4", 9140574);
        COLORS.put("skyblue1", 8900351);
        COLORS.put("lightyellow3", 13487540);
        COLORS.put("skyblue2", 8306926);
        COLORS.put("lightyellow2", 0xEEEED1);
        COLORS.put("rosybrown2", 0xEEB4B4);
        COLORS.put("burlywood", 14596231);
        COLORS.put("gray51", 0x828282);
        COLORS.put("rosybrown1", 0xFFC1C1);
        COLORS.put("lightyellow4", 9145210);
        COLORS.put("gray50", 0x7F7F7F);
        COLORS.put("gray58", 0x949494);
        COLORS.put("gray59", 0x969696);
        COLORS.put("gray56", 0x8F8F8F);
        COLORS.put("gray57", 0x919191);
        COLORS.put("gray54", 0x8A8A8A);
        COLORS.put("gray52", 0x858585);
        COLORS.put("cornsilk", 16775388);
        COLORS.put("gray53", 0x878787);
        COLORS.put("rosybrown", 12357519);
        COLORS.put("chartreuse", 0x7FFF00);
        COLORS.put("firebrick", 0xB22222);
        COLORS.put("gray62", 0x9E9E9E);
        COLORS.put("gray61", 0x9C9C9C);
        COLORS.put("yellow3", 0xCDCD00);
        COLORS.put("olivedrab3", 10145074);
        COLORS.put("gray67", 0xABABAB);
        COLORS.put("yellow2", 0xEEEE00);
        COLORS.put("olivedrab2", 11791930);
        COLORS.put("gray68", 0xADADAD);
        COLORS.put("yellow1", 0xFFFF00);
        COLORS.put("gray69", 0xB0B0B0);
        COLORS.put("olivedrab4", 6916898);
        COLORS.put("gray63", 0xA1A1A1);
        COLORS.put("gray64", 0xA3A3A3);
        COLORS.put("indianred1", 0xFF6A6A);
        COLORS.put("gray66", 0xA8A8A8);
        COLORS.put("palevioletred4", 9127773);
        COLORS.put("darkslategray2", 0x8DEEEE);
        COLORS.put("indianred3", 0xCD5555);
        COLORS.put("darkslategray3", 7982541);
        COLORS.put("indianred2", 0xEE6363);
        COLORS.put("darkslategray4", 5409675);
        COLORS.put("indianred4", 9124410);
        COLORS.put("palevioletred1", 16745131);
        COLORS.put("palevioletred2", 15628703);
        COLORS.put("olivedrab1", 12648254);
        COLORS.put("palevioletred3", 13461641);
        COLORS.put("darkslategray1", 0x97FFFF);
        COLORS.put("dimgrey", 0x696969);
        COLORS.put("gray71", 0xB5B5B5);
        COLORS.put("gray73", 0xBABABA);
        COLORS.put("mediumaquamarine", 6737322);
        COLORS.put("gray72", 0xB8B8B8);
        COLORS.put("gray77", 0xC4C4C4);
        COLORS.put("gray76", 0xC2C2C2);
        COLORS.put("gray74", 0xBDBDBD);
        COLORS.put("deepskyblue", 49151);
        COLORS.put("gray79", 0xC9C9C9);
        COLORS.put("gray78", 0xC7C7C7);
        COLORS.put("gray83", 0xD4D4D4);
        COLORS.put("gray84", 0xD6D6D6);
        COLORS.put("gray81", 0xCFCFCF);
        COLORS.put("gray82", 0xD1D1D1);
        COLORS.put("lightgray", 0xD3D3D3);
        COLORS.put("maroon2", 15610023);
        COLORS.put("maroon3", 13445520);
        COLORS.put("maroon1", 16725171);
        COLORS.put("lightpink", 16758465);
        COLORS.put("maroon4", 9116770);
        COLORS.put("slateblue", 6970061);
        COLORS.put("lemonchiffon1", 16775885);
        COLORS.put("gray86", 0xDBDBDB);
        COLORS.put("orange4", 9132544);
        COLORS.put("orange3", 13468928);
        COLORS.put("lemonchiffon3", 13486501);
        COLORS.put("gray88", 0xE0E0E0);
        COLORS.put("orange2", 15636992);
        COLORS.put("lemonchiffon2", 15657407);
        COLORS.put("gray87", 0xDEDEDE);
        COLORS.put("orange1", 16753920);
        COLORS.put("lemonchiffon4", 9144688);
        COLORS.put("gray89", 0xE3E3E3);
        COLORS.put("darkgreen", 25600);
        COLORS.put("darkslategray", 0x2F4F4F);
        COLORS.put("gray91", 0xE8E8E8);
        COLORS.put("lightpink3", 13470869);
        COLORS.put("crimson", 14423100);
        COLORS.put("gray92", 0xEBEBEB);
        COLORS.put("lightpink2", 15639213);
        COLORS.put("lemonchiffon", 16775885);
        COLORS.put("gray93", 0xEDEDED);
        COLORS.put("lightpink1", 16756409);
        COLORS.put("gray94", 0xF0F0F0);
        COLORS.put("seashell", 0xFFF5EE);
        COLORS.put("pink2", 15641016);
        COLORS.put("magenta1", 0xFF00FF);
        COLORS.put("pink3", 13472158);
        COLORS.put("magenta2", 0xEE00EE);
        COLORS.put("pink4", 9134956);
        COLORS.put("magenta3", 0xCD00CD);
        COLORS.put("magenta4", 0x8B008B);
        COLORS.put("lightpink4", 9133925);
        COLORS.put("pink1", 16758213);
        COLORS.put("antiquewhite2", 15654860);
        COLORS.put("antiquewhite3", 13484208);
        COLORS.put("antiquewhite4", 9143160);
        COLORS.put("antiquewhite1", 16773083);
        COLORS.put("deeppink", 16716947);
        COLORS.put("gray99", 0xFCFCFC);
        COLORS.put("gray98", 0xFAFAFA);
        COLORS.put("gray97", 0xF7F7F7);
        COLORS.put("gray96", 0xF5F5F5);
        COLORS.put("whitesmoke", 0xF5F5F5);
        COLORS.put("wheat", 16113331);
        COLORS.put("olivedrab", 7048739);
        COLORS.put("mediumblue", 205);
        COLORS.put("wheat4", 9141862);
        COLORS.put("darkgrey", 0xA9A9A9);
        COLORS.put("wheat3", 13482646);
        COLORS.put("wheat2", 15653038);
        COLORS.put("wheat1", 16771002);
        COLORS.put("deepskyblue3", 39629);
        COLORS.put("steelblue", 4620980);
        COLORS.put("deepskyblue4", 26763);
        COLORS.put("deepskyblue1", 49151);
        COLORS.put("deepskyblue2", 45806);
    }
}

