/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.impl;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.Container;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.EdgeDirection;
import org.gephi.io.importer.api.EdgeDirectionDefault;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.EdgeMergeStrategy;
import org.gephi.io.importer.api.ElementDraft;
import org.gephi.io.importer.api.ElementIdType;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.impl.ColumnDraftImpl;
import org.gephi.io.importer.impl.EdgeDraftImpl;
import org.gephi.io.importer.impl.ElementDraftImpl;
import org.gephi.io.importer.impl.ElementFactoryImpl;
import org.gephi.io.importer.impl.ImportContainerParameters;
import org.gephi.io.importer.impl.NodeDraftImpl;
import org.joda.time.DateTimeZone;
import org.openide.util.NbBundle;

public class ImportContainerImpl
implements Container,
ContainerLoader,
ContainerUnloader {
    protected static final int NULL_INDEX = -1;
    private String source;
    private final ElementFactoryImpl factory;
    private final ImportContainerParameters parameters;
    private final ObjectList<NodeDraftImpl> nodeList;
    private final ObjectList<EdgeDraftImpl> edgeList;
    private final Object2IntMap<String> nodeMap;
    private final Object2IntMap<String> edgeMap;
    private final Object2IntMap edgeTypeMap;
    private Class lastEdgeType;
    private Long2ObjectMap<int[]>[] edgeTypeSets;
    private EdgeDirectionDefault edgeDefault = EdgeDirectionDefault.MIXED;
    private final Object2ObjectMap<String, ColumnDraft> nodeColumns;
    private final Object2ObjectMap<String, ColumnDraft> edgeColumns;
    private ElementIdType elementIdType = ElementIdType.STRING;
    private boolean dynamicGraph = false;
    private boolean dynamicAttributes = false;
    private Report report;
    private int directedEdgesCount = 0;
    private int undirectedEdgesCount = 0;
    private int selfLoops = 0;
    private TimeFormat timeFormat = TimeFormat.DOUBLE;
    private TimeRepresentation timeRepresentation = TimeRepresentation.INTERVAL;
    private DateTimeZone timeZone = DateTimeZone.getDefault();
    private Double timestamp;
    private Interval interval;
    private boolean reportedUnknownNode;
    private boolean reportedParallelEdges;

    public ImportContainerImpl() {
        this.parameters = new ImportContainerParameters();
        this.nodeMap = new Object2IntOpenHashMap<String>();
        this.edgeMap = new Object2IntOpenHashMap<String>();
        this.nodeMap.defaultReturnValue(-1);
        this.edgeMap.defaultReturnValue(-1);
        this.nodeList = new ObjectArrayList<NodeDraftImpl>();
        this.edgeList = new ObjectArrayList<EdgeDraftImpl>();
        this.edgeTypeMap = new Object2IntOpenHashMap();
        this.edgeTypeSets = new Long2ObjectMap[0];
        this.factory = new ElementFactoryImpl(this);
        this.nodeColumns = new Object2ObjectLinkedOpenHashMap<String, ColumnDraft>();
        this.edgeColumns = new Object2ObjectLinkedOpenHashMap<String, ColumnDraft>();
    }

    @Override
    public ContainerLoader getLoader() {
        return this;
    }

    @Override
    public synchronized ContainerUnloader getUnloader() {
        return this;
    }

    @Override
    public ElementFactoryImpl factory() {
        return this.factory;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public void addNode(NodeDraft nodeDraft) {
        this.checkElementDraftImpl(nodeDraft);
        NodeDraftImpl nodeDraftImpl = (NodeDraftImpl)nodeDraft;
        if (this.nodeMap.containsKey(nodeDraftImpl.getId())) {
            String message = NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_nodeExist", nodeDraftImpl.getId());
            this.report.logIssue(new Issue(message, Issue.Level.WARNING));
            return;
        }
        int index = this.nodeList.size();
        this.nodeList.add(nodeDraftImpl);
        this.nodeMap.put(nodeDraftImpl.getId(), index);
    }

    @Override
    public NodeDraftImpl getNode(String id) {
        this.checkId(id);
        int index = this.nodeMap.getInt(id);
        NodeDraftImpl node = null;
        if (index == -1) {
            if (this.parameters.isAutoNode()) {
                node = this.factory.newNodeDraft(id);
                this.addNode(node);
                node.setCreatedAuto(true);
                if (!this.reportedUnknownNode) {
                    String message = NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_AutoNodeCreated");
                    this.report.logIssue(new Issue(message, Issue.Level.INFO));
                    this.reportedUnknownNode = true;
                }
            } else {
                String message = NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_UnknowNodeId", id);
                this.report.logIssue(new Issue(message, Issue.Level.SEVERE));
            }
        } else {
            node = (NodeDraftImpl)this.nodeList.get(index);
        }
        return node;
    }

    @Override
    public boolean nodeExists(String id) {
        this.checkId(id);
        return this.nodeMap.containsKey(id);
    }

    @Override
    public boolean edgeExists(String source, String target) {
        this.checkId(source);
        this.checkId(target);
        NodeDraftImpl sourceNode = this.getNode(source);
        NodeDraftImpl targetNode = this.getNode(target);
        if (sourceNode != null && targetNode != null) {
            boolean undirected = this.edgeDefault.equals((Object)EdgeDirectionDefault.UNDIRECTED) || this.undirectedEdgesCount > 0 && this.directedEdgesCount == 0;
            long edgeId = this.getLongId(sourceNode, targetNode, !undirected);
            for (Long2ObjectMap<int[]> l : this.edgeTypeSets) {
                if (l == null || !l.containsKey(edgeId)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void addEdge(EdgeDraft edgeDraft) {
        EdgeDirection direction;
        this.checkElementDraftImpl(edgeDraft);
        EdgeDraftImpl edgeDraftImpl = (EdgeDraftImpl)edgeDraft;
        if (edgeDraftImpl.getSource() == null) {
            String message = NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_MissingNodeSource");
            this.report.logIssue(new Issue(message, Issue.Level.SEVERE));
            return;
        }
        if (edgeDraftImpl.getTarget() == null) {
            String message = NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_MissingNodeTarget");
            this.report.logIssue(new Issue(message, Issue.Level.SEVERE));
            return;
        }
        if (this.edgeMap.containsKey(edgeDraftImpl.getId())) {
            String message = NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_edgeExist", edgeDraftImpl.getId());
            this.report.logIssue(new Issue(message, Issue.Level.WARNING));
            return;
        }
        if (edgeDraftImpl.isSelfLoop() && !this.parameters.isSelfLoops()) {
            String message = NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_SelfLoop");
            this.report.logIssue(new Issue(message, Issue.Level.SEVERE));
            return;
        }
        if (edgeDraftImpl.getDirection() != null) {
            switch (this.edgeDefault) {
                case DIRECTED: {
                    if (!edgeDraftImpl.getDirection().equals((Object)EdgeDirection.UNDIRECTED)) break;
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Bad_Edge_Type", (Object)this.edgeDefault, edgeDraftImpl.getId()), Issue.Level.SEVERE));
                    return;
                }
                case UNDIRECTED: {
                    if (!edgeDraftImpl.getDirection().equals((Object)EdgeDirection.DIRECTED)) break;
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Bad_Edge_Type", (Object)this.edgeDefault, edgeDraftImpl.getId()), Issue.Level.SEVERE));
                    return;
                }
            }
        }
        int index = this.edgeList.size();
        int edgeType = this.getEdgeType(edgeDraftImpl.getType());
        long sourceTargetLong = this.getLongId(edgeDraftImpl);
        this.ensureLongSetArraySize(edgeType);
        Long2ObjectMap<int[]> edgeTypeSet = this.edgeTypeSets[edgeType];
        if (edgeTypeSet.containsKey(sourceTargetLong)) {
            if (!this.parameters.isParallelEdges()) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Parallel_Edge_Forbidden", edgeDraftImpl.getId()), Issue.Level.SEVERE));
                return;
            }
            int[] edges = (int[])edgeTypeSet.get(sourceTargetLong);
            int[] newEdges = new int[edges.length + 1];
            newEdges[edges.length] = index;
            System.arraycopy(edges, 0, newEdges, 0, edges.length);
            edgeTypeSet.put(sourceTargetLong, newEdges);
            if (!this.reportedParallelEdges) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Parallel_Edge_Merged", edgeDraftImpl.getId()), Issue.Level.INFO));
                this.reportedParallelEdges = true;
            }
        } else {
            edgeTypeSet.put(sourceTargetLong, new int[]{index});
        }
        if (edgeDraftImpl.isSelfLoop()) {
            ++this.selfLoops;
        }
        if ((direction = edgeDraftImpl.getDirection()) != null) {
            switch (direction) {
                case DIRECTED: {
                    ++this.directedEdgesCount;
                    break;
                }
                case UNDIRECTED: {
                    ++this.undirectedEdgesCount;
                }
            }
        }
        this.edgeList.add(edgeDraftImpl);
        this.edgeMap.put(edgeDraft.getId(), index);
    }

    @Override
    public void removeEdge(EdgeDraft edgeDraft) {
        this.checkElementDraftImpl(edgeDraft);
        EdgeDraftImpl edgeDraftImpl = (EdgeDraftImpl)edgeDraft;
        String id = edgeDraftImpl.getId();
        if (!this.edgeMap.containsKey(id)) {
            return;
        }
        if (edgeDraftImpl.getDirection() != null) {
            switch (edgeDraftImpl.getDirection()) {
                case DIRECTED: {
                    --this.directedEdgesCount;
                    break;
                }
                case UNDIRECTED: {
                    --this.undirectedEdgesCount;
                }
            }
        }
        if (edgeDraftImpl.isSelfLoop()) {
            --this.selfLoops;
        }
        int edgeType = this.getEdgeType(edgeDraftImpl.getType());
        long sourceTargetLong = this.getLongId(edgeDraftImpl);
        this.ensureLongSetArraySize(edgeType);
        Long2ObjectMap<int[]> edgeTypeSet = this.edgeTypeSets[edgeType];
        int index = this.edgeMap.remove(id);
        int[] edges = (int[])edgeTypeSet.remove(sourceTargetLong);
        if (edges.length > 1) {
            int[] newEdges = new int[edges.length - 1];
            int i = 0;
            for (int e : edges) {
                if (e == index) continue;
                newEdges[i++] = e;
            }
            edgeTypeSet.put(sourceTargetLong, newEdges);
        }
        this.edgeList.set(index, null);
    }

    @Override
    public boolean edgeExists(String id) {
        this.checkId(id);
        return this.edgeMap.containsKey(id);
    }

    @Override
    public EdgeDraft getEdge(String id) {
        this.checkId(id);
        int index = this.edgeMap.getInt(id);
        if (index == -1) {
            return null;
        }
        return (EdgeDraft)this.edgeList.get(index);
    }

    @Override
    public Iterable<NodeDraft> getNodes() {
        return new NullFilterIterable<NodeDraft>(this.nodeList);
    }

    @Override
    public int getNodeCount() {
        return this.nodeMap.size();
    }

    @Override
    public Iterable<EdgeDraft> getEdges() {
        return new NullFilterIterable<EdgeDraft>(this.edgeList);
    }

    @Override
    public int getEdgeCount() {
        return this.edgeMap.size();
    }

    @Override
    public TimeFormat getTimeFormat() {
        return this.timeFormat;
    }

    @Override
    public void setTimeFormat(TimeFormat timeFormat) {
        this.timeFormat = timeFormat;
    }

    @Override
    public TimeRepresentation getTimeRepresentation() {
        return this.timeRepresentation;
    }

    @Override
    public void setTimeRepresentation(TimeRepresentation timeRepresentation) {
        this.timeRepresentation = timeRepresentation;
    }

    @Override
    public DateTimeZone getTimeZone() {
        return this.timeZone;
    }

    @Override
    public void setTimeZone(DateTimeZone timeZone) {
        this.timeZone = timeZone;
    }

    @Override
    public ColumnDraft addNodeColumn(String key, Class typeClass) {
        if (AttributeUtils.isDynamicType(typeClass)) {
            if (TimeSet.class.isAssignableFrom(typeClass)) {
                return this.addNodeColumn(key, typeClass, true);
            }
            return this.addNodeColumn(key, AttributeUtils.getStaticType(typeClass), true);
        }
        return this.addNodeColumn(key, typeClass, false);
    }

    @Override
    public ColumnDraft addNodeColumn(String key, Class typeClass, boolean dynamic) {
        key = key.toLowerCase().trim();
        ColumnDraft column = (ColumnDraft)this.nodeColumns.get(key);
        typeClass = AttributeUtils.getStandardizedType(typeClass);
        if (column == null) {
            int index = this.nodeColumns.size();
            column = new ColumnDraftImpl(key, index, dynamic, typeClass);
            this.nodeColumns.put(key, column);
            if (dynamic) {
                this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.AddDynamicNodeColumn", key, typeClass.getSimpleName()));
            } else {
                this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.AddNodeColumn", key, typeClass.getSimpleName()));
            }
        } else if (!column.getTypeClass().equals(typeClass)) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Column_Type_Mismatch", key, column.getTypeClass()), Issue.Level.SEVERE));
        }
        return column;
    }

    @Override
    public ColumnDraft addEdgeColumn(String key, Class typeClass) {
        if (AttributeUtils.isDynamicType(typeClass)) {
            if (TimeSet.class.isAssignableFrom(typeClass)) {
                return this.addEdgeColumn(key, typeClass, true);
            }
            return this.addEdgeColumn(key, AttributeUtils.getStaticType(typeClass), true);
        }
        return this.addEdgeColumn(key, typeClass, false);
    }

    @Override
    public ColumnDraft addEdgeColumn(String key, Class typeClass, boolean dynamic) {
        key = key.toLowerCase().trim();
        ColumnDraft column = (ColumnDraft)this.edgeColumns.get(key);
        typeClass = AttributeUtils.getStandardizedType(typeClass);
        if (column == null) {
            int index = this.edgeColumns.size();
            column = new ColumnDraftImpl(key, index, dynamic, typeClass);
            this.edgeColumns.put(key, column);
            if (dynamic) {
                this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.AddDynamicEdgeColumn", key, typeClass.getSimpleName()));
            } else {
                this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.AddEdgeColumn", key, typeClass.getSimpleName()));
            }
        } else if (!column.getTypeClass().equals(typeClass)) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Column_Type_Mismatch", key, column.getTypeClass()), Issue.Level.SEVERE));
        }
        return column;
    }

    @Override
    public ColumnDraft getNodeColumn(String key) {
        return (ColumnDraft)this.nodeColumns.get(key.toLowerCase());
    }

    @Override
    public boolean hasNodeColumn(String key) {
        return this.nodeColumns.containsKey(key.toLowerCase());
    }

    @Override
    public ColumnDraft getEdgeColumn(String key) {
        return (ColumnDraft)this.edgeColumns.get(key.toLowerCase());
    }

    @Override
    public boolean hasEdgeColumn(String key) {
        return this.edgeColumns.containsKey(key.toLowerCase());
    }

    @Override
    public Iterable<ColumnDraft> getNodeColumns() {
        return this.nodeColumns.values();
    }

    @Override
    public Iterable<ColumnDraft> getEdgeColumns() {
        return this.edgeColumns.values();
    }

    @Override
    public void setTimestamp(String timestamp) {
        try {
            double t = this.timeFormat.equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(timestamp) : AttributeUtils.parseDateTime(timestamp);
            this.timestamp = t;
        }
        catch (Exception e) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Timestamp_Parse_Error", timestamp), Issue.Level.SEVERE));
            return;
        }
        this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.GraphTimestamp", timestamp));
    }

    @Override
    public void setInterval(String startDateTime, String endDateTime) {
        try {
            double start;
            if (startDateTime == null || startDateTime.trim().isEmpty() || "-inf".equalsIgnoreCase(startDateTime) || "-infinity".equalsIgnoreCase(startDateTime)) {
                start = Double.NEGATIVE_INFINITY;
            } else {
                double d = start = this.timeFormat.equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(startDateTime) : AttributeUtils.parseDateTime(startDateTime);
            }
            double end = endDateTime == null || endDateTime.trim().isEmpty() || "inf".equalsIgnoreCase(endDateTime) || "infinity".equalsIgnoreCase(endDateTime) ? Double.POSITIVE_INFINITY : (this.timeFormat.equals((Object)TimeFormat.DOUBLE) ? Double.parseDouble(endDateTime) : AttributeUtils.parseDateTime(endDateTime));
            this.interval = new Interval(start, end);
        }
        catch (Exception e) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Interval_Parse_Error", "[" + startDateTime + "," + endDateTime + "]"), Issue.Level.SEVERE));
            return;
        }
        this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.GraphInterval", "[" + startDateTime + "," + endDateTime + "]"));
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public Double getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setElementIdType(ElementIdType type) {
        if (this.elementIdType != type) {
            this.elementIdType = type;
            this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.ElementIdType", this.elementIdType.toString()));
        }
    }

    @Override
    public ElementIdType getElementIdType() {
        return this.elementIdType;
    }

    @Override
    public boolean verify() {
        for (EdgeDraftImpl edge : new NullFilterIterable(this.edgeList)) {
            String id = edge.getId();
            if (edge.getWeight() < 0.0) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Negative_Weight", id), Issue.Level.WARNING));
                continue;
            }
            if (edge.getWeight() != 0.0) continue;
            this.removeEdge(edge);
            this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Weight_Zero_Ignored", id), Issue.Level.SEVERE));
        }
        if (this.directedEdgesCount > 0 && this.undirectedEdgesCount == 0) {
            this.setEdgeDefault(EdgeDirectionDefault.DIRECTED);
        } else if (this.directedEdgesCount == 0 && this.undirectedEdgesCount > 0) {
            this.setEdgeDefault(EdgeDirectionDefault.UNDIRECTED);
        } else if (this.directedEdgesCount > 0 && this.undirectedEdgesCount > 0) {
            this.setEdgeDefault(EdgeDirectionDefault.MIXED);
        }
        if (this.elementIdType.equals((Object)ElementIdType.INTEGER) || this.elementIdType.equals((Object)ElementIdType.LONG)) {
            try {
                for (NodeDraftImpl node : this.nodeList) {
                    if (this.elementIdType.equals((Object)ElementIdType.INTEGER)) {
                        Integer.parseInt(node.getId());
                        continue;
                    }
                    if (!this.elementIdType.equals((Object)ElementIdType.LONG)) continue;
                    Long.parseLong(node.getId());
                }
                for (EdgeDraftImpl edge : this.edgeList) {
                    if (this.elementIdType.equals((Object)ElementIdType.INTEGER)) {
                        Integer.parseInt(edge.getId());
                        continue;
                    }
                    if (!this.elementIdType.equals((Object)ElementIdType.LONG)) continue;
                    Long.parseLong(edge.getId());
                }
            }
            catch (NumberFormatException e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_ElementIdType_Parse_Error", (Object)this.elementIdType), Issue.Level.WARNING));
                this.elementIdType = ElementIdType.STRING;
            }
        }
        for (NodeDraftImpl node : this.nodeList) {
            if (node == null) continue;
            if (node.isDynamic()) {
                this.dynamicGraph = true;
            }
            if (!node.hasDynamicAttributes()) continue;
            this.dynamicAttributes = true;
        }
        for (EdgeDraftImpl edge : this.edgeList) {
            if (edge == null) continue;
            if (edge.isDynamic()) {
                this.dynamicGraph = true;
            }
            if (!edge.hasDynamicAttributes()) continue;
            this.dynamicAttributes = true;
        }
        if (this.dynamicGraph) {
            this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.TimeFormat", this.timeFormat.toString()));
            this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.TimeRepresentation", this.timeRepresentation.toString()));
            this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.TimeZone", this.timeZone.toString()));
        }
        if (this.lastEdgeType != null) {
            this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.EdgeLabelType", this.lastEdgeType.getSimpleName()));
        }
        if (this.isMultiGraph()) {
            this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerLog.MultiGraphCount", this.edgeTypeMap.size() - 1));
        }
        return true;
    }

    @Override
    public void closeLoader() {
        if (!this.parameters.isSelfLoops() && this.selfLoops > 0) {
            ArrayList l = new ArrayList();
            for (EdgeDraftImpl e : this.edgeList) {
                if (e == null || !e.isSelfLoop()) continue;
                l.add(e);
            }
            Iterator iterator = l.iterator();
            while (iterator.hasNext()) {
                EdgeDraftImpl e;
                e = (EdgeDraftImpl)iterator.next();
                this.removeEdge(e);
            }
        }
        if (this.directedEdgesCount > 0 && this.edgeDefault.equals((Object)EdgeDirectionDefault.UNDIRECTED)) {
            for (EdgeDraftImpl edge : this.edgeList.toArray(new EdgeDraftImpl[0])) {
                EdgeDraftImpl opposite;
                if (edge == null || !edge.getDirection().equals((Object)EdgeDirection.DIRECTED) || (opposite = this.getOpposite(edge)) == null) continue;
                int oppositeIndex = this.edgeMap.getInt(opposite.getId());
                this.mergeDirectedEdges(opposite, edge);
                this.edgeMap.removeInt(opposite.getId());
                this.edgeList.set(oppositeIndex, null);
            }
        }
        if (!this.allowAutoNode()) {
            for (NodeDraftImpl node : this.nodeList) {
                if (node == null || !node.isCreatedAuto()) continue;
                int index = this.nodeMap.removeInt(node.getId());
                this.nodeList.set(index, null);
            }
            for (EdgeDraftImpl edge : this.edgeList) {
                if (edge == null || !edge.getSource().isCreatedAuto() && !edge.getTarget().isCreatedAuto()) continue;
                int index = this.edgeMap.remove(edge.getId());
                this.edgeList.set(index, null);
            }
        }
        if (this.parameters.isSortNodesBySize()) {
            Collections.sort(this.nodeList, new Comparator<NodeDraftImpl>(){

                @Override
                public int compare(NodeDraftImpl o1, NodeDraftImpl o2) {
                    return new Float(o2 != null ? o2.getSize() : 0.0f).compareTo(Float.valueOf(o1 != null ? o1.getSize() : 0.0f));
                }
            });
        }
        if (this.parameters.isFillLabelWithId()) {
            for (NodeDraftImpl node : this.nodeList) {
                if (node == null || node.getLabel() != null) continue;
                node.setLabel(node.getId());
            }
        }
        boolean customPosition = false;
        for (NodeDraftImpl node : this.nodeList) {
            if (node == null) continue;
            if (Float.isNaN(node.getX())) {
                node.setX(0.0f);
            }
            if (Float.isNaN(node.getY())) {
                node.setY(0.0f);
            }
            if (Float.isNaN(node.getZ())) {
                node.setZ(0.0f);
            }
            if (node.getX() == 0.0f && node.getY() == 0.0f) continue;
            customPosition = true;
        }
        if (!customPosition) {
            for (NodeDraftImpl node : this.nodeList) {
                if (node == null) continue;
                node.setX((float)((0.01 + Math.random()) * 1000.0) - 500.0f);
                node.setY((float)((0.01 + Math.random()) * 1000.0) - 500.0f);
            }
        }
    }

    protected void mergeDirectedEdges(EdgeDraftImpl source, EdgeDraftImpl dest) {
        EdgeMergeStrategy mergeStrategy = this.parameters.getEdgesMergeStrategy();
        double result = dest.getWeight();
        switch (mergeStrategy) {
            case AVG: {
                result = (source.getWeight() + dest.getWeight()) / 2.0;
                break;
            }
            case MAX: {
                result = Math.max(source.getWeight(), dest.getWeight());
                break;
            }
            case MIN: {
                result = Math.min(source.getWeight(), dest.getWeight());
                break;
            }
            case SUM: {
                result = source.getWeight() + dest.getWeight();
                break;
            }
            case FIRST: {
                result = dest.getWeight();
                break;
            }
            case LAST: {
                result = source.getWeight();
                break;
            }
        }
        dest.setWeight(result);
    }

    @Override
    public boolean isDynamicGraph() {
        return this.dynamicGraph;
    }

    @Override
    public boolean hasDynamicAttributes() {
        return this.dynamicAttributes;
    }

    @Override
    public Report getReport() {
        return this.report;
    }

    @Override
    public void setReport(Report report) {
        this.report = report;
    }

    @Override
    public boolean allowAutoNode() {
        return this.parameters.isAutoNode();
    }

    @Override
    public boolean allowParallelEdges() {
        return this.parameters.isParallelEdges();
    }

    @Override
    public boolean allowSelfLoop() {
        return this.parameters.isSelfLoops();
    }

    @Override
    public boolean isFillLabelWithId() {
        return this.parameters.isFillLabelWithId();
    }

    @Override
    public EdgeMergeStrategy getEdgesMergeStrategy() {
        return this.parameters.getEdgesMergeStrategy();
    }

    @Override
    public EdgeDirectionDefault getEdgeDefault() {
        return this.edgeDefault;
    }

    @Override
    public boolean isMultiGraph() {
        return this.edgeTypeMap.size() > 1;
    }

    @Override
    public boolean hasSelfLoops() {
        return this.selfLoops > 0;
    }

    @Override
    public void setAllowAutoNode(boolean value) {
        this.parameters.setAutoNode(value);
    }

    @Override
    public void setAllowParallelEdge(boolean value) {
        this.parameters.setParallelEdges(value);
    }

    @Override
    public void setAllowSelfLoop(boolean value) {
        this.parameters.setSelfLoops(value);
    }

    @Override
    public void setFillLabelWithId(boolean value) {
        this.parameters.setFillLabelWithId(value);
    }

    @Override
    public void setEdgeDefault(EdgeDirectionDefault edgeDefault) {
        if (this.edgeDefault != edgeDefault) {
            this.edgeDefault = edgeDefault;
            this.report.log(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Set_EdgeDefault", edgeDefault.toString()));
        }
    }

    @Override
    public boolean isAutoScale() {
        return this.parameters.isAutoScale();
    }

    @Override
    public void setAutoScale(boolean autoscale) {
        this.parameters.setAutoScale(autoscale);
    }

    @Override
    public void setEdgesMergeStrategy(EdgeMergeStrategy edgesMergeStrategy) {
        this.parameters.setEdgesMergeStrategy(edgesMergeStrategy);
    }

    @Override
    public Class getEdgeTypeLabelClass() {
        return this.lastEdgeType;
    }

    private int getEdgeType(Object type) {
        if (type != null) {
            Class<?> cl = type.getClass();
            if (!(cl.equals(Integer.class) || cl.equals(String.class) || cl.equals(Float.class) || cl.equals(Double.class) || cl.equals(Short.class) || cl.equals(Byte.class) || cl.equals(Long.class) || cl.equals(Character.class) || cl.equals(Boolean.class))) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Unsupported_Edge_type"), Issue.Level.SEVERE));
                type = null;
            }
            if (type != null && this.lastEdgeType != null && !this.lastEdgeType.equals(type.getClass())) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImportContainerImpl.class, "ImportContainerException_Unsupported_Edge_type_Conflict", type.getClass().getSimpleName(), this.lastEdgeType.getSimpleName()), Issue.Level.SEVERE));
                type = null;
            }
        }
        if (type != null) {
            this.lastEdgeType = type.getClass();
        }
        if (this.edgeTypeMap.containsKey(type)) {
            return this.edgeTypeMap.getInt(type);
        }
        int id = this.edgeTypeMap.size();
        this.edgeTypeMap.put(type, id);
        return id;
    }

    private void ensureLongSetArraySize(int type) {
        if (this.edgeTypeSets.length <= type) {
            Long2ObjectMap[] l = new Long2ObjectMap[type + 1];
            System.arraycopy(this.edgeTypeSets, 0, l, 0, this.edgeTypeSets.length);
            this.edgeTypeSets = l;
            this.edgeTypeSets[type] = new Long2ObjectOpenHashMap<int[]>();
        }
    }

    private long getLongId(EdgeDraftImpl edge) {
        EdgeDirection direction = edge.getDirection();
        boolean directed = this.edgeDefault.equals((Object)EdgeDirectionDefault.DIRECTED) || this.edgeDefault.equals((Object)EdgeDirectionDefault.MIXED) && direction != EdgeDirection.UNDIRECTED;
        return this.getLongId(edge.getSource(), edge.getTarget(), directed);
    }

    private long getLongId(NodeDraftImpl source, NodeDraftImpl target, boolean directed) {
        if (directed) {
            long edgeId = (long)source.hashCode() << 32;
            return edgeId |= (long)target.hashCode();
        }
        long edgeId = (long)(source.hashCode() > target.hashCode() ? source.hashCode() : target.hashCode()) << 32;
        return edgeId |= (long)(source.hashCode() > target.hashCode() ? target.hashCode() : source.hashCode());
    }

    private EdgeDraftImpl getOpposite(EdgeDraftImpl edge) {
        long longId;
        Long2ObjectMap<int[]> typeSet = this.edgeTypeSets[this.getEdgeType(edge.getType())];
        int[] opposites = (int[])typeSet.get(longId = this.getLongId(edge.getTarget(), edge.getSource(), true));
        if (opposites != null && opposites.length > 0) {
            return (EdgeDraftImpl)this.edgeList.get(opposites[0]);
        }
        return null;
    }

    private void checkElementDraftImpl(ElementDraft elmt) {
        if (elmt == null) {
            throw new NullPointerException();
        }
        if (!(elmt instanceof ElementDraftImpl)) {
            throw new ClassCastException();
        }
    }

    private void checkId(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (id.trim().isEmpty()) {
            throw new IllegalArgumentException("The id can't be empty");
        }
    }

    private static class NullFilterIterator<T extends ElementDraft>
    implements Iterator<T> {
        private T pointer;
        private final Iterator<T> itr;

        public NullFilterIterator(Collection<T> elementCollection) {
            this.itr = elementCollection.iterator();
        }

        @Override
        public boolean hasNext() {
            while (this.itr.hasNext()) {
                this.pointer = (ElementDraft)this.itr.next();
                if (this.pointer == null) continue;
                return true;
            }
            return false;
        }

        @Override
        public T next() {
            return this.pointer;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static class NullFilterIterable<T extends ElementDraft>
    implements Iterable<T> {
        private final Collection<T> collection;

        public NullFilterIterable(Collection elementCollection) {
            this.collection = elementCollection;
        }

        @Override
        public Iterator<T> iterator() {
            return new NullFilterIterator<T>(this.collection);
        }
    }
}

