/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.database;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import org.gephi.graph.api.TimeFormat;
import org.gephi.io.database.drivers.SQLUtils;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.Database;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ElementDraft;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.PropertiesAssociations;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.plugin.database.EdgeColumns;
import org.gephi.io.importer.plugin.database.EdgeListDatabaseImpl;
import org.gephi.io.importer.plugin.database.NodeColumns;
import org.gephi.io.importer.spi.DatabaseImporter;

public class ImporterEdgeList
implements DatabaseImporter {
    private Report report;
    private EdgeListDatabaseImpl database;
    private ContainerLoader container;
    private Connection connection;
    private String timeIntervalStart;
    private String timeIntervalEnd;
    private NodeColumns nodeColumns = new NodeColumns();
    private EdgeColumns edgeColumns = new EdgeColumns();

    @Override
    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        try {
            this.importData();
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
        this.close();
        return true;
    }

    private void close() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.report.log("Database connection terminated");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void importData() throws Exception {
        String url = SQLUtils.getUrl(this.database.getSQLDriver(), this.database.getHost(), this.database.getPort(), this.database.getDBName());
        try {
            this.report.log("Try to connect at " + url);
            this.connection = this.database.getSQLDriver().getConnection(url, this.database.getUsername(), this.database.getPasswd());
            this.report.log("Database connection established");
        }
        catch (SQLException ex) {
            if (this.connection != null) {
                try {
                    this.connection.close();
                    this.report.log("Database connection terminated");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.report.logIssue(new Issue("Failed to connect at " + url, Issue.Level.CRITICAL, ex));
        }
        if (this.connection == null) {
            this.report.logIssue(new Issue("Failed to connect at " + url, Issue.Level.CRITICAL));
        }
        this.report.log(this.database.getPropertiesAssociations().getInfos());
        this.getNodes(this.connection);
        this.getEdges(this.connection);
        this.getNodesAttributes(this.connection);
        this.getEdgesAttributes(this.connection);
    }

    private void getNodes(Connection connection) throws SQLException {
        ElementDraft.Factory factory = this.container.factory();
        PropertiesAssociations properties = this.database.getPropertiesAssociations();
        Statement s = connection.createStatement();
        ResultSet rs = null;
        try {
            rs = s.executeQuery(this.database.getNodeQuery());
        }
        catch (SQLException ex) {
            this.report.logIssue(new Issue("Failed to execute Node query", Issue.Level.SEVERE, ex));
            return;
        }
        this.findNodeAttributesColumns(rs);
        ResultSetMetaData metaData = rs.getMetaData();
        int columnsCount = metaData.getColumnCount();
        int idColumn = this.nodeColumns.findIdIndex(metaData, properties);
        while (rs.next()) {
            NodeDraft node = this.nodeColumns.getNodeDraft(factory, rs, idColumn);
            for (int i = 0; i < columnsCount; ++i) {
                String columnName = metaData.getColumnLabel(i + 1);
                PropertiesAssociations.NodeProperties p = properties.getNodeProperty(columnName);
                if (p != null) {
                    this.injectNodeProperty(p, rs, i + 1, node);
                    continue;
                }
                ColumnDraft col = this.container.getNodeColumn(columnName);
                this.injectElementAttribute(rs, i + 1, col, node);
            }
            this.injectTimeIntervalProperty(node);
            this.container.addNode(node);
        }
        rs.close();
        s.close();
    }

    private void getEdges(Connection connection) throws SQLException {
        ElementDraft.Factory factory = this.container.factory();
        PropertiesAssociations properties = this.database.getPropertiesAssociations();
        Statement s = connection.createStatement();
        ResultSet rs = null;
        try {
            rs = s.executeQuery(this.database.getEdgeQuery());
        }
        catch (SQLException ex) {
            this.report.logIssue(new Issue("Failed to execute Edge query", Issue.Level.SEVERE, ex));
            return;
        }
        this.findEdgeAttributesColumns(rs);
        ResultSetMetaData metaData = rs.getMetaData();
        int columnsCount = metaData.getColumnCount();
        int idColumn = this.edgeColumns.findIdIndex(metaData, properties);
        while (rs.next()) {
            EdgeDraft edge = this.edgeColumns.getEdgeDraft(factory, rs, idColumn);
            for (int i = 0; i < columnsCount; ++i) {
                String columnName = metaData.getColumnLabel(i + 1);
                PropertiesAssociations.EdgeProperties p = properties.getEdgeProperty(columnName);
                if (p != null) {
                    this.injectEdgeProperty(p, rs, i + 1, edge);
                    continue;
                }
                ColumnDraft col = this.container.getEdgeColumn(columnName);
                this.injectElementAttribute(rs, i + 1, col, edge);
            }
            this.injectTimeIntervalProperty(edge);
            this.container.addEdge(edge);
        }
        rs.close();
        s.close();
    }

    private void getNodesAttributes(Connection connection) throws SQLException {
    }

    private void getEdgesAttributes(Connection connection) throws SQLException {
    }

    private void injectNodeProperty(PropertiesAssociations.NodeProperties p, ResultSet rs, int column, NodeDraft nodeDraft) throws SQLException {
        switch (p) {
            case LABEL: {
                String label = rs.getString(column);
                if (label == null) break;
                nodeDraft.setLabel(label);
                break;
            }
            case X: {
                float x = rs.getFloat(column);
                if (x == 0.0f) break;
                nodeDraft.setX(x);
                break;
            }
            case Y: {
                float y = rs.getFloat(column);
                if (y == 0.0f) break;
                nodeDraft.setY(y);
                break;
            }
            case Z: {
                float z = rs.getFloat(column);
                if (z == 0.0f) break;
                nodeDraft.setZ(z);
                break;
            }
            case COLOR: {
                String color = rs.getString(column);
                if (color == null) break;
                String[] rgb = color.replace(" ", "").split(",");
                if (rgb.length == 3) {
                    nodeDraft.setColor(rgb[0], rgb[1], rgb[2]);
                    break;
                }
                nodeDraft.setColor(color);
                break;
            }
            case SIZE: {
                float size = rs.getFloat(column);
                if (size == 0.0f) break;
                nodeDraft.setSize(size);
                break;
            }
            case START: {
                this.container.setTimeFormat(this.getTimeFormat(rs, column));
                String start = this.getDateData(rs, column);
                if (start == null) break;
                this.timeIntervalStart = start;
                break;
            }
            case START_OPEN: {
                this.container.setTimeFormat(this.getTimeFormat(rs, column));
                String startOpen = rs.getString(column);
                if (startOpen == null) break;
                this.timeIntervalStart = startOpen;
                break;
            }
            case END: {
                this.container.setTimeFormat(this.getTimeFormat(rs, column));
                String end = rs.getString(column);
                if (end == null) break;
                this.timeIntervalEnd = end;
                break;
            }
            case END_OPEN: {
                this.container.setTimeFormat(this.getTimeFormat(rs, column));
                String endOpen = rs.getString(column);
                if (endOpen == null) break;
                this.timeIntervalEnd = endOpen;
            }
        }
    }

    private TimeFormat getTimeFormat(ResultSet rs, int column) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int type = metaData.getColumnType(column);
        switch (type) {
            case 91: {
                return TimeFormat.DATE;
            }
            case 92: {
                return TimeFormat.DATETIME;
            }
            case 93: {
                return TimeFormat.DATETIME;
            }
            case 12: {
                return TimeFormat.DATETIME;
            }
            case 6: 
            case 8: {
                return TimeFormat.DOUBLE;
            }
        }
        return TimeFormat.DOUBLE;
    }

    private String getDateData(ResultSet rs, int column) throws SQLException {
        String res = null;
        ResultSetMetaData metaData = rs.getMetaData();
        int type = metaData.getColumnType(column);
        if (type == 91) {
            Date date = rs.getDate(column);
            res = date.toString();
        } else if (type == 92) {
            Time time = rs.getTime(column);
            res = time.toString();
        } else if (type == 93) {
            Timestamp timeStamp = rs.getTimestamp(column);
            res = timeStamp.toString();
        } else if (type == 12) {
            res = rs.getString(column);
        } else if (type == 8 || type == 6) {
            Double dbl = rs.getDouble(column);
            res = dbl.toString();
        }
        return res;
    }

    private void injectTimeIntervalProperty(NodeDraft nodeDraft) {
        if (this.timeIntervalStart != null || this.timeIntervalEnd != null) {
            nodeDraft.addInterval(this.timeIntervalStart, this.timeIntervalEnd);
        }
        this.timeIntervalStart = null;
        this.timeIntervalEnd = null;
    }

    private void injectEdgeProperty(PropertiesAssociations.EdgeProperties p, ResultSet rs, int column, EdgeDraft edgeDraft) throws SQLException {
        switch (p) {
            case LABEL: {
                String label = rs.getString(column);
                if (label == null) break;
                edgeDraft.setLabel(label);
                break;
            }
            case SOURCE: {
                String source = rs.getString(column);
                if (source == null || source.isEmpty()) break;
                NodeDraft sourceNode = this.container.getNode(source);
                edgeDraft.setSource(sourceNode);
                break;
            }
            case TARGET: {
                String target = rs.getString(column);
                if (target == null || target.isEmpty()) break;
                NodeDraft targetNode = this.container.getNode(target);
                edgeDraft.setTarget(targetNode);
                break;
            }
            case WEIGHT: {
                float weight = rs.getFloat(column);
                if (weight == 0.0f) break;
                edgeDraft.setWeight(weight);
                break;
            }
            case COLOR: {
                String color = rs.getString(column);
                if (color == null) break;
                String[] rgb = color.split(",");
                if (rgb.length == 3) {
                    edgeDraft.setColor(rgb[0], rgb[1], rgb[2]);
                    break;
                }
                edgeDraft.setColor(color);
                break;
            }
            case START: {
                this.container.setTimeFormat(this.getTimeFormat(rs, column));
                String start = this.getDateData(rs, column);
                if (start == null) break;
                this.timeIntervalStart = start;
                break;
            }
            case START_OPEN: {
                this.container.setTimeFormat(this.getTimeFormat(rs, column));
                String startOpen = rs.getString(column);
                if (startOpen == null) break;
                this.timeIntervalStart = startOpen;
                break;
            }
            case END: {
                this.container.setTimeFormat(this.getTimeFormat(rs, column));
                String end = rs.getString(column);
                if (end == null) break;
                this.timeIntervalEnd = end;
                break;
            }
            case END_OPEN: {
                this.container.setTimeFormat(this.getTimeFormat(rs, column));
                String endOpen = rs.getString(column);
                if (endOpen == null) break;
                this.timeIntervalEnd = endOpen;
            }
        }
    }

    private void injectTimeIntervalProperty(EdgeDraft edgeDraft) {
        if (this.timeIntervalStart != null || this.timeIntervalEnd != null) {
            edgeDraft.addInterval(this.timeIntervalStart, this.timeIntervalEnd);
        }
        this.timeIntervalStart = null;
        this.timeIntervalEnd = null;
    }

    private void injectElementAttribute(ResultSet rs, int columnIndex, ColumnDraft column, ElementDraft draft) {
        String elementName = draft instanceof NodeDraft ? "node" : "edge";
        Class typeClass = column.getTypeClass();
        if (typeClass.equals(Boolean.class)) {
            try {
                boolean val = rs.getBoolean(columnIndex);
                draft.setValue(column.getId(), val);
            }
            catch (SQLException ex) {
                this.report.logIssue(new Issue("Failed to get a BOOLEAN value for " + elementName + " attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
            }
        } else if (typeClass.equals(Double.class)) {
            try {
                double val = rs.getDouble(columnIndex);
                draft.setValue(column.getId(), val);
            }
            catch (SQLException ex) {
                this.report.logIssue(new Issue("Failed to get a DOUBLE value for " + elementName + " attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
            }
        } else if (typeClass.equals(Float.class)) {
            try {
                float val = rs.getFloat(columnIndex);
                draft.setValue(column.getId(), Float.valueOf(val));
            }
            catch (SQLException ex) {
                this.report.logIssue(new Issue("Failed to get a FLOAT value for " + elementName + " attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
            }
        } else if (typeClass.equals(Integer.class)) {
            try {
                int val = rs.getInt(columnIndex);
                draft.setValue(column.getId(), val);
            }
            catch (SQLException ex) {
                this.report.logIssue(new Issue("Failed to get a INT value for " + elementName + " attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
            }
        } else if (typeClass.equals(Long.class)) {
            try {
                long val = rs.getLong(columnIndex);
                draft.setValue(column.getId(), val);
            }
            catch (SQLException ex) {
                this.report.logIssue(new Issue("Failed to get a LONG value for " + elementName + " attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
            }
        } else if (typeClass.equals(Short.class)) {
            try {
                short val = rs.getShort(columnIndex);
                draft.setValue(column.getId(), val);
            }
            catch (SQLException ex) {
                this.report.logIssue(new Issue("Failed to get a SHORT value for " + elementName + " attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
            }
        } else if (typeClass.equals(Byte.class)) {
            try {
                byte val = rs.getByte(columnIndex);
                draft.setValue(column.getId(), val);
            }
            catch (SQLException ex) {
                this.report.logIssue(new Issue("Failed to get a BYTE value for " + elementName + " attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
            }
        } else {
            try {
                String val = rs.getString(columnIndex);
                if (val != null) {
                    draft.setValue(column.getId(), val);
                } else {
                    this.report.logIssue(new Issue("Failed to get a STRING value for " + elementName + " attribute '" + column.getId() + "'", Issue.Level.WARNING));
                }
            }
            catch (SQLException ex) {
                this.report.logIssue(new Issue("Failed to get a STRING value for " + elementName + " attribute '" + column.getId() + "'", Issue.Level.SEVERE, ex));
            }
        }
    }

    private void findNodeAttributesColumns(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnsCount = metaData.getColumnCount();
        for (int i = 0; i < columnsCount; ++i) {
            String columnName = metaData.getColumnLabel(i + 1);
            PropertiesAssociations.NodeProperties p = this.database.getPropertiesAssociations().getNodeProperty(columnName);
            if (p != null) continue;
            Class typeClass = this.findTypeClass(metaData, i);
            this.container.addNodeColumn(columnName, typeClass);
        }
    }

    private void findEdgeAttributesColumns(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnsCount = metaData.getColumnCount();
        for (int i = 0; i < columnsCount; ++i) {
            String columnName = metaData.getColumnLabel(i + 1);
            PropertiesAssociations.EdgeProperties p = this.database.getPropertiesAssociations().getEdgeProperty(columnName);
            if (p != null) continue;
            Class typeClass = this.findTypeClass(metaData, i);
            this.container.addEdgeColumn(columnName, typeClass);
        }
    }

    private Class findTypeClass(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        Class type = String.class;
        switch (metaData.getColumnType(columnIndex + 1)) {
            case -5: {
                type = Long.class;
                break;
            }
            case 4: {
                type = Integer.class;
                break;
            }
            case -6: {
                type = Byte.class;
                break;
            }
            case 5: {
                type = Short.class;
                break;
            }
            case 16: {
                type = Boolean.class;
                break;
            }
            case 6: {
                type = Float.class;
                break;
            }
            case 8: {
                type = Double.class;
                break;
            }
            case 12: {
                type = String.class;
                break;
            }
            case -7: {
                type = Boolean.class;
                break;
            }
            case 7: {
                type = Float.class;
                break;
            }
            default: {
                this.report.logIssue(new Issue("Unknown SQL Type " + metaData.getColumnType(columnIndex + 1) + ", STRING used.", Issue.Level.WARNING));
            }
        }
        return type;
    }

    @Override
    public void setDatabase(Database database) {
        this.database = (EdgeListDatabaseImpl)database;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public ContainerLoader getContainer() {
        return this.container;
    }

    @Override
    public Report getReport() {
        return this.report;
    }
}

