/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ImporterDL
implements FileImporter,
LongTask {
    private Reader reader;
    private ContainerLoader container;
    private Report report;
    private ProgressTicket progressTicket;
    private boolean cancel = false;
    private Format format = Format.FULLMATRIX;
    private Map<String, String> headerMap;
    private int numNodes;
    private int numMatricies;
    private int dataLineStartDelta = -1;

    @Override
    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        LineNumberReader lineReader = ImportUtils.getTextReader(this.reader);
        try {
            this.importData(lineReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException iOException) {}
        }
        return !this.cancel;
    }

    private void importData(LineNumberReader reader) throws Exception {
        String line;
        int i;
        Progress.start(this.progressTicket);
        ArrayList<String> lines = new ArrayList<String>();
        while (reader.ready()) {
            String line2 = reader.readLine();
            if (line2 == null || line2.isEmpty()) continue;
            lines.add(line2);
        }
        if (lines.isEmpty() || !((String)lines.get(0)).startsWith("DL") && !((String)lines.get(0)).startsWith("dl")) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_firstline"), Issue.Level.CRITICAL));
        }
        this.headerMap = new HashMap<String, String>();
        this.readHeaderLine(((String)lines.get(0)).substring(2));
        for (i = 1; i < lines.size() && !(line = ((String)lines.get(i)).toLowerCase()).trim().endsWith("data:") && !line.trim().endsWith("labels:"); ++i) {
            this.readHeaderLine(line);
        }
        this.computeHeaders();
        if (((String)lines.get(i)).toLowerCase().trim().endsWith("labels:") && lines.size() > i + 1) {
            this.readLabels((String)lines.get(++i));
        }
        int dataLineStart = -1;
        while (i < lines.size()) {
            String line3 = ((String)lines.get(i)).toLowerCase();
            if (line3.trim().endsWith("data:")) {
                dataLineStart = i + 1;
                break;
            }
            ++i;
        }
        if (dataLineStart == -1) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_nodata"), Issue.Level.SEVERE));
        } else if (lines.size() > dataLineStart) {
            this.dataLineStartDelta = dataLineStart + 1;
            lines = lines.subList(dataLineStart, lines.size());
            if (this.format.equals((Object)Format.FULLMATRIX)) {
                this.readeMatrixBlock(lines);
            } else if (this.format.equals((Object)Format.EDGELIST1)) {
                this.readEdgelistBlock(lines);
            }
        }
    }

    private void readHeaderLine(String line) {
        line = line.replaceAll(" = ", "=");
        StringTokenizer firstLineTokenizer = new StringTokenizer(line, " ,;");
        while (firstLineTokenizer.hasMoreTokens()) {
            String tag = firstLineTokenizer.nextToken().toLowerCase();
            if (!tag.contains("=")) continue;
            this.headerMap.put(tag.substring(0, tag.indexOf("=")).trim(), tag.substring(tag.indexOf("=") + 1).trim());
        }
    }

    private void computeHeaders() {
        String form = this.headerMap.get("format");
        if (form == null) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_formatmissing"), Issue.Level.INFO));
        } else if (!form.equals("edgelist1") && !form.equals("fullmatrix")) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_badformat", form), Issue.Level.SEVERE));
        } else if (form.equals("edgelist1")) {
            this.format = Format.EDGELIST1;
        } else if (form.equals("fullmatrix")) {
            this.format = Format.FULLMATRIX;
        }
        try {
            String nArg = this.headerMap.get("n");
            this.numNodes = Integer.parseInt(nArg);
        }
        catch (Exception e) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_nmissing"), Issue.Level.SEVERE));
        }
        String mats = this.headerMap.get("nm");
        if (mats != null) {
            try {
                this.numMatricies = Integer.parseInt(mats);
            }
            catch (Exception e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_mmissing"), Issue.Level.SEVERE));
            }
        } else {
            this.numMatricies = 1;
        }
    }

    private void readLabels(String labels) {
        StringTokenizer labelkonizer = new StringTokenizer(labels, ",");
        if (labelkonizer.countTokens() != this.numNodes) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_labelscount", labelkonizer.countTokens(), this.numNodes), Issue.Level.SEVERE));
        }
        int nodeCount = 0;
        while (labelkonizer.hasMoreTokens()) {
            String label = labelkonizer.nextToken();
            NodeDraft nodeDraft = this.container.factory().newNodeDraft("" + ++nodeCount);
            nodeDraft.setLabel(label);
            this.container.addNode(nodeDraft);
        }
    }

    private void readeMatrixBlock(List<String> data) {
        int startTime = 0;
        for (int i = 0; i < data.size(); ++i) {
            int rowNum = 0;
            while (i < data.size() && !data.get(i).trim().equals("!")) {
                if (rowNum <= this.numNodes) {
                    this.readMatrixRow(data.get(i), i, rowNum, startTime, startTime + 1);
                    ++rowNum;
                } else {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_matrixrowscount", rowNum, this.numNodes), Issue.Level.SEVERE));
                    break;
                }
                ++i;
            }
            if (rowNum < this.numNodes) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_matrixrowscount2", rowNum, this.numNodes), Issue.Level.SEVERE));
            }
            ++startTime;
        }
        if (startTime != this.numMatricies) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_matriciescount", startTime, this.numMatricies), Issue.Level.SEVERE));
        }
    }

    private void readMatrixRow(String line, int pointer, int row, int startTime, int endTime) {
        StringTokenizer rowkonizer = new StringTokenizer(line, " ");
        int from = row + 1;
        int to = 1;
        double weight = 0.0;
        while (rowkonizer.hasMoreTokens()) {
            String toParse = rowkonizer.nextToken();
            if (to > this.numNodes) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_matrixentriescount", row, startTime, this.getLineNumber(pointer)), Issue.Level.SEVERE));
            }
            try {
                weight = Double.parseDouble(toParse);
            }
            catch (Exception e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_weightparseerror", toParse, startTime, this.getLineNumber(pointer)), Issue.Level.SEVERE));
            }
            if (weight != 0.0) {
                NodeDraft sourceNode = this.container.getNode("" + from);
                NodeDraft targetNode = this.container.getNode("" + to);
                EdgeDraft edgeDraft = this.container.factory().newEdgeDraft();
                edgeDraft.setSource(sourceNode);
                edgeDraft.setTarget(targetNode);
                edgeDraft.setWeight((float)weight);
                this.container.addEdge(edgeDraft);
            }
            ++to;
        }
    }

    private void readEdgelistBlock(List<String> data) {
        int startTime = 0;
        for (int i = 0; i < data.size(); ++i) {
            while (i < data.size() && !data.get(i).trim().equals("!")) {
                this.readEdgelistRow(data.get(i), i, startTime, startTime + 1);
                ++i;
            }
            ++startTime;
        }
        if (startTime != this.numMatricies) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_edgelistssetscount", startTime, this.numMatricies), Issue.Level.SEVERE));
        }
    }

    private void readEdgelistRow(String row, int pointer, double startTime, double endTime) {
        StringTokenizer rowkonizer = new StringTokenizer(row);
        if (!rowkonizer.hasMoreTokens()) {
            return;
        }
        String from = rowkonizer.nextToken();
        if (!rowkonizer.hasMoreTokens()) {
            return;
        }
        String to = rowkonizer.nextToken();
        double weight = 1.0;
        if (rowkonizer.hasMoreTokens()) {
            String weightParse = rowkonizer.nextToken();
            try {
                weight = Double.parseDouble(weightParse);
            }
            catch (Exception e) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterDL.class, "importerDL_error_edgeparseweight", weightParse, this.getLineNumber(pointer)), Issue.Level.WARNING));
            }
        }
        NodeDraft sourceNode = this.container.getNode(from);
        NodeDraft targetNode = this.container.getNode(to);
        EdgeDraft edgeDraft = this.container.factory().newEdgeDraft();
        edgeDraft.setSource(sourceNode);
        edgeDraft.setTarget(targetNode);
        edgeDraft.setWeight((float)weight);
        this.container.addEdge(edgeDraft);
    }

    private int getLineNumber(int pointer) {
        return pointer + this.dataLineStartDelta;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public ContainerLoader getContainer() {
        return this.container;
    }

    @Override
    public Report getReport() {
        return this.report;
    }

    @Override
    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    private static enum Format {
        FULLMATRIX,
        EDGELIST1;

    }
}

