/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.StringTokenizer;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ImporterPajek
implements FileImporter,
LongTask {
    private Reader reader;
    private LineNumberReader lineReader;
    private ContainerLoader container;
    private Report report;
    private ProgressTicket progressTicket;
    private boolean cancel = false;
    private NodeDraft[] verticesArray;

    @Override
    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        this.lineReader = ImportUtils.getTextReader(this.reader);
        try {
            this.importData(this.lineReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                this.lineReader.close();
            }
            catch (IOException iOException) {}
        }
        return !this.cancel;
    }

    private void importData(LineNumberReader reader) throws Exception {
        Progress.start(this.progressTicket);
        try {
            String curLine = this.skip(reader, "*vertices");
            if (curLine == null) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterPajek.class, "importerNET_error_dataformat1"), Issue.Level.CRITICAL));
            }
            StringTokenizer stringTokenizer = new StringTokenizer(curLine);
            stringTokenizer.nextToken();
            int num_vertices = Integer.parseInt(stringTokenizer.nextToken());
            Progress.switchToDeterminate(this.progressTicket, num_vertices);
            this.verticesArray = new NodeDraft[num_vertices];
            for (int i = 0; i < num_vertices; ++i) {
                String label = "" + (i + 1);
                NodeDraft node = this.container.factory().newNodeDraft(label);
                node.setLabel(label);
                this.verticesArray[i] = node;
            }
            curLine = null;
            while (reader.ready()) {
                if (this.cancel) {
                    reader.close();
                    return;
                }
                curLine = reader.readLine();
                if (curLine == null || curLine.startsWith("*")) break;
                if (curLine.isEmpty()) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterPajek.class, "importerNET_error_dataformat2", reader.getLineNumber()), Issue.Level.WARNING));
                    continue;
                }
                try {
                    this.readVertex(curLine, num_vertices);
                }
                catch (IllegalArgumentException iae) {
                    reader.close();
                    throw iae;
                }
                Progress.progress(this.progressTicket);
            }
            for (NodeDraft node : this.verticesArray) {
                this.container.addNode(node);
            }
            curLine = this.readArcsOrEdges(curLine, reader);
            this.readArcsOrEdges(curLine, reader);
            reader.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Progress.finish(this.progressTicket);
    }

    private void readVertex(String curLine, int num_vertices) throws Exception {
        String index;
        String[] parts = null;
        int firstParts = -1;
        String label = null;
        if (curLine.indexOf(34) != -1) {
            String[] initial_split = curLine.trim().split("\"");
            if (initial_split.length < 1 || initial_split.length > 3) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterPajek.class, "importerNET_error_dataformat3", this.lineReader.getLineNumber()), Issue.Level.SEVERE));
            }
            index = initial_split[0].trim();
            if (initial_split.length > 1) {
                label = initial_split[1].trim();
            }
            if (initial_split.length == 3) {
                parts = initial_split[2].trim().split("\\s+", -1);
            }
            firstParts = 0;
        } else {
            parts = curLine.trim().split("\\s+", -1);
            index = parts[0];
            switch (parts.length) {
                case 1: {
                    break;
                }
                case 2: {
                    label = parts[1];
                    break;
                }
                case 3: {
                    firstParts = 1;
                    break;
                }
                case 4: {
                    firstParts = 2;
                }
            }
        }
        int v_id = Integer.parseInt(index) - 1;
        if (v_id >= num_vertices || v_id < 0) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterPajek.class, "importerNET_error_dataformat4", v_id, num_vertices), Issue.Level.SEVERE));
        }
        NodeDraft node = this.verticesArray[v_id];
        if (label != null && label.length() > 0) {
            node.setLabel(label);
        }
        if (firstParts != -1 && parts != null && parts.length >= firstParts + 2) {
            int i = firstParts;
            if (i < parts.length - 1) {
                try {
                    float x = Float.parseFloat(parts[i]);
                    float y = Float.parseFloat(parts[i + 1]);
                    node.setX(x);
                    node.setY(y);
                    ++i;
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterPajek.class, "importerNET_error_dataformat5", this.lineReader.getLineNumber()), Issue.Level.WARNING));
                }
            }
            if (i < parts.length - 1) {
                try {
                    float size = Float.parseFloat(parts[i]);
                    node.setSize(size);
                    ++i;
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterPajek.class, "importerNET_error_dataformat6", this.lineReader.getLineNumber()), Issue.Level.WARNING));
                }
            }
            while (i < parts.length - 1) {
                if ("ic".equals(parts[i])) {
                    String colorName = parts[i + 1].replaceAll(" ", "");
                    node.setColor(colorName);
                    break;
                }
                ++i;
            }
        }
    }

    private String readArcsOrEdges(String curLine, BufferedReader br) throws Exception {
        String nextLine = curLine;
        boolean reading_arcs = false;
        boolean reading_edges = false;
        if (nextLine.toLowerCase().startsWith("*arcs")) {
            reading_arcs = true;
        } else if (nextLine.toLowerCase().startsWith("*edges")) {
            reading_edges = true;
        }
        if (!reading_arcs && !reading_edges) {
            return nextLine;
        }
        boolean is_list = false;
        if (nextLine.toLowerCase().endsWith("list")) {
            is_list = true;
        }
        while (br.ready()) {
            EdgeDraft edge;
            NodeDraft nodeTo;
            int vid2;
            if (this.cancel) {
                return nextLine;
            }
            nextLine = br.readLine();
            if (nextLine == null || nextLine.startsWith("*")) break;
            if (nextLine.equals("")) {
                this.report.logIssue(new Issue(NbBundle.getMessage(ImporterPajek.class, "importerNET_error_dataformat2", this.lineReader.getLineNumber()), Issue.Level.WARNING));
                continue;
            }
            StringTokenizer st = new StringTokenizer(nextLine.trim());
            int vid1 = Integer.parseInt(st.nextToken()) - 1;
            NodeDraft nodeFrom = this.verticesArray[vid1];
            if (is_list) {
                do {
                    vid2 = Integer.parseInt(st.nextToken()) - 1;
                    nodeTo = this.verticesArray[vid2];
                    edge = this.container.factory().newEdgeDraft();
                    edge.setSource(nodeFrom);
                    edge.setTarget(nodeTo);
                    this.container.addEdge(edge);
                } while (st.hasMoreTokens());
                continue;
            }
            vid2 = Integer.parseInt(st.nextToken()) - 1;
            nodeTo = this.verticesArray[vid2];
            edge = this.container.factory().newEdgeDraft();
            edge.setSource(nodeFrom);
            edge.setTarget(nodeTo);
            if (st.hasMoreTokens()) {
                double edgeWeight = 1.0;
                try {
                    edgeWeight = new Double(st.nextToken());
                }
                catch (Exception e) {
                    this.report.logIssue(new Issue(NbBundle.getMessage(ImporterPajek.class, "importerNET_error_dataformat7", this.lineReader.getLineNumber()), Issue.Level.WARNING));
                }
                edge.setWeight(edgeWeight);
            }
            this.container.addEdge(edge);
        }
        return nextLine;
    }

    private String skip(BufferedReader br, String str) throws Exception {
        String curLine;
        while (br.ready() && (curLine = br.readLine()) != null) {
            if (!(curLine = curLine.trim()).toLowerCase().startsWith(str)) continue;
            return curLine;
        }
        return null;
    }

    @Override
    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public ContainerLoader getContainer() {
        return this.container;
    }

    @Override
    public Report getReport() {
        return this.report;
    }

    @Override
    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

