/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.spi.FileImporter;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public class ImporterTGF
implements FileImporter,
LongTask {
    private Reader reader;
    private ContainerLoader container;
    private Report report;
    private ProgressTicket progressTicket;
    private boolean cancel = false;

    @Override
    public boolean execute(ContainerLoader container) {
        this.container = container;
        this.report = new Report();
        LineNumberReader lineReader = ImportUtils.getTextReader(this.reader);
        try {
            this.importData(lineReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException iOException) {}
        }
        return !this.cancel;
    }

    private void importData(LineNumberReader reader) throws Exception {
        Progress.start(this.progressTicket);
        ArrayList<String> nodes = new ArrayList<String>();
        ArrayList<String> edges = new ArrayList<String>();
        boolean isNode = true;
        while (reader.ready()) {
            String line = reader.readLine().trim();
            if ("#".equalsIgnoreCase(line)) {
                isNode = false;
                continue;
            }
            if (line == null || line.isEmpty()) continue;
            if (isNode) {
                nodes.add(line);
                continue;
            }
            edges.add(line);
        }
        Progress.switchToDeterminate(this.progressTicket, nodes.size() + edges.size());
        if (nodes.isEmpty()) {
            this.report.logIssue(new Issue(NbBundle.getMessage(ImporterTGF.class, "importerTGF_error_emptynodes"), Issue.Level.CRITICAL));
        }
        for (String n : nodes) {
            this.addNode(n.substring(0, n.indexOf(" ")), n.substring(n.indexOf(" ")));
        }
        Progress.progress(this.progressTicket);
        for (String e : edges) {
            int firstSpace = e.indexOf(" ");
            int secondSpace = e.indexOf(" ", firstSpace + 1);
            String[] tempFields = e.split(" ");
            String from = tempFields[0];
            String to = tempFields[1];
            this.addEdge(from, to, e.substring(secondSpace));
        }
        Progress.progress(this.progressTicket);
    }

    private void addNode(String id, String label) {
        if (!this.container.nodeExists(id)) {
            NodeDraft node = this.container.factory().newNodeDraft(id);
            node.setLabel(label);
            this.container.addNode(node);
        }
    }

    private void addEdge(String source, String target, String label) {
        NodeDraft targetNode;
        NodeDraft sourceNode;
        if (!this.container.nodeExists(source)) {
            sourceNode = this.container.factory().newNodeDraft(source);
            this.container.addNode(sourceNode);
        } else {
            sourceNode = this.container.getNode(source);
        }
        if (!this.container.nodeExists(target)) {
            targetNode = this.container.factory().newNodeDraft(target);
            this.container.addNode(targetNode);
        } else {
            targetNode = this.container.getNode(target);
        }
        if (!this.container.edgeExists(sourceNode.getId(), targetNode.getId())) {
            EdgeDraft edge = this.container.factory().newEdgeDraft();
            edge.setSource(sourceNode);
            edge.setTarget(targetNode);
            edge.setLabel(label);
            this.container.addEdge(edge);
        }
    }

    @Override
    public void setReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public ContainerLoader getContainer() {
        return this.container;
    }

    @Override
    public Report getReport() {
        return this.report;
    }

    @Override
    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

