/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.csv.CSVParser;
import org.gephi.io.importer.api.ImportUtils;
import org.gephi.io.importer.plugin.file.spreadsheet.AbstractImporterSpreadsheet;
import org.gephi.io.importer.plugin.file.spreadsheet.SpreadsheetUtils;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.EmptySheet;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.ErrorSheet;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheets.csv.CSVSheetParser;
import org.gephi.utils.CharsetToolkit;
import org.openide.filesystems.FileUtil;

public class ImporterSpreadsheetCSV
extends AbstractImporterSpreadsheet {
    protected char fieldDelimiter = (char)44;
    protected Charset charset = Charset.forName("UTF-8");

    @Override
    public SheetParser createParserWithoutHeaders() throws IOException {
        return this.createParser(false);
    }

    @Override
    public SheetParser createParser() throws IOException {
        boolean withFirstRecordAsHeader = this.generalConfig.getMode() == SpreadsheetGeneralConfiguration.Mode.NODES_TABLE || this.generalConfig.getMode() == SpreadsheetGeneralConfiguration.Mode.EDGES_TABLE;
        return this.createParser(withFirstRecordAsHeader);
    }

    private SheetParser createParser(boolean withFirstRecordAsHeader) throws IOException {
        try {
            CSVParser csvParser = SpreadsheetUtils.configureCSVParser(this.file, Character.valueOf(this.fieldDelimiter), this.charset, withFirstRecordAsHeader);
            return new CSVSheetParser(csvParser);
        }
        catch (Exception ex) {
            if (this.report != null) {
                SpreadsheetUtils.logError(this.report, ex.getMessage(), null);
                return EmptySheet.INSTANCE;
            }
            return new ErrorSheet(ex.getMessage());
        }
    }

    @Override
    public void refreshAutoDetections() {
        this.autoDetectCharset();
        this.autoDetectFieldDelimiter();
        super.refreshAutoDetections();
    }

    private void autoDetectCharset() {
        try {
            FileInputStream is = new FileInputStream(this.file);
            CharsetToolkit charsetToolkit = new CharsetToolkit(is);
            charsetToolkit.setDefaultCharset(Charset.forName("UTF-8"));
            this.charset = charsetToolkit.getCharset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void autoDetectFieldDelimiter() {
        try (LineNumberReader reader = ImportUtils.getTextReader(FileUtil.toFileObject(this.file));){
            String line = reader.readLine();
            int commaCount = 0;
            int semicolonCount = 0;
            int tabCount = 0;
            int spaceCount = 0;
            boolean inQuote = false;
            block17: for (char c : line.toCharArray()) {
                if (c == '\"' || c == '\'') {
                    boolean bl = inQuote = !inQuote;
                }
                if (inQuote) continue;
                switch (c) {
                    case ',': {
                        ++commaCount;
                        continue block17;
                    }
                    case ';': {
                        ++semicolonCount;
                        continue block17;
                    }
                    case '\t': {
                        ++tabCount;
                        continue block17;
                    }
                    case ' ': {
                        ++spaceCount;
                    }
                }
            }
            int max = Collections.max(Arrays.asList(commaCount, semicolonCount, tabCount, spaceCount));
            if (commaCount == max) {
                this.fieldDelimiter = (char)44;
            } else if (semicolonCount == max) {
                this.fieldDelimiter = (char)59;
            } else if (tabCount == max) {
                this.fieldDelimiter = (char)9;
            } else if (spaceCount == max) {
                this.fieldDelimiter = (char)32;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public char getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public void setFieldDelimiter(char fieldDelimiter) {
        this.fieldDelimiter = fieldDelimiter;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }
}

