/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.importer.plugin.file.spreadsheet.process;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.io.importer.api.ContainerLoader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.importer.plugin.file.spreadsheet.SpreadsheetUtils;
import org.gephi.io.importer.plugin.file.spreadsheet.process.SpreadsheetGeneralConfiguration;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetParser;
import org.gephi.io.importer.plugin.file.spreadsheet.sheet.SheetRow;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public abstract class AbstractImportProcess
implements Closeable {
    protected final SpreadsheetGeneralConfiguration generalConfig;
    protected final ContainerLoader container;
    protected final Report report;
    protected final ProgressTicket progressTicket;
    protected final SheetParser parser;
    protected boolean cancel = false;
    protected final Map<String, Integer> specialColumnsIndexMap = new HashMap<String, Integer>();
    protected final Map<String, Integer> headersIndexMap = new HashMap<String, Integer>();
    protected final Map<String, Class> headersClassMap = new HashMap<String, Class>();

    public AbstractImportProcess(SpreadsheetGeneralConfiguration generalConfig, ContainerLoader container, ProgressTicket progressTicket, SheetParser parser) {
        this.generalConfig = generalConfig;
        this.container = container;
        this.progressTicket = progressTicket;
        this.parser = parser;
        this.report = new Report();
        container.setFillLabelWithId(false);
    }

    public abstract boolean execute();

    protected void setupColumnsIndexesAndFindSpecialColumns(List<String> specialColumnNames, Map<String, Class> columnsClasses) {
        Map<String, Integer> headerMap = this.parser.getHeaderMap();
        HashSet<String> lowerCaseHeaders = new HashSet<String>();
        for (Map.Entry<String, Integer> entry : headerMap.entrySet()) {
            String headerName = entry.getKey().trim();
            int currentIndex = entry.getValue();
            boolean isSpecialColumn = false;
            if (!columnsClasses.containsKey(headerName)) continue;
            if (lowerCaseHeaders.contains(headerName.toLowerCase())) {
                this.logError(this.getMessage("AbstractImportProcess.error.repeatedColumn", headerName));
                continue;
            }
            lowerCaseHeaders.add(headerName.toLowerCase());
            for (String specialColumnName : specialColumnNames) {
                if (!headerName.equalsIgnoreCase(specialColumnName)) continue;
                this.specialColumnsIndexMap.put(specialColumnName, currentIndex);
                isSpecialColumn = true;
                break;
            }
            if (isSpecialColumn) continue;
            Class type = columnsClasses.get(headerName);
            this.headersClassMap.put(headerName, type);
            this.headersIndexMap.put(headerName, currentIndex);
            this.addColumn(headerName, type);
        }
    }

    protected Object parseValue(String value, Class type, String column) {
        try {
            return AttributeUtils.parse(value, type);
        }
        catch (Exception e) {
            this.logError(this.getMessage("AbstractImportProcess.error.parseError", value, type.getSimpleName(), column));
            return null;
        }
    }

    protected boolean checkRow(SheetRow row) {
        boolean consistent = row.isConsistent();
        if (!consistent) {
            this.logError(this.getMessage("AbstractImportProcess.error.inconsistentRow"));
        }
        return consistent;
    }

    protected void addEdge(String source, String target) {
        this.addEdge(source, target, 1.0f);
    }

    protected void addEdge(String source, String target, float weight) {
        NodeDraft targetNode;
        NodeDraft sourceNode;
        if (!this.container.nodeExists(source)) {
            sourceNode = this.container.factory().newNodeDraft(source);
            this.container.addNode(sourceNode);
        } else {
            sourceNode = this.container.getNode(source);
        }
        if (!this.container.nodeExists(target)) {
            targetNode = this.container.factory().newNodeDraft(target);
            this.container.addNode(targetNode);
        } else {
            targetNode = this.container.getNode(target);
        }
        EdgeDraft edge = this.container.factory().newEdgeDraft();
        edge.setSource(sourceNode);
        edge.setTarget(targetNode);
        edge.setWeight(weight);
        this.container.addEdge(edge);
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    protected void logInfo(String message) {
        SpreadsheetUtils.logInfo(this.report, message, this.parser);
    }

    protected void logWarning(String message) {
        SpreadsheetUtils.logWarning(this.report, message, this.parser);
    }

    protected void logError(String message) {
        SpreadsheetUtils.logError(this.report, message, this.parser);
    }

    @Override
    public void close() throws IOException {
        if (this.parser != null) {
            this.parser.close();
        }
    }

    public Report getReport() {
        return this.report;
    }

    protected String getMessage(String key) {
        return NbBundle.getMessage(this.getClass(), key);
    }

    protected String getMessage(String key, Object ... params) {
        return NbBundle.getMessage(this.getClass(), key, params);
    }

    protected abstract void addColumn(String var1, Class var2);
}

