/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.processor.plugin;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.IntervalMap;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.io.importer.api.ColumnDraft;
import org.gephi.io.importer.api.ContainerUnloader;
import org.gephi.io.importer.api.EdgeDraft;
import org.gephi.io.importer.api.EdgeMergeStrategy;
import org.gephi.io.importer.api.ElementDraft;
import org.gephi.io.importer.api.Issue;
import org.gephi.io.importer.api.NodeDraft;
import org.gephi.io.importer.api.Report;
import org.gephi.io.processor.spi.Processor;
import org.gephi.project.api.Workspace;
import org.gephi.utils.Attributes;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.NbBundle;

public abstract class AbstractProcessor
implements Processor {
    protected ProgressTicket progressTicket;
    protected Workspace workspace;
    protected ContainerUnloader[] containers;
    protected GraphModel graphModel;
    private final Set<Column> columnsTypeMismatchAlreadyWarned = new HashSet<Column>();
    protected Report report = new Report();
    protected Report reportAfterDone = new Report();
    private final Object2IntOpenHashMap<Edge> edgeCountForAverage = new Object2IntOpenHashMap();

    protected void clean() {
        this.workspace = null;
        this.graphModel = null;
        this.containers = null;
        this.progressTicket = null;
        this.columnsTypeMismatchAlreadyWarned.clear();
        this.reportAfterDone = this.report;
        this.report = new Report();
        this.edgeCountForAverage.clear();
    }

    protected void flushColumns(ContainerUnloader container) {
        this.addColumnsToTable(container, this.graphModel.getNodeTable(), container.getNodeColumns());
        this.addColumnsToTable(container, this.graphModel.getEdgeTable(), container.getEdgeColumns());
    }

    private void addColumnsToTable(ContainerUnloader container, Table table, Iterable<ColumnDraft> columns) {
        TimeRepresentation timeRepresentation = container.getTimeRepresentation();
        for (ColumnDraft col : columns) {
            if (table.hasColumn(col.getId())) continue;
            Class typeClass = col.getResolvedTypeClass(container);
            if (Attributes.isTypeAvailable(typeClass, timeRepresentation)) {
                Object defaultValue = col.getResolvedDefaultValue(container);
                if (defaultValue != null && !typeClass.isAssignableFrom(defaultValue.getClass())) {
                    String error = NbBundle.getMessage(AbstractProcessor.class, "AbstractProcessor.error.columnDefaultValueTypeMismatch", col.getId(), defaultValue.toString(), defaultValue.getClass().getSimpleName(), typeClass.getSimpleName(), new Object[0]);
                    this.report.logIssue(new Issue(error, Issue.Level.SEVERE));
                    defaultValue = null;
                }
                table.addColumn(col.getId(), col.getTitle(), typeClass, Origin.DATA, defaultValue, !col.isDynamic());
                continue;
            }
            String error = NbBundle.getMessage(AbstractProcessor.class, "AbstractProcessor.error.unavailableColumnType", typeClass.getSimpleName(), timeRepresentation.name(), col.getId());
            this.report.logIssue(new Issue(error, Issue.Level.SEVERE));
        }
    }

    protected void flushToNode(ContainerUnloader container, NodeDraft nodeDraft, Node node) {
        if (nodeDraft.getColor() != null) {
            node.setColor(nodeDraft.getColor());
        }
        if (!(nodeDraft.getLabel() == null || node.getLabel() != null && nodeDraft.isCreatedAuto())) {
            node.setLabel(nodeDraft.getLabel());
        }
        if (node.getTextProperties() != null) {
            node.getTextProperties().setVisible(nodeDraft.isLabelVisible());
        }
        if (nodeDraft.getLabelColor() != null && node.getTextProperties() != null) {
            Color labelColor = nodeDraft.getLabelColor();
            node.getTextProperties().setColor(labelColor);
        } else {
            node.getTextProperties().setColor(new Color(0, 0, 0, 0));
        }
        if (nodeDraft.getLabelSize() != -1.0f && node.getTextProperties() != null) {
            node.getTextProperties().setSize(nodeDraft.getLabelSize());
        }
        if ((nodeDraft.getX() != 0.0f || nodeDraft.getY() != 0.0f || nodeDraft.getZ() != 0.0f) && node.x() == 0.0f && node.y() == 0.0f && node.z() == 0.0f) {
            node.setX(nodeDraft.getX());
            node.setY(nodeDraft.getY());
            node.setZ(nodeDraft.getZ());
        }
        if (nodeDraft.getSize() != 0.0f && !Float.isNaN(nodeDraft.getSize())) {
            node.setSize(nodeDraft.getSize());
        } else if (node.size() == 0.0f) {
            node.setSize(10.0f);
        }
        if (nodeDraft.getTimeSet() != null) {
            this.flushTimeSet(nodeDraft.getTimeSet(), node);
        }
        if (nodeDraft.getGraphTimestamp() != null) {
            node.addTimestamp(nodeDraft.getGraphTimestamp());
        } else if (nodeDraft.getGraphInterval() != null) {
            node.addInterval(nodeDraft.getGraphInterval());
        }
        this.flushToElementAttributes(container, nodeDraft, node);
    }

    protected void flushToElementAttributes(ContainerUnloader container, ElementDraft elementDraft, Element element) {
        for (ColumnDraft columnDraft : elementDraft.getColumns()) {
            if (elementDraft instanceof EdgeDraft && columnDraft.getId().equalsIgnoreCase("weight")) continue;
            Object val = elementDraft.getValue(columnDraft.getId());
            Column column = element.getTable().getColumn(columnDraft.getId());
            if (column == null || column.isReadOnly()) continue;
            Class columnDraftTypeClass = columnDraft.getResolvedTypeClass(container);
            if (!column.getTypeClass().equals(columnDraftTypeClass)) {
                if (this.columnsTypeMismatchAlreadyWarned.contains(column)) continue;
                this.columnsTypeMismatchAlreadyWarned.add(column);
                String error = NbBundle.getMessage(AbstractProcessor.class, "AbstractProcessor.error.columnTypeMismatch", column.getId(), column.getTypeClass().getSimpleName(), columnDraftTypeClass.getSimpleName());
                this.report.logIssue(new Issue(error, Issue.Level.SEVERE));
                continue;
            }
            if (val == null) continue;
            Object processedNewValue = val;
            Object existingValue = element.getAttribute(columnDraft.getId());
            if (columnDraft.isDynamic() && existingValue != null) {
                if (TimeMap.class.isAssignableFrom(columnDraft.getTypeClass())) {
                    TimeMap existingMap = (TimeMap)existingValue;
                    if (!existingMap.isEmpty()) {
                        TimeMap valMap = (TimeMap)val;
                        TimeMap newMap = existingMap;
                        K[] keys = valMap.toKeysArray();
                        V[] vals = valMap.toValuesArray();
                        for (int i = 0; i < keys.length; ++i) {
                            try {
                                newMap.put(keys[i], vals[i]);
                                continue;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }
                        processedNewValue = newMap;
                    }
                } else if (TimeSet.class.isAssignableFrom(columnDraft.getTypeClass())) {
                    TimeSet existingTimeSet = (TimeSet)existingValue;
                    processedNewValue = this.mergeTimeSets(existingTimeSet, (TimeSet)val);
                }
            }
            element.setAttribute(columnDraft.getId(), processedNewValue);
        }
    }

    protected void flushToEdge(ContainerUnloader container, EdgeDraft edgeDraft, Edge edge, boolean newEdge) {
        this.flushEdgeWeight(container, edgeDraft, edge, newEdge);
        EdgeMergeStrategy edgesMergeStrategy = this.containers[0].getEdgesMergeStrategy();
        if (newEdge || edgesMergeStrategy != EdgeMergeStrategy.FIRST) {
            if (edgeDraft.getColor() != null) {
                edge.setColor(edgeDraft.getColor());
            } else {
                edge.setR(0.0f);
                edge.setG(0.0f);
                edge.setB(0.0f);
                edge.setAlpha(0.0f);
            }
            if (edgeDraft.getLabel() != null) {
                edge.setLabel(edgeDraft.getLabel());
            }
            if (edge.getTextProperties() != null) {
                edge.getTextProperties().setVisible(edgeDraft.isLabelVisible());
            }
            if (edgeDraft.getLabelSize() != -1.0f && edge.getTextProperties() != null) {
                edge.getTextProperties().setSize(edgeDraft.getLabelSize());
            }
            if (edgeDraft.getLabelColor() != null && edge.getTextProperties() != null) {
                Color labelColor = edgeDraft.getLabelColor();
                edge.getTextProperties().setColor(labelColor);
            } else {
                edge.getTextProperties().setColor(new Color(0, 0, 0, 0));
            }
            this.flushToElementAttributes(container, edgeDraft, edge);
        }
        if (edgeDraft.getTimeSet() != null) {
            this.flushTimeSet(edgeDraft.getTimeSet(), edge);
        }
        if (edgeDraft.getGraphTimestamp() != null) {
            edge.addTimestamp(edgeDraft.getGraphTimestamp());
        } else if (edgeDraft.getGraphInterval() != null) {
            edge.addInterval(edgeDraft.getGraphInterval());
        }
    }

    protected void flushEdgeWeight(ContainerUnloader container, EdgeDraft edgeDraft, Edge edge, boolean newEdge) {
        boolean weightColumnDraftIsDynamic;
        Column weightColumn = this.graphModel.getEdgeTable().getColumn("weight");
        ColumnDraft weightColumnDraft = container.getEdgeColumn("weight");
        boolean bl = weightColumnDraftIsDynamic = weightColumnDraft != null && weightColumnDraft.isDynamic();
        if (weightColumn.isDynamic() != weightColumnDraftIsDynamic) {
            Class weightColumnDraftTypeClass;
            Class clazz = weightColumnDraftTypeClass = weightColumnDraft != null ? weightColumnDraft.getResolvedTypeClass(container) : Double.class;
            if (!this.columnsTypeMismatchAlreadyWarned.contains(weightColumn)) {
                this.columnsTypeMismatchAlreadyWarned.add(weightColumn);
                String error = NbBundle.getMessage(AbstractProcessor.class, "AbstractProcessor.error.columnTypeMismatch", weightColumn.getId(), weightColumn.getTypeClass().getSimpleName(), weightColumnDraftTypeClass.getSimpleName());
                this.report.logIssue(new Issue(error, Issue.Level.SEVERE));
            }
            return;
        }
        if (weightColumn.isDynamic()) {
            TimeMap valMap;
            Object val = edgeDraft.getValue("weight");
            if (val != null && val instanceof TimeMap && Number.class.isAssignableFrom((valMap = (TimeMap)val).getTypeClass())) {
                int i;
                TimeMap<Interval, Double> newMap = val instanceof IntervalMap ? new IntervalDoubleMap() : new TimestampDoubleMap();
                TimeMap existingMap = (TimeMap)edge.getAttribute("weight");
                if (existingMap != null) {
                    K[] keys2 = existingMap.toKeysArray();
                    V[] vals2 = existingMap.toValuesArray();
                    for (i = 0; i < keys2.length; ++i) {
                        newMap.put((Interval)keys2[i], ((Number)vals2[i]).doubleValue());
                    }
                }
                K[] keys1 = valMap.toKeysArray();
                V[] vals1 = valMap.toValuesArray();
                for (i = 0; i < keys1.length; ++i) {
                    try {
                        newMap.put((Interval)keys1[i], ((Number)vals1[i]).doubleValue());
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                edge.setAttribute("weight", (Object)newMap);
            }
        } else if (!newEdge) {
            if (edgeDraft.getTimeSet() != null || edgeDraft.getValue("timeset") != null || edge.getAttribute("timeset") != null) {
                return;
            }
            double result = edge.getWeight();
            this.edgeCountForAverage.addTo(edge, 1);
            int edgeCount = this.edgeCountForAverage.getInt(edge);
            switch (this.containers[0].getEdgesMergeStrategy()) {
                case AVG: {
                    result = (edge.getWeight() * (double)edgeCount + edgeDraft.getWeight()) / (double)(edgeCount + 1);
                    break;
                }
                case MAX: {
                    result = Math.max(edgeDraft.getWeight(), edge.getWeight());
                    break;
                }
                case MIN: {
                    result = Math.min(edgeDraft.getWeight(), edge.getWeight());
                    break;
                }
                case SUM: {
                    result = edgeDraft.getWeight() + edge.getWeight();
                    break;
                }
                case FIRST: {
                    result = edge.getWeight();
                    break;
                }
                case LAST: {
                    result = edgeDraft.getWeight();
                    break;
                }
            }
            edge.setWeight(result);
        }
    }

    protected void flushTimeSet(TimeSet timeSet, Element element) {
        TimeSet existingTimeSet = (TimeSet)element.getAttribute("timeset");
        element.setAttribute("timeset", (Object)this.mergeTimeSets(existingTimeSet, timeSet));
    }

    protected TimeSet mergeTimeSets(TimeSet set1, TimeSet set2) {
        if (set1 instanceof IntervalSet) {
            return this.mergeIntervalSets((IntervalSet)set1, (IntervalSet)set2);
        }
        if (set1 instanceof TimestampSet) {
            return this.mergeTimestampSets((TimestampSet)set1, (TimestampSet)set2);
        }
        return set2;
    }

    protected IntervalSet mergeIntervalSets(IntervalSet set1, IntervalSet set2) {
        IntervalSet merged = new IntervalSet();
        for (Interval i : set1.toArray()) {
            merged.add(i);
        }
        boolean overlappingIntervals = false;
        for (Interval i : set2.toArray()) {
            try {
                merged.add(i);
            }
            catch (IllegalArgumentException e) {
                overlappingIntervals = true;
            }
        }
        if (overlappingIntervals) {
            String warning = NbBundle.getMessage(AbstractProcessor.class, "AbstractProcessor.warning.overlappingIntervals", set1.toString(this.graphModel.getTimeFormat(), this.graphModel.getTimeZone()), set2.toString(this.graphModel.getTimeFormat(), this.graphModel.getTimeZone()), merged.toString(this.graphModel.getTimeFormat(), this.graphModel.getTimeZone()));
            this.report.logIssue(new Issue(warning, Issue.Level.WARNING));
        }
        return merged;
    }

    protected TimestampSet mergeTimestampSets(TimestampSet set1, TimestampSet set2) {
        TimestampSet merged = new TimestampSet();
        for (Double t : set1.toArray()) {
            merged.add(t);
        }
        for (Double t : set2.toArray()) {
            merged.add(t);
        }
        return merged;
    }

    @Override
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public void setContainers(ContainerUnloader[] containers) {
        this.containers = containers;
    }

    @Override
    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }

    @Override
    public Report getReport() {
        return this.reportAfterDone;
    }
}

