/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.gephi.graph.api.GraphModel;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

public class AutoLayout {
    private final float duration;
    private final List<LayoutScenario> layouts;
    private GraphModel graphModel;
    private long startTime = 0L;
    private long lastExecutionTime;
    private float currentRatio;
    private int innerIteration;
    private float innerStart;
    private float innerRatio;
    private LayoutScenario currentLayout;
    private boolean cancel;

    public AutoLayout(long duration, TimeUnit timeUnit) {
        this.duration = TimeUnit.MILLISECONDS.convert(duration, timeUnit);
        this.layouts = new ArrayList<LayoutScenario>();
    }

    public void addLayout(Layout layout, float ratio) {
        this.layouts.add(new LayoutScenario(layout, ratio));
    }

    public void addLayout(Layout layout, float ratio, DynamicProperty[] properties) {
        for (int i = 0; i < properties.length; ++i) {
            AbstractDynamicProperty property = (AbstractDynamicProperty)properties[i];
            for (LayoutProperty lp : layout.getProperties()) {
                if (!lp.getCanonicalName().equalsIgnoreCase(property.getCanonicalName())) continue;
                property.setProperty(lp.getProperty());
                break;
            }
            if (property.getProperty() != null) continue;
            throw new IllegalArgumentException(property.getCanonicalName() + " property cannot be found in layout");
        }
        this.layouts.add(new LayoutScenario(layout, ratio, properties));
    }

    public void execute() {
        LayoutScenario layout;
        this.cancel = false;
        this.verifiy();
        while (!this.cancel && (layout = this.setLayout()) != null) {
            this.setProperties();
            layout.layout.goAlgo();
        }
    }

    public void cancel() {
        this.cancel = true;
    }

    private void setProperties() {
        for (int i = 0; i < this.currentLayout.properties.length; ++i) {
            DynamicProperty d = this.currentLayout.properties[i];
            Object val = d.getValue(this.innerRatio);
            if (val == null) continue;
            try {
                if (val == d.getProperty().getValue()) continue;
                d.getProperty().setValue(val);
                continue;
            }
            catch (Exception ex) {
                Exceptions.printStackTrace(ex);
            }
        }
    }

    private LayoutScenario setLayout() {
        long elapsedTime = this.getElapsedTime();
        long diff = elapsedTime - this.lastExecutionTime;
        this.lastExecutionTime = elapsedTime;
        this.currentRatio = (float)elapsedTime / this.duration;
        float ratio = this.currentRatio + (float)diff / this.duration;
        if (ratio >= 1.0f) {
            this.currentLayout = null;
            return this.currentLayout;
        }
        LayoutScenario layout = null;
        float sumRatio = 0.0f;
        float sum = 0.0f;
        for (int i = 0; i < this.layouts.size(); ++i) {
            LayoutScenario l = this.layouts.get(i);
            if (sum <= ratio) {
                layout = l;
                sumRatio = sum;
            }
            sum += l.ratio;
        }
        if (this.currentLayout != layout) {
            this.innerStart = this.currentRatio;
            this.innerIteration = 0;
            layout.layout.setGraphModel(this.graphModel);
            layout.layout.resetPropertiesValues();
            layout.layout.initAlgo();
        } else {
            ++this.innerIteration;
        }
        this.currentLayout = layout;
        float start = this.innerStart;
        float end = sumRatio + layout.ratio;
        float averageIteration = this.innerIteration == 0 ? 0.0f : (this.currentRatio - start) / (float)this.innerIteration;
        int totalIteration = averageIteration == 0.0f ? 0 : (int)((end - start) / averageIteration) - 1;
        this.innerRatio = totalIteration == 0 ? 0.0f : (float)this.innerIteration / (float)totalIteration;
        return this.currentLayout;
    }

    private long getElapsedTime() {
        if (this.startTime == 0L) {
            this.startTime = System.currentTimeMillis();
            return 0L;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public void setGraphModel(GraphModel graphModel) {
        this.graphModel = graphModel;
    }

    private void verifiy() {
        float sum = 0.0f;
        for (LayoutScenario l : this.layouts) {
            sum += l.ratio;
        }
        if (sum != 1.0f) {
            throw new RuntimeException("Ratio sum is not 1");
        }
    }

    public static DynamicProperty createDynamicProperty(String propertyName, Object value, float ratio) {
        return new SingleDynamicProperty(propertyName, value, ratio);
    }

    public static DynamicProperty createDynamicProperty(String propertyName, Object[] value, float[] ratio) {
        return new MultiDynamicProperty(propertyName, value, ratio);
    }

    public static DynamicProperty createDynamicProperty(String propertyName, Number[] value, float[] ratio, Interpolation interpolation) {
        return new InterpolateDynamicProperty(propertyName, value, ratio, interpolation);
    }

    private static class LayoutScenario {
        private final Layout layout;
        private final float ratio;
        private final DynamicProperty[] properties;

        public LayoutScenario(Layout layout, float ratio, DynamicProperty[] properties) {
            this.layout = layout;
            this.ratio = ratio;
            this.properties = properties;
        }

        public LayoutScenario(Layout layout, float ratio) {
            this(layout, ratio, new DynamicProperty[0]);
        }
    }

    private static class InterpolateDynamicProperty
    extends AbstractDynamicProperty {
        private final Number[] value;
        private final float[] thresholds;
        private final Interpolation interpolation;
        private int currentIndex = 0;

        InterpolateDynamicProperty(String propertyName, Number[] value, float[] ratio, Interpolation interpolation) {
            super(propertyName);
            this.value = value;
            this.thresholds = ratio;
            this.interpolation = interpolation;
            if (value.length != ratio.length) {
                throw new IllegalArgumentException("Value and ratio arrays must have same length");
            }
        }

        @Override
        public Object getValue(float ratio) {
            while (this.currentIndex < this.thresholds.length && this.thresholds[this.currentIndex] < ratio) {
                ++this.currentIndex;
            }
            if (this.currentIndex > 0) {
                float r = 1.0f / (this.thresholds[this.currentIndex] - this.thresholds[this.currentIndex - 1]);
                ratio = (ratio - this.thresholds[this.currentIndex - 1]) * r;
                return this.value[this.currentIndex - 1].doubleValue() + (this.value[this.currentIndex].doubleValue() - this.value[this.currentIndex - 1].doubleValue()) * (double)ratio;
            }
            return this.value[this.currentIndex];
        }
    }

    private static class MultiDynamicProperty
    extends AbstractDynamicProperty {
        private final Object[] value;
        private final float[] thresholds;
        private int currentIndex = 0;

        MultiDynamicProperty(String propertyName, Object[] value, float[] ratio) {
            super(propertyName);
            this.value = value;
            this.thresholds = ratio;
            if (value.length != ratio.length) {
                throw new IllegalArgumentException("Value and ratio arrays must have same length");
            }
        }

        @Override
        public Object getValue(float ratio) {
            while (this.currentIndex < this.thresholds.length && this.thresholds[this.currentIndex] < ratio) {
                ++this.currentIndex;
            }
            return this.value[this.currentIndex];
        }
    }

    private static class SingleDynamicProperty
    extends AbstractDynamicProperty {
        private final Object value;
        private final float threshold;

        SingleDynamicProperty(String propertyName, Object value, float ratio) {
            super(propertyName);
            this.value = value;
            this.threshold = ratio;
        }

        @Override
        public Object getValue(float ratio) {
            try {
                if (ratio >= this.threshold) {
                    return this.value;
                }
                return this.property.getValue();
            }
            catch (Exception e) {
                Exceptions.printStackTrace(e);
                return null;
            }
        }
    }

    private static abstract class AbstractDynamicProperty
    implements DynamicProperty {
        private final String propertyCanonicalName;
        protected Node.Property property;

        public AbstractDynamicProperty(String propertyName) {
            this.propertyCanonicalName = propertyName;
        }

        @Override
        public Node.Property getProperty() {
            return this.property;
        }

        void setProperty(Node.Property property) {
            this.property = property;
        }

        @Override
        public String getCanonicalName() {
            return this.propertyCanonicalName;
        }
    }

    public static enum Interpolation {
        LINEAR,
        LOG;

    }

    public static interface DynamicProperty {
        public Object getValue(float var1);

        public Node.Property getProperty();

        public String getCanonicalName();
    }
}

