/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.force.yifanHu;

import java.util.ArrayList;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.ForceVectorUtils;
import org.gephi.layout.plugin.force.AbstractForce;
import org.gephi.layout.plugin.force.Displacement;
import org.gephi.layout.plugin.force.ForceVector;
import org.gephi.layout.plugin.force.quadtree.BarnesHut;
import org.gephi.layout.plugin.force.quadtree.QuadTree;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class YifanHuLayout
extends AbstractLayout
implements Layout {
    private float optimalDistance;
    private float relativeStrength;
    private float step;
    private float initialStep;
    private int progress;
    private float stepRatio;
    private int quadTreeMaxLevel;
    private float barnesHutTheta;
    private float convergenceThreshold;
    private boolean adaptiveCooling;
    private Displacement displacement;
    private double energy0;
    private double energy;
    private Graph graph;

    public YifanHuLayout(LayoutBuilder layoutBuilder, Displacement displacement) {
        super(layoutBuilder);
        this.displacement = displacement;
    }

    protected void postAlgo() {
        this.updateStep();
        if (Math.abs((this.energy - this.energy0) / this.energy) < (double)this.getConvergenceThreshold().floatValue()) {
            this.setConverged(true);
        }
    }

    private Displacement getDisplacement() {
        this.displacement.setStep(this.step);
        return this.displacement;
    }

    private AbstractForce getEdgeForce() {
        return new SpringForce(this.getOptimalDistance().floatValue());
    }

    private AbstractForce getNodeForce() {
        return new ElectricalForce(this.getRelativeStrength().floatValue(), this.getOptimalDistance().floatValue());
    }

    private void updateStep() {
        if (this.isAdaptiveCooling().booleanValue()) {
            if (this.energy < this.energy0) {
                ++this.progress;
                if (this.progress >= 5) {
                    this.progress = 0;
                    this.setStep(Float.valueOf(this.step / this.getStepRatio().floatValue()));
                }
            } else {
                this.progress = 0;
                this.setStep(Float.valueOf(this.step * this.getStepRatio().floatValue()));
            }
        } else {
            this.setStep(Float.valueOf(this.step * this.getStepRatio().floatValue()));
        }
    }

    @Override
    public void resetPropertiesValues() {
        this.setStepRatio(Float.valueOf(0.95f));
        this.setRelativeStrength(Float.valueOf(0.2f));
        if (this.graph != null) {
            this.setOptimalDistance(Float.valueOf((float)(Math.pow(this.getRelativeStrength().floatValue(), 0.3333333333333333) * (double)this.getAverageEdgeLength(this.graph))));
        } else {
            this.setOptimalDistance(Float.valueOf(100.0f));
        }
        this.setInitialStep(Float.valueOf(this.optimalDistance / 5.0f));
        this.setStep(Float.valueOf(this.initialStep));
        this.setQuadTreeMaxLevel(10);
        this.setBarnesHutTheta(Float.valueOf(1.2f));
        this.setAdaptiveCooling(true);
        this.setConvergenceThreshold(Float.valueOf(1.0E-4f));
    }

    public float getAverageEdgeLength(Graph graph) {
        float edgeLength = 0.0f;
        int count = 1;
        for (Edge e : graph.getEdges()) {
            edgeLength += ForceVectorUtils.distance(e.getSource(), e.getTarget());
            ++count;
        }
        return edgeLength / (float)count;
    }

    @Override
    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String YIFANHU_CATEGORY = "Yifan Hu's properties";
        String BARNESHUT_CATEGORY = "Barnes-Hut's properties";
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, NbBundle.getMessage(this.getClass(), "YifanHu.optimalDistance.name"), "Yifan Hu's properties", "YifanHu.optimalDistance.name", NbBundle.getMessage(this.getClass(), "YifanHu.optimalDistance.desc"), "getOptimalDistance", "setOptimalDistance"));
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, NbBundle.getMessage(this.getClass(), "YifanHu.relativeStrength.name"), "Yifan Hu's properties", "YifanHu.relativeStrength.name", NbBundle.getMessage(this.getClass(), "YifanHu.relativeStrength.desc"), "getRelativeStrength", "setRelativeStrength"));
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, NbBundle.getMessage(this.getClass(), "YifanHu.initialStepSize.name"), "Yifan Hu's properties", "YifanHu.initialStepSize.name", NbBundle.getMessage(this.getClass(), "YifanHu.initialStepSize.desc"), "getInitialStep", "setInitialStep"));
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, NbBundle.getMessage(this.getClass(), "YifanHu.stepRatio.name"), "Yifan Hu's properties", "YifanHu.stepRatio.name", NbBundle.getMessage(this.getClass(), "YifanHu.stepRatio.desc"), "getStepRatio", "setStepRatio"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, NbBundle.getMessage(this.getClass(), "YifanHu.adaptativeCooling.name"), "Yifan Hu's properties", "YifanHu.adaptativeCooling.name", NbBundle.getMessage(this.getClass(), "YifanHu.adaptativeCooling.desc"), "isAdaptiveCooling", "setAdaptiveCooling"));
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, NbBundle.getMessage(this.getClass(), "YifanHu.convergenceThreshold.name"), "Yifan Hu's properties", "YifanHu.convergenceThreshold.name", NbBundle.getMessage(this.getClass(), "YifanHu.convergenceThreshold.desc"), "getConvergenceThreshold", "setConvergenceThreshold"));
            properties.add(LayoutProperty.createProperty((Layout)this, Integer.class, NbBundle.getMessage(this.getClass(), "YifanHu.quadTreeMaxLevel.name"), "Barnes-Hut's properties", "YifanHu.quadTreeMaxLevel.name", NbBundle.getMessage(this.getClass(), "YifanHu.quadTreeMaxLevel.desc"), "getQuadTreeMaxLevel", "setQuadTreeMaxLevel"));
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, NbBundle.getMessage(this.getClass(), "YifanHu.theta.name"), "Barnes-Hut's properties", "YifanHu.theta.name", NbBundle.getMessage(this.getClass(), "YifanHu.theta.desc"), "getBarnesHutTheta", "setBarnesHutTheta"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace(e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    @Override
    public void initAlgo() {
        if (this.graphModel == null) {
            return;
        }
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            this.energy = Double.POSITIVE_INFINITY;
            for (Node n : this.graph.getNodes()) {
                n.setLayoutData(new ForceVector());
            }
            this.progress = 0;
            this.setConverged(false);
            this.setStep(Float.valueOf(this.initialStep));
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    @Override
    public void endAlgo() {
        this.graph.readLock();
        try {
            for (Node n : this.graph.getNodes()) {
                n.setLayoutData(null);
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            ForceVector force;
            Node[] nodes;
            for (Node n : nodes = this.graph.getNodes().toArray()) {
                if (n.getLayoutData() != null && n.getLayoutData() instanceof ForceVector) continue;
                n.setLayoutData(new ForceVector());
            }
            QuadTree tree = QuadTree.buildTree(this.graph, this.getQuadTreeMaxLevel());
            BarnesHut barnes = new BarnesHut(this.getNodeForce());
            barnes.setTheta(this.getBarnesHutTheta().floatValue());
            for (Node node : nodes) {
                ForceVector layoutData = (ForceVector)node.getLayoutData();
                ForceVector f = barnes.calculateForce(node, tree);
                layoutData.add(f);
            }
            for (Edge e : this.graph.getEdges()) {
                if (e.getSource().equals(e.getTarget())) continue;
                Node n1 = e.getSource();
                Node n2 = e.getTarget();
                ForceVector f1 = (ForceVector)n1.getLayoutData();
                ForceVector f2 = (ForceVector)n2.getLayoutData();
                ForceVector f = this.getEdgeForce().calculateForce(n1, n2);
                f1.add(f);
                f2.subtract(f);
            }
            this.energy0 = this.energy;
            this.energy = 0.0;
            double maxForce = 1.0;
            for (Node n : nodes) {
                force = (ForceVector)n.getLayoutData();
                this.energy += (double)force.getNorm();
                maxForce = Math.max(maxForce, (double)force.getNorm());
            }
            for (Node n : nodes) {
                if (n.isFixed()) continue;
                force = (ForceVector)n.getLayoutData();
                force.multiply((float)(1.0 / maxForce));
                this.getDisplacement().moveNode(n, force);
            }
            this.postAlgo();
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    public Integer getQuadTreeMaxLevel() {
        return this.quadTreeMaxLevel;
    }

    public void setQuadTreeMaxLevel(Integer quadTreeMaxLevel) {
        this.quadTreeMaxLevel = quadTreeMaxLevel;
    }

    public Float getBarnesHutTheta() {
        return Float.valueOf(this.barnesHutTheta);
    }

    public void setBarnesHutTheta(Float barnesHutTheta) {
        this.barnesHutTheta = barnesHutTheta.floatValue();
    }

    public Float getOptimalDistance() {
        return Float.valueOf(this.optimalDistance);
    }

    public void setOptimalDistance(Float optimalDistance) {
        this.optimalDistance = optimalDistance.floatValue();
    }

    public Float getRelativeStrength() {
        return Float.valueOf(this.relativeStrength);
    }

    public void setRelativeStrength(Float relativeStrength) {
        this.relativeStrength = relativeStrength.floatValue();
    }

    public void setStep(Float step) {
        this.step = step.floatValue();
    }

    public Boolean isAdaptiveCooling() {
        return this.adaptiveCooling;
    }

    public void setAdaptiveCooling(Boolean adaptiveCooling) {
        this.adaptiveCooling = adaptiveCooling;
    }

    public Float getStepRatio() {
        return Float.valueOf(this.stepRatio);
    }

    public void setStepRatio(Float stepRatio) {
        this.stepRatio = stepRatio.floatValue();
    }

    public Float getConvergenceThreshold() {
        return Float.valueOf(this.convergenceThreshold);
    }

    public void setConvergenceThreshold(Float convergenceThreshold) {
        this.convergenceThreshold = convergenceThreshold.floatValue();
    }

    public Float getInitialStep() {
        return Float.valueOf(this.initialStep);
    }

    public void setInitialStep(Float initialStep) {
        this.initialStep = initialStep.floatValue();
    }

    public class ElectricalForce
    extends AbstractForce {
        private float relativeStrength;
        private float optimalDistance;

        public ElectricalForce(float relativeStrength, float optimalDistance) {
            this.relativeStrength = relativeStrength;
            this.optimalDistance = optimalDistance;
        }

        @Override
        public ForceVector calculateForce(Node node1, Node node2, float distance) {
            ForceVector f = new ForceVector(node2.x() - node1.x(), node2.y() - node1.y());
            float scale = -this.relativeStrength * this.optimalDistance * this.optimalDistance / (distance * distance);
            if (Float.isNaN(scale) || Float.isInfinite(scale)) {
                scale = -1.0f;
            }
            f.multiply(scale);
            return f;
        }
    }

    public class SpringForce
    extends AbstractForce {
        private float optimalDistance;

        public SpringForce(float optimalDistance) {
            this.optimalDistance = optimalDistance;
        }

        @Override
        public ForceVector calculateForce(Node node1, Node node2, float distance) {
            ForceVector f = new ForceVector(node2.x() - node1.x(), node2.y() - node1.y());
            f.multiply(distance / this.optimalDistance);
            return f;
        }

        public void setOptimalDistance(Float optimalDistance) {
            this.optimalDistance = optimalDistance.floatValue();
        }

        public Float getOptimalDistance() {
            return Float.valueOf(this.optimalDistance);
        }
    }
}

