/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.forceAtlas;

import java.util.ArrayList;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.ForceVectorNodeLayoutData;
import org.gephi.layout.plugin.ForceVectorUtils;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ForceAtlasLayout
extends AbstractLayout
implements Layout {
    protected Graph graph;
    public double inertia;
    private double repulsionStrength;
    private double attractionStrength;
    private double maxDisplacement;
    private boolean freezeBalance;
    private double freezeStrength;
    private double freezeInertia;
    private double gravity;
    private double speed;
    private double cooling;
    private boolean outboundAttractionDistribution;
    private boolean adjustSizes;

    public ForceAtlasLayout(LayoutBuilder layoutBuilder) {
        super(layoutBuilder);
    }

    @Override
    public void resetPropertiesValues() {
        this.inertia = 0.1;
        this.setRepulsionStrength(200.0);
        this.setAttractionStrength(10.0);
        this.setMaxDisplacement(10.0);
        this.setFreezeBalance(true);
        this.setFreezeStrength(80.0);
        this.setFreezeInertia(0.2);
        this.setGravity(30.0);
        this.setOutboundAttractionDistribution(false);
        this.setAdjustSizes(false);
        this.setSpeed(1.0);
        this.setCooling(1.0);
    }

    @Override
    public void initAlgo() {
        ForceAtlasLayout.ensureSafeLayoutNodePositions(this.graphModel);
    }

    private double getEdgeWeight(Edge edge, boolean isDynamicWeight, Interval interval) {
        if (isDynamicWeight) {
            return edge.getWeight(interval);
        }
        return edge.getWeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        boolean isDynamicWeight = this.graphModel.getEdgeTable().getColumn("weight").isDynamic();
        Interval interval = this.graph.getView().getTimeInterval();
        try {
            Node nf;
            Node[] nodes = this.graph.getNodes().toArray();
            Edge[] edges = this.graph.getEdges().toArray();
            for (Node node : nodes) {
                if (node.getLayoutData() != null && node.getLayoutData() instanceof ForceVectorNodeLayoutData) continue;
                node.setLayoutData(new ForceVectorNodeLayoutData());
            }
            for (Node node : nodes) {
                Node[] layoutData = (Node[])node.getLayoutData();
                layoutData.old_dx = layoutData.dx;
                layoutData.old_dy = layoutData.dy;
                layoutData.dx = (float)((double)layoutData.dx * this.inertia);
                layoutData.dy = (float)((double)layoutData.dy * this.inertia);
            }
            if (this.isAdjustSizes().booleanValue()) {
                for (Node node : nodes) {
                    for (Node n2 : nodes) {
                        if (node == n2) continue;
                        ForceVectorUtils.fcBiRepulsor_noCollide(node, n2, this.getRepulsionStrength() * (double)(1 + this.graph.getDegree(node)) * (double)(1 + this.graph.getDegree(n2)));
                    }
                }
            } else {
                for (Node node : nodes) {
                    for (Node n2 : nodes) {
                        if (node == n2) continue;
                        ForceVectorUtils.fcBiRepulsor(node, n2, this.getRepulsionStrength() * (double)(1 + this.graph.getDegree(node)) * (double)(1 + this.graph.getDegree(n2)));
                    }
                }
            }
            if (this.isAdjustSizes().booleanValue()) {
                if (this.isOutboundAttractionDistribution().booleanValue()) {
                    for (Element element : edges) {
                        nf = element.getSource();
                        Node nt = element.getTarget();
                        double bonus = nf.isFixed() || nt.isFixed() ? 100.0 : 1.0;
                        ForceVectorUtils.fcBiAttractor_noCollide(nf, nt, (bonus *= this.getEdgeWeight((Edge)element, isDynamicWeight, interval)) * this.getAttractionStrength() / (double)(1 + this.graph.getDegree(nf)));
                    }
                } else {
                    for (Element element : edges) {
                        nf = element.getSource();
                        Node nt = element.getTarget();
                        double bonus = nf.isFixed() || nt.isFixed() ? 100.0 : 1.0;
                        ForceVectorUtils.fcBiAttractor_noCollide(nf, nt, (bonus *= this.getEdgeWeight((Edge)element, isDynamicWeight, interval)) * this.getAttractionStrength());
                    }
                }
            } else if (this.isOutboundAttractionDistribution().booleanValue()) {
                for (Element element : edges) {
                    nf = element.getSource();
                    Node nt = element.getTarget();
                    double bonus = nf.isFixed() || nt.isFixed() ? 100.0 : 1.0;
                    ForceVectorUtils.fcBiAttractor(nf, nt, (bonus *= this.getEdgeWeight((Edge)element, isDynamicWeight, interval)) * this.getAttractionStrength() / (double)(1 + this.graph.getDegree(nf)));
                }
            } else {
                for (Element element : edges) {
                    nf = element.getSource();
                    Node nt = element.getTarget();
                    double bonus = nf.isFixed() || nt.isFixed() ? 100.0 : 1.0;
                    ForceVectorUtils.fcBiAttractor(nf, nt, (bonus *= this.getEdgeWeight((Edge)element, isDynamicWeight, interval)) * this.getAttractionStrength());
                }
            }
            for (Element element : nodes) {
                float nx = element.x();
                float ny = element.y();
                double d = 1.0E-4 + Math.sqrt(nx * nx + ny * ny);
                double gf = 1.0E-4 * this.getGravity() * d;
                ForceVectorNodeLayoutData layoutData = (ForceVectorNodeLayoutData)element.getLayoutData();
                layoutData.dx = (float)((double)layoutData.dx - gf * (double)nx / d);
                layoutData.dy = (float)((double)layoutData.dy - gf * (double)ny / d);
            }
            if (this.isFreezeBalance().booleanValue()) {
                for (Element element : nodes) {
                    ForceVectorNodeLayoutData layoutData = (ForceVectorNodeLayoutData)element.getLayoutData();
                    layoutData.dx = (float)((double)layoutData.dx * (this.getSpeed() * 10.0));
                    layoutData.dy = (float)((double)layoutData.dy * (this.getSpeed() * 10.0));
                }
            } else {
                for (Element element : nodes) {
                    ForceVectorNodeLayoutData layoutData = (ForceVectorNodeLayoutData)element.getLayoutData();
                    layoutData.dx = (float)((double)layoutData.dx * this.getSpeed());
                    layoutData.dy = (float)((double)layoutData.dy * this.getSpeed());
                }
            }
            for (Element element : nodes) {
                float ratio;
                ForceVectorNodeLayoutData nLayout = (ForceVectorNodeLayoutData)element.getLayoutData();
                if (element.isFixed()) continue;
                double d = 1.0E-4 + Math.sqrt(nLayout.dx * nLayout.dx + nLayout.dy * nLayout.dy);
                if (this.isFreezeBalance().booleanValue()) {
                    nLayout.freeze = (float)(this.getFreezeInertia() * (double)nLayout.freeze + (1.0 - this.getFreezeInertia()) * 0.1 * this.getFreezeStrength() * Math.sqrt(Math.sqrt((nLayout.old_dx - nLayout.dx) * (nLayout.old_dx - nLayout.dx) + (nLayout.old_dy - nLayout.dy) * (nLayout.old_dy - nLayout.dy))));
                    ratio = (float)Math.min(d / (d * (double)(1.0f + nLayout.freeze)), this.getMaxDisplacement() / d);
                } else {
                    ratio = (float)Math.min(1.0, this.getMaxDisplacement() / d);
                }
                nLayout.dx = (float)((double)nLayout.dx * ((double)ratio / this.getCooling()));
                nLayout.dy = (float)((double)nLayout.dy * ((double)ratio / this.getCooling()));
                float x = element.x() + nLayout.dx;
                float y = element.y() + nLayout.dy;
                element.setX(x);
                element.setY(y);
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    @Override
    public void endAlgo() {
        this.graph.readLock();
        try {
            for (Node n : this.graph.getNodes()) {
                n.setLayoutData(null);
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    @Override
    public boolean canAlgo() {
        return true;
    }

    @Override
    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String FORCE_ATLAS = "Force Atlas";
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.inertia.name"), "Force Atlas", "forceAtlas.inertia.name", NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.inertia.desc"), "getInertia", "setInertia"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.repulsionStrength.name"), "Force Atlas", "forceAtlas.repulsionStrength.name", NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.repulsionStrength.desc"), "getRepulsionStrength", "setRepulsionStrength"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.attractionStrength.name"), "Force Atlas", "forceAtlas.attractionStrength.name", NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.attractionStrength.desc"), "getAttractionStrength", "setAttractionStrength"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.maxDisplacement.name"), "Force Atlas", "forceAtlas.maxDisplacement.name", NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.maxDisplacement.desc"), "getMaxDisplacement", "setMaxDisplacement"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.freezeBalance.name"), "Force Atlas", "forceAtlas.freezeBalance.name", NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.freezeBalance.desc"), "isFreezeBalance", "setFreezeBalance"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.freezeStrength.name"), "Force Atlas", "forceAtlas.freezeStrength.name", NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.freezeStrength.desc"), "getFreezeStrength", "setFreezeStrength"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.freezeInertia.name"), "Force Atlas", "forceAtlas.freezeInertia.name", NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.freezeInertia.desc"), "getFreezeInertia", "setFreezeInertia"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.gravity.name"), "Force Atlas", "forceAtlas.gravity.name", NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.gravity.desc"), "getGravity", "setGravity"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.outboundAttractionDistribution.name"), "Force Atlas", "forceAtlas.outboundAttractionDistribution.name", NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.outboundAttractionDistribution.desc"), "isOutboundAttractionDistribution", "setOutboundAttractionDistribution"));
            properties.add(LayoutProperty.createProperty((Layout)this, Boolean.class, NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.adjustSizes.name"), "Force Atlas", "forceAtlas.adjustSizes.name", NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.adjustSizes.desc"), "isAdjustSizes", "setAdjustSizes"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.speed.name"), "Force Atlas", "forceAtlas.speed.name", NbBundle.getMessage(ForceAtlasLayout.class, "forceAtlas.speed.desc"), "getSpeed", "setSpeed"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace(e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public void setInertia(Double inertia) {
        this.inertia = inertia;
    }

    public Double getInertia() {
        return this.inertia;
    }

    public Double getRepulsionStrength() {
        return this.repulsionStrength;
    }

    public void setRepulsionStrength(Double repulsionStrength) {
        this.repulsionStrength = repulsionStrength;
    }

    public Double getAttractionStrength() {
        return this.attractionStrength;
    }

    public void setAttractionStrength(Double attractionStrength) {
        this.attractionStrength = attractionStrength;
    }

    public Double getMaxDisplacement() {
        return this.maxDisplacement;
    }

    public void setMaxDisplacement(Double maxDisplacement) {
        this.maxDisplacement = maxDisplacement;
    }

    public Boolean isFreezeBalance() {
        return this.freezeBalance;
    }

    public void setFreezeBalance(Boolean freezeBalance) {
        this.freezeBalance = freezeBalance;
    }

    public Double getFreezeStrength() {
        return this.freezeStrength;
    }

    public void setFreezeStrength(Double freezeStrength) {
        this.freezeStrength = freezeStrength;
    }

    public Double getFreezeInertia() {
        return this.freezeInertia;
    }

    public void setFreezeInertia(Double freezeInertia) {
        this.freezeInertia = freezeInertia;
    }

    public Double getGravity() {
        return this.gravity;
    }

    public void setGravity(Double gravity) {
        this.gravity = gravity;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public Double getCooling() {
        return this.cooling;
    }

    public void setCooling(Double cooling) {
        this.cooling = cooling;
    }

    public Boolean isOutboundAttractionDistribution() {
        return this.outboundAttractionDistribution;
    }

    public void setOutboundAttractionDistribution(Boolean outboundAttractionDistribution) {
        this.outboundAttractionDistribution = outboundAttractionDistribution;
    }

    public Boolean isAdjustSizes() {
        return this.adjustSizes;
    }

    public void setAdjustSizes(Boolean adjustSizes) {
        this.adjustSizes = adjustSizes;
    }
}

