/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.fruchterman;

import java.util.ArrayList;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.plugin.ForceVectorNodeLayoutData;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FruchtermanReingold
extends AbstractLayout
implements Layout {
    private static final float SPEED_DIVISOR = 800.0f;
    private static final float AREA_MULTIPLICATOR = 10000.0f;
    protected Graph graph;
    private float area;
    private double gravity;
    private double speed;

    public FruchtermanReingold(LayoutBuilder layoutBuilder) {
        super(layoutBuilder);
    }

    @Override
    public void resetPropertiesValues() {
        this.speed = 1.0;
        this.area = 10000.0f;
        this.gravity = 10.0;
    }

    @Override
    public void initAlgo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            ForceVectorNodeLayoutData layoutData;
            Node[] nodes = this.graph.getNodes().toArray();
            Edge[] edges = this.graph.getEdges().toArray();
            for (Node n : nodes) {
                if (n.getLayoutData() == null || !(n.getLayoutData() instanceof ForceVectorNodeLayoutData)) {
                    n.setLayoutData(new ForceVectorNodeLayoutData());
                }
                ForceVectorNodeLayoutData layoutData2 = (ForceVectorNodeLayoutData)n.getLayoutData();
                layoutData2.dx = 0.0f;
                layoutData2.dy = 0.0f;
            }
            float maxDisplace = (float)(Math.sqrt(10000.0f * this.area) / 10.0);
            float k = (float)Math.sqrt(10000.0f * this.area / (1.0f + (float)nodes.length));
            for (Node node : nodes) {
                for (Node N2 : nodes) {
                    float yDist;
                    float xDist;
                    float dist;
                    if (node == N2 || !((dist = (float)Math.sqrt((xDist = node.x() - N2.x()) * xDist + (yDist = node.y() - N2.y()) * yDist)) > 0.0f)) continue;
                    float repulsiveF = k * k / dist;
                    ForceVectorNodeLayoutData layoutData3 = (ForceVectorNodeLayoutData)node.getLayoutData();
                    layoutData3.dx += xDist / dist * repulsiveF;
                    layoutData3.dy += yDist / dist * repulsiveF;
                }
            }
            for (Element element : edges) {
                Node Nf = element.getSource();
                Node Nt = element.getTarget();
                float xDist = Nf.x() - Nt.x();
                float yDist = Nf.y() - Nt.y();
                float dist = (float)Math.sqrt(xDist * xDist + yDist * yDist);
                float attractiveF = dist * dist / k;
                if (!(dist > 0.0f)) continue;
                ForceVectorNodeLayoutData sourceLayoutData = (ForceVectorNodeLayoutData)Nf.getLayoutData();
                ForceVectorNodeLayoutData targetLayoutData = (ForceVectorNodeLayoutData)Nt.getLayoutData();
                sourceLayoutData.dx -= xDist / dist * attractiveF;
                sourceLayoutData.dy -= yDist / dist * attractiveF;
                targetLayoutData.dx += xDist / dist * attractiveF;
                targetLayoutData.dy += yDist / dist * attractiveF;
            }
            for (Element element : nodes) {
                layoutData = (ForceVectorNodeLayoutData)element.getLayoutData();
                float d = (float)Math.sqrt(element.x() * element.x() + element.y() * element.y());
                float gf = 0.01f * k * (float)this.gravity * d;
                layoutData.dx -= gf * element.x() / d;
                layoutData.dy -= gf * element.y() / d;
            }
            for (Element element : nodes) {
                layoutData = (ForceVectorNodeLayoutData)element.getLayoutData();
                layoutData.dx = (float)((double)layoutData.dx * (this.speed / 800.0));
                layoutData.dy = (float)((double)layoutData.dy * (this.speed / 800.0));
            }
            for (Element element : nodes) {
                layoutData = (ForceVectorNodeLayoutData)element.getLayoutData();
                float xDist = layoutData.dx;
                float yDist = layoutData.dy;
                float dist = (float)Math.sqrt(layoutData.dx * layoutData.dx + layoutData.dy * layoutData.dy);
                if (!(dist > 0.0f) || element.isFixed()) continue;
                float limitedDist = Math.min(maxDisplace * ((float)this.speed / 800.0f), dist);
                element.setX(element.x() + xDist / dist * limitedDist);
                element.setY(element.y() + yDist / dist * limitedDist);
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    @Override
    public void endAlgo() {
        this.graph.readLock();
        try {
            for (Node n : this.graph.getNodes()) {
                n.setLayoutData(null);
            }
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    @Override
    public boolean canAlgo() {
        return true;
    }

    @Override
    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String FRUCHTERMAN_REINGOLD = "Fruchterman Reingold";
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Float.class, NbBundle.getMessage(FruchtermanReingold.class, "fruchtermanReingold.area.name"), "Fruchterman Reingold", "fruchtermanReingold.area.name", NbBundle.getMessage(FruchtermanReingold.class, "fruchtermanReingold.area.desc"), "getArea", "setArea"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(FruchtermanReingold.class, "fruchtermanReingold.gravity.name"), "Fruchterman Reingold", "fruchtermanReingold.gravity.name", NbBundle.getMessage(FruchtermanReingold.class, "fruchtermanReingold.gravity.desc"), "getGravity", "setGravity"));
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(FruchtermanReingold.class, "fruchtermanReingold.speed.name"), "Fruchterman Reingold", "fruchtermanReingold.speed.name", NbBundle.getMessage(FruchtermanReingold.class, "fruchtermanReingold.speed.desc"), "getSpeed", "setSpeed"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace(e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Float getArea() {
        return Float.valueOf(this.area);
    }

    public void setArea(Float area) {
        this.area = area.floatValue();
    }

    public Double getGravity() {
        return this.gravity;
    }

    public void setGravity(Double gravity) {
        this.gravity = gravity;
    }

    public Double getSpeed() {
        return this.speed;
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }
}

