/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.openord;

import gnu.trove.iterator.TIntFloatIterator;
import gnu.trove.map.hash.TIntFloatHashMap;
import gnu.trove.map.hash.TIntIntHashMap;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.CyclicBarrier;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Interval;
import org.gephi.layout.plugin.openord.Combine;
import org.gephi.layout.plugin.openord.Control;
import org.gephi.layout.plugin.openord.DensityGrid;
import org.gephi.layout.plugin.openord.Node;
import org.gephi.layout.plugin.openord.OpenOrdLayoutData;
import org.gephi.layout.plugin.openord.Params;
import org.gephi.layout.plugin.openord.Worker;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.ProgressTicket;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class OpenOrdLayout
implements Layout,
LongTask {
    private final LayoutBuilder builder;
    private GraphModel graphModel;
    private boolean running = true;
    private ProgressTicket progressTicket;
    private Params param;
    private float edgeCut;
    private int numThreads;
    private long randSeed;
    private int numIterations;
    private float realTime;
    private Worker[] workers;
    private Combine combine;
    private Control control;
    private CyclicBarrier barrier;
    private Graph graph;
    private boolean firstIteration = true;

    public OpenOrdLayout(LayoutBuilder builder) {
        this.builder = builder;
    }

    @Override
    public void resetPropertiesValues() {
        this.edgeCut = 0.8f;
        this.numIterations = 750;
        this.numThreads = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        Random r = new Random();
        this.randSeed = r.nextLong();
        this.running = true;
        this.realTime = 0.2f;
        this.param = Params.DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initAlgo() {
        if (this.param.getIterationsSum() != 1.0f) {
            this.param = Params.DEFAULT;
        }
        this.graph = this.graphModel.getUndirectedGraphVisible();
        this.graph.readLock();
        boolean isDynamicWeight = this.graphModel.getEdgeTable().getColumn("weight").isDynamic();
        Interval interval = this.graph.getView().getTimeInterval();
        try {
            int numNodes = this.graph.getNodeCount();
            Node[] nodes = new Node[numNodes];
            TIntFloatHashMap[] neighbors = new TIntFloatHashMap[numNodes];
            TIntIntHashMap idMap = new TIntIntHashMap(numNodes, 1.0f);
            org.gephi.graph.api.Node[] graphNodes = this.graph.getNodes().toArray();
            for (int i = 0; i < numNodes; ++i) {
                org.gephi.graph.api.Node n = graphNodes[i];
                nodes[i] = new Node(i);
                nodes[i].x = n.x();
                nodes[i].y = n.y();
                nodes[i].fixed = n.isFixed();
                OpenOrdLayoutData layoutData = new OpenOrdLayoutData(i);
                n.setLayoutData(layoutData);
                idMap.put(n.getStoreId(), i);
            }
            float highestSimilarity = Float.NEGATIVE_INFINITY;
            for (Node[] e : this.graph.getEdges()) {
                int target;
                int source = idMap.get(e.getSource().getStoreId());
                if (source == (target = idMap.get(e.getTarget().getStoreId()))) continue;
                float weight = (float)(isDynamicWeight ? e.getWeight(interval) : e.getWeight());
                if (neighbors[source] == null) {
                    neighbors[source] = new TIntFloatHashMap();
                }
                if (neighbors[target] == null) {
                    neighbors[target] = new TIntFloatHashMap();
                }
                neighbors[source].put(target, weight);
                neighbors[target].put(source, weight);
                highestSimilarity = Math.max(highestSimilarity, weight);
            }
            boolean someFixed = false;
            for (Node n : nodes) {
                if (!n.fixed) {
                    n.x = 0.0f;
                    n.y = 0.0f;
                    continue;
                }
                someFixed = true;
            }
            if (someFixed) {
                float minX = Float.POSITIVE_INFINITY;
                float maxX = Float.NEGATIVE_INFINITY;
                float minY = Float.POSITIVE_INFINITY;
                float maxY = Float.NEGATIVE_INFINITY;
                for (Node node : nodes) {
                    if (!node.fixed) continue;
                    minX = Math.min(minX, node.x);
                    maxX = Math.max(maxX, node.x);
                    minY = Math.min(minY, node.y);
                    maxY = Math.max(maxY, node.y);
                }
                float shiftX = minX + (maxX - minX) / 2.0f;
                float shiftY = minY + (maxY - minY) / 2.0f;
                float ratio = Math.min(DensityGrid.getViewSize() / (maxX - minX), DensityGrid.getViewSize() / (maxY - minY));
                ratio = Math.min(1.0f, ratio);
                for (Node n : nodes) {
                    if (!n.fixed) continue;
                    n.x = (n.x - shiftX) * ratio;
                    n.y = (n.y - shiftY) * ratio;
                }
            }
            this.control = new Control();
            this.combine = new Combine(this);
            this.barrier = new CyclicBarrier(this.numThreads, this.combine);
            this.control.setEdgeCut(this.edgeCut);
            this.control.setRealParm(this.realTime);
            this.control.setProgressTicket(this.progressTicket);
            this.control.initParams(this.param, this.numIterations);
            this.control.setNumNodes(numNodes);
            this.control.setHighestSimilarity(highestSimilarity);
            this.workers = new Worker[this.numThreads];
            for (int i = 0; i < this.numThreads; ++i) {
                this.workers[i] = new Worker(i, this.numThreads, this.barrier);
                this.workers[i].setRandom(new Random(this.randSeed));
                this.control.initWorker(this.workers[i]);
            }
            for (Worker w : this.workers) {
                Node[] nodesCopy = new Node[nodes.length];
                for (int i = 0; i < nodes.length; ++i) {
                    nodesCopy[i] = nodes[i].clone();
                }
                TIntFloatHashMap[] neighborsCopy = new TIntFloatHashMap[numNodes];
                for (int i = 0; i < neighbors.length; ++i) {
                    if (i % this.numThreads != w.getId() || neighbors[i] == null) continue;
                    int n = neighbors[i].size();
                    neighborsCopy[i] = new TIntFloatHashMap(n, 1.0f);
                    TIntFloatIterator itr = neighbors[i].iterator();
                    while (itr.hasNext()) {
                        itr.advance();
                        float weight = this.normalizeWeight(itr.value(), highestSimilarity);
                        neighborsCopy[i].put(itr.key(), weight);
                    }
                }
                w.setPositions(nodesCopy);
                w.setNeighbors(neighborsCopy);
            }
            for (Node n : nodes) {
                if (!n.fixed) continue;
                for (Worker worker : this.workers) {
                    worker.getDensityGrid().add(n, worker.isFineDensity());
                }
            }
            this.running = true;
            this.firstIteration = true;
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    @Override
    public void goAlgo() {
        if (this.firstIteration) {
            for (int i = 0; i < this.numThreads; ++i) {
                Thread t = new Thread(this.workers[i]);
                t.setDaemon(true);
                t.start();
            }
            this.firstIteration = false;
        }
        this.combine.waitForIteration();
    }

    @Override
    public void endAlgo() {
        this.running = false;
        this.combine = null;
    }

    private float normalizeWeight(float weight, float highestSimilarity) {
        weight /= highestSimilarity;
        weight *= Math.abs(weight);
        return weight;
    }

    @Override
    public boolean canAlgo() {
        return this.running;
    }

    @Override
    public void setGraphModel(GraphModel graphModel) {
        this.graphModel = graphModel;
    }

    @Override
    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        String OPENORD = "OpenOrd";
        String STAGE = "Stages";
        try {
            properties.add(LayoutProperty.createProperty(this, Float.class, NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.edgecut.name"), "OpenOrd", NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.edgecut.description"), "getEdgeCut", "setEdgeCut"));
            properties.add(LayoutProperty.createProperty(this, Integer.class, NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.numthreads.name"), "OpenOrd", NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.numthreads.description"), "getNumThreads", "setNumThreads"));
            properties.add(LayoutProperty.createProperty(this, Integer.class, NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.numiterations.name"), "OpenOrd", NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.numiterations.description"), "getNumIterations", "setNumIterations"));
            properties.add(LayoutProperty.createProperty(this, Float.class, NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.realtime.name"), "OpenOrd", NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.realtime.description"), "getRealTime", "setRealTime"));
            properties.add(LayoutProperty.createProperty(this, Long.class, NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.seed.name"), "OpenOrd", NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.seed.description"), "getRandSeed", "setRandSeed"));
            properties.add(LayoutProperty.createProperty(this, Integer.class, NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.stage.liquid.name"), "Stages", NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.stage.liquid.description"), "getLiquidStage", "setLiquidStage"));
            properties.add(LayoutProperty.createProperty(this, Integer.class, NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.stage.expansion.name"), "Stages", NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.stage.expansion.description"), "getExpansionStage", "setExpansionStage"));
            properties.add(LayoutProperty.createProperty(this, Integer.class, NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.stage.cooldown.name"), "Stages", NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.stage.cooldown.description"), "getCooldownStage", "setCooldownStage"));
            properties.add(LayoutProperty.createProperty(this, Integer.class, NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.stage.crunch.name"), "Stages", NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.stage.crunch.description"), "getCrunchStage", "setCrunchStage"));
            properties.add(LayoutProperty.createProperty(this, Integer.class, NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.stage.simmer.name"), "Stages", NbBundle.getMessage(OpenOrdLayout.class, "OpenOrd.properties.stage.simmer.description"), "getSimmerStage", "setSimmerStage"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace(e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    public Float getEdgeCut() {
        return Float.valueOf(this.edgeCut);
    }

    public void setEdgeCut(Float edgeCut) {
        edgeCut = Float.valueOf(Math.min(1.0f, edgeCut.floatValue()));
        edgeCut = Float.valueOf(Math.max(0.0f, edgeCut.floatValue()));
        this.edgeCut = edgeCut.floatValue();
    }

    public Integer getNumThreads() {
        return this.numThreads;
    }

    public void setNumThreads(Integer numThreads) {
        numThreads = Math.max(1, numThreads);
        this.numThreads = numThreads;
    }

    public Long getRandSeed() {
        return this.randSeed;
    }

    public void setRandSeed(Long randSeed) {
        this.randSeed = randSeed;
    }

    public void setRunning(Boolean running) {
        this.running = running;
    }

    public Integer getNumIterations() {
        return this.numIterations;
    }

    public void setNumIterations(Integer numIterations) {
        numIterations = Math.max(100, numIterations);
        this.numIterations = numIterations;
    }

    public Float getRealTime() {
        return Float.valueOf(this.realTime);
    }

    public void setRealTime(Float realTime) {
        realTime = Float.valueOf(Math.min(1.0f, realTime.floatValue()));
        realTime = Float.valueOf(Math.max(0.0f, realTime.floatValue()));
        this.realTime = realTime.floatValue();
    }

    public Integer getLiquidStage() {
        return this.param.getLiquid().getIterationsPercentage();
    }

    public Integer getExpansionStage() {
        return this.param.getExpansion().getIterationsPercentage();
    }

    public Integer getCooldownStage() {
        return this.param.getCooldown().getIterationsPercentage();
    }

    public Integer getCrunchStage() {
        return this.param.getCrunch().getIterationsPercentage();
    }

    public Integer getSimmerStage() {
        return this.param.getSimmer().getIterationsPercentage();
    }

    public void setLiquidStage(Integer value) {
        int v = Math.min(100, value);
        v = Math.max(0, v);
        this.param.getLiquid().setIterations((float)v / 100.0f);
    }

    public void setExpansionStage(Integer value) {
        int v = Math.min(100, value);
        v = Math.max(0, v);
        this.param.getExpansion().setIterations((float)v / 100.0f);
    }

    public void setCooldownStage(Integer value) {
        int v = Math.min(100, value);
        v = Math.max(0, v);
        this.param.getCooldown().setIterations((float)v / 100.0f);
    }

    public void setCrunchStage(Integer value) {
        int v = Math.min(100, value);
        v = Math.max(0, v);
        this.param.getCrunch().setIterations((float)v / 100.0f);
    }

    public void setSimmerStage(Integer value) {
        int v = Math.min(100, value);
        v = Math.max(0, v);
        this.param.getSimmer().setIterations((float)v / 100.0f);
    }

    @Override
    public LayoutBuilder getBuilder() {
        return this.builder;
    }

    public Worker[] getWorkers() {
        return this.workers;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public Control getControl() {
        return this.control;
    }

    @Override
    public boolean cancel() {
        return true;
    }

    @Override
    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progressTicket = progressTicket;
    }
}

