/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.random;

import java.util.ArrayList;
import java.util.Random;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class RandomLayout
extends AbstractLayout
implements Layout {
    private Random random;
    private Graph graph;
    private boolean converged;
    private double size;

    public RandomLayout(LayoutBuilder layoutBuilder, double size) {
        super(layoutBuilder);
        this.size = size;
        this.random = new Random();
    }

    @Override
    public void initAlgo() {
        this.converged = false;
    }

    @Override
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            for (Node n : this.graph.getNodes()) {
                n.setX((float)(-this.size / 2.0 + this.size * this.random.nextDouble()));
                n.setY((float)(-this.size / 2.0 + this.size * this.random.nextDouble()));
            }
            this.converged = true;
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    @Override
    public boolean canAlgo() {
        return !this.converged;
    }

    @Override
    public void endAlgo() {
        this.graph = null;
    }

    @Override
    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(this.getClass(), "Random.spaceSize.name"), null, "Random.spaceSize.name", NbBundle.getMessage(this.getClass(), "Random.spaceSize.desc"), "getSize", "setSize"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace(e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    @Override
    public void resetPropertiesValues() {
    }

    public void setSize(Double size) {
        this.size = size;
    }

    public Double getSize() {
        return this.size;
    }
}

