/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.layout.plugin.scale;

import java.util.ArrayList;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.layout.plugin.AbstractLayout;
import org.gephi.layout.spi.Layout;
import org.gephi.layout.spi.LayoutBuilder;
import org.gephi.layout.spi.LayoutProperty;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public abstract class AbstractScaleLayout
extends AbstractLayout
implements Layout {
    private double scale;
    private Graph graph;

    public AbstractScaleLayout(LayoutBuilder layoutBuilder, double scale) {
        super(layoutBuilder);
        this.scale = scale;
    }

    @Override
    public void initAlgo() {
        this.setConverged(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void goAlgo() {
        this.graph = this.graphModel.getGraphVisible();
        this.graph.readLock();
        try {
            double xMean = 0.0;
            double yMean = 0.0;
            for (Node n : this.graph.getNodes()) {
                xMean += (double)n.x();
                yMean += (double)n.y();
            }
            xMean /= (double)this.graph.getNodeCount();
            yMean /= (double)this.graph.getNodeCount();
            for (Node n : this.graph.getNodes()) {
                double dx = ((double)n.x() - xMean) * this.getScale();
                double dy = ((double)n.y() - yMean) * this.getScale();
                n.setX((float)(xMean + dx));
                n.setY((float)(yMean + dy));
            }
            this.setConverged(true);
        }
        finally {
            this.graph.readUnlockAll();
        }
    }

    @Override
    public void endAlgo() {
    }

    @Override
    public LayoutProperty[] getProperties() {
        ArrayList<LayoutProperty> properties = new ArrayList<LayoutProperty>();
        try {
            properties.add(LayoutProperty.createProperty((Layout)this, Double.class, NbBundle.getMessage(this.getClass(), "ScaleLayout.scaleFactor.name"), null, "ScaleLayout.scaleFactor.name", NbBundle.getMessage(this.getClass(), "ScaleLayout.scaleFactor.desc"), "getScale", "setScale"));
        }
        catch (Exception e) {
            Exceptions.printStackTrace(e);
        }
        return properties.toArray(new LayoutProperty[0]);
    }

    @Override
    public void resetPropertiesValues() {
    }

    public Double getScale() {
        return this.scale;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }
}

